# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['BaremetalServerArgs', 'BaremetalServer']

@pulumi.input_type
class BaremetalServerArgs:
    def __init__(__self__, *,
                 offer: pulumi.Input[str],
                 description: Optional[pulumi.Input[str]] = None,
                 hostname: Optional[pulumi.Input[str]] = None,
                 install_config_afterward: Optional[pulumi.Input[bool]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 options: Optional[pulumi.Input[Sequence[pulumi.Input['BaremetalServerOptionArgs']]]] = None,
                 os: Optional[pulumi.Input[str]] = None,
                 password: Optional[pulumi.Input[str]] = None,
                 private_networks: Optional[pulumi.Input[Sequence[pulumi.Input['BaremetalServerPrivateNetworkArgs']]]] = None,
                 project_id: Optional[pulumi.Input[str]] = None,
                 reinstall_on_config_changes: Optional[pulumi.Input[bool]] = None,
                 service_password: Optional[pulumi.Input[str]] = None,
                 service_user: Optional[pulumi.Input[str]] = None,
                 ssh_key_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 user: Optional[pulumi.Input[str]] = None,
                 zone: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a BaremetalServer resource.
        :param pulumi.Input[str] offer: The offer name or UUID of the baremetal server.
               Use [this endpoint](https://www.scaleway.com/en/developers/api/elastic-metal/#path-servers-get-a-specific-elastic-metal-server) to find the right offer.
               
               > **Important:** Updates to `offer` will recreate the server.
        :param pulumi.Input[str] description: A description for the server.
        :param pulumi.Input[str] hostname: The hostname of the server.
        :param pulumi.Input[bool] install_config_afterward: If True, this boolean allows to create a server without the install config if you want to provide it later.
        :param pulumi.Input[str] name: The name of the server.
        :param pulumi.Input[Sequence[pulumi.Input['BaremetalServerOptionArgs']]] options: The options to enable on the server.
               > The `options` block supports:
        :param pulumi.Input[str] os: The UUID of the os to install on the server.
               Use [this endpoint](https://www.scaleway.com/en/developers/api/elastic-metal/#path-os-list-available-oses) to find the right OS ID.
               > **Important:** Updates to `os` will reinstall the server.
        :param pulumi.Input[str] password: Password used for the installation. May be required depending on used os.
        :param pulumi.Input[Sequence[pulumi.Input['BaremetalServerPrivateNetworkArgs']]] private_networks: The private networks to attach to the server. For more information, see [the documentation](https://www.scaleway.com/en/docs/compute/elastic-metal/how-to/use-private-networks/)
        :param pulumi.Input[str] project_id: `project_id`) The ID of the project the server is associated with.
        :param pulumi.Input[bool] reinstall_on_config_changes: If True, this boolean allows to reinstall the server on install config changes.
               > **Important:** Updates to `ssh_key_ids`, `user`, `password`, `service_user` or `service_password` will not take effect on the server, it requires to reinstall it. To do so please set 'reinstall_on_config_changes' argument to true.
        :param pulumi.Input[str] service_password: Password used for the service to install. May be required depending on used os.
        :param pulumi.Input[str] service_user: User used for the service to install.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] ssh_key_ids: List of SSH keys allowed to connect to the server.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] tags: The tags associated with the server.
        :param pulumi.Input[str] user: User used for the installation.
        :param pulumi.Input[str] zone: `zone`) The zone in which the server should be created.
        """
        pulumi.set(__self__, "offer", offer)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if hostname is not None:
            pulumi.set(__self__, "hostname", hostname)
        if install_config_afterward is not None:
            pulumi.set(__self__, "install_config_afterward", install_config_afterward)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if options is not None:
            pulumi.set(__self__, "options", options)
        if os is not None:
            pulumi.set(__self__, "os", os)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if private_networks is not None:
            pulumi.set(__self__, "private_networks", private_networks)
        if project_id is not None:
            pulumi.set(__self__, "project_id", project_id)
        if reinstall_on_config_changes is not None:
            pulumi.set(__self__, "reinstall_on_config_changes", reinstall_on_config_changes)
        if service_password is not None:
            pulumi.set(__self__, "service_password", service_password)
        if service_user is not None:
            pulumi.set(__self__, "service_user", service_user)
        if ssh_key_ids is not None:
            pulumi.set(__self__, "ssh_key_ids", ssh_key_ids)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if user is not None:
            pulumi.set(__self__, "user", user)
        if zone is not None:
            pulumi.set(__self__, "zone", zone)

    @property
    @pulumi.getter
    def offer(self) -> pulumi.Input[str]:
        """
        The offer name or UUID of the baremetal server.
        Use [this endpoint](https://www.scaleway.com/en/developers/api/elastic-metal/#path-servers-get-a-specific-elastic-metal-server) to find the right offer.

        > **Important:** Updates to `offer` will recreate the server.
        """
        return pulumi.get(self, "offer")

    @offer.setter
    def offer(self, value: pulumi.Input[str]):
        pulumi.set(self, "offer", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        A description for the server.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def hostname(self) -> Optional[pulumi.Input[str]]:
        """
        The hostname of the server.
        """
        return pulumi.get(self, "hostname")

    @hostname.setter
    def hostname(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "hostname", value)

    @property
    @pulumi.getter(name="installConfigAfterward")
    def install_config_afterward(self) -> Optional[pulumi.Input[bool]]:
        """
        If True, this boolean allows to create a server without the install config if you want to provide it later.
        """
        return pulumi.get(self, "install_config_afterward")

    @install_config_afterward.setter
    def install_config_afterward(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "install_config_afterward", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the server.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def options(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['BaremetalServerOptionArgs']]]]:
        """
        The options to enable on the server.
        > The `options` block supports:
        """
        return pulumi.get(self, "options")

    @options.setter
    def options(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['BaremetalServerOptionArgs']]]]):
        pulumi.set(self, "options", value)

    @property
    @pulumi.getter
    def os(self) -> Optional[pulumi.Input[str]]:
        """
        The UUID of the os to install on the server.
        Use [this endpoint](https://www.scaleway.com/en/developers/api/elastic-metal/#path-os-list-available-oses) to find the right OS ID.
        > **Important:** Updates to `os` will reinstall the server.
        """
        return pulumi.get(self, "os")

    @os.setter
    def os(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "os", value)

    @property
    @pulumi.getter
    def password(self) -> Optional[pulumi.Input[str]]:
        """
        Password used for the installation. May be required depending on used os.
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "password", value)

    @property
    @pulumi.getter(name="privateNetworks")
    def private_networks(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['BaremetalServerPrivateNetworkArgs']]]]:
        """
        The private networks to attach to the server. For more information, see [the documentation](https://www.scaleway.com/en/docs/compute/elastic-metal/how-to/use-private-networks/)
        """
        return pulumi.get(self, "private_networks")

    @private_networks.setter
    def private_networks(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['BaremetalServerPrivateNetworkArgs']]]]):
        pulumi.set(self, "private_networks", value)

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[pulumi.Input[str]]:
        """
        `project_id`) The ID of the project the server is associated with.
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project_id", value)

    @property
    @pulumi.getter(name="reinstallOnConfigChanges")
    def reinstall_on_config_changes(self) -> Optional[pulumi.Input[bool]]:
        """
        If True, this boolean allows to reinstall the server on install config changes.
        > **Important:** Updates to `ssh_key_ids`, `user`, `password`, `service_user` or `service_password` will not take effect on the server, it requires to reinstall it. To do so please set 'reinstall_on_config_changes' argument to true.
        """
        return pulumi.get(self, "reinstall_on_config_changes")

    @reinstall_on_config_changes.setter
    def reinstall_on_config_changes(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "reinstall_on_config_changes", value)

    @property
    @pulumi.getter(name="servicePassword")
    def service_password(self) -> Optional[pulumi.Input[str]]:
        """
        Password used for the service to install. May be required depending on used os.
        """
        return pulumi.get(self, "service_password")

    @service_password.setter
    def service_password(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "service_password", value)

    @property
    @pulumi.getter(name="serviceUser")
    def service_user(self) -> Optional[pulumi.Input[str]]:
        """
        User used for the service to install.
        """
        return pulumi.get(self, "service_user")

    @service_user.setter
    def service_user(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "service_user", value)

    @property
    @pulumi.getter(name="sshKeyIds")
    def ssh_key_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of SSH keys allowed to connect to the server.
        """
        return pulumi.get(self, "ssh_key_ids")

    @ssh_key_ids.setter
    def ssh_key_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "ssh_key_ids", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The tags associated with the server.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter
    def user(self) -> Optional[pulumi.Input[str]]:
        """
        User used for the installation.
        """
        return pulumi.get(self, "user")

    @user.setter
    def user(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "user", value)

    @property
    @pulumi.getter
    def zone(self) -> Optional[pulumi.Input[str]]:
        """
        `zone`) The zone in which the server should be created.
        """
        return pulumi.get(self, "zone")

    @zone.setter
    def zone(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "zone", value)


@pulumi.input_type
class _BaremetalServerState:
    def __init__(__self__, *,
                 description: Optional[pulumi.Input[str]] = None,
                 domain: Optional[pulumi.Input[str]] = None,
                 hostname: Optional[pulumi.Input[str]] = None,
                 install_config_afterward: Optional[pulumi.Input[bool]] = None,
                 ips: Optional[pulumi.Input[Sequence[pulumi.Input['BaremetalServerIpArgs']]]] = None,
                 ipv4s: Optional[pulumi.Input[Sequence[pulumi.Input['BaremetalServerIpv4Args']]]] = None,
                 ipv6s: Optional[pulumi.Input[Sequence[pulumi.Input['BaremetalServerIpv6Args']]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 offer: Optional[pulumi.Input[str]] = None,
                 offer_id: Optional[pulumi.Input[str]] = None,
                 offer_name: Optional[pulumi.Input[str]] = None,
                 options: Optional[pulumi.Input[Sequence[pulumi.Input['BaremetalServerOptionArgs']]]] = None,
                 organization_id: Optional[pulumi.Input[str]] = None,
                 os: Optional[pulumi.Input[str]] = None,
                 os_name: Optional[pulumi.Input[str]] = None,
                 password: Optional[pulumi.Input[str]] = None,
                 private_networks: Optional[pulumi.Input[Sequence[pulumi.Input['BaremetalServerPrivateNetworkArgs']]]] = None,
                 project_id: Optional[pulumi.Input[str]] = None,
                 reinstall_on_config_changes: Optional[pulumi.Input[bool]] = None,
                 service_password: Optional[pulumi.Input[str]] = None,
                 service_user: Optional[pulumi.Input[str]] = None,
                 ssh_key_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 user: Optional[pulumi.Input[str]] = None,
                 zone: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering BaremetalServer resources.
        :param pulumi.Input[str] description: A description for the server.
        :param pulumi.Input[str] domain: The domain of the server.
        :param pulumi.Input[str] hostname: The hostname of the server.
        :param pulumi.Input[bool] install_config_afterward: If True, this boolean allows to create a server without the install config if you want to provide it later.
        :param pulumi.Input[Sequence[pulumi.Input['BaremetalServerIpArgs']]] ips: (List of) The IPs of the server.
        :param pulumi.Input[Sequence[pulumi.Input['BaremetalServerIpv4Args']]] ipv4s: (List of) The IPv4 addresses of the server.
        :param pulumi.Input[Sequence[pulumi.Input['BaremetalServerIpv6Args']]] ipv6s: (List of) The IPv6 addresses of the server.
        :param pulumi.Input[str] name: The name of the server.
        :param pulumi.Input[str] offer: The offer name or UUID of the baremetal server.
               Use [this endpoint](https://www.scaleway.com/en/developers/api/elastic-metal/#path-servers-get-a-specific-elastic-metal-server) to find the right offer.
               
               > **Important:** Updates to `offer` will recreate the server.
        :param pulumi.Input[str] offer_id: The ID of the offer.
        :param pulumi.Input[str] offer_name: The name of the offer.
        :param pulumi.Input[Sequence[pulumi.Input['BaremetalServerOptionArgs']]] options: The options to enable on the server.
               > The `options` block supports:
        :param pulumi.Input[str] organization_id: The organization ID the server is associated with.
        :param pulumi.Input[str] os: The UUID of the os to install on the server.
               Use [this endpoint](https://www.scaleway.com/en/developers/api/elastic-metal/#path-os-list-available-oses) to find the right OS ID.
               > **Important:** Updates to `os` will reinstall the server.
        :param pulumi.Input[str] os_name: The name of the os.
        :param pulumi.Input[str] password: Password used for the installation. May be required depending on used os.
        :param pulumi.Input[Sequence[pulumi.Input['BaremetalServerPrivateNetworkArgs']]] private_networks: The private networks to attach to the server. For more information, see [the documentation](https://www.scaleway.com/en/docs/compute/elastic-metal/how-to/use-private-networks/)
        :param pulumi.Input[str] project_id: `project_id`) The ID of the project the server is associated with.
        :param pulumi.Input[bool] reinstall_on_config_changes: If True, this boolean allows to reinstall the server on install config changes.
               > **Important:** Updates to `ssh_key_ids`, `user`, `password`, `service_user` or `service_password` will not take effect on the server, it requires to reinstall it. To do so please set 'reinstall_on_config_changes' argument to true.
        :param pulumi.Input[str] service_password: Password used for the service to install. May be required depending on used os.
        :param pulumi.Input[str] service_user: User used for the service to install.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] ssh_key_ids: List of SSH keys allowed to connect to the server.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] tags: The tags associated with the server.
        :param pulumi.Input[str] user: User used for the installation.
        :param pulumi.Input[str] zone: `zone`) The zone in which the server should be created.
        """
        if description is not None:
            pulumi.set(__self__, "description", description)
        if domain is not None:
            pulumi.set(__self__, "domain", domain)
        if hostname is not None:
            pulumi.set(__self__, "hostname", hostname)
        if install_config_afterward is not None:
            pulumi.set(__self__, "install_config_afterward", install_config_afterward)
        if ips is not None:
            pulumi.set(__self__, "ips", ips)
        if ipv4s is not None:
            pulumi.set(__self__, "ipv4s", ipv4s)
        if ipv6s is not None:
            pulumi.set(__self__, "ipv6s", ipv6s)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if offer is not None:
            pulumi.set(__self__, "offer", offer)
        if offer_id is not None:
            pulumi.set(__self__, "offer_id", offer_id)
        if offer_name is not None:
            pulumi.set(__self__, "offer_name", offer_name)
        if options is not None:
            pulumi.set(__self__, "options", options)
        if organization_id is not None:
            pulumi.set(__self__, "organization_id", organization_id)
        if os is not None:
            pulumi.set(__self__, "os", os)
        if os_name is not None:
            pulumi.set(__self__, "os_name", os_name)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if private_networks is not None:
            pulumi.set(__self__, "private_networks", private_networks)
        if project_id is not None:
            pulumi.set(__self__, "project_id", project_id)
        if reinstall_on_config_changes is not None:
            pulumi.set(__self__, "reinstall_on_config_changes", reinstall_on_config_changes)
        if service_password is not None:
            pulumi.set(__self__, "service_password", service_password)
        if service_user is not None:
            pulumi.set(__self__, "service_user", service_user)
        if ssh_key_ids is not None:
            pulumi.set(__self__, "ssh_key_ids", ssh_key_ids)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if user is not None:
            pulumi.set(__self__, "user", user)
        if zone is not None:
            pulumi.set(__self__, "zone", zone)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        A description for the server.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def domain(self) -> Optional[pulumi.Input[str]]:
        """
        The domain of the server.
        """
        return pulumi.get(self, "domain")

    @domain.setter
    def domain(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "domain", value)

    @property
    @pulumi.getter
    def hostname(self) -> Optional[pulumi.Input[str]]:
        """
        The hostname of the server.
        """
        return pulumi.get(self, "hostname")

    @hostname.setter
    def hostname(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "hostname", value)

    @property
    @pulumi.getter(name="installConfigAfterward")
    def install_config_afterward(self) -> Optional[pulumi.Input[bool]]:
        """
        If True, this boolean allows to create a server without the install config if you want to provide it later.
        """
        return pulumi.get(self, "install_config_afterward")

    @install_config_afterward.setter
    def install_config_afterward(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "install_config_afterward", value)

    @property
    @pulumi.getter
    def ips(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['BaremetalServerIpArgs']]]]:
        """
        (List of) The IPs of the server.
        """
        return pulumi.get(self, "ips")

    @ips.setter
    def ips(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['BaremetalServerIpArgs']]]]):
        pulumi.set(self, "ips", value)

    @property
    @pulumi.getter
    def ipv4s(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['BaremetalServerIpv4Args']]]]:
        """
        (List of) The IPv4 addresses of the server.
        """
        return pulumi.get(self, "ipv4s")

    @ipv4s.setter
    def ipv4s(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['BaremetalServerIpv4Args']]]]):
        pulumi.set(self, "ipv4s", value)

    @property
    @pulumi.getter
    def ipv6s(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['BaremetalServerIpv6Args']]]]:
        """
        (List of) The IPv6 addresses of the server.
        """
        return pulumi.get(self, "ipv6s")

    @ipv6s.setter
    def ipv6s(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['BaremetalServerIpv6Args']]]]):
        pulumi.set(self, "ipv6s", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the server.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def offer(self) -> Optional[pulumi.Input[str]]:
        """
        The offer name or UUID of the baremetal server.
        Use [this endpoint](https://www.scaleway.com/en/developers/api/elastic-metal/#path-servers-get-a-specific-elastic-metal-server) to find the right offer.

        > **Important:** Updates to `offer` will recreate the server.
        """
        return pulumi.get(self, "offer")

    @offer.setter
    def offer(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "offer", value)

    @property
    @pulumi.getter(name="offerId")
    def offer_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the offer.
        """
        return pulumi.get(self, "offer_id")

    @offer_id.setter
    def offer_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "offer_id", value)

    @property
    @pulumi.getter(name="offerName")
    def offer_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the offer.
        """
        return pulumi.get(self, "offer_name")

    @offer_name.setter
    def offer_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "offer_name", value)

    @property
    @pulumi.getter
    def options(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['BaremetalServerOptionArgs']]]]:
        """
        The options to enable on the server.
        > The `options` block supports:
        """
        return pulumi.get(self, "options")

    @options.setter
    def options(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['BaremetalServerOptionArgs']]]]):
        pulumi.set(self, "options", value)

    @property
    @pulumi.getter(name="organizationId")
    def organization_id(self) -> Optional[pulumi.Input[str]]:
        """
        The organization ID the server is associated with.
        """
        return pulumi.get(self, "organization_id")

    @organization_id.setter
    def organization_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "organization_id", value)

    @property
    @pulumi.getter
    def os(self) -> Optional[pulumi.Input[str]]:
        """
        The UUID of the os to install on the server.
        Use [this endpoint](https://www.scaleway.com/en/developers/api/elastic-metal/#path-os-list-available-oses) to find the right OS ID.
        > **Important:** Updates to `os` will reinstall the server.
        """
        return pulumi.get(self, "os")

    @os.setter
    def os(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "os", value)

    @property
    @pulumi.getter(name="osName")
    def os_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the os.
        """
        return pulumi.get(self, "os_name")

    @os_name.setter
    def os_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "os_name", value)

    @property
    @pulumi.getter
    def password(self) -> Optional[pulumi.Input[str]]:
        """
        Password used for the installation. May be required depending on used os.
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "password", value)

    @property
    @pulumi.getter(name="privateNetworks")
    def private_networks(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['BaremetalServerPrivateNetworkArgs']]]]:
        """
        The private networks to attach to the server. For more information, see [the documentation](https://www.scaleway.com/en/docs/compute/elastic-metal/how-to/use-private-networks/)
        """
        return pulumi.get(self, "private_networks")

    @private_networks.setter
    def private_networks(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['BaremetalServerPrivateNetworkArgs']]]]):
        pulumi.set(self, "private_networks", value)

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[pulumi.Input[str]]:
        """
        `project_id`) The ID of the project the server is associated with.
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project_id", value)

    @property
    @pulumi.getter(name="reinstallOnConfigChanges")
    def reinstall_on_config_changes(self) -> Optional[pulumi.Input[bool]]:
        """
        If True, this boolean allows to reinstall the server on install config changes.
        > **Important:** Updates to `ssh_key_ids`, `user`, `password`, `service_user` or `service_password` will not take effect on the server, it requires to reinstall it. To do so please set 'reinstall_on_config_changes' argument to true.
        """
        return pulumi.get(self, "reinstall_on_config_changes")

    @reinstall_on_config_changes.setter
    def reinstall_on_config_changes(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "reinstall_on_config_changes", value)

    @property
    @pulumi.getter(name="servicePassword")
    def service_password(self) -> Optional[pulumi.Input[str]]:
        """
        Password used for the service to install. May be required depending on used os.
        """
        return pulumi.get(self, "service_password")

    @service_password.setter
    def service_password(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "service_password", value)

    @property
    @pulumi.getter(name="serviceUser")
    def service_user(self) -> Optional[pulumi.Input[str]]:
        """
        User used for the service to install.
        """
        return pulumi.get(self, "service_user")

    @service_user.setter
    def service_user(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "service_user", value)

    @property
    @pulumi.getter(name="sshKeyIds")
    def ssh_key_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of SSH keys allowed to connect to the server.
        """
        return pulumi.get(self, "ssh_key_ids")

    @ssh_key_ids.setter
    def ssh_key_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "ssh_key_ids", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The tags associated with the server.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter
    def user(self) -> Optional[pulumi.Input[str]]:
        """
        User used for the installation.
        """
        return pulumi.get(self, "user")

    @user.setter
    def user(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "user", value)

    @property
    @pulumi.getter
    def zone(self) -> Optional[pulumi.Input[str]]:
        """
        `zone`) The zone in which the server should be created.
        """
        return pulumi.get(self, "zone")

    @zone.setter
    def zone(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "zone", value)


class BaremetalServer(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 hostname: Optional[pulumi.Input[str]] = None,
                 install_config_afterward: Optional[pulumi.Input[bool]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 offer: Optional[pulumi.Input[str]] = None,
                 options: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['BaremetalServerOptionArgs']]]]] = None,
                 os: Optional[pulumi.Input[str]] = None,
                 password: Optional[pulumi.Input[str]] = None,
                 private_networks: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['BaremetalServerPrivateNetworkArgs']]]]] = None,
                 project_id: Optional[pulumi.Input[str]] = None,
                 reinstall_on_config_changes: Optional[pulumi.Input[bool]] = None,
                 service_password: Optional[pulumi.Input[str]] = None,
                 service_user: Optional[pulumi.Input[str]] = None,
                 ssh_key_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 user: Optional[pulumi.Input[str]] = None,
                 zone: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Creates and manages Scaleway Compute Baremetal servers. For more information, see [the documentation](https://www.scaleway.com/en/developers/api/elastic-metal/).

        ## Example Usage

        ### Basic

        ```python
        import pulumi
        import ediri_scaleway as scaleway
        import pulumi_scaleway as scaleway

        main = scaleway.get_account_ssh_key(name="main")
        base = scaleway.BaremetalServer("base",
            zone="fr-par-2",
            offer="GP-BM1-S",
            os="d17d6872-0412-45d9-a198-af82c34d3c5c",
            ssh_key_ids=[main.id])
        ```

        ### Without install config

        ```python
        import pulumi
        import ediri_scaleway as scaleway
        import pulumi_scaleway as scaleway

        my_offer = scaleway.get_baremetal_offer(zone="fr-par-2",
            name="EM-B112X-SSD")
        base = scaleway.BaremetalServer("base",
            zone="fr-par-2",
            offer=my_offer.offer_id,
            install_config_afterward=True)
        ```

        ## Import

        Baremetal servers can be imported using the `{zone}/{id}`, e.g.

        bash

        ```sh
        $ pulumi import scaleway:index/baremetalServer:BaremetalServer web fr-par-2/11111111-1111-1111-1111-111111111111
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] description: A description for the server.
        :param pulumi.Input[str] hostname: The hostname of the server.
        :param pulumi.Input[bool] install_config_afterward: If True, this boolean allows to create a server without the install config if you want to provide it later.
        :param pulumi.Input[str] name: The name of the server.
        :param pulumi.Input[str] offer: The offer name or UUID of the baremetal server.
               Use [this endpoint](https://www.scaleway.com/en/developers/api/elastic-metal/#path-servers-get-a-specific-elastic-metal-server) to find the right offer.
               
               > **Important:** Updates to `offer` will recreate the server.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['BaremetalServerOptionArgs']]]] options: The options to enable on the server.
               > The `options` block supports:
        :param pulumi.Input[str] os: The UUID of the os to install on the server.
               Use [this endpoint](https://www.scaleway.com/en/developers/api/elastic-metal/#path-os-list-available-oses) to find the right OS ID.
               > **Important:** Updates to `os` will reinstall the server.
        :param pulumi.Input[str] password: Password used for the installation. May be required depending on used os.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['BaremetalServerPrivateNetworkArgs']]]] private_networks: The private networks to attach to the server. For more information, see [the documentation](https://www.scaleway.com/en/docs/compute/elastic-metal/how-to/use-private-networks/)
        :param pulumi.Input[str] project_id: `project_id`) The ID of the project the server is associated with.
        :param pulumi.Input[bool] reinstall_on_config_changes: If True, this boolean allows to reinstall the server on install config changes.
               > **Important:** Updates to `ssh_key_ids`, `user`, `password`, `service_user` or `service_password` will not take effect on the server, it requires to reinstall it. To do so please set 'reinstall_on_config_changes' argument to true.
        :param pulumi.Input[str] service_password: Password used for the service to install. May be required depending on used os.
        :param pulumi.Input[str] service_user: User used for the service to install.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] ssh_key_ids: List of SSH keys allowed to connect to the server.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] tags: The tags associated with the server.
        :param pulumi.Input[str] user: User used for the installation.
        :param pulumi.Input[str] zone: `zone`) The zone in which the server should be created.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: BaremetalServerArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Creates and manages Scaleway Compute Baremetal servers. For more information, see [the documentation](https://www.scaleway.com/en/developers/api/elastic-metal/).

        ## Example Usage

        ### Basic

        ```python
        import pulumi
        import ediri_scaleway as scaleway
        import pulumi_scaleway as scaleway

        main = scaleway.get_account_ssh_key(name="main")
        base = scaleway.BaremetalServer("base",
            zone="fr-par-2",
            offer="GP-BM1-S",
            os="d17d6872-0412-45d9-a198-af82c34d3c5c",
            ssh_key_ids=[main.id])
        ```

        ### Without install config

        ```python
        import pulumi
        import ediri_scaleway as scaleway
        import pulumi_scaleway as scaleway

        my_offer = scaleway.get_baremetal_offer(zone="fr-par-2",
            name="EM-B112X-SSD")
        base = scaleway.BaremetalServer("base",
            zone="fr-par-2",
            offer=my_offer.offer_id,
            install_config_afterward=True)
        ```

        ## Import

        Baremetal servers can be imported using the `{zone}/{id}`, e.g.

        bash

        ```sh
        $ pulumi import scaleway:index/baremetalServer:BaremetalServer web fr-par-2/11111111-1111-1111-1111-111111111111
        ```

        :param str resource_name: The name of the resource.
        :param BaremetalServerArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(BaremetalServerArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 hostname: Optional[pulumi.Input[str]] = None,
                 install_config_afterward: Optional[pulumi.Input[bool]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 offer: Optional[pulumi.Input[str]] = None,
                 options: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['BaremetalServerOptionArgs']]]]] = None,
                 os: Optional[pulumi.Input[str]] = None,
                 password: Optional[pulumi.Input[str]] = None,
                 private_networks: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['BaremetalServerPrivateNetworkArgs']]]]] = None,
                 project_id: Optional[pulumi.Input[str]] = None,
                 reinstall_on_config_changes: Optional[pulumi.Input[bool]] = None,
                 service_password: Optional[pulumi.Input[str]] = None,
                 service_user: Optional[pulumi.Input[str]] = None,
                 ssh_key_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 user: Optional[pulumi.Input[str]] = None,
                 zone: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = BaremetalServerArgs.__new__(BaremetalServerArgs)

            __props__.__dict__["description"] = description
            __props__.__dict__["hostname"] = hostname
            __props__.__dict__["install_config_afterward"] = install_config_afterward
            __props__.__dict__["name"] = name
            if offer is None and not opts.urn:
                raise TypeError("Missing required property 'offer'")
            __props__.__dict__["offer"] = offer
            __props__.__dict__["options"] = options
            __props__.__dict__["os"] = os
            __props__.__dict__["password"] = None if password is None else pulumi.Output.secret(password)
            __props__.__dict__["private_networks"] = private_networks
            __props__.__dict__["project_id"] = project_id
            __props__.__dict__["reinstall_on_config_changes"] = reinstall_on_config_changes
            __props__.__dict__["service_password"] = None if service_password is None else pulumi.Output.secret(service_password)
            __props__.__dict__["service_user"] = service_user
            __props__.__dict__["ssh_key_ids"] = ssh_key_ids
            __props__.__dict__["tags"] = tags
            __props__.__dict__["user"] = user
            __props__.__dict__["zone"] = zone
            __props__.__dict__["domain"] = None
            __props__.__dict__["ips"] = None
            __props__.__dict__["ipv4s"] = None
            __props__.__dict__["ipv6s"] = None
            __props__.__dict__["offer_id"] = None
            __props__.__dict__["offer_name"] = None
            __props__.__dict__["organization_id"] = None
            __props__.__dict__["os_name"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["password", "servicePassword"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(BaremetalServer, __self__).__init__(
            'scaleway:index/baremetalServer:BaremetalServer',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            description: Optional[pulumi.Input[str]] = None,
            domain: Optional[pulumi.Input[str]] = None,
            hostname: Optional[pulumi.Input[str]] = None,
            install_config_afterward: Optional[pulumi.Input[bool]] = None,
            ips: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['BaremetalServerIpArgs']]]]] = None,
            ipv4s: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['BaremetalServerIpv4Args']]]]] = None,
            ipv6s: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['BaremetalServerIpv6Args']]]]] = None,
            name: Optional[pulumi.Input[str]] = None,
            offer: Optional[pulumi.Input[str]] = None,
            offer_id: Optional[pulumi.Input[str]] = None,
            offer_name: Optional[pulumi.Input[str]] = None,
            options: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['BaremetalServerOptionArgs']]]]] = None,
            organization_id: Optional[pulumi.Input[str]] = None,
            os: Optional[pulumi.Input[str]] = None,
            os_name: Optional[pulumi.Input[str]] = None,
            password: Optional[pulumi.Input[str]] = None,
            private_networks: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['BaremetalServerPrivateNetworkArgs']]]]] = None,
            project_id: Optional[pulumi.Input[str]] = None,
            reinstall_on_config_changes: Optional[pulumi.Input[bool]] = None,
            service_password: Optional[pulumi.Input[str]] = None,
            service_user: Optional[pulumi.Input[str]] = None,
            ssh_key_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            tags: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            user: Optional[pulumi.Input[str]] = None,
            zone: Optional[pulumi.Input[str]] = None) -> 'BaremetalServer':
        """
        Get an existing BaremetalServer resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] description: A description for the server.
        :param pulumi.Input[str] domain: The domain of the server.
        :param pulumi.Input[str] hostname: The hostname of the server.
        :param pulumi.Input[bool] install_config_afterward: If True, this boolean allows to create a server without the install config if you want to provide it later.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['BaremetalServerIpArgs']]]] ips: (List of) The IPs of the server.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['BaremetalServerIpv4Args']]]] ipv4s: (List of) The IPv4 addresses of the server.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['BaremetalServerIpv6Args']]]] ipv6s: (List of) The IPv6 addresses of the server.
        :param pulumi.Input[str] name: The name of the server.
        :param pulumi.Input[str] offer: The offer name or UUID of the baremetal server.
               Use [this endpoint](https://www.scaleway.com/en/developers/api/elastic-metal/#path-servers-get-a-specific-elastic-metal-server) to find the right offer.
               
               > **Important:** Updates to `offer` will recreate the server.
        :param pulumi.Input[str] offer_id: The ID of the offer.
        :param pulumi.Input[str] offer_name: The name of the offer.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['BaremetalServerOptionArgs']]]] options: The options to enable on the server.
               > The `options` block supports:
        :param pulumi.Input[str] organization_id: The organization ID the server is associated with.
        :param pulumi.Input[str] os: The UUID of the os to install on the server.
               Use [this endpoint](https://www.scaleway.com/en/developers/api/elastic-metal/#path-os-list-available-oses) to find the right OS ID.
               > **Important:** Updates to `os` will reinstall the server.
        :param pulumi.Input[str] os_name: The name of the os.
        :param pulumi.Input[str] password: Password used for the installation. May be required depending on used os.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['BaremetalServerPrivateNetworkArgs']]]] private_networks: The private networks to attach to the server. For more information, see [the documentation](https://www.scaleway.com/en/docs/compute/elastic-metal/how-to/use-private-networks/)
        :param pulumi.Input[str] project_id: `project_id`) The ID of the project the server is associated with.
        :param pulumi.Input[bool] reinstall_on_config_changes: If True, this boolean allows to reinstall the server on install config changes.
               > **Important:** Updates to `ssh_key_ids`, `user`, `password`, `service_user` or `service_password` will not take effect on the server, it requires to reinstall it. To do so please set 'reinstall_on_config_changes' argument to true.
        :param pulumi.Input[str] service_password: Password used for the service to install. May be required depending on used os.
        :param pulumi.Input[str] service_user: User used for the service to install.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] ssh_key_ids: List of SSH keys allowed to connect to the server.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] tags: The tags associated with the server.
        :param pulumi.Input[str] user: User used for the installation.
        :param pulumi.Input[str] zone: `zone`) The zone in which the server should be created.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _BaremetalServerState.__new__(_BaremetalServerState)

        __props__.__dict__["description"] = description
        __props__.__dict__["domain"] = domain
        __props__.__dict__["hostname"] = hostname
        __props__.__dict__["install_config_afterward"] = install_config_afterward
        __props__.__dict__["ips"] = ips
        __props__.__dict__["ipv4s"] = ipv4s
        __props__.__dict__["ipv6s"] = ipv6s
        __props__.__dict__["name"] = name
        __props__.__dict__["offer"] = offer
        __props__.__dict__["offer_id"] = offer_id
        __props__.__dict__["offer_name"] = offer_name
        __props__.__dict__["options"] = options
        __props__.__dict__["organization_id"] = organization_id
        __props__.__dict__["os"] = os
        __props__.__dict__["os_name"] = os_name
        __props__.__dict__["password"] = password
        __props__.__dict__["private_networks"] = private_networks
        __props__.__dict__["project_id"] = project_id
        __props__.__dict__["reinstall_on_config_changes"] = reinstall_on_config_changes
        __props__.__dict__["service_password"] = service_password
        __props__.__dict__["service_user"] = service_user
        __props__.__dict__["ssh_key_ids"] = ssh_key_ids
        __props__.__dict__["tags"] = tags
        __props__.__dict__["user"] = user
        __props__.__dict__["zone"] = zone
        return BaremetalServer(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[str]]:
        """
        A description for the server.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def domain(self) -> pulumi.Output[str]:
        """
        The domain of the server.
        """
        return pulumi.get(self, "domain")

    @property
    @pulumi.getter
    def hostname(self) -> pulumi.Output[Optional[str]]:
        """
        The hostname of the server.
        """
        return pulumi.get(self, "hostname")

    @property
    @pulumi.getter(name="installConfigAfterward")
    def install_config_afterward(self) -> pulumi.Output[Optional[bool]]:
        """
        If True, this boolean allows to create a server without the install config if you want to provide it later.
        """
        return pulumi.get(self, "install_config_afterward")

    @property
    @pulumi.getter
    def ips(self) -> pulumi.Output[Sequence['outputs.BaremetalServerIp']]:
        """
        (List of) The IPs of the server.
        """
        return pulumi.get(self, "ips")

    @property
    @pulumi.getter
    def ipv4s(self) -> pulumi.Output[Sequence['outputs.BaremetalServerIpv4']]:
        """
        (List of) The IPv4 addresses of the server.
        """
        return pulumi.get(self, "ipv4s")

    @property
    @pulumi.getter
    def ipv6s(self) -> pulumi.Output[Sequence['outputs.BaremetalServerIpv6']]:
        """
        (List of) The IPv6 addresses of the server.
        """
        return pulumi.get(self, "ipv6s")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The name of the server.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def offer(self) -> pulumi.Output[str]:
        """
        The offer name or UUID of the baremetal server.
        Use [this endpoint](https://www.scaleway.com/en/developers/api/elastic-metal/#path-servers-get-a-specific-elastic-metal-server) to find the right offer.

        > **Important:** Updates to `offer` will recreate the server.
        """
        return pulumi.get(self, "offer")

    @property
    @pulumi.getter(name="offerId")
    def offer_id(self) -> pulumi.Output[str]:
        """
        The ID of the offer.
        """
        return pulumi.get(self, "offer_id")

    @property
    @pulumi.getter(name="offerName")
    def offer_name(self) -> pulumi.Output[str]:
        """
        The name of the offer.
        """
        return pulumi.get(self, "offer_name")

    @property
    @pulumi.getter
    def options(self) -> pulumi.Output[Optional[Sequence['outputs.BaremetalServerOption']]]:
        """
        The options to enable on the server.
        > The `options` block supports:
        """
        return pulumi.get(self, "options")

    @property
    @pulumi.getter(name="organizationId")
    def organization_id(self) -> pulumi.Output[str]:
        """
        The organization ID the server is associated with.
        """
        return pulumi.get(self, "organization_id")

    @property
    @pulumi.getter
    def os(self) -> pulumi.Output[Optional[str]]:
        """
        The UUID of the os to install on the server.
        Use [this endpoint](https://www.scaleway.com/en/developers/api/elastic-metal/#path-os-list-available-oses) to find the right OS ID.
        > **Important:** Updates to `os` will reinstall the server.
        """
        return pulumi.get(self, "os")

    @property
    @pulumi.getter(name="osName")
    def os_name(self) -> pulumi.Output[str]:
        """
        The name of the os.
        """
        return pulumi.get(self, "os_name")

    @property
    @pulumi.getter
    def password(self) -> pulumi.Output[Optional[str]]:
        """
        Password used for the installation. May be required depending on used os.
        """
        return pulumi.get(self, "password")

    @property
    @pulumi.getter(name="privateNetworks")
    def private_networks(self) -> pulumi.Output[Optional[Sequence['outputs.BaremetalServerPrivateNetwork']]]:
        """
        The private networks to attach to the server. For more information, see [the documentation](https://www.scaleway.com/en/docs/compute/elastic-metal/how-to/use-private-networks/)
        """
        return pulumi.get(self, "private_networks")

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> pulumi.Output[str]:
        """
        `project_id`) The ID of the project the server is associated with.
        """
        return pulumi.get(self, "project_id")

    @property
    @pulumi.getter(name="reinstallOnConfigChanges")
    def reinstall_on_config_changes(self) -> pulumi.Output[Optional[bool]]:
        """
        If True, this boolean allows to reinstall the server on install config changes.
        > **Important:** Updates to `ssh_key_ids`, `user`, `password`, `service_user` or `service_password` will not take effect on the server, it requires to reinstall it. To do so please set 'reinstall_on_config_changes' argument to true.
        """
        return pulumi.get(self, "reinstall_on_config_changes")

    @property
    @pulumi.getter(name="servicePassword")
    def service_password(self) -> pulumi.Output[Optional[str]]:
        """
        Password used for the service to install. May be required depending on used os.
        """
        return pulumi.get(self, "service_password")

    @property
    @pulumi.getter(name="serviceUser")
    def service_user(self) -> pulumi.Output[str]:
        """
        User used for the service to install.
        """
        return pulumi.get(self, "service_user")

    @property
    @pulumi.getter(name="sshKeyIds")
    def ssh_key_ids(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        List of SSH keys allowed to connect to the server.
        """
        return pulumi.get(self, "ssh_key_ids")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Sequence[str]]:
        """
        The tags associated with the server.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter
    def user(self) -> pulumi.Output[str]:
        """
        User used for the installation.
        """
        return pulumi.get(self, "user")

    @property
    @pulumi.getter
    def zone(self) -> pulumi.Output[str]:
        """
        `zone`) The zone in which the server should be created.
        """
        return pulumi.get(self, "zone")

