# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities

__all__ = [
    'BaremetalServerIpArgs',
    'BaremetalServerIpv4Args',
    'BaremetalServerIpv6Args',
    'BaremetalServerOptionArgs',
    'BaremetalServerPrivateNetworkArgs',
    'CockpitAlertManagerContactPointArgs',
    'CockpitEndpointArgs',
    'CockpitPushUrlArgs',
    'CockpitTokenScopesArgs',
    'ContainerTriggerNatsArgs',
    'ContainerTriggerSqsArgs',
    'DocumentdbReadReplicaDirectAccessArgs',
    'DocumentdbReadReplicaPrivateNetworkArgs',
    'DomainRecordGeoIpArgs',
    'DomainRecordGeoIpMatchArgs',
    'DomainRecordHttpServiceArgs',
    'DomainRecordViewArgs',
    'DomainRecordWeightedArgs',
    'FunctionTriggerNatsArgs',
    'FunctionTriggerSqsArgs',
    'IamPolicyRuleArgs',
    'InstanceImageAdditionalVolumeArgs',
    'InstanceSecurityGroupInboundRuleArgs',
    'InstanceSecurityGroupOutboundRuleArgs',
    'InstanceSecurityGroupRulesInboundRuleArgs',
    'InstanceSecurityGroupRulesOutboundRuleArgs',
    'InstanceServerPrivateNetworkArgs',
    'InstanceServerPublicIpArgs',
    'InstanceServerRootVolumeArgs',
    'InstanceSnapshotImportArgs',
    'IotDeviceCertificateArgs',
    'IotDeviceMessageFiltersArgs',
    'IotDeviceMessageFiltersPublishArgs',
    'IotDeviceMessageFiltersSubscribeArgs',
    'IotRouteDatabaseArgs',
    'IotRouteRestArgs',
    'IotRouteS3Args',
    'IpamIpResourceArgs',
    'IpamIpReverseArgs',
    'IpamIpSourceArgs',
    'JobDefinitionCronArgs',
    'K8sClusterAutoUpgradeArgs',
    'K8sClusterAutoscalerConfigArgs',
    'K8sClusterKubeconfigArgs',
    'K8sClusterOpenIdConnectConfigArgs',
    'K8sPoolNodeArgs',
    'K8sPoolUpgradePolicyArgs',
    'LbAclActionArgs',
    'LbAclActionRedirectArgs',
    'LbAclMatchArgs',
    'LbBackendHealthCheckHttpArgs',
    'LbBackendHealthCheckHttpsArgs',
    'LbBackendHealthCheckTcpArgs',
    'LbCertificateCustomCertificateArgs',
    'LbCertificateLetsencryptArgs',
    'LbFrontendAclArgs',
    'LbFrontendAclActionArgs',
    'LbFrontendAclActionRedirectArgs',
    'LbFrontendAclMatchArgs',
    'LbPrivateNetworkArgs',
    'MnqSnsCredentialsPermissionsArgs',
    'MnqSqsCredentialsPermissionsArgs',
    'ObjectBucketAclAccessControlPolicyArgs',
    'ObjectBucketAclAccessControlPolicyGrantArgs',
    'ObjectBucketAclAccessControlPolicyGrantGranteeArgs',
    'ObjectBucketAclAccessControlPolicyOwnerArgs',
    'ObjectBucketCorsRuleArgs',
    'ObjectBucketLifecycleRuleArgs',
    'ObjectBucketLifecycleRuleExpirationArgs',
    'ObjectBucketLifecycleRuleTransitionArgs',
    'ObjectBucketLockConfigurationRuleArgs',
    'ObjectBucketLockConfigurationRuleDefaultRetentionArgs',
    'ObjectBucketVersioningArgs',
    'ObjectBucketWebsiteConfigurationErrorDocumentArgs',
    'ObjectBucketWebsiteConfigurationIndexDocumentArgs',
    'RdbAclAclRuleArgs',
    'RdbInstanceLoadBalancerArgs',
    'RdbInstanceLogsPolicyArgs',
    'RdbInstancePrivateNetworkArgs',
    'RdbInstanceReadReplicaArgs',
    'RdbReadReplicaDirectAccessArgs',
    'RdbReadReplicaPrivateNetworkArgs',
    'RedisClusterAclArgs',
    'RedisClusterPrivateNetworkArgs',
    'RedisClusterPublicNetworkArgs',
    'TemDomainReputationArgs',
    'VpcGatewayNetworkIpamConfigArgs',
    'VpcPrivateNetworkIpv4SubnetArgs',
    'VpcPrivateNetworkIpv6SubnetArgs',
    'WebhostingCpanelUrlArgs',
    'WebhostingOptionArgs',
    'GetIpamIpResourceArgs',
    'GetIpamIpsResourceArgs',
]

@pulumi.input_type
class BaremetalServerIpArgs:
    def __init__(__self__, *,
                 address: Optional[pulumi.Input[str]] = None,
                 id: Optional[pulumi.Input[str]] = None,
                 reverse: Optional[pulumi.Input[str]] = None,
                 version: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] address: The address of the IPv6.
        :param pulumi.Input[str] id: The ID of the IPv6.
        :param pulumi.Input[str] reverse: The reverse of the IPv6.
        :param pulumi.Input[str] version: The type of the IPv6.
        """
        if address is not None:
            pulumi.set(__self__, "address", address)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if reverse is not None:
            pulumi.set(__self__, "reverse", reverse)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter
    def address(self) -> Optional[pulumi.Input[str]]:
        """
        The address of the IPv6.
        """
        return pulumi.get(self, "address")

    @address.setter
    def address(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "address", value)

    @property
    @pulumi.getter
    def id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the IPv6.
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "id", value)

    @property
    @pulumi.getter
    def reverse(self) -> Optional[pulumi.Input[str]]:
        """
        The reverse of the IPv6.
        """
        return pulumi.get(self, "reverse")

    @reverse.setter
    def reverse(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "reverse", value)

    @property
    @pulumi.getter
    def version(self) -> Optional[pulumi.Input[str]]:
        """
        The type of the IPv6.
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "version", value)


@pulumi.input_type
class BaremetalServerIpv4Args:
    def __init__(__self__, *,
                 address: Optional[pulumi.Input[str]] = None,
                 id: Optional[pulumi.Input[str]] = None,
                 reverse: Optional[pulumi.Input[str]] = None,
                 version: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] address: The address of the IPv6.
        :param pulumi.Input[str] id: The ID of the IPv6.
        :param pulumi.Input[str] reverse: The reverse of the IPv6.
        :param pulumi.Input[str] version: The type of the IPv6.
        """
        if address is not None:
            pulumi.set(__self__, "address", address)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if reverse is not None:
            pulumi.set(__self__, "reverse", reverse)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter
    def address(self) -> Optional[pulumi.Input[str]]:
        """
        The address of the IPv6.
        """
        return pulumi.get(self, "address")

    @address.setter
    def address(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "address", value)

    @property
    @pulumi.getter
    def id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the IPv6.
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "id", value)

    @property
    @pulumi.getter
    def reverse(self) -> Optional[pulumi.Input[str]]:
        """
        The reverse of the IPv6.
        """
        return pulumi.get(self, "reverse")

    @reverse.setter
    def reverse(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "reverse", value)

    @property
    @pulumi.getter
    def version(self) -> Optional[pulumi.Input[str]]:
        """
        The type of the IPv6.
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "version", value)


@pulumi.input_type
class BaremetalServerIpv6Args:
    def __init__(__self__, *,
                 address: Optional[pulumi.Input[str]] = None,
                 id: Optional[pulumi.Input[str]] = None,
                 reverse: Optional[pulumi.Input[str]] = None,
                 version: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] address: The address of the IPv6.
        :param pulumi.Input[str] id: The ID of the IPv6.
        :param pulumi.Input[str] reverse: The reverse of the IPv6.
        :param pulumi.Input[str] version: The type of the IPv6.
        """
        if address is not None:
            pulumi.set(__self__, "address", address)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if reverse is not None:
            pulumi.set(__self__, "reverse", reverse)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter
    def address(self) -> Optional[pulumi.Input[str]]:
        """
        The address of the IPv6.
        """
        return pulumi.get(self, "address")

    @address.setter
    def address(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "address", value)

    @property
    @pulumi.getter
    def id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the IPv6.
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "id", value)

    @property
    @pulumi.getter
    def reverse(self) -> Optional[pulumi.Input[str]]:
        """
        The reverse of the IPv6.
        """
        return pulumi.get(self, "reverse")

    @reverse.setter
    def reverse(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "reverse", value)

    @property
    @pulumi.getter
    def version(self) -> Optional[pulumi.Input[str]]:
        """
        The type of the IPv6.
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "version", value)


@pulumi.input_type
class BaremetalServerOptionArgs:
    def __init__(__self__, *,
                 id: pulumi.Input[str],
                 expires_at: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] id: The id of the option to enable. Use [this endpoint](https://www.scaleway.com/en/developers/api/elastic-metal/#path-options-list-options) to find the available options IDs.
        :param pulumi.Input[str] expires_at: The auto expiration date for compatible options
        :param pulumi.Input[str] name: The name of the server.
        """
        pulumi.set(__self__, "id", id)
        if expires_at is not None:
            pulumi.set(__self__, "expires_at", expires_at)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def id(self) -> pulumi.Input[str]:
        """
        The id of the option to enable. Use [this endpoint](https://www.scaleway.com/en/developers/api/elastic-metal/#path-options-list-options) to find the available options IDs.
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: pulumi.Input[str]):
        pulumi.set(self, "id", value)

    @property
    @pulumi.getter(name="expiresAt")
    def expires_at(self) -> Optional[pulumi.Input[str]]:
        """
        The auto expiration date for compatible options
        """
        return pulumi.get(self, "expires_at")

    @expires_at.setter
    def expires_at(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "expires_at", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the server.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class BaremetalServerPrivateNetworkArgs:
    def __init__(__self__, *,
                 id: pulumi.Input[str],
                 created_at: Optional[pulumi.Input[str]] = None,
                 status: Optional[pulumi.Input[str]] = None,
                 updated_at: Optional[pulumi.Input[str]] = None,
                 vlan: Optional[pulumi.Input[int]] = None):
        """
        :param pulumi.Input[str] id: The id of the private network to attach.
        :param pulumi.Input[str] created_at: The date and time of the creation of the private network.
        :param pulumi.Input[str] status: The private network status.
        :param pulumi.Input[str] updated_at: The date and time of the last update of the private network.
        :param pulumi.Input[int] vlan: The VLAN ID associated to the private network.
        """
        pulumi.set(__self__, "id", id)
        if created_at is not None:
            pulumi.set(__self__, "created_at", created_at)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if updated_at is not None:
            pulumi.set(__self__, "updated_at", updated_at)
        if vlan is not None:
            pulumi.set(__self__, "vlan", vlan)

    @property
    @pulumi.getter
    def id(self) -> pulumi.Input[str]:
        """
        The id of the private network to attach.
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: pulumi.Input[str]):
        pulumi.set(self, "id", value)

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[pulumi.Input[str]]:
        """
        The date and time of the creation of the private network.
        """
        return pulumi.get(self, "created_at")

    @created_at.setter
    def created_at(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "created_at", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[str]]:
        """
        The private network status.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "status", value)

    @property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> Optional[pulumi.Input[str]]:
        """
        The date and time of the last update of the private network.
        """
        return pulumi.get(self, "updated_at")

    @updated_at.setter
    def updated_at(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "updated_at", value)

    @property
    @pulumi.getter
    def vlan(self) -> Optional[pulumi.Input[int]]:
        """
        The VLAN ID associated to the private network.
        """
        return pulumi.get(self, "vlan")

    @vlan.setter
    def vlan(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "vlan", value)


@pulumi.input_type
class CockpitAlertManagerContactPointArgs:
    def __init__(__self__, *,
                 email: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] email: Email addresses for the alert receivers
        """
        if email is not None:
            pulumi.set(__self__, "email", email)

    @property
    @pulumi.getter
    def email(self) -> Optional[pulumi.Input[str]]:
        """
        Email addresses for the alert receivers
        """
        return pulumi.get(self, "email")

    @email.setter
    def email(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "email", value)


@pulumi.input_type
class CockpitEndpointArgs:
    def __init__(__self__, *,
                 alertmanager_url: Optional[pulumi.Input[str]] = None,
                 grafana_url: Optional[pulumi.Input[str]] = None,
                 logs_url: Optional[pulumi.Input[str]] = None,
                 metrics_url: Optional[pulumi.Input[str]] = None,
                 traces_url: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] alertmanager_url: The alertmanager URL.
        :param pulumi.Input[str] grafana_url: The grafana URL.
        :param pulumi.Input[str] logs_url: The logs URL.
        :param pulumi.Input[str] metrics_url: The metrics URL.
        :param pulumi.Input[str] traces_url: The traces URL.
        """
        if alertmanager_url is not None:
            pulumi.set(__self__, "alertmanager_url", alertmanager_url)
        if grafana_url is not None:
            pulumi.set(__self__, "grafana_url", grafana_url)
        if logs_url is not None:
            pulumi.set(__self__, "logs_url", logs_url)
        if metrics_url is not None:
            pulumi.set(__self__, "metrics_url", metrics_url)
        if traces_url is not None:
            pulumi.set(__self__, "traces_url", traces_url)

    @property
    @pulumi.getter(name="alertmanagerUrl")
    def alertmanager_url(self) -> Optional[pulumi.Input[str]]:
        """
        The alertmanager URL.
        """
        return pulumi.get(self, "alertmanager_url")

    @alertmanager_url.setter
    def alertmanager_url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "alertmanager_url", value)

    @property
    @pulumi.getter(name="grafanaUrl")
    def grafana_url(self) -> Optional[pulumi.Input[str]]:
        """
        The grafana URL.
        """
        return pulumi.get(self, "grafana_url")

    @grafana_url.setter
    def grafana_url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "grafana_url", value)

    @property
    @pulumi.getter(name="logsUrl")
    def logs_url(self) -> Optional[pulumi.Input[str]]:
        """
        The logs URL.
        """
        return pulumi.get(self, "logs_url")

    @logs_url.setter
    def logs_url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "logs_url", value)

    @property
    @pulumi.getter(name="metricsUrl")
    def metrics_url(self) -> Optional[pulumi.Input[str]]:
        """
        The metrics URL.
        """
        return pulumi.get(self, "metrics_url")

    @metrics_url.setter
    def metrics_url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "metrics_url", value)

    @property
    @pulumi.getter(name="tracesUrl")
    def traces_url(self) -> Optional[pulumi.Input[str]]:
        """
        The traces URL.
        """
        return pulumi.get(self, "traces_url")

    @traces_url.setter
    def traces_url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "traces_url", value)


@pulumi.input_type
class CockpitPushUrlArgs:
    def __init__(__self__, *,
                 push_logs_url: Optional[pulumi.Input[str]] = None,
                 push_metrics_url: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] push_logs_url: Push URL for logs (Grafana Loki)
        :param pulumi.Input[str] push_metrics_url: Push URL for metrics (Grafana Mimir)
        """
        if push_logs_url is not None:
            pulumi.set(__self__, "push_logs_url", push_logs_url)
        if push_metrics_url is not None:
            pulumi.set(__self__, "push_metrics_url", push_metrics_url)

    @property
    @pulumi.getter(name="pushLogsUrl")
    def push_logs_url(self) -> Optional[pulumi.Input[str]]:
        """
        Push URL for logs (Grafana Loki)
        """
        return pulumi.get(self, "push_logs_url")

    @push_logs_url.setter
    def push_logs_url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "push_logs_url", value)

    @property
    @pulumi.getter(name="pushMetricsUrl")
    def push_metrics_url(self) -> Optional[pulumi.Input[str]]:
        """
        Push URL for metrics (Grafana Mimir)
        """
        return pulumi.get(self, "push_metrics_url")

    @push_metrics_url.setter
    def push_metrics_url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "push_metrics_url", value)


@pulumi.input_type
class CockpitTokenScopesArgs:
    def __init__(__self__, *,
                 query_logs: Optional[pulumi.Input[bool]] = None,
                 query_metrics: Optional[pulumi.Input[bool]] = None,
                 query_traces: Optional[pulumi.Input[bool]] = None,
                 setup_alerts: Optional[pulumi.Input[bool]] = None,
                 setup_logs_rules: Optional[pulumi.Input[bool]] = None,
                 setup_metrics_rules: Optional[pulumi.Input[bool]] = None,
                 write_logs: Optional[pulumi.Input[bool]] = None,
                 write_metrics: Optional[pulumi.Input[bool]] = None,
                 write_traces: Optional[pulumi.Input[bool]] = None):
        """
        :param pulumi.Input[bool] query_logs: Query logs.
        :param pulumi.Input[bool] query_metrics: Query metrics.
        :param pulumi.Input[bool] query_traces: Query traces.
        :param pulumi.Input[bool] setup_alerts: Setup alerts.
        :param pulumi.Input[bool] setup_logs_rules: Setup logs rules.
        :param pulumi.Input[bool] setup_metrics_rules: Setup metrics rules.
        :param pulumi.Input[bool] write_logs: Write logs.
        :param pulumi.Input[bool] write_metrics: Write metrics.
        :param pulumi.Input[bool] write_traces: Write traces.
        """
        if query_logs is not None:
            pulumi.set(__self__, "query_logs", query_logs)
        if query_metrics is not None:
            pulumi.set(__self__, "query_metrics", query_metrics)
        if query_traces is not None:
            pulumi.set(__self__, "query_traces", query_traces)
        if setup_alerts is not None:
            pulumi.set(__self__, "setup_alerts", setup_alerts)
        if setup_logs_rules is not None:
            pulumi.set(__self__, "setup_logs_rules", setup_logs_rules)
        if setup_metrics_rules is not None:
            pulumi.set(__self__, "setup_metrics_rules", setup_metrics_rules)
        if write_logs is not None:
            pulumi.set(__self__, "write_logs", write_logs)
        if write_metrics is not None:
            pulumi.set(__self__, "write_metrics", write_metrics)
        if write_traces is not None:
            pulumi.set(__self__, "write_traces", write_traces)

    @property
    @pulumi.getter(name="queryLogs")
    def query_logs(self) -> Optional[pulumi.Input[bool]]:
        """
        Query logs.
        """
        return pulumi.get(self, "query_logs")

    @query_logs.setter
    def query_logs(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "query_logs", value)

    @property
    @pulumi.getter(name="queryMetrics")
    def query_metrics(self) -> Optional[pulumi.Input[bool]]:
        """
        Query metrics.
        """
        return pulumi.get(self, "query_metrics")

    @query_metrics.setter
    def query_metrics(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "query_metrics", value)

    @property
    @pulumi.getter(name="queryTraces")
    def query_traces(self) -> Optional[pulumi.Input[bool]]:
        """
        Query traces.
        """
        return pulumi.get(self, "query_traces")

    @query_traces.setter
    def query_traces(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "query_traces", value)

    @property
    @pulumi.getter(name="setupAlerts")
    def setup_alerts(self) -> Optional[pulumi.Input[bool]]:
        """
        Setup alerts.
        """
        return pulumi.get(self, "setup_alerts")

    @setup_alerts.setter
    def setup_alerts(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "setup_alerts", value)

    @property
    @pulumi.getter(name="setupLogsRules")
    def setup_logs_rules(self) -> Optional[pulumi.Input[bool]]:
        """
        Setup logs rules.
        """
        return pulumi.get(self, "setup_logs_rules")

    @setup_logs_rules.setter
    def setup_logs_rules(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "setup_logs_rules", value)

    @property
    @pulumi.getter(name="setupMetricsRules")
    def setup_metrics_rules(self) -> Optional[pulumi.Input[bool]]:
        """
        Setup metrics rules.
        """
        return pulumi.get(self, "setup_metrics_rules")

    @setup_metrics_rules.setter
    def setup_metrics_rules(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "setup_metrics_rules", value)

    @property
    @pulumi.getter(name="writeLogs")
    def write_logs(self) -> Optional[pulumi.Input[bool]]:
        """
        Write logs.
        """
        return pulumi.get(self, "write_logs")

    @write_logs.setter
    def write_logs(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "write_logs", value)

    @property
    @pulumi.getter(name="writeMetrics")
    def write_metrics(self) -> Optional[pulumi.Input[bool]]:
        """
        Write metrics.
        """
        return pulumi.get(self, "write_metrics")

    @write_metrics.setter
    def write_metrics(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "write_metrics", value)

    @property
    @pulumi.getter(name="writeTraces")
    def write_traces(self) -> Optional[pulumi.Input[bool]]:
        """
        Write traces.
        """
        return pulumi.get(self, "write_traces")

    @write_traces.setter
    def write_traces(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "write_traces", value)


@pulumi.input_type
class ContainerTriggerNatsArgs:
    def __init__(__self__, *,
                 subject: pulumi.Input[str],
                 account_id: Optional[pulumi.Input[str]] = None,
                 project_id: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] subject: The subject to listen to
        :param pulumi.Input[str] account_id: ID of the mnq nats account.
        :param pulumi.Input[str] project_id: ID of the project that contain the mnq nats account, defaults to provider's project
        :param pulumi.Input[str] region: Region where the mnq nats account is, defaults to provider's region
        """
        pulumi.set(__self__, "subject", subject)
        if account_id is not None:
            pulumi.set(__self__, "account_id", account_id)
        if project_id is not None:
            pulumi.set(__self__, "project_id", project_id)
        if region is not None:
            pulumi.set(__self__, "region", region)

    @property
    @pulumi.getter
    def subject(self) -> pulumi.Input[str]:
        """
        The subject to listen to
        """
        return pulumi.get(self, "subject")

    @subject.setter
    def subject(self, value: pulumi.Input[str]):
        pulumi.set(self, "subject", value)

    @property
    @pulumi.getter(name="accountId")
    def account_id(self) -> Optional[pulumi.Input[str]]:
        """
        ID of the mnq nats account.
        """
        return pulumi.get(self, "account_id")

    @account_id.setter
    def account_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "account_id", value)

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[pulumi.Input[str]]:
        """
        ID of the project that contain the mnq nats account, defaults to provider's project
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project_id", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[str]]:
        """
        Region where the mnq nats account is, defaults to provider's region
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region", value)


@pulumi.input_type
class ContainerTriggerSqsArgs:
    def __init__(__self__, *,
                 queue: pulumi.Input[str],
                 namespace_id: Optional[pulumi.Input[str]] = None,
                 project_id: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] queue: Name of the queue
        :param pulumi.Input[str] namespace_id: ID of the mnq namespace. Deprecated.
        :param pulumi.Input[str] project_id: ID of the project where sqs is enabled, defaults to provider's project
        :param pulumi.Input[str] region: Region where sqs is enabled, defaults to provider's region
        """
        pulumi.set(__self__, "queue", queue)
        if namespace_id is not None:
            warnings.warn("""The 'namespace_id' field is deprecated and will be removed in the next major version. It is no longer necessary to specify it""", DeprecationWarning)
            pulumi.log.warn("""namespace_id is deprecated: The 'namespace_id' field is deprecated and will be removed in the next major version. It is no longer necessary to specify it""")
        if namespace_id is not None:
            pulumi.set(__self__, "namespace_id", namespace_id)
        if project_id is not None:
            pulumi.set(__self__, "project_id", project_id)
        if region is not None:
            pulumi.set(__self__, "region", region)

    @property
    @pulumi.getter
    def queue(self) -> pulumi.Input[str]:
        """
        Name of the queue
        """
        return pulumi.get(self, "queue")

    @queue.setter
    def queue(self, value: pulumi.Input[str]):
        pulumi.set(self, "queue", value)

    @property
    @pulumi.getter(name="namespaceId")
    def namespace_id(self) -> Optional[pulumi.Input[str]]:
        """
        ID of the mnq namespace. Deprecated.
        """
        warnings.warn("""The 'namespace_id' field is deprecated and will be removed in the next major version. It is no longer necessary to specify it""", DeprecationWarning)
        pulumi.log.warn("""namespace_id is deprecated: The 'namespace_id' field is deprecated and will be removed in the next major version. It is no longer necessary to specify it""")

        return pulumi.get(self, "namespace_id")

    @namespace_id.setter
    def namespace_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "namespace_id", value)

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[pulumi.Input[str]]:
        """
        ID of the project where sqs is enabled, defaults to provider's project
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project_id", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[str]]:
        """
        Region where sqs is enabled, defaults to provider's region
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region", value)


@pulumi.input_type
class DocumentdbReadReplicaDirectAccessArgs:
    def __init__(__self__, *,
                 endpoint_id: Optional[pulumi.Input[str]] = None,
                 hostname: Optional[pulumi.Input[str]] = None,
                 ip: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 port: Optional[pulumi.Input[int]] = None):
        """
        :param pulumi.Input[str] endpoint_id: The ID of the endpoint of the read replica.
        :param pulumi.Input[str] hostname: Hostname of the endpoint. Only one of ip and hostname may be set.
        :param pulumi.Input[str] ip: IPv4 address of the endpoint (IP address). Only one of ip and hostname may be set.
        :param pulumi.Input[str] name: Name of the endpoint.
        :param pulumi.Input[int] port: TCP port of the endpoint.
        """
        if endpoint_id is not None:
            pulumi.set(__self__, "endpoint_id", endpoint_id)
        if hostname is not None:
            pulumi.set(__self__, "hostname", hostname)
        if ip is not None:
            pulumi.set(__self__, "ip", ip)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if port is not None:
            pulumi.set(__self__, "port", port)

    @property
    @pulumi.getter(name="endpointId")
    def endpoint_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the endpoint of the read replica.
        """
        return pulumi.get(self, "endpoint_id")

    @endpoint_id.setter
    def endpoint_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "endpoint_id", value)

    @property
    @pulumi.getter
    def hostname(self) -> Optional[pulumi.Input[str]]:
        """
        Hostname of the endpoint. Only one of ip and hostname may be set.
        """
        return pulumi.get(self, "hostname")

    @hostname.setter
    def hostname(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "hostname", value)

    @property
    @pulumi.getter
    def ip(self) -> Optional[pulumi.Input[str]]:
        """
        IPv4 address of the endpoint (IP address). Only one of ip and hostname may be set.
        """
        return pulumi.get(self, "ip")

    @ip.setter
    def ip(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ip", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the endpoint.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def port(self) -> Optional[pulumi.Input[int]]:
        """
        TCP port of the endpoint.
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "port", value)


@pulumi.input_type
class DocumentdbReadReplicaPrivateNetworkArgs:
    def __init__(__self__, *,
                 private_network_id: pulumi.Input[str],
                 endpoint_id: Optional[pulumi.Input[str]] = None,
                 hostname: Optional[pulumi.Input[str]] = None,
                 ip: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 port: Optional[pulumi.Input[int]] = None,
                 service_ip: Optional[pulumi.Input[str]] = None,
                 zone: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] private_network_id: UUID of the private network to be connected to the read replica.
        :param pulumi.Input[str] endpoint_id: The ID of the endpoint of the read replica.
        :param pulumi.Input[str] hostname: Hostname of the endpoint. Only one of ip and hostname may be set.
        :param pulumi.Input[str] ip: IPv4 address of the endpoint (IP address). Only one of ip and hostname may be set.
        :param pulumi.Input[str] name: Name of the endpoint.
        :param pulumi.Input[int] port: TCP port of the endpoint.
        :param pulumi.Input[str] service_ip: The IP network address within the private subnet. This must be an IPv4 address with a
               CIDR notation. The IP network address within the private subnet is determined by the IP Address Management (IPAM)
               service if not set.
        :param pulumi.Input[str] zone: Private network zone
        """
        pulumi.set(__self__, "private_network_id", private_network_id)
        if endpoint_id is not None:
            pulumi.set(__self__, "endpoint_id", endpoint_id)
        if hostname is not None:
            pulumi.set(__self__, "hostname", hostname)
        if ip is not None:
            pulumi.set(__self__, "ip", ip)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if service_ip is not None:
            pulumi.set(__self__, "service_ip", service_ip)
        if zone is not None:
            pulumi.set(__self__, "zone", zone)

    @property
    @pulumi.getter(name="privateNetworkId")
    def private_network_id(self) -> pulumi.Input[str]:
        """
        UUID of the private network to be connected to the read replica.
        """
        return pulumi.get(self, "private_network_id")

    @private_network_id.setter
    def private_network_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "private_network_id", value)

    @property
    @pulumi.getter(name="endpointId")
    def endpoint_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the endpoint of the read replica.
        """
        return pulumi.get(self, "endpoint_id")

    @endpoint_id.setter
    def endpoint_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "endpoint_id", value)

    @property
    @pulumi.getter
    def hostname(self) -> Optional[pulumi.Input[str]]:
        """
        Hostname of the endpoint. Only one of ip and hostname may be set.
        """
        return pulumi.get(self, "hostname")

    @hostname.setter
    def hostname(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "hostname", value)

    @property
    @pulumi.getter
    def ip(self) -> Optional[pulumi.Input[str]]:
        """
        IPv4 address of the endpoint (IP address). Only one of ip and hostname may be set.
        """
        return pulumi.get(self, "ip")

    @ip.setter
    def ip(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ip", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the endpoint.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def port(self) -> Optional[pulumi.Input[int]]:
        """
        TCP port of the endpoint.
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "port", value)

    @property
    @pulumi.getter(name="serviceIp")
    def service_ip(self) -> Optional[pulumi.Input[str]]:
        """
        The IP network address within the private subnet. This must be an IPv4 address with a
        CIDR notation. The IP network address within the private subnet is determined by the IP Address Management (IPAM)
        service if not set.
        """
        return pulumi.get(self, "service_ip")

    @service_ip.setter
    def service_ip(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "service_ip", value)

    @property
    @pulumi.getter
    def zone(self) -> Optional[pulumi.Input[str]]:
        """
        Private network zone
        """
        return pulumi.get(self, "zone")

    @zone.setter
    def zone(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "zone", value)


@pulumi.input_type
class DomainRecordGeoIpArgs:
    def __init__(__self__, *,
                 matches: pulumi.Input[Sequence[pulumi.Input['DomainRecordGeoIpMatchArgs']]]):
        """
        :param pulumi.Input[Sequence[pulumi.Input['DomainRecordGeoIpMatchArgs']]] matches: The list of matches
        """
        pulumi.set(__self__, "matches", matches)

    @property
    @pulumi.getter
    def matches(self) -> pulumi.Input[Sequence[pulumi.Input['DomainRecordGeoIpMatchArgs']]]:
        """
        The list of matches
        """
        return pulumi.get(self, "matches")

    @matches.setter
    def matches(self, value: pulumi.Input[Sequence[pulumi.Input['DomainRecordGeoIpMatchArgs']]]):
        pulumi.set(self, "matches", value)


@pulumi.input_type
class DomainRecordGeoIpMatchArgs:
    def __init__(__self__, *,
                 data: pulumi.Input[str],
                 continents: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 countries: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        :param pulumi.Input[str] data: The content of the record (an IPv4 for an `A`, a string for a `TXT`...).
        :param pulumi.Input[Sequence[pulumi.Input[str]]] continents: List of continents (eg: EU for Europe, NA for North America, AS for Asia...). List of all continents code: https://api.scaleway.com/domain-private/v2beta1/continents
        :param pulumi.Input[Sequence[pulumi.Input[str]]] countries: List of countries (eg: FR for France, US for the United States, GB for Great Britain...). List of all countries code: https://api.scaleway.com/domain-private/v2beta1/countries
        """
        pulumi.set(__self__, "data", data)
        if continents is not None:
            pulumi.set(__self__, "continents", continents)
        if countries is not None:
            pulumi.set(__self__, "countries", countries)

    @property
    @pulumi.getter
    def data(self) -> pulumi.Input[str]:
        """
        The content of the record (an IPv4 for an `A`, a string for a `TXT`...).
        """
        return pulumi.get(self, "data")

    @data.setter
    def data(self, value: pulumi.Input[str]):
        pulumi.set(self, "data", value)

    @property
    @pulumi.getter
    def continents(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of continents (eg: EU for Europe, NA for North America, AS for Asia...). List of all continents code: https://api.scaleway.com/domain-private/v2beta1/continents
        """
        return pulumi.get(self, "continents")

    @continents.setter
    def continents(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "continents", value)

    @property
    @pulumi.getter
    def countries(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of countries (eg: FR for France, US for the United States, GB for Great Britain...). List of all countries code: https://api.scaleway.com/domain-private/v2beta1/countries
        """
        return pulumi.get(self, "countries")

    @countries.setter
    def countries(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "countries", value)


@pulumi.input_type
class DomainRecordHttpServiceArgs:
    def __init__(__self__, *,
                 ips: pulumi.Input[Sequence[pulumi.Input[str]]],
                 must_contain: pulumi.Input[str],
                 strategy: pulumi.Input[str],
                 url: pulumi.Input[str],
                 user_agent: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[Sequence[pulumi.Input[str]]] ips: IPs to check
        :param pulumi.Input[str] must_contain: Text to search
        :param pulumi.Input[str] strategy: Strategy to return an IP from the IPs list
        :param pulumi.Input[str] url: URL to match the must_contain text to validate an IP
        :param pulumi.Input[str] user_agent: User-agent used when checking the URL
        """
        pulumi.set(__self__, "ips", ips)
        pulumi.set(__self__, "must_contain", must_contain)
        pulumi.set(__self__, "strategy", strategy)
        pulumi.set(__self__, "url", url)
        if user_agent is not None:
            pulumi.set(__self__, "user_agent", user_agent)

    @property
    @pulumi.getter
    def ips(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        """
        IPs to check
        """
        return pulumi.get(self, "ips")

    @ips.setter
    def ips(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "ips", value)

    @property
    @pulumi.getter(name="mustContain")
    def must_contain(self) -> pulumi.Input[str]:
        """
        Text to search
        """
        return pulumi.get(self, "must_contain")

    @must_contain.setter
    def must_contain(self, value: pulumi.Input[str]):
        pulumi.set(self, "must_contain", value)

    @property
    @pulumi.getter
    def strategy(self) -> pulumi.Input[str]:
        """
        Strategy to return an IP from the IPs list
        """
        return pulumi.get(self, "strategy")

    @strategy.setter
    def strategy(self, value: pulumi.Input[str]):
        pulumi.set(self, "strategy", value)

    @property
    @pulumi.getter
    def url(self) -> pulumi.Input[str]:
        """
        URL to match the must_contain text to validate an IP
        """
        return pulumi.get(self, "url")

    @url.setter
    def url(self, value: pulumi.Input[str]):
        pulumi.set(self, "url", value)

    @property
    @pulumi.getter(name="userAgent")
    def user_agent(self) -> Optional[pulumi.Input[str]]:
        """
        User-agent used when checking the URL
        """
        return pulumi.get(self, "user_agent")

    @user_agent.setter
    def user_agent(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "user_agent", value)


@pulumi.input_type
class DomainRecordViewArgs:
    def __init__(__self__, *,
                 data: pulumi.Input[str],
                 subnet: pulumi.Input[str]):
        """
        :param pulumi.Input[str] data: The content of the record (an IPv4 for an `A`, a string for a `TXT`...).
        :param pulumi.Input[str] subnet: The subnet of the view
        """
        pulumi.set(__self__, "data", data)
        pulumi.set(__self__, "subnet", subnet)

    @property
    @pulumi.getter
    def data(self) -> pulumi.Input[str]:
        """
        The content of the record (an IPv4 for an `A`, a string for a `TXT`...).
        """
        return pulumi.get(self, "data")

    @data.setter
    def data(self, value: pulumi.Input[str]):
        pulumi.set(self, "data", value)

    @property
    @pulumi.getter
    def subnet(self) -> pulumi.Input[str]:
        """
        The subnet of the view
        """
        return pulumi.get(self, "subnet")

    @subnet.setter
    def subnet(self, value: pulumi.Input[str]):
        pulumi.set(self, "subnet", value)


@pulumi.input_type
class DomainRecordWeightedArgs:
    def __init__(__self__, *,
                 ip: pulumi.Input[str],
                 weight: pulumi.Input[int]):
        """
        :param pulumi.Input[str] ip: The weighted IP
        :param pulumi.Input[int] weight: The weight of the IP
        """
        pulumi.set(__self__, "ip", ip)
        pulumi.set(__self__, "weight", weight)

    @property
    @pulumi.getter
    def ip(self) -> pulumi.Input[str]:
        """
        The weighted IP
        """
        return pulumi.get(self, "ip")

    @ip.setter
    def ip(self, value: pulumi.Input[str]):
        pulumi.set(self, "ip", value)

    @property
    @pulumi.getter
    def weight(self) -> pulumi.Input[int]:
        """
        The weight of the IP
        """
        return pulumi.get(self, "weight")

    @weight.setter
    def weight(self, value: pulumi.Input[int]):
        pulumi.set(self, "weight", value)


@pulumi.input_type
class FunctionTriggerNatsArgs:
    def __init__(__self__, *,
                 subject: pulumi.Input[str],
                 account_id: Optional[pulumi.Input[str]] = None,
                 project_id: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] subject: The subject to listen to
        :param pulumi.Input[str] account_id: ID of the mnq nats account.
        :param pulumi.Input[str] project_id: ID of the project that contain the mnq nats account, defaults to provider's project
        :param pulumi.Input[str] region: Region where the mnq nats account is, defaults to provider's region
        """
        pulumi.set(__self__, "subject", subject)
        if account_id is not None:
            pulumi.set(__self__, "account_id", account_id)
        if project_id is not None:
            pulumi.set(__self__, "project_id", project_id)
        if region is not None:
            pulumi.set(__self__, "region", region)

    @property
    @pulumi.getter
    def subject(self) -> pulumi.Input[str]:
        """
        The subject to listen to
        """
        return pulumi.get(self, "subject")

    @subject.setter
    def subject(self, value: pulumi.Input[str]):
        pulumi.set(self, "subject", value)

    @property
    @pulumi.getter(name="accountId")
    def account_id(self) -> Optional[pulumi.Input[str]]:
        """
        ID of the mnq nats account.
        """
        return pulumi.get(self, "account_id")

    @account_id.setter
    def account_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "account_id", value)

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[pulumi.Input[str]]:
        """
        ID of the project that contain the mnq nats account, defaults to provider's project
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project_id", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[str]]:
        """
        Region where the mnq nats account is, defaults to provider's region
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region", value)


@pulumi.input_type
class FunctionTriggerSqsArgs:
    def __init__(__self__, *,
                 queue: pulumi.Input[str],
                 namespace_id: Optional[pulumi.Input[str]] = None,
                 project_id: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] queue: Name of the queue
        :param pulumi.Input[str] namespace_id: ID of the mnq namespace. Deprecated.
        :param pulumi.Input[str] project_id: ID of the project that contain the mnq namespace, defaults to provider's project
        :param pulumi.Input[str] region: Region where the mnq namespace is, defaults to provider's region
        """
        pulumi.set(__self__, "queue", queue)
        if namespace_id is not None:
            warnings.warn("""The 'namespace_id' field is deprecated and will be removed in the next major version. It is no longer necessary to specify it""", DeprecationWarning)
            pulumi.log.warn("""namespace_id is deprecated: The 'namespace_id' field is deprecated and will be removed in the next major version. It is no longer necessary to specify it""")
        if namespace_id is not None:
            pulumi.set(__self__, "namespace_id", namespace_id)
        if project_id is not None:
            pulumi.set(__self__, "project_id", project_id)
        if region is not None:
            pulumi.set(__self__, "region", region)

    @property
    @pulumi.getter
    def queue(self) -> pulumi.Input[str]:
        """
        Name of the queue
        """
        return pulumi.get(self, "queue")

    @queue.setter
    def queue(self, value: pulumi.Input[str]):
        pulumi.set(self, "queue", value)

    @property
    @pulumi.getter(name="namespaceId")
    def namespace_id(self) -> Optional[pulumi.Input[str]]:
        """
        ID of the mnq namespace. Deprecated.
        """
        warnings.warn("""The 'namespace_id' field is deprecated and will be removed in the next major version. It is no longer necessary to specify it""", DeprecationWarning)
        pulumi.log.warn("""namespace_id is deprecated: The 'namespace_id' field is deprecated and will be removed in the next major version. It is no longer necessary to specify it""")

        return pulumi.get(self, "namespace_id")

    @namespace_id.setter
    def namespace_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "namespace_id", value)

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[pulumi.Input[str]]:
        """
        ID of the project that contain the mnq namespace, defaults to provider's project
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project_id", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[str]]:
        """
        Region where the mnq namespace is, defaults to provider's region
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region", value)


@pulumi.input_type
class IamPolicyRuleArgs:
    def __init__(__self__, *,
                 permission_set_names: pulumi.Input[Sequence[pulumi.Input[str]]],
                 organization_id: Optional[pulumi.Input[str]] = None,
                 project_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        :param pulumi.Input[Sequence[pulumi.Input[str]]] permission_set_names: Names of permission sets bound to the rule.
               
               **_TIP:_**  You can use the Scaleway CLI to list the permissions details. e.g:
               
               ```shell
               $ scw iam permission-set list
               ```
        :param pulumi.Input[str] organization_id: ID of organization scoped to the rule, this can be used to create a rule for all projects in an organization.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] project_ids: List of project IDs scoped to the rule.
               
               > **Important** One of `organization_id` or `project_ids`  must be set per rule.
        """
        pulumi.set(__self__, "permission_set_names", permission_set_names)
        if organization_id is not None:
            pulumi.set(__self__, "organization_id", organization_id)
        if project_ids is not None:
            pulumi.set(__self__, "project_ids", project_ids)

    @property
    @pulumi.getter(name="permissionSetNames")
    def permission_set_names(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        """
        Names of permission sets bound to the rule.

        **_TIP:_**  You can use the Scaleway CLI to list the permissions details. e.g:

        ```shell
        $ scw iam permission-set list
        ```
        """
        return pulumi.get(self, "permission_set_names")

    @permission_set_names.setter
    def permission_set_names(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "permission_set_names", value)

    @property
    @pulumi.getter(name="organizationId")
    def organization_id(self) -> Optional[pulumi.Input[str]]:
        """
        ID of organization scoped to the rule, this can be used to create a rule for all projects in an organization.
        """
        return pulumi.get(self, "organization_id")

    @organization_id.setter
    def organization_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "organization_id", value)

    @property
    @pulumi.getter(name="projectIds")
    def project_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of project IDs scoped to the rule.

        > **Important** One of `organization_id` or `project_ids`  must be set per rule.
        """
        return pulumi.get(self, "project_ids")

    @project_ids.setter
    def project_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "project_ids", value)


@pulumi.input_type
class InstanceImageAdditionalVolumeArgs:
    def __init__(__self__, *,
                 creation_date: Optional[pulumi.Input[str]] = None,
                 export_uri: Optional[pulumi.Input[str]] = None,
                 id: Optional[pulumi.Input[str]] = None,
                 modification_date: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 organization: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 server: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 size: Optional[pulumi.Input[int]] = None,
                 state: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 volume_type: Optional[pulumi.Input[str]] = None,
                 zone: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] creation_date: Date of the volume creation.
        :param pulumi.Input[str] export_uri: The export URI of the volume.
        :param pulumi.Input[str] id: ID of the server containing the volume.
        :param pulumi.Input[str] modification_date: Date of volume latest update.
        :param pulumi.Input[str] name: The name of the image. If not provided it will be randomly generated.
        :param pulumi.Input[str] organization: The organization ID the volume is associated with.
        :param pulumi.Input[str] project: ID of the project the volume is associated with
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] server: Description of the server containing the volume (in case the image is a backup from a server).
        :param pulumi.Input[int] size: The size of the volume.
        :param pulumi.Input[str] state: State of the volume.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] tags: A list of tags to apply to the image.
        :param pulumi.Input[str] volume_type: The type of volume, possible values are `l_ssd` and `b_ssd`.
        :param pulumi.Input[str] zone: The zone in which the image should be created.
        """
        if creation_date is not None:
            pulumi.set(__self__, "creation_date", creation_date)
        if export_uri is not None:
            pulumi.set(__self__, "export_uri", export_uri)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if modification_date is not None:
            pulumi.set(__self__, "modification_date", modification_date)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if organization is not None:
            pulumi.set(__self__, "organization", organization)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if server is not None:
            pulumi.set(__self__, "server", server)
        if size is not None:
            pulumi.set(__self__, "size", size)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if volume_type is not None:
            pulumi.set(__self__, "volume_type", volume_type)
        if zone is not None:
            pulumi.set(__self__, "zone", zone)

    @property
    @pulumi.getter(name="creationDate")
    def creation_date(self) -> Optional[pulumi.Input[str]]:
        """
        Date of the volume creation.
        """
        return pulumi.get(self, "creation_date")

    @creation_date.setter
    def creation_date(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "creation_date", value)

    @property
    @pulumi.getter(name="exportUri")
    def export_uri(self) -> Optional[pulumi.Input[str]]:
        """
        The export URI of the volume.
        """
        return pulumi.get(self, "export_uri")

    @export_uri.setter
    def export_uri(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "export_uri", value)

    @property
    @pulumi.getter
    def id(self) -> Optional[pulumi.Input[str]]:
        """
        ID of the server containing the volume.
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "id", value)

    @property
    @pulumi.getter(name="modificationDate")
    def modification_date(self) -> Optional[pulumi.Input[str]]:
        """
        Date of volume latest update.
        """
        return pulumi.get(self, "modification_date")

    @modification_date.setter
    def modification_date(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "modification_date", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the image. If not provided it will be randomly generated.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def organization(self) -> Optional[pulumi.Input[str]]:
        """
        The organization ID the volume is associated with.
        """
        return pulumi.get(self, "organization")

    @organization.setter
    def organization(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "organization", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[str]]:
        """
        ID of the project the volume is associated with
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter
    def server(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Description of the server containing the volume (in case the image is a backup from a server).
        """
        return pulumi.get(self, "server")

    @server.setter
    def server(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "server", value)

    @property
    @pulumi.getter
    def size(self) -> Optional[pulumi.Input[int]]:
        """
        The size of the volume.
        """
        return pulumi.get(self, "size")

    @size.setter
    def size(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "size", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[str]]:
        """
        State of the volume.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "state", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        A list of tags to apply to the image.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="volumeType")
    def volume_type(self) -> Optional[pulumi.Input[str]]:
        """
        The type of volume, possible values are `l_ssd` and `b_ssd`.
        """
        return pulumi.get(self, "volume_type")

    @volume_type.setter
    def volume_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "volume_type", value)

    @property
    @pulumi.getter
    def zone(self) -> Optional[pulumi.Input[str]]:
        """
        The zone in which the image should be created.
        """
        return pulumi.get(self, "zone")

    @zone.setter
    def zone(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "zone", value)


@pulumi.input_type
class InstanceSecurityGroupInboundRuleArgs:
    def __init__(__self__, *,
                 action: pulumi.Input[str],
                 ip: Optional[pulumi.Input[str]] = None,
                 ip_range: Optional[pulumi.Input[str]] = None,
                 port: Optional[pulumi.Input[int]] = None,
                 port_range: Optional[pulumi.Input[str]] = None,
                 protocol: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] action: The action to take when rule match. Possible values are: `accept` or `drop`.
        :param pulumi.Input[str] ip: The ip this rule apply to. If no `ip` nor `ip_range` are specified, rule will apply to all ip. Only one of `ip` and `ip_range` should be specified.
        :param pulumi.Input[str] ip_range: The ip range (e.g `192.168.1.0/24`) this rule applies to. If no `ip` nor `ip_range` are specified, rule will apply to all ip. Only one of `ip` and `ip_range` should be specified.
        :param pulumi.Input[int] port: The port this rule applies to. If no `port` nor `port_range` are specified, the rule will apply to all port. Only one of `port` and `port_range` should be specified.
        :param pulumi.Input[str] port_range: Computed port range for this rule (e.g: 1-1024, 22-22)
        :param pulumi.Input[str] protocol: The protocol this rule apply to. Possible values are: `TCP`, `UDP`, `ICMP` or `ANY`.
        """
        pulumi.set(__self__, "action", action)
        if ip is not None:
            warnings.warn("""Ip address is deprecated. Please use ip_range instead""", DeprecationWarning)
            pulumi.log.warn("""ip is deprecated: Ip address is deprecated. Please use ip_range instead""")
        if ip is not None:
            pulumi.set(__self__, "ip", ip)
        if ip_range is not None:
            pulumi.set(__self__, "ip_range", ip_range)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if port_range is not None:
            pulumi.set(__self__, "port_range", port_range)
        if protocol is not None:
            pulumi.set(__self__, "protocol", protocol)

    @property
    @pulumi.getter
    def action(self) -> pulumi.Input[str]:
        """
        The action to take when rule match. Possible values are: `accept` or `drop`.
        """
        return pulumi.get(self, "action")

    @action.setter
    def action(self, value: pulumi.Input[str]):
        pulumi.set(self, "action", value)

    @property
    @pulumi.getter
    def ip(self) -> Optional[pulumi.Input[str]]:
        """
        The ip this rule apply to. If no `ip` nor `ip_range` are specified, rule will apply to all ip. Only one of `ip` and `ip_range` should be specified.
        """
        warnings.warn("""Ip address is deprecated. Please use ip_range instead""", DeprecationWarning)
        pulumi.log.warn("""ip is deprecated: Ip address is deprecated. Please use ip_range instead""")

        return pulumi.get(self, "ip")

    @ip.setter
    def ip(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ip", value)

    @property
    @pulumi.getter(name="ipRange")
    def ip_range(self) -> Optional[pulumi.Input[str]]:
        """
        The ip range (e.g `192.168.1.0/24`) this rule applies to. If no `ip` nor `ip_range` are specified, rule will apply to all ip. Only one of `ip` and `ip_range` should be specified.
        """
        return pulumi.get(self, "ip_range")

    @ip_range.setter
    def ip_range(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ip_range", value)

    @property
    @pulumi.getter
    def port(self) -> Optional[pulumi.Input[int]]:
        """
        The port this rule applies to. If no `port` nor `port_range` are specified, the rule will apply to all port. Only one of `port` and `port_range` should be specified.
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "port", value)

    @property
    @pulumi.getter(name="portRange")
    def port_range(self) -> Optional[pulumi.Input[str]]:
        """
        Computed port range for this rule (e.g: 1-1024, 22-22)
        """
        return pulumi.get(self, "port_range")

    @port_range.setter
    def port_range(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "port_range", value)

    @property
    @pulumi.getter
    def protocol(self) -> Optional[pulumi.Input[str]]:
        """
        The protocol this rule apply to. Possible values are: `TCP`, `UDP`, `ICMP` or `ANY`.
        """
        return pulumi.get(self, "protocol")

    @protocol.setter
    def protocol(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "protocol", value)


@pulumi.input_type
class InstanceSecurityGroupOutboundRuleArgs:
    def __init__(__self__, *,
                 action: pulumi.Input[str],
                 ip: Optional[pulumi.Input[str]] = None,
                 ip_range: Optional[pulumi.Input[str]] = None,
                 port: Optional[pulumi.Input[int]] = None,
                 port_range: Optional[pulumi.Input[str]] = None,
                 protocol: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] action: Action when rule match request (drop or accept)
        :param pulumi.Input[str] ip: Ip address for this rule (e.g: 1.1.1.1). Only one of ip or ip_range should be provided
        :param pulumi.Input[str] ip_range: Ip range for this rule (e.g: 192.168.1.0/24). Only one of ip or ip_range should be provided
        :param pulumi.Input[int] port: Network port for this rule
        :param pulumi.Input[str] port_range: Computed port range for this rule (e.g: 1-1024, 22-22)
        :param pulumi.Input[str] protocol: Protocol for this rule (TCP, UDP, ICMP or ANY)
        """
        pulumi.set(__self__, "action", action)
        if ip is not None:
            warnings.warn("""Ip address is deprecated. Please use ip_range instead""", DeprecationWarning)
            pulumi.log.warn("""ip is deprecated: Ip address is deprecated. Please use ip_range instead""")
        if ip is not None:
            pulumi.set(__self__, "ip", ip)
        if ip_range is not None:
            pulumi.set(__self__, "ip_range", ip_range)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if port_range is not None:
            pulumi.set(__self__, "port_range", port_range)
        if protocol is not None:
            pulumi.set(__self__, "protocol", protocol)

    @property
    @pulumi.getter
    def action(self) -> pulumi.Input[str]:
        """
        Action when rule match request (drop or accept)
        """
        return pulumi.get(self, "action")

    @action.setter
    def action(self, value: pulumi.Input[str]):
        pulumi.set(self, "action", value)

    @property
    @pulumi.getter
    def ip(self) -> Optional[pulumi.Input[str]]:
        """
        Ip address for this rule (e.g: 1.1.1.1). Only one of ip or ip_range should be provided
        """
        warnings.warn("""Ip address is deprecated. Please use ip_range instead""", DeprecationWarning)
        pulumi.log.warn("""ip is deprecated: Ip address is deprecated. Please use ip_range instead""")

        return pulumi.get(self, "ip")

    @ip.setter
    def ip(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ip", value)

    @property
    @pulumi.getter(name="ipRange")
    def ip_range(self) -> Optional[pulumi.Input[str]]:
        """
        Ip range for this rule (e.g: 192.168.1.0/24). Only one of ip or ip_range should be provided
        """
        return pulumi.get(self, "ip_range")

    @ip_range.setter
    def ip_range(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ip_range", value)

    @property
    @pulumi.getter
    def port(self) -> Optional[pulumi.Input[int]]:
        """
        Network port for this rule
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "port", value)

    @property
    @pulumi.getter(name="portRange")
    def port_range(self) -> Optional[pulumi.Input[str]]:
        """
        Computed port range for this rule (e.g: 1-1024, 22-22)
        """
        return pulumi.get(self, "port_range")

    @port_range.setter
    def port_range(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "port_range", value)

    @property
    @pulumi.getter
    def protocol(self) -> Optional[pulumi.Input[str]]:
        """
        Protocol for this rule (TCP, UDP, ICMP or ANY)
        """
        return pulumi.get(self, "protocol")

    @protocol.setter
    def protocol(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "protocol", value)


@pulumi.input_type
class InstanceSecurityGroupRulesInboundRuleArgs:
    def __init__(__self__, *,
                 action: pulumi.Input[str],
                 ip: Optional[pulumi.Input[str]] = None,
                 ip_range: Optional[pulumi.Input[str]] = None,
                 port: Optional[pulumi.Input[int]] = None,
                 port_range: Optional[pulumi.Input[str]] = None,
                 protocol: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] action: The action to take when rule match. Possible values are: `accept` or `drop`.
        :param pulumi.Input[str] ip: The ip this rule apply to. If no `ip` nor `ip_range` are specified, rule will apply to all ip. Only one of `ip` and `ip_range` should be specified.
        :param pulumi.Input[str] ip_range: The ip range (e.g `192.168.1.0/24`) this rule applies to. If no `ip` nor `ip_range` are specified, rule will apply to all ip. Only one of `ip` and `ip_range` should be specified.
        :param pulumi.Input[int] port: The port this rule apply to. If no port is specified, rule will apply to all port.
        :param pulumi.Input[str] port_range: Computed port range for this rule (e.g: 1-1024, 22-22)
        :param pulumi.Input[str] protocol: The protocol this rule apply to. Possible values are: `TCP`, `UDP`, `ICMP` or `ANY`.
        """
        pulumi.set(__self__, "action", action)
        if ip is not None:
            warnings.warn("""Ip address is deprecated. Please use ip_range instead""", DeprecationWarning)
            pulumi.log.warn("""ip is deprecated: Ip address is deprecated. Please use ip_range instead""")
        if ip is not None:
            pulumi.set(__self__, "ip", ip)
        if ip_range is not None:
            pulumi.set(__self__, "ip_range", ip_range)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if port_range is not None:
            pulumi.set(__self__, "port_range", port_range)
        if protocol is not None:
            pulumi.set(__self__, "protocol", protocol)

    @property
    @pulumi.getter
    def action(self) -> pulumi.Input[str]:
        """
        The action to take when rule match. Possible values are: `accept` or `drop`.
        """
        return pulumi.get(self, "action")

    @action.setter
    def action(self, value: pulumi.Input[str]):
        pulumi.set(self, "action", value)

    @property
    @pulumi.getter
    def ip(self) -> Optional[pulumi.Input[str]]:
        """
        The ip this rule apply to. If no `ip` nor `ip_range` are specified, rule will apply to all ip. Only one of `ip` and `ip_range` should be specified.
        """
        warnings.warn("""Ip address is deprecated. Please use ip_range instead""", DeprecationWarning)
        pulumi.log.warn("""ip is deprecated: Ip address is deprecated. Please use ip_range instead""")

        return pulumi.get(self, "ip")

    @ip.setter
    def ip(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ip", value)

    @property
    @pulumi.getter(name="ipRange")
    def ip_range(self) -> Optional[pulumi.Input[str]]:
        """
        The ip range (e.g `192.168.1.0/24`) this rule applies to. If no `ip` nor `ip_range` are specified, rule will apply to all ip. Only one of `ip` and `ip_range` should be specified.
        """
        return pulumi.get(self, "ip_range")

    @ip_range.setter
    def ip_range(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ip_range", value)

    @property
    @pulumi.getter
    def port(self) -> Optional[pulumi.Input[int]]:
        """
        The port this rule apply to. If no port is specified, rule will apply to all port.
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "port", value)

    @property
    @pulumi.getter(name="portRange")
    def port_range(self) -> Optional[pulumi.Input[str]]:
        """
        Computed port range for this rule (e.g: 1-1024, 22-22)
        """
        return pulumi.get(self, "port_range")

    @port_range.setter
    def port_range(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "port_range", value)

    @property
    @pulumi.getter
    def protocol(self) -> Optional[pulumi.Input[str]]:
        """
        The protocol this rule apply to. Possible values are: `TCP`, `UDP`, `ICMP` or `ANY`.
        """
        return pulumi.get(self, "protocol")

    @protocol.setter
    def protocol(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "protocol", value)


@pulumi.input_type
class InstanceSecurityGroupRulesOutboundRuleArgs:
    def __init__(__self__, *,
                 action: pulumi.Input[str],
                 ip: Optional[pulumi.Input[str]] = None,
                 ip_range: Optional[pulumi.Input[str]] = None,
                 port: Optional[pulumi.Input[int]] = None,
                 port_range: Optional[pulumi.Input[str]] = None,
                 protocol: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] action: Action when rule match request (drop or accept)
        :param pulumi.Input[str] ip: Ip address for this rule (e.g: 1.1.1.1). Only one of ip or ip_range should be provided
        :param pulumi.Input[str] ip_range: Ip range for this rule (e.g: 192.168.1.0/24). Only one of ip or ip_range should be provided
        :param pulumi.Input[int] port: Network port for this rule
        :param pulumi.Input[str] port_range: Computed port range for this rule (e.g: 1-1024, 22-22)
        :param pulumi.Input[str] protocol: Protocol for this rule (TCP, UDP, ICMP or ANY)
        """
        pulumi.set(__self__, "action", action)
        if ip is not None:
            warnings.warn("""Ip address is deprecated. Please use ip_range instead""", DeprecationWarning)
            pulumi.log.warn("""ip is deprecated: Ip address is deprecated. Please use ip_range instead""")
        if ip is not None:
            pulumi.set(__self__, "ip", ip)
        if ip_range is not None:
            pulumi.set(__self__, "ip_range", ip_range)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if port_range is not None:
            pulumi.set(__self__, "port_range", port_range)
        if protocol is not None:
            pulumi.set(__self__, "protocol", protocol)

    @property
    @pulumi.getter
    def action(self) -> pulumi.Input[str]:
        """
        Action when rule match request (drop or accept)
        """
        return pulumi.get(self, "action")

    @action.setter
    def action(self, value: pulumi.Input[str]):
        pulumi.set(self, "action", value)

    @property
    @pulumi.getter
    def ip(self) -> Optional[pulumi.Input[str]]:
        """
        Ip address for this rule (e.g: 1.1.1.1). Only one of ip or ip_range should be provided
        """
        warnings.warn("""Ip address is deprecated. Please use ip_range instead""", DeprecationWarning)
        pulumi.log.warn("""ip is deprecated: Ip address is deprecated. Please use ip_range instead""")

        return pulumi.get(self, "ip")

    @ip.setter
    def ip(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ip", value)

    @property
    @pulumi.getter(name="ipRange")
    def ip_range(self) -> Optional[pulumi.Input[str]]:
        """
        Ip range for this rule (e.g: 192.168.1.0/24). Only one of ip or ip_range should be provided
        """
        return pulumi.get(self, "ip_range")

    @ip_range.setter
    def ip_range(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ip_range", value)

    @property
    @pulumi.getter
    def port(self) -> Optional[pulumi.Input[int]]:
        """
        Network port for this rule
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "port", value)

    @property
    @pulumi.getter(name="portRange")
    def port_range(self) -> Optional[pulumi.Input[str]]:
        """
        Computed port range for this rule (e.g: 1-1024, 22-22)
        """
        return pulumi.get(self, "port_range")

    @port_range.setter
    def port_range(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "port_range", value)

    @property
    @pulumi.getter
    def protocol(self) -> Optional[pulumi.Input[str]]:
        """
        Protocol for this rule (TCP, UDP, ICMP or ANY)
        """
        return pulumi.get(self, "protocol")

    @protocol.setter
    def protocol(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "protocol", value)


@pulumi.input_type
class InstanceServerPrivateNetworkArgs:
    def __init__(__self__, *,
                 pn_id: pulumi.Input[str],
                 mac_address: Optional[pulumi.Input[str]] = None,
                 pnic_id: Optional[pulumi.Input[str]] = None,
                 status: Optional[pulumi.Input[str]] = None,
                 zone: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] pn_id: The Private Network ID
        :param pulumi.Input[str] mac_address: MAC address of the NIC
        :param pulumi.Input[str] pnic_id: The ID of the NIC
        :param pulumi.Input[str] status: The private NIC state
        :param pulumi.Input[str] zone: `zone`) The zone in which the server should be created.
        """
        pulumi.set(__self__, "pn_id", pn_id)
        if mac_address is not None:
            pulumi.set(__self__, "mac_address", mac_address)
        if pnic_id is not None:
            pulumi.set(__self__, "pnic_id", pnic_id)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if zone is not None:
            pulumi.set(__self__, "zone", zone)

    @property
    @pulumi.getter(name="pnId")
    def pn_id(self) -> pulumi.Input[str]:
        """
        The Private Network ID
        """
        return pulumi.get(self, "pn_id")

    @pn_id.setter
    def pn_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "pn_id", value)

    @property
    @pulumi.getter(name="macAddress")
    def mac_address(self) -> Optional[pulumi.Input[str]]:
        """
        MAC address of the NIC
        """
        return pulumi.get(self, "mac_address")

    @mac_address.setter
    def mac_address(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "mac_address", value)

    @property
    @pulumi.getter(name="pnicId")
    def pnic_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the NIC
        """
        return pulumi.get(self, "pnic_id")

    @pnic_id.setter
    def pnic_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "pnic_id", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[str]]:
        """
        The private NIC state
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "status", value)

    @property
    @pulumi.getter
    def zone(self) -> Optional[pulumi.Input[str]]:
        """
        `zone`) The zone in which the server should be created.
        """
        return pulumi.get(self, "zone")

    @zone.setter
    def zone(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "zone", value)


@pulumi.input_type
class InstanceServerPublicIpArgs:
    def __init__(__self__, *,
                 address: Optional[pulumi.Input[str]] = None,
                 id: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] address: The address of the IP
        :param pulumi.Input[str] id: The ID of the IP
        """
        if address is not None:
            pulumi.set(__self__, "address", address)
        if id is not None:
            pulumi.set(__self__, "id", id)

    @property
    @pulumi.getter
    def address(self) -> Optional[pulumi.Input[str]]:
        """
        The address of the IP
        """
        return pulumi.get(self, "address")

    @address.setter
    def address(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "address", value)

    @property
    @pulumi.getter
    def id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the IP
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "id", value)


@pulumi.input_type
class InstanceServerRootVolumeArgs:
    def __init__(__self__, *,
                 boot: Optional[pulumi.Input[bool]] = None,
                 delete_on_termination: Optional[pulumi.Input[bool]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 size_in_gb: Optional[pulumi.Input[int]] = None,
                 volume_id: Optional[pulumi.Input[str]] = None,
                 volume_type: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[bool] boot: Set the volume where the boot the server
        :param pulumi.Input[bool] delete_on_termination: Forces deletion of the root volume on instance termination.
               
               > **Important:** Updates to `root_volume.size_in_gb` will be ignored after the creation of the server.
        :param pulumi.Input[str] name: The name of the server.
        :param pulumi.Input[int] size_in_gb: Size of the root volume in gigabytes.
               To find the right size use [this endpoint](https://www.scaleway.com/en/developers/api/instance/#path-instances-list-all-instances) and
               check the `volumes_constraint.{min|max}_size` (in bytes) for your `commercial_type`.
               Updates to this field will recreate a new resource.
        :param pulumi.Input[str] volume_id: The volume ID of the root volume of the server, allows you to create server with an existing volume. If empty, will be computed to a created volume ID.
        :param pulumi.Input[str] volume_type: Volume type of root volume, can be `b_ssd` or `l_ssd`, default value depends on server type
        """
        if boot is not None:
            pulumi.set(__self__, "boot", boot)
        if delete_on_termination is not None:
            pulumi.set(__self__, "delete_on_termination", delete_on_termination)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if size_in_gb is not None:
            pulumi.set(__self__, "size_in_gb", size_in_gb)
        if volume_id is not None:
            pulumi.set(__self__, "volume_id", volume_id)
        if volume_type is not None:
            pulumi.set(__self__, "volume_type", volume_type)

    @property
    @pulumi.getter
    def boot(self) -> Optional[pulumi.Input[bool]]:
        """
        Set the volume where the boot the server
        """
        return pulumi.get(self, "boot")

    @boot.setter
    def boot(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "boot", value)

    @property
    @pulumi.getter(name="deleteOnTermination")
    def delete_on_termination(self) -> Optional[pulumi.Input[bool]]:
        """
        Forces deletion of the root volume on instance termination.

        > **Important:** Updates to `root_volume.size_in_gb` will be ignored after the creation of the server.
        """
        return pulumi.get(self, "delete_on_termination")

    @delete_on_termination.setter
    def delete_on_termination(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "delete_on_termination", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the server.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="sizeInGb")
    def size_in_gb(self) -> Optional[pulumi.Input[int]]:
        """
        Size of the root volume in gigabytes.
        To find the right size use [this endpoint](https://www.scaleway.com/en/developers/api/instance/#path-instances-list-all-instances) and
        check the `volumes_constraint.{min|max}_size` (in bytes) for your `commercial_type`.
        Updates to this field will recreate a new resource.
        """
        return pulumi.get(self, "size_in_gb")

    @size_in_gb.setter
    def size_in_gb(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "size_in_gb", value)

    @property
    @pulumi.getter(name="volumeId")
    def volume_id(self) -> Optional[pulumi.Input[str]]:
        """
        The volume ID of the root volume of the server, allows you to create server with an existing volume. If empty, will be computed to a created volume ID.
        """
        return pulumi.get(self, "volume_id")

    @volume_id.setter
    def volume_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "volume_id", value)

    @property
    @pulumi.getter(name="volumeType")
    def volume_type(self) -> Optional[pulumi.Input[str]]:
        """
        Volume type of root volume, can be `b_ssd` or `l_ssd`, default value depends on server type
        """
        return pulumi.get(self, "volume_type")

    @volume_type.setter
    def volume_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "volume_type", value)


@pulumi.input_type
class InstanceSnapshotImportArgs:
    def __init__(__self__, *,
                 bucket: pulumi.Input[str],
                 key: pulumi.Input[str]):
        """
        :param pulumi.Input[str] bucket: Bucket name containing [qcow2](https://en.wikipedia.org/wiki/Qcow) to import
        :param pulumi.Input[str] key: Key of the object to import
               
               > **Note:** The type `unified` could be instantiated on both `l_ssd` and `b_ssd` volumes.
        """
        pulumi.set(__self__, "bucket", bucket)
        pulumi.set(__self__, "key", key)

    @property
    @pulumi.getter
    def bucket(self) -> pulumi.Input[str]:
        """
        Bucket name containing [qcow2](https://en.wikipedia.org/wiki/Qcow) to import
        """
        return pulumi.get(self, "bucket")

    @bucket.setter
    def bucket(self, value: pulumi.Input[str]):
        pulumi.set(self, "bucket", value)

    @property
    @pulumi.getter
    def key(self) -> pulumi.Input[str]:
        """
        Key of the object to import

        > **Note:** The type `unified` could be instantiated on both `l_ssd` and `b_ssd` volumes.
        """
        return pulumi.get(self, "key")

    @key.setter
    def key(self, value: pulumi.Input[str]):
        pulumi.set(self, "key", value)


@pulumi.input_type
class IotDeviceCertificateArgs:
    def __init__(__self__, *,
                 crt: Optional[pulumi.Input[str]] = None,
                 key: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] crt: X509 PEM encoded certificate of the device
        :param pulumi.Input[str] key: The private key of the device, in case it is generated by Scaleway.
        """
        if crt is not None:
            pulumi.set(__self__, "crt", crt)
        if key is not None:
            pulumi.set(__self__, "key", key)

    @property
    @pulumi.getter
    def crt(self) -> Optional[pulumi.Input[str]]:
        """
        X509 PEM encoded certificate of the device
        """
        return pulumi.get(self, "crt")

    @crt.setter
    def crt(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "crt", value)

    @property
    @pulumi.getter
    def key(self) -> Optional[pulumi.Input[str]]:
        """
        The private key of the device, in case it is generated by Scaleway.
        """
        return pulumi.get(self, "key")

    @key.setter
    def key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "key", value)


@pulumi.input_type
class IotDeviceMessageFiltersArgs:
    def __init__(__self__, *,
                 publish: Optional[pulumi.Input['IotDeviceMessageFiltersPublishArgs']] = None,
                 subscribe: Optional[pulumi.Input['IotDeviceMessageFiltersSubscribeArgs']] = None):
        """
        :param pulumi.Input['IotDeviceMessageFiltersPublishArgs'] publish: Rules used to restrict topics the device can publish to.
        :param pulumi.Input['IotDeviceMessageFiltersSubscribeArgs'] subscribe: Rules used to restrict topics the device can subscribe to.
        """
        if publish is not None:
            pulumi.set(__self__, "publish", publish)
        if subscribe is not None:
            pulumi.set(__self__, "subscribe", subscribe)

    @property
    @pulumi.getter
    def publish(self) -> Optional[pulumi.Input['IotDeviceMessageFiltersPublishArgs']]:
        """
        Rules used to restrict topics the device can publish to.
        """
        return pulumi.get(self, "publish")

    @publish.setter
    def publish(self, value: Optional[pulumi.Input['IotDeviceMessageFiltersPublishArgs']]):
        pulumi.set(self, "publish", value)

    @property
    @pulumi.getter
    def subscribe(self) -> Optional[pulumi.Input['IotDeviceMessageFiltersSubscribeArgs']]:
        """
        Rules used to restrict topics the device can subscribe to.
        """
        return pulumi.get(self, "subscribe")

    @subscribe.setter
    def subscribe(self, value: Optional[pulumi.Input['IotDeviceMessageFiltersSubscribeArgs']]):
        pulumi.set(self, "subscribe", value)


@pulumi.input_type
class IotDeviceMessageFiltersPublishArgs:
    def __init__(__self__, *,
                 policy: Optional[pulumi.Input[str]] = None,
                 topics: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        :param pulumi.Input[str] policy: Filtering policy (eg `accept` or `reject`)
        :param pulumi.Input[Sequence[pulumi.Input[str]]] topics: List of topics to match (eg `foo/bar/+/baz/#`)
        """
        if policy is not None:
            pulumi.set(__self__, "policy", policy)
        if topics is not None:
            pulumi.set(__self__, "topics", topics)

    @property
    @pulumi.getter
    def policy(self) -> Optional[pulumi.Input[str]]:
        """
        Filtering policy (eg `accept` or `reject`)
        """
        return pulumi.get(self, "policy")

    @policy.setter
    def policy(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "policy", value)

    @property
    @pulumi.getter
    def topics(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of topics to match (eg `foo/bar/+/baz/#`)
        """
        return pulumi.get(self, "topics")

    @topics.setter
    def topics(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "topics", value)


@pulumi.input_type
class IotDeviceMessageFiltersSubscribeArgs:
    def __init__(__self__, *,
                 policy: Optional[pulumi.Input[str]] = None,
                 topics: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        :param pulumi.Input[str] policy: Same as publish rules.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] topics: Same as publish rules.
               
               - `certificate.crt` - (Optional) The certificate of the device, either generated by Scaleway or provided.
               
               > **Important:** Updates to `certificate.crt` will disconnect connected devices and the previous certificate will be deleted and won't be recoverable.
        """
        if policy is not None:
            pulumi.set(__self__, "policy", policy)
        if topics is not None:
            pulumi.set(__self__, "topics", topics)

    @property
    @pulumi.getter
    def policy(self) -> Optional[pulumi.Input[str]]:
        """
        Same as publish rules.
        """
        return pulumi.get(self, "policy")

    @policy.setter
    def policy(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "policy", value)

    @property
    @pulumi.getter
    def topics(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Same as publish rules.

        - `certificate.crt` - (Optional) The certificate of the device, either generated by Scaleway or provided.

        > **Important:** Updates to `certificate.crt` will disconnect connected devices and the previous certificate will be deleted and won't be recoverable.
        """
        return pulumi.get(self, "topics")

    @topics.setter
    def topics(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "topics", value)


@pulumi.input_type
class IotRouteDatabaseArgs:
    def __init__(__self__, *,
                 dbname: pulumi.Input[str],
                 host: pulumi.Input[str],
                 password: pulumi.Input[str],
                 port: pulumi.Input[int],
                 query: pulumi.Input[str],
                 username: pulumi.Input[str]):
        """
        :param pulumi.Input[str] dbname: The database name (e.g. `measurements`).
        :param pulumi.Input[str] host: The database hostname. Can be an IP or a FQDN.
        :param pulumi.Input[str] password: The database password.
        :param pulumi.Input[int] port: The database port (e.g. `5432`)
        :param pulumi.Input[str] query: The SQL query that will be executed when receiving a message ($TOPIC and $PAYLOAD variables are available, see documentation, e.g. `INSERT INTO mytable(date, topic, value) VALUES (NOW(), $TOPIC, $PAYLOAD)`).
        :param pulumi.Input[str] username: The database username.
        """
        pulumi.set(__self__, "dbname", dbname)
        pulumi.set(__self__, "host", host)
        pulumi.set(__self__, "password", password)
        pulumi.set(__self__, "port", port)
        pulumi.set(__self__, "query", query)
        pulumi.set(__self__, "username", username)

    @property
    @pulumi.getter
    def dbname(self) -> pulumi.Input[str]:
        """
        The database name (e.g. `measurements`).
        """
        return pulumi.get(self, "dbname")

    @dbname.setter
    def dbname(self, value: pulumi.Input[str]):
        pulumi.set(self, "dbname", value)

    @property
    @pulumi.getter
    def host(self) -> pulumi.Input[str]:
        """
        The database hostname. Can be an IP or a FQDN.
        """
        return pulumi.get(self, "host")

    @host.setter
    def host(self, value: pulumi.Input[str]):
        pulumi.set(self, "host", value)

    @property
    @pulumi.getter
    def password(self) -> pulumi.Input[str]:
        """
        The database password.
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: pulumi.Input[str]):
        pulumi.set(self, "password", value)

    @property
    @pulumi.getter
    def port(self) -> pulumi.Input[int]:
        """
        The database port (e.g. `5432`)
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: pulumi.Input[int]):
        pulumi.set(self, "port", value)

    @property
    @pulumi.getter
    def query(self) -> pulumi.Input[str]:
        """
        The SQL query that will be executed when receiving a message ($TOPIC and $PAYLOAD variables are available, see documentation, e.g. `INSERT INTO mytable(date, topic, value) VALUES (NOW(), $TOPIC, $PAYLOAD)`).
        """
        return pulumi.get(self, "query")

    @query.setter
    def query(self, value: pulumi.Input[str]):
        pulumi.set(self, "query", value)

    @property
    @pulumi.getter
    def username(self) -> pulumi.Input[str]:
        """
        The database username.
        """
        return pulumi.get(self, "username")

    @username.setter
    def username(self, value: pulumi.Input[str]):
        pulumi.set(self, "username", value)


@pulumi.input_type
class IotRouteRestArgs:
    def __init__(__self__, *,
                 headers: pulumi.Input[Mapping[str, pulumi.Input[str]]],
                 uri: pulumi.Input[str],
                 verb: pulumi.Input[str]):
        """
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] headers: a map of the extra headers to send with the HTTP call (e.g. `X-Header = Value`).
        :param pulumi.Input[str] uri: The URI of the Rest endpoint (e.g. `https://internal.mycompany.com/ingest/mqttdata`).
        :param pulumi.Input[str] verb: The HTTP Verb used to call Rest URI (e.g. `post`).
        """
        pulumi.set(__self__, "headers", headers)
        pulumi.set(__self__, "uri", uri)
        pulumi.set(__self__, "verb", verb)

    @property
    @pulumi.getter
    def headers(self) -> pulumi.Input[Mapping[str, pulumi.Input[str]]]:
        """
        a map of the extra headers to send with the HTTP call (e.g. `X-Header = Value`).
        """
        return pulumi.get(self, "headers")

    @headers.setter
    def headers(self, value: pulumi.Input[Mapping[str, pulumi.Input[str]]]):
        pulumi.set(self, "headers", value)

    @property
    @pulumi.getter
    def uri(self) -> pulumi.Input[str]:
        """
        The URI of the Rest endpoint (e.g. `https://internal.mycompany.com/ingest/mqttdata`).
        """
        return pulumi.get(self, "uri")

    @uri.setter
    def uri(self, value: pulumi.Input[str]):
        pulumi.set(self, "uri", value)

    @property
    @pulumi.getter
    def verb(self) -> pulumi.Input[str]:
        """
        The HTTP Verb used to call Rest URI (e.g. `post`).
        """
        return pulumi.get(self, "verb")

    @verb.setter
    def verb(self, value: pulumi.Input[str]):
        pulumi.set(self, "verb", value)


@pulumi.input_type
class IotRouteS3Args:
    def __init__(__self__, *,
                 bucket_name: pulumi.Input[str],
                 bucket_region: pulumi.Input[str],
                 strategy: pulumi.Input[str],
                 object_prefix: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] bucket_name: The name of the S3 route's destination bucket (e.g. `my-object-storage`).
        :param pulumi.Input[str] bucket_region: The region of the S3 route's destination bucket (e.g. `fr-par`).
        :param pulumi.Input[str] strategy: How the S3 route's objects will be created (e.g. `per_topic`). See [documentation](https://www.scaleway.com/en/docs/scaleway-iothub-route/#-Messages-Store-Strategies) for behaviour details.
        :param pulumi.Input[str] object_prefix: The string to prefix object names with (e.g. `mykeyprefix-`).
        """
        pulumi.set(__self__, "bucket_name", bucket_name)
        pulumi.set(__self__, "bucket_region", bucket_region)
        pulumi.set(__self__, "strategy", strategy)
        if object_prefix is not None:
            pulumi.set(__self__, "object_prefix", object_prefix)

    @property
    @pulumi.getter(name="bucketName")
    def bucket_name(self) -> pulumi.Input[str]:
        """
        The name of the S3 route's destination bucket (e.g. `my-object-storage`).
        """
        return pulumi.get(self, "bucket_name")

    @bucket_name.setter
    def bucket_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "bucket_name", value)

    @property
    @pulumi.getter(name="bucketRegion")
    def bucket_region(self) -> pulumi.Input[str]:
        """
        The region of the S3 route's destination bucket (e.g. `fr-par`).
        """
        return pulumi.get(self, "bucket_region")

    @bucket_region.setter
    def bucket_region(self, value: pulumi.Input[str]):
        pulumi.set(self, "bucket_region", value)

    @property
    @pulumi.getter
    def strategy(self) -> pulumi.Input[str]:
        """
        How the S3 route's objects will be created (e.g. `per_topic`). See [documentation](https://www.scaleway.com/en/docs/scaleway-iothub-route/#-Messages-Store-Strategies) for behaviour details.
        """
        return pulumi.get(self, "strategy")

    @strategy.setter
    def strategy(self, value: pulumi.Input[str]):
        pulumi.set(self, "strategy", value)

    @property
    @pulumi.getter(name="objectPrefix")
    def object_prefix(self) -> Optional[pulumi.Input[str]]:
        """
        The string to prefix object names with (e.g. `mykeyprefix-`).
        """
        return pulumi.get(self, "object_prefix")

    @object_prefix.setter
    def object_prefix(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "object_prefix", value)


@pulumi.input_type
class IpamIpResourceArgs:
    def __init__(__self__, *,
                 id: Optional[pulumi.Input[str]] = None,
                 mac_address: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 type: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] id: The ID of the resource that the IP is bound to.
        :param pulumi.Input[str] mac_address: The MAC Address of the resource the IP is attached to.
        :param pulumi.Input[str] name: The name of the resource the IP is attached to.
        :param pulumi.Input[str] type: The type of resource the IP is attached to.
        """
        if id is not None:
            pulumi.set(__self__, "id", id)
        if mac_address is not None:
            pulumi.set(__self__, "mac_address", mac_address)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the resource that the IP is bound to.
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "id", value)

    @property
    @pulumi.getter(name="macAddress")
    def mac_address(self) -> Optional[pulumi.Input[str]]:
        """
        The MAC Address of the resource the IP is attached to.
        """
        return pulumi.get(self, "mac_address")

    @mac_address.setter
    def mac_address(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "mac_address", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the resource the IP is attached to.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[str]]:
        """
        The type of resource the IP is attached to.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "type", value)


@pulumi.input_type
class IpamIpReverseArgs:
    def __init__(__self__, *,
                 address: Optional[pulumi.Input[str]] = None,
                 hostname: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] address: The IP corresponding to the hostname
        :param pulumi.Input[str] hostname: The reverse domain name.
        """
        if address is not None:
            pulumi.set(__self__, "address", address)
        if hostname is not None:
            pulumi.set(__self__, "hostname", hostname)

    @property
    @pulumi.getter
    def address(self) -> Optional[pulumi.Input[str]]:
        """
        The IP corresponding to the hostname
        """
        return pulumi.get(self, "address")

    @address.setter
    def address(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "address", value)

    @property
    @pulumi.getter
    def hostname(self) -> Optional[pulumi.Input[str]]:
        """
        The reverse domain name.
        """
        return pulumi.get(self, "hostname")

    @hostname.setter
    def hostname(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "hostname", value)


@pulumi.input_type
class IpamIpSourceArgs:
    def __init__(__self__, *,
                 private_network_id: Optional[pulumi.Input[str]] = None,
                 subnet_id: Optional[pulumi.Input[str]] = None,
                 zonal: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] private_network_id: The private network the IP lives in if the IP is a private IP.
        :param pulumi.Input[str] subnet_id: The private network subnet the IP lives in if the IP is a private IP in a private network.
        :param pulumi.Input[str] zonal: The zone the IP lives in if the IP is a public zoned one
        """
        if private_network_id is not None:
            pulumi.set(__self__, "private_network_id", private_network_id)
        if subnet_id is not None:
            pulumi.set(__self__, "subnet_id", subnet_id)
        if zonal is not None:
            pulumi.set(__self__, "zonal", zonal)

    @property
    @pulumi.getter(name="privateNetworkId")
    def private_network_id(self) -> Optional[pulumi.Input[str]]:
        """
        The private network the IP lives in if the IP is a private IP.
        """
        return pulumi.get(self, "private_network_id")

    @private_network_id.setter
    def private_network_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "private_network_id", value)

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> Optional[pulumi.Input[str]]:
        """
        The private network subnet the IP lives in if the IP is a private IP in a private network.
        """
        return pulumi.get(self, "subnet_id")

    @subnet_id.setter
    def subnet_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "subnet_id", value)

    @property
    @pulumi.getter
    def zonal(self) -> Optional[pulumi.Input[str]]:
        """
        The zone the IP lives in if the IP is a public zoned one
        """
        return pulumi.get(self, "zonal")

    @zonal.setter
    def zonal(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "zonal", value)


@pulumi.input_type
class JobDefinitionCronArgs:
    def __init__(__self__, *,
                 schedule: pulumi.Input[str],
                 timezone: pulumi.Input[str]):
        """
        :param pulumi.Input[str] schedule: Cron format string.
        :param pulumi.Input[str] timezone: The timezone, must be a canonical TZ identifier as found in this [list](https://en.wikipedia.org/wiki/List_of_tz_database_time_zones).
        """
        pulumi.set(__self__, "schedule", schedule)
        pulumi.set(__self__, "timezone", timezone)

    @property
    @pulumi.getter
    def schedule(self) -> pulumi.Input[str]:
        """
        Cron format string.
        """
        return pulumi.get(self, "schedule")

    @schedule.setter
    def schedule(self, value: pulumi.Input[str]):
        pulumi.set(self, "schedule", value)

    @property
    @pulumi.getter
    def timezone(self) -> pulumi.Input[str]:
        """
        The timezone, must be a canonical TZ identifier as found in this [list](https://en.wikipedia.org/wiki/List_of_tz_database_time_zones).
        """
        return pulumi.get(self, "timezone")

    @timezone.setter
    def timezone(self, value: pulumi.Input[str]):
        pulumi.set(self, "timezone", value)


@pulumi.input_type
class K8sClusterAutoUpgradeArgs:
    def __init__(__self__, *,
                 enable: pulumi.Input[bool],
                 maintenance_window_day: pulumi.Input[str],
                 maintenance_window_start_hour: pulumi.Input[int]):
        """
        :param pulumi.Input[bool] enable: Set to `true` to enable Kubernetes patch version auto upgrades.
               > **Important:** When enabling auto upgrades, the `version` field take a minor version like x.y (ie 1.18).
        :param pulumi.Input[str] maintenance_window_day: The day of the auto upgrade maintenance window (`monday` to `sunday`, or `any`).
        :param pulumi.Input[int] maintenance_window_start_hour: The start hour (UTC) of the 2-hour auto upgrade maintenance window (0 to 23).
        """
        pulumi.set(__self__, "enable", enable)
        pulumi.set(__self__, "maintenance_window_day", maintenance_window_day)
        pulumi.set(__self__, "maintenance_window_start_hour", maintenance_window_start_hour)

    @property
    @pulumi.getter
    def enable(self) -> pulumi.Input[bool]:
        """
        Set to `true` to enable Kubernetes patch version auto upgrades.
        > **Important:** When enabling auto upgrades, the `version` field take a minor version like x.y (ie 1.18).
        """
        return pulumi.get(self, "enable")

    @enable.setter
    def enable(self, value: pulumi.Input[bool]):
        pulumi.set(self, "enable", value)

    @property
    @pulumi.getter(name="maintenanceWindowDay")
    def maintenance_window_day(self) -> pulumi.Input[str]:
        """
        The day of the auto upgrade maintenance window (`monday` to `sunday`, or `any`).
        """
        return pulumi.get(self, "maintenance_window_day")

    @maintenance_window_day.setter
    def maintenance_window_day(self, value: pulumi.Input[str]):
        pulumi.set(self, "maintenance_window_day", value)

    @property
    @pulumi.getter(name="maintenanceWindowStartHour")
    def maintenance_window_start_hour(self) -> pulumi.Input[int]:
        """
        The start hour (UTC) of the 2-hour auto upgrade maintenance window (0 to 23).
        """
        return pulumi.get(self, "maintenance_window_start_hour")

    @maintenance_window_start_hour.setter
    def maintenance_window_start_hour(self, value: pulumi.Input[int]):
        pulumi.set(self, "maintenance_window_start_hour", value)


@pulumi.input_type
class K8sClusterAutoscalerConfigArgs:
    def __init__(__self__, *,
                 balance_similar_node_groups: Optional[pulumi.Input[bool]] = None,
                 disable_scale_down: Optional[pulumi.Input[bool]] = None,
                 estimator: Optional[pulumi.Input[str]] = None,
                 expander: Optional[pulumi.Input[str]] = None,
                 expendable_pods_priority_cutoff: Optional[pulumi.Input[int]] = None,
                 ignore_daemonsets_utilization: Optional[pulumi.Input[bool]] = None,
                 max_graceful_termination_sec: Optional[pulumi.Input[int]] = None,
                 scale_down_delay_after_add: Optional[pulumi.Input[str]] = None,
                 scale_down_unneeded_time: Optional[pulumi.Input[str]] = None,
                 scale_down_utilization_threshold: Optional[pulumi.Input[float]] = None):
        """
        :param pulumi.Input[bool] balance_similar_node_groups: Detect similar node groups and balance the number of nodes between them.
        :param pulumi.Input[bool] disable_scale_down: Disables the scale down feature of the autoscaler.
        :param pulumi.Input[str] estimator: Type of resource estimator to be used in scale up.
        :param pulumi.Input[str] expander: Type of node group expander to be used in scale up.
        :param pulumi.Input[int] expendable_pods_priority_cutoff: Pods with priority below cutoff will be expendable. They can be killed without any consideration during scale down and they don't cause scale up. Pods with null priority (PodPriority disabled) are non expendable.
        :param pulumi.Input[bool] ignore_daemonsets_utilization: Ignore DaemonSet pods when calculating resource utilization for scaling down.
        :param pulumi.Input[int] max_graceful_termination_sec: Maximum number of seconds the cluster autoscaler waits for pod termination when trying to scale down a node
        :param pulumi.Input[str] scale_down_delay_after_add: How long after scale up that scale down evaluation resumes.
        :param pulumi.Input[str] scale_down_unneeded_time: How long a node should be unneeded before it is eligible for scale down.
        :param pulumi.Input[float] scale_down_utilization_threshold: Node utilization level, defined as sum of requested resources divided by capacity, below which a node can be considered for scale down
        """
        if balance_similar_node_groups is not None:
            pulumi.set(__self__, "balance_similar_node_groups", balance_similar_node_groups)
        if disable_scale_down is not None:
            pulumi.set(__self__, "disable_scale_down", disable_scale_down)
        if estimator is not None:
            pulumi.set(__self__, "estimator", estimator)
        if expander is not None:
            pulumi.set(__self__, "expander", expander)
        if expendable_pods_priority_cutoff is not None:
            pulumi.set(__self__, "expendable_pods_priority_cutoff", expendable_pods_priority_cutoff)
        if ignore_daemonsets_utilization is not None:
            pulumi.set(__self__, "ignore_daemonsets_utilization", ignore_daemonsets_utilization)
        if max_graceful_termination_sec is not None:
            pulumi.set(__self__, "max_graceful_termination_sec", max_graceful_termination_sec)
        if scale_down_delay_after_add is not None:
            pulumi.set(__self__, "scale_down_delay_after_add", scale_down_delay_after_add)
        if scale_down_unneeded_time is not None:
            pulumi.set(__self__, "scale_down_unneeded_time", scale_down_unneeded_time)
        if scale_down_utilization_threshold is not None:
            pulumi.set(__self__, "scale_down_utilization_threshold", scale_down_utilization_threshold)

    @property
    @pulumi.getter(name="balanceSimilarNodeGroups")
    def balance_similar_node_groups(self) -> Optional[pulumi.Input[bool]]:
        """
        Detect similar node groups and balance the number of nodes between them.
        """
        return pulumi.get(self, "balance_similar_node_groups")

    @balance_similar_node_groups.setter
    def balance_similar_node_groups(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "balance_similar_node_groups", value)

    @property
    @pulumi.getter(name="disableScaleDown")
    def disable_scale_down(self) -> Optional[pulumi.Input[bool]]:
        """
        Disables the scale down feature of the autoscaler.
        """
        return pulumi.get(self, "disable_scale_down")

    @disable_scale_down.setter
    def disable_scale_down(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "disable_scale_down", value)

    @property
    @pulumi.getter
    def estimator(self) -> Optional[pulumi.Input[str]]:
        """
        Type of resource estimator to be used in scale up.
        """
        return pulumi.get(self, "estimator")

    @estimator.setter
    def estimator(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "estimator", value)

    @property
    @pulumi.getter
    def expander(self) -> Optional[pulumi.Input[str]]:
        """
        Type of node group expander to be used in scale up.
        """
        return pulumi.get(self, "expander")

    @expander.setter
    def expander(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "expander", value)

    @property
    @pulumi.getter(name="expendablePodsPriorityCutoff")
    def expendable_pods_priority_cutoff(self) -> Optional[pulumi.Input[int]]:
        """
        Pods with priority below cutoff will be expendable. They can be killed without any consideration during scale down and they don't cause scale up. Pods with null priority (PodPriority disabled) are non expendable.
        """
        return pulumi.get(self, "expendable_pods_priority_cutoff")

    @expendable_pods_priority_cutoff.setter
    def expendable_pods_priority_cutoff(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "expendable_pods_priority_cutoff", value)

    @property
    @pulumi.getter(name="ignoreDaemonsetsUtilization")
    def ignore_daemonsets_utilization(self) -> Optional[pulumi.Input[bool]]:
        """
        Ignore DaemonSet pods when calculating resource utilization for scaling down.
        """
        return pulumi.get(self, "ignore_daemonsets_utilization")

    @ignore_daemonsets_utilization.setter
    def ignore_daemonsets_utilization(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "ignore_daemonsets_utilization", value)

    @property
    @pulumi.getter(name="maxGracefulTerminationSec")
    def max_graceful_termination_sec(self) -> Optional[pulumi.Input[int]]:
        """
        Maximum number of seconds the cluster autoscaler waits for pod termination when trying to scale down a node
        """
        return pulumi.get(self, "max_graceful_termination_sec")

    @max_graceful_termination_sec.setter
    def max_graceful_termination_sec(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "max_graceful_termination_sec", value)

    @property
    @pulumi.getter(name="scaleDownDelayAfterAdd")
    def scale_down_delay_after_add(self) -> Optional[pulumi.Input[str]]:
        """
        How long after scale up that scale down evaluation resumes.
        """
        return pulumi.get(self, "scale_down_delay_after_add")

    @scale_down_delay_after_add.setter
    def scale_down_delay_after_add(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "scale_down_delay_after_add", value)

    @property
    @pulumi.getter(name="scaleDownUnneededTime")
    def scale_down_unneeded_time(self) -> Optional[pulumi.Input[str]]:
        """
        How long a node should be unneeded before it is eligible for scale down.
        """
        return pulumi.get(self, "scale_down_unneeded_time")

    @scale_down_unneeded_time.setter
    def scale_down_unneeded_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "scale_down_unneeded_time", value)

    @property
    @pulumi.getter(name="scaleDownUtilizationThreshold")
    def scale_down_utilization_threshold(self) -> Optional[pulumi.Input[float]]:
        """
        Node utilization level, defined as sum of requested resources divided by capacity, below which a node can be considered for scale down
        """
        return pulumi.get(self, "scale_down_utilization_threshold")

    @scale_down_utilization_threshold.setter
    def scale_down_utilization_threshold(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "scale_down_utilization_threshold", value)


@pulumi.input_type
class K8sClusterKubeconfigArgs:
    def __init__(__self__, *,
                 cluster_ca_certificate: Optional[pulumi.Input[str]] = None,
                 config_file: Optional[pulumi.Input[str]] = None,
                 host: Optional[pulumi.Input[str]] = None,
                 token: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] cluster_ca_certificate: The CA certificate of the Kubernetes API server.
        :param pulumi.Input[str] config_file: The raw kubeconfig file.
        :param pulumi.Input[str] host: The URL of the Kubernetes API server.
        :param pulumi.Input[str] token: The token to connect to the Kubernetes API server.
        """
        if cluster_ca_certificate is not None:
            pulumi.set(__self__, "cluster_ca_certificate", cluster_ca_certificate)
        if config_file is not None:
            pulumi.set(__self__, "config_file", config_file)
        if host is not None:
            pulumi.set(__self__, "host", host)
        if token is not None:
            pulumi.set(__self__, "token", token)

    @property
    @pulumi.getter(name="clusterCaCertificate")
    def cluster_ca_certificate(self) -> Optional[pulumi.Input[str]]:
        """
        The CA certificate of the Kubernetes API server.
        """
        return pulumi.get(self, "cluster_ca_certificate")

    @cluster_ca_certificate.setter
    def cluster_ca_certificate(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cluster_ca_certificate", value)

    @property
    @pulumi.getter(name="configFile")
    def config_file(self) -> Optional[pulumi.Input[str]]:
        """
        The raw kubeconfig file.
        """
        return pulumi.get(self, "config_file")

    @config_file.setter
    def config_file(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "config_file", value)

    @property
    @pulumi.getter
    def host(self) -> Optional[pulumi.Input[str]]:
        """
        The URL of the Kubernetes API server.
        """
        return pulumi.get(self, "host")

    @host.setter
    def host(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "host", value)

    @property
    @pulumi.getter
    def token(self) -> Optional[pulumi.Input[str]]:
        """
        The token to connect to the Kubernetes API server.
        """
        return pulumi.get(self, "token")

    @token.setter
    def token(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "token", value)


@pulumi.input_type
class K8sClusterOpenIdConnectConfigArgs:
    def __init__(__self__, *,
                 client_id: pulumi.Input[str],
                 issuer_url: pulumi.Input[str],
                 groups_claims: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 groups_prefix: Optional[pulumi.Input[str]] = None,
                 required_claims: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 username_claim: Optional[pulumi.Input[str]] = None,
                 username_prefix: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] client_id: A client id that all tokens must be issued for
        :param pulumi.Input[str] issuer_url: URL of the provider which allows the API server to discover public signing keys
        :param pulumi.Input[Sequence[pulumi.Input[str]]] groups_claims: JWT claim to use as the user's group
        :param pulumi.Input[str] groups_prefix: Prefix prepended to group claims
        :param pulumi.Input[Sequence[pulumi.Input[str]]] required_claims: Multiple key=value pairs that describes a required claim in the ID Token
        :param pulumi.Input[str] username_claim: JWT claim to use as the user name
        :param pulumi.Input[str] username_prefix: Prefix prepended to username
        """
        pulumi.set(__self__, "client_id", client_id)
        pulumi.set(__self__, "issuer_url", issuer_url)
        if groups_claims is not None:
            pulumi.set(__self__, "groups_claims", groups_claims)
        if groups_prefix is not None:
            pulumi.set(__self__, "groups_prefix", groups_prefix)
        if required_claims is not None:
            pulumi.set(__self__, "required_claims", required_claims)
        if username_claim is not None:
            pulumi.set(__self__, "username_claim", username_claim)
        if username_prefix is not None:
            pulumi.set(__self__, "username_prefix", username_prefix)

    @property
    @pulumi.getter(name="clientId")
    def client_id(self) -> pulumi.Input[str]:
        """
        A client id that all tokens must be issued for
        """
        return pulumi.get(self, "client_id")

    @client_id.setter
    def client_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "client_id", value)

    @property
    @pulumi.getter(name="issuerUrl")
    def issuer_url(self) -> pulumi.Input[str]:
        """
        URL of the provider which allows the API server to discover public signing keys
        """
        return pulumi.get(self, "issuer_url")

    @issuer_url.setter
    def issuer_url(self, value: pulumi.Input[str]):
        pulumi.set(self, "issuer_url", value)

    @property
    @pulumi.getter(name="groupsClaims")
    def groups_claims(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        JWT claim to use as the user's group
        """
        return pulumi.get(self, "groups_claims")

    @groups_claims.setter
    def groups_claims(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "groups_claims", value)

    @property
    @pulumi.getter(name="groupsPrefix")
    def groups_prefix(self) -> Optional[pulumi.Input[str]]:
        """
        Prefix prepended to group claims
        """
        return pulumi.get(self, "groups_prefix")

    @groups_prefix.setter
    def groups_prefix(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "groups_prefix", value)

    @property
    @pulumi.getter(name="requiredClaims")
    def required_claims(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Multiple key=value pairs that describes a required claim in the ID Token
        """
        return pulumi.get(self, "required_claims")

    @required_claims.setter
    def required_claims(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "required_claims", value)

    @property
    @pulumi.getter(name="usernameClaim")
    def username_claim(self) -> Optional[pulumi.Input[str]]:
        """
        JWT claim to use as the user name
        """
        return pulumi.get(self, "username_claim")

    @username_claim.setter
    def username_claim(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "username_claim", value)

    @property
    @pulumi.getter(name="usernamePrefix")
    def username_prefix(self) -> Optional[pulumi.Input[str]]:
        """
        Prefix prepended to username
        """
        return pulumi.get(self, "username_prefix")

    @username_prefix.setter
    def username_prefix(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "username_prefix", value)


@pulumi.input_type
class K8sPoolNodeArgs:
    def __init__(__self__, *,
                 name: Optional[pulumi.Input[str]] = None,
                 public_ip: Optional[pulumi.Input[str]] = None,
                 public_ip_v6: Optional[pulumi.Input[str]] = None,
                 status: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] name: The name for the pool.
               > **Important:** Updates to this field will recreate a new resource.
        :param pulumi.Input[str] public_ip: The public IPv4.
        :param pulumi.Input[str] public_ip_v6: The public IPv6.
        :param pulumi.Input[str] status: The status of the node.
        """
        if name is not None:
            pulumi.set(__self__, "name", name)
        if public_ip is not None:
            pulumi.set(__self__, "public_ip", public_ip)
        if public_ip_v6 is not None:
            pulumi.set(__self__, "public_ip_v6", public_ip_v6)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name for the pool.
        > **Important:** Updates to this field will recreate a new resource.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="publicIp")
    def public_ip(self) -> Optional[pulumi.Input[str]]:
        """
        The public IPv4.
        """
        return pulumi.get(self, "public_ip")

    @public_ip.setter
    def public_ip(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "public_ip", value)

    @property
    @pulumi.getter(name="publicIpV6")
    def public_ip_v6(self) -> Optional[pulumi.Input[str]]:
        """
        The public IPv6.
        """
        return pulumi.get(self, "public_ip_v6")

    @public_ip_v6.setter
    def public_ip_v6(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "public_ip_v6", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[str]]:
        """
        The status of the node.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "status", value)


@pulumi.input_type
class K8sPoolUpgradePolicyArgs:
    def __init__(__self__, *,
                 max_surge: Optional[pulumi.Input[int]] = None,
                 max_unavailable: Optional[pulumi.Input[int]] = None):
        """
        :param pulumi.Input[int] max_surge: The maximum number of nodes to be created during the upgrade
        :param pulumi.Input[int] max_unavailable: The maximum number of nodes that can be not ready at the same time
        """
        if max_surge is not None:
            pulumi.set(__self__, "max_surge", max_surge)
        if max_unavailable is not None:
            pulumi.set(__self__, "max_unavailable", max_unavailable)

    @property
    @pulumi.getter(name="maxSurge")
    def max_surge(self) -> Optional[pulumi.Input[int]]:
        """
        The maximum number of nodes to be created during the upgrade
        """
        return pulumi.get(self, "max_surge")

    @max_surge.setter
    def max_surge(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "max_surge", value)

    @property
    @pulumi.getter(name="maxUnavailable")
    def max_unavailable(self) -> Optional[pulumi.Input[int]]:
        """
        The maximum number of nodes that can be not ready at the same time
        """
        return pulumi.get(self, "max_unavailable")

    @max_unavailable.setter
    def max_unavailable(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "max_unavailable", value)


@pulumi.input_type
class LbAclActionArgs:
    def __init__(__self__, *,
                 type: pulumi.Input[str],
                 redirects: Optional[pulumi.Input[Sequence[pulumi.Input['LbAclActionRedirectArgs']]]] = None):
        """
        :param pulumi.Input[str] type: The action type. Possible values are: `allow` or `deny` or `redirect`.
        :param pulumi.Input[Sequence[pulumi.Input['LbAclActionRedirectArgs']]] redirects: Redirect parameters when using an ACL with `redirect` action.
        """
        pulumi.set(__self__, "type", type)
        if redirects is not None:
            pulumi.set(__self__, "redirects", redirects)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        The action type. Possible values are: `allow` or `deny` or `redirect`.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter
    def redirects(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['LbAclActionRedirectArgs']]]]:
        """
        Redirect parameters when using an ACL with `redirect` action.
        """
        return pulumi.get(self, "redirects")

    @redirects.setter
    def redirects(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['LbAclActionRedirectArgs']]]]):
        pulumi.set(self, "redirects", value)


@pulumi.input_type
class LbAclActionRedirectArgs:
    def __init__(__self__, *,
                 code: Optional[pulumi.Input[int]] = None,
                 target: Optional[pulumi.Input[str]] = None,
                 type: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[int] code: The HTTP redirect code to use. Valid values are `301`, `302`, `303`, `307` and `308`.
        :param pulumi.Input[str] target: An URL can be used in case of a location redirect (e.g. `https://scaleway.com` will redirect to this same URL). A scheme name (e.g. `https`, `http`, `ftp`, `git`) will replace the request's original scheme.
        :param pulumi.Input[str] type: The redirect type. Possible values are: `location` or `scheme`.
        """
        if code is not None:
            pulumi.set(__self__, "code", code)
        if target is not None:
            pulumi.set(__self__, "target", target)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def code(self) -> Optional[pulumi.Input[int]]:
        """
        The HTTP redirect code to use. Valid values are `301`, `302`, `303`, `307` and `308`.
        """
        return pulumi.get(self, "code")

    @code.setter
    def code(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "code", value)

    @property
    @pulumi.getter
    def target(self) -> Optional[pulumi.Input[str]]:
        """
        An URL can be used in case of a location redirect (e.g. `https://scaleway.com` will redirect to this same URL). A scheme name (e.g. `https`, `http`, `ftp`, `git`) will replace the request's original scheme.
        """
        return pulumi.get(self, "target")

    @target.setter
    def target(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "target", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[str]]:
        """
        The redirect type. Possible values are: `location` or `scheme`.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "type", value)


@pulumi.input_type
class LbAclMatchArgs:
    def __init__(__self__, *,
                 http_filter: Optional[pulumi.Input[str]] = None,
                 http_filter_option: Optional[pulumi.Input[str]] = None,
                 http_filter_values: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 invert: Optional[pulumi.Input[bool]] = None,
                 ip_subnets: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        :param pulumi.Input[str] http_filter: The HTTP filter to match. This filter is supported only if your backend protocol has an HTTP forward protocol.
               It extracts the request's URL path, which starts at the first slash and ends before the question mark (without the host part).
               Possible values are: `acl_http_filter_none`, `path_begin`, `path_end`, `http_header_match` or `regex`.
        :param pulumi.Input[str] http_filter_option: If you have `http_filter` at `http_header_match`, you can use this field to filter on the HTTP header's value.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] http_filter_values: A list of possible values to match for the given HTTP filter.
               Keep in mind that in the case of `http_header_match` the HTTP header field name is case-insensitive.
        :param pulumi.Input[bool] invert: If set to `true`, the condition will be of type "unless".
        :param pulumi.Input[Sequence[pulumi.Input[str]]] ip_subnets: A list of IPs or CIDR v4/v6 addresses of the client of the session to match.
        """
        if http_filter is not None:
            pulumi.set(__self__, "http_filter", http_filter)
        if http_filter_option is not None:
            pulumi.set(__self__, "http_filter_option", http_filter_option)
        if http_filter_values is not None:
            pulumi.set(__self__, "http_filter_values", http_filter_values)
        if invert is not None:
            pulumi.set(__self__, "invert", invert)
        if ip_subnets is not None:
            pulumi.set(__self__, "ip_subnets", ip_subnets)

    @property
    @pulumi.getter(name="httpFilter")
    def http_filter(self) -> Optional[pulumi.Input[str]]:
        """
        The HTTP filter to match. This filter is supported only if your backend protocol has an HTTP forward protocol.
        It extracts the request's URL path, which starts at the first slash and ends before the question mark (without the host part).
        Possible values are: `acl_http_filter_none`, `path_begin`, `path_end`, `http_header_match` or `regex`.
        """
        return pulumi.get(self, "http_filter")

    @http_filter.setter
    def http_filter(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "http_filter", value)

    @property
    @pulumi.getter(name="httpFilterOption")
    def http_filter_option(self) -> Optional[pulumi.Input[str]]:
        """
        If you have `http_filter` at `http_header_match`, you can use this field to filter on the HTTP header's value.
        """
        return pulumi.get(self, "http_filter_option")

    @http_filter_option.setter
    def http_filter_option(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "http_filter_option", value)

    @property
    @pulumi.getter(name="httpFilterValues")
    def http_filter_values(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        A list of possible values to match for the given HTTP filter.
        Keep in mind that in the case of `http_header_match` the HTTP header field name is case-insensitive.
        """
        return pulumi.get(self, "http_filter_values")

    @http_filter_values.setter
    def http_filter_values(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "http_filter_values", value)

    @property
    @pulumi.getter
    def invert(self) -> Optional[pulumi.Input[bool]]:
        """
        If set to `true`, the condition will be of type "unless".
        """
        return pulumi.get(self, "invert")

    @invert.setter
    def invert(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "invert", value)

    @property
    @pulumi.getter(name="ipSubnets")
    def ip_subnets(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        A list of IPs or CIDR v4/v6 addresses of the client of the session to match.
        """
        return pulumi.get(self, "ip_subnets")

    @ip_subnets.setter
    def ip_subnets(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "ip_subnets", value)


@pulumi.input_type
class LbBackendHealthCheckHttpArgs:
    def __init__(__self__, *,
                 uri: pulumi.Input[str],
                 code: Optional[pulumi.Input[int]] = None,
                 host_header: Optional[pulumi.Input[str]] = None,
                 method: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] uri: The HTTP endpoint URL to call for HC requests
        :param pulumi.Input[int] code: The expected HTTP status code
        :param pulumi.Input[str] host_header: The HTTP host header to use for HC requests
        :param pulumi.Input[str] method: The HTTP method to use for HC requests
        """
        pulumi.set(__self__, "uri", uri)
        if code is not None:
            pulumi.set(__self__, "code", code)
        if host_header is not None:
            pulumi.set(__self__, "host_header", host_header)
        if method is not None:
            pulumi.set(__self__, "method", method)

    @property
    @pulumi.getter
    def uri(self) -> pulumi.Input[str]:
        """
        The HTTP endpoint URL to call for HC requests
        """
        return pulumi.get(self, "uri")

    @uri.setter
    def uri(self, value: pulumi.Input[str]):
        pulumi.set(self, "uri", value)

    @property
    @pulumi.getter
    def code(self) -> Optional[pulumi.Input[int]]:
        """
        The expected HTTP status code
        """
        return pulumi.get(self, "code")

    @code.setter
    def code(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "code", value)

    @property
    @pulumi.getter(name="hostHeader")
    def host_header(self) -> Optional[pulumi.Input[str]]:
        """
        The HTTP host header to use for HC requests
        """
        return pulumi.get(self, "host_header")

    @host_header.setter
    def host_header(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "host_header", value)

    @property
    @pulumi.getter
    def method(self) -> Optional[pulumi.Input[str]]:
        """
        The HTTP method to use for HC requests
        """
        return pulumi.get(self, "method")

    @method.setter
    def method(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "method", value)


@pulumi.input_type
class LbBackendHealthCheckHttpsArgs:
    def __init__(__self__, *,
                 uri: pulumi.Input[str],
                 code: Optional[pulumi.Input[int]] = None,
                 host_header: Optional[pulumi.Input[str]] = None,
                 method: Optional[pulumi.Input[str]] = None,
                 sni: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] uri: The HTTPS endpoint URL to call for HC requests
        :param pulumi.Input[int] code: The expected HTTP status code
        :param pulumi.Input[str] host_header: The HTTP host header to use for HC requests
        :param pulumi.Input[str] method: The HTTP method to use for HC requests
        :param pulumi.Input[str] sni: The SNI to use for HC requests over SSL
        """
        pulumi.set(__self__, "uri", uri)
        if code is not None:
            pulumi.set(__self__, "code", code)
        if host_header is not None:
            pulumi.set(__self__, "host_header", host_header)
        if method is not None:
            pulumi.set(__self__, "method", method)
        if sni is not None:
            pulumi.set(__self__, "sni", sni)

    @property
    @pulumi.getter
    def uri(self) -> pulumi.Input[str]:
        """
        The HTTPS endpoint URL to call for HC requests
        """
        return pulumi.get(self, "uri")

    @uri.setter
    def uri(self, value: pulumi.Input[str]):
        pulumi.set(self, "uri", value)

    @property
    @pulumi.getter
    def code(self) -> Optional[pulumi.Input[int]]:
        """
        The expected HTTP status code
        """
        return pulumi.get(self, "code")

    @code.setter
    def code(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "code", value)

    @property
    @pulumi.getter(name="hostHeader")
    def host_header(self) -> Optional[pulumi.Input[str]]:
        """
        The HTTP host header to use for HC requests
        """
        return pulumi.get(self, "host_header")

    @host_header.setter
    def host_header(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "host_header", value)

    @property
    @pulumi.getter
    def method(self) -> Optional[pulumi.Input[str]]:
        """
        The HTTP method to use for HC requests
        """
        return pulumi.get(self, "method")

    @method.setter
    def method(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "method", value)

    @property
    @pulumi.getter
    def sni(self) -> Optional[pulumi.Input[str]]:
        """
        The SNI to use for HC requests over SSL
        """
        return pulumi.get(self, "sni")

    @sni.setter
    def sni(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "sni", value)


@pulumi.input_type
class LbBackendHealthCheckTcpArgs:
    def __init__(__self__):
        pass


@pulumi.input_type
class LbCertificateCustomCertificateArgs:
    def __init__(__self__, *,
                 certificate_chain: pulumi.Input[str]):
        """
        :param pulumi.Input[str] certificate_chain: The full PEM-formatted certificate chain
        """
        pulumi.set(__self__, "certificate_chain", certificate_chain)

    @property
    @pulumi.getter(name="certificateChain")
    def certificate_chain(self) -> pulumi.Input[str]:
        """
        The full PEM-formatted certificate chain
        """
        return pulumi.get(self, "certificate_chain")

    @certificate_chain.setter
    def certificate_chain(self, value: pulumi.Input[str]):
        pulumi.set(self, "certificate_chain", value)


@pulumi.input_type
class LbCertificateLetsencryptArgs:
    def __init__(__self__, *,
                 common_name: pulumi.Input[str],
                 subject_alternative_names: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        :param pulumi.Input[str] common_name: Main domain of the certificate
        :param pulumi.Input[Sequence[pulumi.Input[str]]] subject_alternative_names: The alternative domain names of the certificate
        """
        pulumi.set(__self__, "common_name", common_name)
        if subject_alternative_names is not None:
            pulumi.set(__self__, "subject_alternative_names", subject_alternative_names)

    @property
    @pulumi.getter(name="commonName")
    def common_name(self) -> pulumi.Input[str]:
        """
        Main domain of the certificate
        """
        return pulumi.get(self, "common_name")

    @common_name.setter
    def common_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "common_name", value)

    @property
    @pulumi.getter(name="subjectAlternativeNames")
    def subject_alternative_names(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The alternative domain names of the certificate
        """
        return pulumi.get(self, "subject_alternative_names")

    @subject_alternative_names.setter
    def subject_alternative_names(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "subject_alternative_names", value)


@pulumi.input_type
class LbFrontendAclArgs:
    def __init__(__self__, *,
                 action: pulumi.Input['LbFrontendAclActionArgs'],
                 match: pulumi.Input['LbFrontendAclMatchArgs'],
                 created_at: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 updated_at: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input['LbFrontendAclActionArgs'] action: Action to undertake when an ACL filter matches.
        :param pulumi.Input['LbFrontendAclMatchArgs'] match: The ACL match rule. At least `ip_subnet` or `http_filter` and `http_filter_value` are required.
        :param pulumi.Input[str] created_at: IsDate and time of ACL's creation (RFC 3339 format)
        :param pulumi.Input[str] description: Description of the ACL
        :param pulumi.Input[str] name: The ACL name. If not provided it will be randomly generated.
        :param pulumi.Input[str] updated_at: IsDate and time of ACL's update (RFC 3339 format)
        """
        pulumi.set(__self__, "action", action)
        pulumi.set(__self__, "match", match)
        if created_at is not None:
            pulumi.set(__self__, "created_at", created_at)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if updated_at is not None:
            pulumi.set(__self__, "updated_at", updated_at)

    @property
    @pulumi.getter
    def action(self) -> pulumi.Input['LbFrontendAclActionArgs']:
        """
        Action to undertake when an ACL filter matches.
        """
        return pulumi.get(self, "action")

    @action.setter
    def action(self, value: pulumi.Input['LbFrontendAclActionArgs']):
        pulumi.set(self, "action", value)

    @property
    @pulumi.getter
    def match(self) -> pulumi.Input['LbFrontendAclMatchArgs']:
        """
        The ACL match rule. At least `ip_subnet` or `http_filter` and `http_filter_value` are required.
        """
        return pulumi.get(self, "match")

    @match.setter
    def match(self, value: pulumi.Input['LbFrontendAclMatchArgs']):
        pulumi.set(self, "match", value)

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[pulumi.Input[str]]:
        """
        IsDate and time of ACL's creation (RFC 3339 format)
        """
        return pulumi.get(self, "created_at")

    @created_at.setter
    def created_at(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "created_at", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Description of the ACL
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The ACL name. If not provided it will be randomly generated.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> Optional[pulumi.Input[str]]:
        """
        IsDate and time of ACL's update (RFC 3339 format)
        """
        return pulumi.get(self, "updated_at")

    @updated_at.setter
    def updated_at(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "updated_at", value)


@pulumi.input_type
class LbFrontendAclActionArgs:
    def __init__(__self__, *,
                 type: pulumi.Input[str],
                 redirects: Optional[pulumi.Input[Sequence[pulumi.Input['LbFrontendAclActionRedirectArgs']]]] = None):
        """
        :param pulumi.Input[str] type: The action type. Possible values are: `allow` or `deny` or `redirect`.
        :param pulumi.Input[Sequence[pulumi.Input['LbFrontendAclActionRedirectArgs']]] redirects: Redirect parameters when using an ACL with `redirect` action.
        """
        pulumi.set(__self__, "type", type)
        if redirects is not None:
            pulumi.set(__self__, "redirects", redirects)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        The action type. Possible values are: `allow` or `deny` or `redirect`.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter
    def redirects(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['LbFrontendAclActionRedirectArgs']]]]:
        """
        Redirect parameters when using an ACL with `redirect` action.
        """
        return pulumi.get(self, "redirects")

    @redirects.setter
    def redirects(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['LbFrontendAclActionRedirectArgs']]]]):
        pulumi.set(self, "redirects", value)


@pulumi.input_type
class LbFrontendAclActionRedirectArgs:
    def __init__(__self__, *,
                 code: Optional[pulumi.Input[int]] = None,
                 target: Optional[pulumi.Input[str]] = None,
                 type: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[int] code: The HTTP redirect code to use. Valid values are `301`, `302`, `303`, `307` and `308`.
        :param pulumi.Input[str] target: An URL can be used in case of a location redirect (e.g. `https://scaleway.com` will redirect to this same URL). A scheme name (e.g. `https`, `http`, `ftp`, `git`) will replace the request's original scheme.
        :param pulumi.Input[str] type: The redirect type. Possible values are: `location` or `scheme`.
        """
        if code is not None:
            pulumi.set(__self__, "code", code)
        if target is not None:
            pulumi.set(__self__, "target", target)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def code(self) -> Optional[pulumi.Input[int]]:
        """
        The HTTP redirect code to use. Valid values are `301`, `302`, `303`, `307` and `308`.
        """
        return pulumi.get(self, "code")

    @code.setter
    def code(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "code", value)

    @property
    @pulumi.getter
    def target(self) -> Optional[pulumi.Input[str]]:
        """
        An URL can be used in case of a location redirect (e.g. `https://scaleway.com` will redirect to this same URL). A scheme name (e.g. `https`, `http`, `ftp`, `git`) will replace the request's original scheme.
        """
        return pulumi.get(self, "target")

    @target.setter
    def target(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "target", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[str]]:
        """
        The redirect type. Possible values are: `location` or `scheme`.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "type", value)


@pulumi.input_type
class LbFrontendAclMatchArgs:
    def __init__(__self__, *,
                 http_filter: Optional[pulumi.Input[str]] = None,
                 http_filter_option: Optional[pulumi.Input[str]] = None,
                 http_filter_values: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 invert: Optional[pulumi.Input[bool]] = None,
                 ip_subnets: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        :param pulumi.Input[str] http_filter: The HTTP filter to match. This filter is supported only if your backend protocol has an HTTP forward protocol.
               It extracts the request's URL path, which starts at the first slash and ends before the question mark (without the host part).
               Possible values are: `acl_http_filter_none`, `path_begin`, `path_end`, `http_header_match` or `regex`.
        :param pulumi.Input[str] http_filter_option: If you have `http_filter` at `http_header_match`, you can use this field to filter on the HTTP header's value.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] http_filter_values: A list of possible values to match for the given HTTP filter.
               Keep in mind that in the case of `http_header_match` the HTTP header field name is case-insensitive.
        :param pulumi.Input[bool] invert: If set to `true`, the condition will be of type "unless".
        :param pulumi.Input[Sequence[pulumi.Input[str]]] ip_subnets: A list of IPs or CIDR v4/v6 addresses of the client of the session to match.
        """
        if http_filter is not None:
            pulumi.set(__self__, "http_filter", http_filter)
        if http_filter_option is not None:
            pulumi.set(__self__, "http_filter_option", http_filter_option)
        if http_filter_values is not None:
            pulumi.set(__self__, "http_filter_values", http_filter_values)
        if invert is not None:
            pulumi.set(__self__, "invert", invert)
        if ip_subnets is not None:
            pulumi.set(__self__, "ip_subnets", ip_subnets)

    @property
    @pulumi.getter(name="httpFilter")
    def http_filter(self) -> Optional[pulumi.Input[str]]:
        """
        The HTTP filter to match. This filter is supported only if your backend protocol has an HTTP forward protocol.
        It extracts the request's URL path, which starts at the first slash and ends before the question mark (without the host part).
        Possible values are: `acl_http_filter_none`, `path_begin`, `path_end`, `http_header_match` or `regex`.
        """
        return pulumi.get(self, "http_filter")

    @http_filter.setter
    def http_filter(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "http_filter", value)

    @property
    @pulumi.getter(name="httpFilterOption")
    def http_filter_option(self) -> Optional[pulumi.Input[str]]:
        """
        If you have `http_filter` at `http_header_match`, you can use this field to filter on the HTTP header's value.
        """
        return pulumi.get(self, "http_filter_option")

    @http_filter_option.setter
    def http_filter_option(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "http_filter_option", value)

    @property
    @pulumi.getter(name="httpFilterValues")
    def http_filter_values(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        A list of possible values to match for the given HTTP filter.
        Keep in mind that in the case of `http_header_match` the HTTP header field name is case-insensitive.
        """
        return pulumi.get(self, "http_filter_values")

    @http_filter_values.setter
    def http_filter_values(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "http_filter_values", value)

    @property
    @pulumi.getter
    def invert(self) -> Optional[pulumi.Input[bool]]:
        """
        If set to `true`, the condition will be of type "unless".
        """
        return pulumi.get(self, "invert")

    @invert.setter
    def invert(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "invert", value)

    @property
    @pulumi.getter(name="ipSubnets")
    def ip_subnets(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        A list of IPs or CIDR v4/v6 addresses of the client of the session to match.
        """
        return pulumi.get(self, "ip_subnets")

    @ip_subnets.setter
    def ip_subnets(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "ip_subnets", value)


@pulumi.input_type
class LbPrivateNetworkArgs:
    def __init__(__self__, *,
                 private_network_id: pulumi.Input[str],
                 dhcp_config: Optional[pulumi.Input[bool]] = None,
                 static_config: Optional[pulumi.Input[str]] = None,
                 status: Optional[pulumi.Input[str]] = None,
                 zone: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] private_network_id: (Required) The ID of the Private Network to associate.
        :param pulumi.Input[bool] dhcp_config: (Optional) Set to true if you want to let DHCP assign IP addresses. See below.
        :param pulumi.Input[str] static_config: (Optional) Define a local ip address of your choice for the load balancer instance. See below.
        :param pulumi.Input[str] status: The status of private network connection
        :param pulumi.Input[str] zone: `zone`) The zone of the load-balancer.
        """
        pulumi.set(__self__, "private_network_id", private_network_id)
        if dhcp_config is not None:
            pulumi.set(__self__, "dhcp_config", dhcp_config)
        if static_config is not None:
            pulumi.set(__self__, "static_config", static_config)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if zone is not None:
            pulumi.set(__self__, "zone", zone)

    @property
    @pulumi.getter(name="privateNetworkId")
    def private_network_id(self) -> pulumi.Input[str]:
        """
        (Required) The ID of the Private Network to associate.
        """
        return pulumi.get(self, "private_network_id")

    @private_network_id.setter
    def private_network_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "private_network_id", value)

    @property
    @pulumi.getter(name="dhcpConfig")
    def dhcp_config(self) -> Optional[pulumi.Input[bool]]:
        """
        (Optional) Set to true if you want to let DHCP assign IP addresses. See below.
        """
        return pulumi.get(self, "dhcp_config")

    @dhcp_config.setter
    def dhcp_config(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "dhcp_config", value)

    @property
    @pulumi.getter(name="staticConfig")
    def static_config(self) -> Optional[pulumi.Input[str]]:
        """
        (Optional) Define a local ip address of your choice for the load balancer instance. See below.
        """
        return pulumi.get(self, "static_config")

    @static_config.setter
    def static_config(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "static_config", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[str]]:
        """
        The status of private network connection
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "status", value)

    @property
    @pulumi.getter
    def zone(self) -> Optional[pulumi.Input[str]]:
        """
        `zone`) The zone of the load-balancer.
        """
        return pulumi.get(self, "zone")

    @zone.setter
    def zone(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "zone", value)


@pulumi.input_type
class MnqSnsCredentialsPermissionsArgs:
    def __init__(__self__, *,
                 can_manage: Optional[pulumi.Input[bool]] = None,
                 can_publish: Optional[pulumi.Input[bool]] = None,
                 can_receive: Optional[pulumi.Input[bool]] = None):
        """
        :param pulumi.Input[bool] can_manage: . Defines if user can manage the associated resource(s).
        :param pulumi.Input[bool] can_publish: . Defines if user can publish messages to the service.
        :param pulumi.Input[bool] can_receive: . Defines if user can receive messages from the service.
        """
        if can_manage is not None:
            pulumi.set(__self__, "can_manage", can_manage)
        if can_publish is not None:
            pulumi.set(__self__, "can_publish", can_publish)
        if can_receive is not None:
            pulumi.set(__self__, "can_receive", can_receive)

    @property
    @pulumi.getter(name="canManage")
    def can_manage(self) -> Optional[pulumi.Input[bool]]:
        """
        . Defines if user can manage the associated resource(s).
        """
        return pulumi.get(self, "can_manage")

    @can_manage.setter
    def can_manage(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "can_manage", value)

    @property
    @pulumi.getter(name="canPublish")
    def can_publish(self) -> Optional[pulumi.Input[bool]]:
        """
        . Defines if user can publish messages to the service.
        """
        return pulumi.get(self, "can_publish")

    @can_publish.setter
    def can_publish(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "can_publish", value)

    @property
    @pulumi.getter(name="canReceive")
    def can_receive(self) -> Optional[pulumi.Input[bool]]:
        """
        . Defines if user can receive messages from the service.
        """
        return pulumi.get(self, "can_receive")

    @can_receive.setter
    def can_receive(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "can_receive", value)


@pulumi.input_type
class MnqSqsCredentialsPermissionsArgs:
    def __init__(__self__, *,
                 can_manage: Optional[pulumi.Input[bool]] = None,
                 can_publish: Optional[pulumi.Input[bool]] = None,
                 can_receive: Optional[pulumi.Input[bool]] = None):
        """
        :param pulumi.Input[bool] can_manage: . Defines if user can manage the associated resource(s).
        :param pulumi.Input[bool] can_publish: . Defines if user can publish messages to the service.
        :param pulumi.Input[bool] can_receive: . Defines if user can receive messages from the service.
        """
        if can_manage is not None:
            pulumi.set(__self__, "can_manage", can_manage)
        if can_publish is not None:
            pulumi.set(__self__, "can_publish", can_publish)
        if can_receive is not None:
            pulumi.set(__self__, "can_receive", can_receive)

    @property
    @pulumi.getter(name="canManage")
    def can_manage(self) -> Optional[pulumi.Input[bool]]:
        """
        . Defines if user can manage the associated resource(s).
        """
        return pulumi.get(self, "can_manage")

    @can_manage.setter
    def can_manage(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "can_manage", value)

    @property
    @pulumi.getter(name="canPublish")
    def can_publish(self) -> Optional[pulumi.Input[bool]]:
        """
        . Defines if user can publish messages to the service.
        """
        return pulumi.get(self, "can_publish")

    @can_publish.setter
    def can_publish(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "can_publish", value)

    @property
    @pulumi.getter(name="canReceive")
    def can_receive(self) -> Optional[pulumi.Input[bool]]:
        """
        . Defines if user can receive messages from the service.
        """
        return pulumi.get(self, "can_receive")

    @can_receive.setter
    def can_receive(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "can_receive", value)


@pulumi.input_type
class ObjectBucketAclAccessControlPolicyArgs:
    def __init__(__self__, *,
                 owner: pulumi.Input['ObjectBucketAclAccessControlPolicyOwnerArgs'],
                 grants: Optional[pulumi.Input[Sequence[pulumi.Input['ObjectBucketAclAccessControlPolicyGrantArgs']]]] = None):
        """
        :param pulumi.Input['ObjectBucketAclAccessControlPolicyOwnerArgs'] owner: Configuration block of the bucket project owner's display organization ID.
        """
        pulumi.set(__self__, "owner", owner)
        if grants is not None:
            pulumi.set(__self__, "grants", grants)

    @property
    @pulumi.getter
    def owner(self) -> pulumi.Input['ObjectBucketAclAccessControlPolicyOwnerArgs']:
        """
        Configuration block of the bucket project owner's display organization ID.
        """
        return pulumi.get(self, "owner")

    @owner.setter
    def owner(self, value: pulumi.Input['ObjectBucketAclAccessControlPolicyOwnerArgs']):
        pulumi.set(self, "owner", value)

    @property
    @pulumi.getter
    def grants(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ObjectBucketAclAccessControlPolicyGrantArgs']]]]:
        return pulumi.get(self, "grants")

    @grants.setter
    def grants(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ObjectBucketAclAccessControlPolicyGrantArgs']]]]):
        pulumi.set(self, "grants", value)


@pulumi.input_type
class ObjectBucketAclAccessControlPolicyGrantArgs:
    def __init__(__self__, *,
                 permission: pulumi.Input[str],
                 grantee: Optional[pulumi.Input['ObjectBucketAclAccessControlPolicyGrantGranteeArgs']] = None):
        """
        :param pulumi.Input[str] permission: Logging permissions assigned to the grantee for the bucket.
        :param pulumi.Input['ObjectBucketAclAccessControlPolicyGrantGranteeArgs'] grantee: Configuration block for the project being granted permissions.
        """
        pulumi.set(__self__, "permission", permission)
        if grantee is not None:
            pulumi.set(__self__, "grantee", grantee)

    @property
    @pulumi.getter
    def permission(self) -> pulumi.Input[str]:
        """
        Logging permissions assigned to the grantee for the bucket.
        """
        return pulumi.get(self, "permission")

    @permission.setter
    def permission(self, value: pulumi.Input[str]):
        pulumi.set(self, "permission", value)

    @property
    @pulumi.getter
    def grantee(self) -> Optional[pulumi.Input['ObjectBucketAclAccessControlPolicyGrantGranteeArgs']]:
        """
        Configuration block for the project being granted permissions.
        """
        return pulumi.get(self, "grantee")

    @grantee.setter
    def grantee(self, value: Optional[pulumi.Input['ObjectBucketAclAccessControlPolicyGrantGranteeArgs']]):
        pulumi.set(self, "grantee", value)


@pulumi.input_type
class ObjectBucketAclAccessControlPolicyGrantGranteeArgs:
    def __init__(__self__, *,
                 id: pulumi.Input[str],
                 type: pulumi.Input[str],
                 display_name: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] id: The `region`,`bucket` and `acl` separated by (`/`).
        :param pulumi.Input[str] type: Type of grantee. Valid values: `CanonicalUser`
        """
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "type", type)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)

    @property
    @pulumi.getter
    def id(self) -> pulumi.Input[str]:
        """
        The `region`,`bucket` and `acl` separated by (`/`).
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: pulumi.Input[str]):
        pulumi.set(self, "id", value)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        Type of grantee. Valid values: `CanonicalUser`
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "display_name", value)


@pulumi.input_type
class ObjectBucketAclAccessControlPolicyOwnerArgs:
    def __init__(__self__, *,
                 id: pulumi.Input[str],
                 display_name: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] id: The `region`,`bucket` and `acl` separated by (`/`).
        :param pulumi.Input[str] display_name: The project ID of the grantee.
        """
        pulumi.set(__self__, "id", id)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)

    @property
    @pulumi.getter
    def id(self) -> pulumi.Input[str]:
        """
        The `region`,`bucket` and `acl` separated by (`/`).
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: pulumi.Input[str]):
        pulumi.set(self, "id", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[str]]:
        """
        The project ID of the grantee.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "display_name", value)


@pulumi.input_type
class ObjectBucketCorsRuleArgs:
    def __init__(__self__, *,
                 allowed_methods: pulumi.Input[Sequence[pulumi.Input[str]]],
                 allowed_origins: pulumi.Input[Sequence[pulumi.Input[str]]],
                 allowed_headers: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 expose_headers: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 max_age_seconds: Optional[pulumi.Input[int]] = None):
        """
        :param pulumi.Input[Sequence[pulumi.Input[str]]] allowed_methods: Specifies which methods are allowed. Can be `GET`, `PUT`, `POST`, `DELETE` or `HEAD`.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] allowed_origins: Specifies which origins are allowed.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] allowed_headers: Specifies which headers are allowed.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] expose_headers: Specifies expose header in the response.
        :param pulumi.Input[int] max_age_seconds: Specifies time in seconds that browser can cache the response for a preflight request.
        """
        pulumi.set(__self__, "allowed_methods", allowed_methods)
        pulumi.set(__self__, "allowed_origins", allowed_origins)
        if allowed_headers is not None:
            pulumi.set(__self__, "allowed_headers", allowed_headers)
        if expose_headers is not None:
            pulumi.set(__self__, "expose_headers", expose_headers)
        if max_age_seconds is not None:
            pulumi.set(__self__, "max_age_seconds", max_age_seconds)

    @property
    @pulumi.getter(name="allowedMethods")
    def allowed_methods(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        """
        Specifies which methods are allowed. Can be `GET`, `PUT`, `POST`, `DELETE` or `HEAD`.
        """
        return pulumi.get(self, "allowed_methods")

    @allowed_methods.setter
    def allowed_methods(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "allowed_methods", value)

    @property
    @pulumi.getter(name="allowedOrigins")
    def allowed_origins(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        """
        Specifies which origins are allowed.
        """
        return pulumi.get(self, "allowed_origins")

    @allowed_origins.setter
    def allowed_origins(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "allowed_origins", value)

    @property
    @pulumi.getter(name="allowedHeaders")
    def allowed_headers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Specifies which headers are allowed.
        """
        return pulumi.get(self, "allowed_headers")

    @allowed_headers.setter
    def allowed_headers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "allowed_headers", value)

    @property
    @pulumi.getter(name="exposeHeaders")
    def expose_headers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Specifies expose header in the response.
        """
        return pulumi.get(self, "expose_headers")

    @expose_headers.setter
    def expose_headers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "expose_headers", value)

    @property
    @pulumi.getter(name="maxAgeSeconds")
    def max_age_seconds(self) -> Optional[pulumi.Input[int]]:
        """
        Specifies time in seconds that browser can cache the response for a preflight request.
        """
        return pulumi.get(self, "max_age_seconds")

    @max_age_seconds.setter
    def max_age_seconds(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "max_age_seconds", value)


@pulumi.input_type
class ObjectBucketLifecycleRuleArgs:
    def __init__(__self__, *,
                 enabled: pulumi.Input[bool],
                 abort_incomplete_multipart_upload_days: Optional[pulumi.Input[int]] = None,
                 expiration: Optional[pulumi.Input['ObjectBucketLifecycleRuleExpirationArgs']] = None,
                 id: Optional[pulumi.Input[str]] = None,
                 prefix: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 transitions: Optional[pulumi.Input[Sequence[pulumi.Input['ObjectBucketLifecycleRuleTransitionArgs']]]] = None):
        """
        :param pulumi.Input[bool] enabled: The element value can be either Enabled or Disabled. If a rule is disabled, Scaleway S3 doesn't perform any of the actions defined in the rule.
        :param pulumi.Input[int] abort_incomplete_multipart_upload_days: Specifies the number of days after initiating a multipart upload when the multipart upload must be completed.
               
               * > **Important:** It's not recommended using `prefix` for `AbortIncompleteMultipartUpload` as any incomplete multipart upload will be billed
        :param pulumi.Input['ObjectBucketLifecycleRuleExpirationArgs'] expiration: Specifies a period in the object's expire (documented below).
        :param pulumi.Input[str] id: Unique identifier for the rule. Must be less than or equal to 255 characters in length.
        :param pulumi.Input[str] prefix: Object key prefix identifying one or more objects to which the rule applies.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: Specifies object tags key and value.
        :param pulumi.Input[Sequence[pulumi.Input['ObjectBucketLifecycleRuleTransitionArgs']]] transitions: Specifies a period in the object's transitions (documented below).
               
               At least one of `abort_incomplete_multipart_upload_days`, `expiration`, `transition` must be specified.
        """
        pulumi.set(__self__, "enabled", enabled)
        if abort_incomplete_multipart_upload_days is not None:
            pulumi.set(__self__, "abort_incomplete_multipart_upload_days", abort_incomplete_multipart_upload_days)
        if expiration is not None:
            pulumi.set(__self__, "expiration", expiration)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if prefix is not None:
            pulumi.set(__self__, "prefix", prefix)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if transitions is not None:
            pulumi.set(__self__, "transitions", transitions)

    @property
    @pulumi.getter
    def enabled(self) -> pulumi.Input[bool]:
        """
        The element value can be either Enabled or Disabled. If a rule is disabled, Scaleway S3 doesn't perform any of the actions defined in the rule.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: pulumi.Input[bool]):
        pulumi.set(self, "enabled", value)

    @property
    @pulumi.getter(name="abortIncompleteMultipartUploadDays")
    def abort_incomplete_multipart_upload_days(self) -> Optional[pulumi.Input[int]]:
        """
        Specifies the number of days after initiating a multipart upload when the multipart upload must be completed.

        * > **Important:** It's not recommended using `prefix` for `AbortIncompleteMultipartUpload` as any incomplete multipart upload will be billed
        """
        return pulumi.get(self, "abort_incomplete_multipart_upload_days")

    @abort_incomplete_multipart_upload_days.setter
    def abort_incomplete_multipart_upload_days(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "abort_incomplete_multipart_upload_days", value)

    @property
    @pulumi.getter
    def expiration(self) -> Optional[pulumi.Input['ObjectBucketLifecycleRuleExpirationArgs']]:
        """
        Specifies a period in the object's expire (documented below).
        """
        return pulumi.get(self, "expiration")

    @expiration.setter
    def expiration(self, value: Optional[pulumi.Input['ObjectBucketLifecycleRuleExpirationArgs']]):
        pulumi.set(self, "expiration", value)

    @property
    @pulumi.getter
    def id(self) -> Optional[pulumi.Input[str]]:
        """
        Unique identifier for the rule. Must be less than or equal to 255 characters in length.
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "id", value)

    @property
    @pulumi.getter
    def prefix(self) -> Optional[pulumi.Input[str]]:
        """
        Object key prefix identifying one or more objects to which the rule applies.
        """
        return pulumi.get(self, "prefix")

    @prefix.setter
    def prefix(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "prefix", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Specifies object tags key and value.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter
    def transitions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ObjectBucketLifecycleRuleTransitionArgs']]]]:
        """
        Specifies a period in the object's transitions (documented below).

        At least one of `abort_incomplete_multipart_upload_days`, `expiration`, `transition` must be specified.
        """
        return pulumi.get(self, "transitions")

    @transitions.setter
    def transitions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ObjectBucketLifecycleRuleTransitionArgs']]]]):
        pulumi.set(self, "transitions", value)


@pulumi.input_type
class ObjectBucketLifecycleRuleExpirationArgs:
    def __init__(__self__, *,
                 days: pulumi.Input[int]):
        """
        :param pulumi.Input[int] days: Specifies the number of days after object creation when the specific rule action takes effect.
               
               > **Important:**  If versioning is enabled, this rule only deletes the current version of an object.
        """
        pulumi.set(__self__, "days", days)

    @property
    @pulumi.getter
    def days(self) -> pulumi.Input[int]:
        """
        Specifies the number of days after object creation when the specific rule action takes effect.

        > **Important:**  If versioning is enabled, this rule only deletes the current version of an object.
        """
        return pulumi.get(self, "days")

    @days.setter
    def days(self, value: pulumi.Input[int]):
        pulumi.set(self, "days", value)


@pulumi.input_type
class ObjectBucketLifecycleRuleTransitionArgs:
    def __init__(__self__, *,
                 storage_class: pulumi.Input[str],
                 days: Optional[pulumi.Input[int]] = None):
        """
        :param pulumi.Input[str] storage_class: Specifies the Scaleway [storage class](https://www.scaleway.com/en/docs/storage/object/concepts/#storage-class) `STANDARD`, `GLACIER`, `ONEZONE_IA`  to which you want the object to transition.
               
               > **Important:**  `ONEZONE_IA` is only available in `fr-par` region. The storage class `GLACIER` is not available in `pl-waw` region.
        :param pulumi.Input[int] days: Specifies the number of days after object creation when the specific rule action takes effect.
        """
        pulumi.set(__self__, "storage_class", storage_class)
        if days is not None:
            pulumi.set(__self__, "days", days)

    @property
    @pulumi.getter(name="storageClass")
    def storage_class(self) -> pulumi.Input[str]:
        """
        Specifies the Scaleway [storage class](https://www.scaleway.com/en/docs/storage/object/concepts/#storage-class) `STANDARD`, `GLACIER`, `ONEZONE_IA`  to which you want the object to transition.

        > **Important:**  `ONEZONE_IA` is only available in `fr-par` region. The storage class `GLACIER` is not available in `pl-waw` region.
        """
        return pulumi.get(self, "storage_class")

    @storage_class.setter
    def storage_class(self, value: pulumi.Input[str]):
        pulumi.set(self, "storage_class", value)

    @property
    @pulumi.getter
    def days(self) -> Optional[pulumi.Input[int]]:
        """
        Specifies the number of days after object creation when the specific rule action takes effect.
        """
        return pulumi.get(self, "days")

    @days.setter
    def days(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "days", value)


@pulumi.input_type
class ObjectBucketLockConfigurationRuleArgs:
    def __init__(__self__, *,
                 default_retention: pulumi.Input['ObjectBucketLockConfigurationRuleDefaultRetentionArgs']):
        """
        :param pulumi.Input['ObjectBucketLockConfigurationRuleDefaultRetentionArgs'] default_retention: The default retention for the lock.
        """
        pulumi.set(__self__, "default_retention", default_retention)

    @property
    @pulumi.getter(name="defaultRetention")
    def default_retention(self) -> pulumi.Input['ObjectBucketLockConfigurationRuleDefaultRetentionArgs']:
        """
        The default retention for the lock.
        """
        return pulumi.get(self, "default_retention")

    @default_retention.setter
    def default_retention(self, value: pulumi.Input['ObjectBucketLockConfigurationRuleDefaultRetentionArgs']):
        pulumi.set(self, "default_retention", value)


@pulumi.input_type
class ObjectBucketLockConfigurationRuleDefaultRetentionArgs:
    def __init__(__self__, *,
                 mode: pulumi.Input[str],
                 days: Optional[pulumi.Input[int]] = None,
                 years: Optional[pulumi.Input[int]] = None):
        """
        :param pulumi.Input[str] mode: The default Object Lock retention mode you want to apply to new objects placed in the specified bucket. Valid values are `GOVERNANCE` or `COMPLIANCE`. To learn more about the difference between these modes, see [Object Lock retention modes](https://www.scaleway.com/en/docs/storage/object/api-cli/object-lock/#retention-modes).
        :param pulumi.Input[int] days: The number of days that you want to specify for the default retention period.
        :param pulumi.Input[int] years: The number of years that you want to specify for the default retention period.
        """
        pulumi.set(__self__, "mode", mode)
        if days is not None:
            pulumi.set(__self__, "days", days)
        if years is not None:
            pulumi.set(__self__, "years", years)

    @property
    @pulumi.getter
    def mode(self) -> pulumi.Input[str]:
        """
        The default Object Lock retention mode you want to apply to new objects placed in the specified bucket. Valid values are `GOVERNANCE` or `COMPLIANCE`. To learn more about the difference between these modes, see [Object Lock retention modes](https://www.scaleway.com/en/docs/storage/object/api-cli/object-lock/#retention-modes).
        """
        return pulumi.get(self, "mode")

    @mode.setter
    def mode(self, value: pulumi.Input[str]):
        pulumi.set(self, "mode", value)

    @property
    @pulumi.getter
    def days(self) -> Optional[pulumi.Input[int]]:
        """
        The number of days that you want to specify for the default retention period.
        """
        return pulumi.get(self, "days")

    @days.setter
    def days(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "days", value)

    @property
    @pulumi.getter
    def years(self) -> Optional[pulumi.Input[int]]:
        """
        The number of years that you want to specify for the default retention period.
        """
        return pulumi.get(self, "years")

    @years.setter
    def years(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "years", value)


@pulumi.input_type
class ObjectBucketVersioningArgs:
    def __init__(__self__, *,
                 enabled: Optional[pulumi.Input[bool]] = None):
        """
        :param pulumi.Input[bool] enabled: Enable versioning. Once you version-enable a bucket, it can never return to an unversioned state. You can, however, suspend versioning on that bucket.
        """
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Enable versioning. Once you version-enable a bucket, it can never return to an unversioned state. You can, however, suspend versioning on that bucket.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enabled", value)


@pulumi.input_type
class ObjectBucketWebsiteConfigurationErrorDocumentArgs:
    def __init__(__self__, *,
                 key: pulumi.Input[str]):
        """
        :param pulumi.Input[str] key: The object key name to use when a 4XX class error occurs.
        """
        pulumi.set(__self__, "key", key)

    @property
    @pulumi.getter
    def key(self) -> pulumi.Input[str]:
        """
        The object key name to use when a 4XX class error occurs.
        """
        return pulumi.get(self, "key")

    @key.setter
    def key(self, value: pulumi.Input[str]):
        pulumi.set(self, "key", value)


@pulumi.input_type
class ObjectBucketWebsiteConfigurationIndexDocumentArgs:
    def __init__(__self__, *,
                 suffix: pulumi.Input[str]):
        """
        :param pulumi.Input[str] suffix: A suffix that is appended to a request that is for a directory on the website endpoint.
               
               > **Important:** The suffix must not be empty and must not include a slash character. The routing is not supported.
        """
        pulumi.set(__self__, "suffix", suffix)

    @property
    @pulumi.getter
    def suffix(self) -> pulumi.Input[str]:
        """
        A suffix that is appended to a request that is for a directory on the website endpoint.

        > **Important:** The suffix must not be empty and must not include a slash character. The routing is not supported.
        """
        return pulumi.get(self, "suffix")

    @suffix.setter
    def suffix(self, value: pulumi.Input[str]):
        pulumi.set(self, "suffix", value)


@pulumi.input_type
class RdbAclAclRuleArgs:
    def __init__(__self__, *,
                 ip: pulumi.Input[str],
                 description: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] ip: The ip range to whitelist in [CIDR notation](https://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing#CIDR_notation)
        :param pulumi.Input[str] description: A text describing this rule. Default description: `IP allowed`
        """
        pulumi.set(__self__, "ip", ip)
        if description is not None:
            pulumi.set(__self__, "description", description)

    @property
    @pulumi.getter
    def ip(self) -> pulumi.Input[str]:
        """
        The ip range to whitelist in [CIDR notation](https://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing#CIDR_notation)
        """
        return pulumi.get(self, "ip")

    @ip.setter
    def ip(self, value: pulumi.Input[str]):
        pulumi.set(self, "ip", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        A text describing this rule. Default description: `IP allowed`
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)


@pulumi.input_type
class RdbInstanceLoadBalancerArgs:
    def __init__(__self__, *,
                 endpoint_id: Optional[pulumi.Input[str]] = None,
                 hostname: Optional[pulumi.Input[str]] = None,
                 ip: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 port: Optional[pulumi.Input[int]] = None):
        """
        :param pulumi.Input[str] endpoint_id: The ID of the endpoint.
        :param pulumi.Input[str] hostname: Hostname of the endpoint.
        :param pulumi.Input[str] ip: IPv4 address on the network.
        :param pulumi.Input[str] name: The name of the Database Instance.
        :param pulumi.Input[int] port: Port in the Private Network.
        """
        if endpoint_id is not None:
            pulumi.set(__self__, "endpoint_id", endpoint_id)
        if hostname is not None:
            pulumi.set(__self__, "hostname", hostname)
        if ip is not None:
            pulumi.set(__self__, "ip", ip)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if port is not None:
            pulumi.set(__self__, "port", port)

    @property
    @pulumi.getter(name="endpointId")
    def endpoint_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the endpoint.
        """
        return pulumi.get(self, "endpoint_id")

    @endpoint_id.setter
    def endpoint_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "endpoint_id", value)

    @property
    @pulumi.getter
    def hostname(self) -> Optional[pulumi.Input[str]]:
        """
        Hostname of the endpoint.
        """
        return pulumi.get(self, "hostname")

    @hostname.setter
    def hostname(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "hostname", value)

    @property
    @pulumi.getter
    def ip(self) -> Optional[pulumi.Input[str]]:
        """
        IPv4 address on the network.
        """
        return pulumi.get(self, "ip")

    @ip.setter
    def ip(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ip", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the Database Instance.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def port(self) -> Optional[pulumi.Input[int]]:
        """
        Port in the Private Network.
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "port", value)


@pulumi.input_type
class RdbInstanceLogsPolicyArgs:
    def __init__(__self__, *,
                 max_age_retention: Optional[pulumi.Input[int]] = None,
                 total_disk_retention: Optional[pulumi.Input[int]] = None):
        """
        :param pulumi.Input[int] max_age_retention: The max age (in days) of remote logs to keep on the Database Instance
        :param pulumi.Input[int] total_disk_retention: The max disk size of remote logs to keep on the Database Instance.
        """
        if max_age_retention is not None:
            pulumi.set(__self__, "max_age_retention", max_age_retention)
        if total_disk_retention is not None:
            pulumi.set(__self__, "total_disk_retention", total_disk_retention)

    @property
    @pulumi.getter(name="maxAgeRetention")
    def max_age_retention(self) -> Optional[pulumi.Input[int]]:
        """
        The max age (in days) of remote logs to keep on the Database Instance
        """
        return pulumi.get(self, "max_age_retention")

    @max_age_retention.setter
    def max_age_retention(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "max_age_retention", value)

    @property
    @pulumi.getter(name="totalDiskRetention")
    def total_disk_retention(self) -> Optional[pulumi.Input[int]]:
        """
        The max disk size of remote logs to keep on the Database Instance.
        """
        return pulumi.get(self, "total_disk_retention")

    @total_disk_retention.setter
    def total_disk_retention(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "total_disk_retention", value)


@pulumi.input_type
class RdbInstancePrivateNetworkArgs:
    def __init__(__self__, *,
                 pn_id: pulumi.Input[str],
                 enable_ipam: Optional[pulumi.Input[bool]] = None,
                 endpoint_id: Optional[pulumi.Input[str]] = None,
                 hostname: Optional[pulumi.Input[str]] = None,
                 ip: Optional[pulumi.Input[str]] = None,
                 ip_net: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 port: Optional[pulumi.Input[int]] = None,
                 zone: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] pn_id: The private network ID
        :param pulumi.Input[bool] enable_ipam: Whether or not the private network endpoint should be configured with IPAM
        :param pulumi.Input[str] endpoint_id: The ID of the endpoint.
        :param pulumi.Input[str] hostname: Hostname of the endpoint.
        :param pulumi.Input[str] ip: IPv4 address on the network.
        :param pulumi.Input[str] ip_net: The IP with the given mask within the private subnet
        :param pulumi.Input[str] name: The name of the Database Instance.
        :param pulumi.Input[int] port: Port in the Private Network.
        :param pulumi.Input[str] zone: The zone you want to attach the resource to
        """
        pulumi.set(__self__, "pn_id", pn_id)
        if enable_ipam is not None:
            pulumi.set(__self__, "enable_ipam", enable_ipam)
        if endpoint_id is not None:
            pulumi.set(__self__, "endpoint_id", endpoint_id)
        if hostname is not None:
            pulumi.set(__self__, "hostname", hostname)
        if ip is not None:
            pulumi.set(__self__, "ip", ip)
        if ip_net is not None:
            pulumi.set(__self__, "ip_net", ip_net)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if zone is not None:
            pulumi.set(__self__, "zone", zone)

    @property
    @pulumi.getter(name="pnId")
    def pn_id(self) -> pulumi.Input[str]:
        """
        The private network ID
        """
        return pulumi.get(self, "pn_id")

    @pn_id.setter
    def pn_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "pn_id", value)

    @property
    @pulumi.getter(name="enableIpam")
    def enable_ipam(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether or not the private network endpoint should be configured with IPAM
        """
        return pulumi.get(self, "enable_ipam")

    @enable_ipam.setter
    def enable_ipam(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_ipam", value)

    @property
    @pulumi.getter(name="endpointId")
    def endpoint_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the endpoint.
        """
        return pulumi.get(self, "endpoint_id")

    @endpoint_id.setter
    def endpoint_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "endpoint_id", value)

    @property
    @pulumi.getter
    def hostname(self) -> Optional[pulumi.Input[str]]:
        """
        Hostname of the endpoint.
        """
        return pulumi.get(self, "hostname")

    @hostname.setter
    def hostname(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "hostname", value)

    @property
    @pulumi.getter
    def ip(self) -> Optional[pulumi.Input[str]]:
        """
        IPv4 address on the network.
        """
        return pulumi.get(self, "ip")

    @ip.setter
    def ip(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ip", value)

    @property
    @pulumi.getter(name="ipNet")
    def ip_net(self) -> Optional[pulumi.Input[str]]:
        """
        The IP with the given mask within the private subnet
        """
        return pulumi.get(self, "ip_net")

    @ip_net.setter
    def ip_net(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ip_net", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the Database Instance.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def port(self) -> Optional[pulumi.Input[int]]:
        """
        Port in the Private Network.
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "port", value)

    @property
    @pulumi.getter
    def zone(self) -> Optional[pulumi.Input[str]]:
        """
        The zone you want to attach the resource to
        """
        return pulumi.get(self, "zone")

    @zone.setter
    def zone(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "zone", value)


@pulumi.input_type
class RdbInstanceReadReplicaArgs:
    def __init__(__self__, *,
                 ip: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 port: Optional[pulumi.Input[int]] = None):
        """
        :param pulumi.Input[str] ip: IPv4 address on the network.
        :param pulumi.Input[str] name: The name of the Database Instance.
        :param pulumi.Input[int] port: Port in the Private Network.
        """
        if ip is not None:
            pulumi.set(__self__, "ip", ip)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if port is not None:
            pulumi.set(__self__, "port", port)

    @property
    @pulumi.getter
    def ip(self) -> Optional[pulumi.Input[str]]:
        """
        IPv4 address on the network.
        """
        return pulumi.get(self, "ip")

    @ip.setter
    def ip(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ip", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the Database Instance.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def port(self) -> Optional[pulumi.Input[int]]:
        """
        Port in the Private Network.
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "port", value)


@pulumi.input_type
class RdbReadReplicaDirectAccessArgs:
    def __init__(__self__, *,
                 endpoint_id: Optional[pulumi.Input[str]] = None,
                 hostname: Optional[pulumi.Input[str]] = None,
                 ip: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 port: Optional[pulumi.Input[int]] = None):
        """
        :param pulumi.Input[str] endpoint_id: The ID of the endpoint of the read replica.
        :param pulumi.Input[str] hostname: Hostname of the endpoint. Only one of ip and hostname may be set.
        :param pulumi.Input[str] ip: IPv4 address of the endpoint (IP address). Only one of ip and hostname may be set.
        :param pulumi.Input[str] name: Name of the endpoint.
        :param pulumi.Input[int] port: TCP port of the endpoint.
        """
        if endpoint_id is not None:
            pulumi.set(__self__, "endpoint_id", endpoint_id)
        if hostname is not None:
            pulumi.set(__self__, "hostname", hostname)
        if ip is not None:
            pulumi.set(__self__, "ip", ip)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if port is not None:
            pulumi.set(__self__, "port", port)

    @property
    @pulumi.getter(name="endpointId")
    def endpoint_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the endpoint of the read replica.
        """
        return pulumi.get(self, "endpoint_id")

    @endpoint_id.setter
    def endpoint_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "endpoint_id", value)

    @property
    @pulumi.getter
    def hostname(self) -> Optional[pulumi.Input[str]]:
        """
        Hostname of the endpoint. Only one of ip and hostname may be set.
        """
        return pulumi.get(self, "hostname")

    @hostname.setter
    def hostname(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "hostname", value)

    @property
    @pulumi.getter
    def ip(self) -> Optional[pulumi.Input[str]]:
        """
        IPv4 address of the endpoint (IP address). Only one of ip and hostname may be set.
        """
        return pulumi.get(self, "ip")

    @ip.setter
    def ip(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ip", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the endpoint.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def port(self) -> Optional[pulumi.Input[int]]:
        """
        TCP port of the endpoint.
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "port", value)


@pulumi.input_type
class RdbReadReplicaPrivateNetworkArgs:
    def __init__(__self__, *,
                 private_network_id: pulumi.Input[str],
                 enable_ipam: Optional[pulumi.Input[bool]] = None,
                 endpoint_id: Optional[pulumi.Input[str]] = None,
                 hostname: Optional[pulumi.Input[str]] = None,
                 ip: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 port: Optional[pulumi.Input[int]] = None,
                 service_ip: Optional[pulumi.Input[str]] = None,
                 zone: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] private_network_id: UUID of the private network to be connected to the read replica.
        :param pulumi.Input[bool] enable_ipam: If true, the IP network address within the private subnet is determined by the IP Address Management (IPAM) service.
               
               > **Important:** One of `service_ip` or `enable_ipam=true` must be set.
        :param pulumi.Input[str] endpoint_id: The ID of the endpoint of the read replica.
        :param pulumi.Input[str] hostname: Hostname of the endpoint. Only one of ip and hostname may be set.
        :param pulumi.Input[str] ip: IPv4 address of the endpoint (IP address). Only one of ip and hostname may be set.
        :param pulumi.Input[str] name: Name of the endpoint.
        :param pulumi.Input[int] port: TCP port of the endpoint.
        :param pulumi.Input[str] service_ip: The IP network address within the private subnet. This must be an IPv4 address with a CIDR notation. If not set, The IP network address within the private subnet is determined by the IP Address Management (IPAM) service.
        :param pulumi.Input[str] zone: Private network zone
        """
        pulumi.set(__self__, "private_network_id", private_network_id)
        if enable_ipam is not None:
            pulumi.set(__self__, "enable_ipam", enable_ipam)
        if endpoint_id is not None:
            pulumi.set(__self__, "endpoint_id", endpoint_id)
        if hostname is not None:
            pulumi.set(__self__, "hostname", hostname)
        if ip is not None:
            pulumi.set(__self__, "ip", ip)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if service_ip is not None:
            pulumi.set(__self__, "service_ip", service_ip)
        if zone is not None:
            pulumi.set(__self__, "zone", zone)

    @property
    @pulumi.getter(name="privateNetworkId")
    def private_network_id(self) -> pulumi.Input[str]:
        """
        UUID of the private network to be connected to the read replica.
        """
        return pulumi.get(self, "private_network_id")

    @private_network_id.setter
    def private_network_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "private_network_id", value)

    @property
    @pulumi.getter(name="enableIpam")
    def enable_ipam(self) -> Optional[pulumi.Input[bool]]:
        """
        If true, the IP network address within the private subnet is determined by the IP Address Management (IPAM) service.

        > **Important:** One of `service_ip` or `enable_ipam=true` must be set.
        """
        return pulumi.get(self, "enable_ipam")

    @enable_ipam.setter
    def enable_ipam(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_ipam", value)

    @property
    @pulumi.getter(name="endpointId")
    def endpoint_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the endpoint of the read replica.
        """
        return pulumi.get(self, "endpoint_id")

    @endpoint_id.setter
    def endpoint_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "endpoint_id", value)

    @property
    @pulumi.getter
    def hostname(self) -> Optional[pulumi.Input[str]]:
        """
        Hostname of the endpoint. Only one of ip and hostname may be set.
        """
        return pulumi.get(self, "hostname")

    @hostname.setter
    def hostname(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "hostname", value)

    @property
    @pulumi.getter
    def ip(self) -> Optional[pulumi.Input[str]]:
        """
        IPv4 address of the endpoint (IP address). Only one of ip and hostname may be set.
        """
        return pulumi.get(self, "ip")

    @ip.setter
    def ip(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ip", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the endpoint.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def port(self) -> Optional[pulumi.Input[int]]:
        """
        TCP port of the endpoint.
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "port", value)

    @property
    @pulumi.getter(name="serviceIp")
    def service_ip(self) -> Optional[pulumi.Input[str]]:
        """
        The IP network address within the private subnet. This must be an IPv4 address with a CIDR notation. If not set, The IP network address within the private subnet is determined by the IP Address Management (IPAM) service.
        """
        return pulumi.get(self, "service_ip")

    @service_ip.setter
    def service_ip(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "service_ip", value)

    @property
    @pulumi.getter
    def zone(self) -> Optional[pulumi.Input[str]]:
        """
        Private network zone
        """
        return pulumi.get(self, "zone")

    @zone.setter
    def zone(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "zone", value)


@pulumi.input_type
class RedisClusterAclArgs:
    def __init__(__self__, *,
                 ip: pulumi.Input[str],
                 description: Optional[pulumi.Input[str]] = None,
                 id: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] ip: The ip range to whitelist
               in [CIDR notation](https://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing#CIDR_notation)
        :param pulumi.Input[str] description: A text describing this rule. Default description: `Allow IP`
               
               > The `acl` conflict with `private_network`. Only one should be specified.
        :param pulumi.Input[str] id: (Required) The UUID of the endpoint.
        """
        pulumi.set(__self__, "ip", ip)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if id is not None:
            pulumi.set(__self__, "id", id)

    @property
    @pulumi.getter
    def ip(self) -> pulumi.Input[str]:
        """
        The ip range to whitelist
        in [CIDR notation](https://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing#CIDR_notation)
        """
        return pulumi.get(self, "ip")

    @ip.setter
    def ip(self, value: pulumi.Input[str]):
        pulumi.set(self, "ip", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        A text describing this rule. Default description: `Allow IP`

        > The `acl` conflict with `private_network`. Only one should be specified.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def id(self) -> Optional[pulumi.Input[str]]:
        """
        (Required) The UUID of the endpoint.
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "id", value)


@pulumi.input_type
class RedisClusterPrivateNetworkArgs:
    def __init__(__self__, *,
                 id: pulumi.Input[str],
                 endpoint_id: Optional[pulumi.Input[str]] = None,
                 service_ips: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 zone: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] id: The UUID of the Private Network resource.
        :param pulumi.Input[str] endpoint_id: The ID of the endpoint.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] service_ips: Endpoint IPv4 addresses in [CIDR notation](https://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing#CIDR_notation). You must provide at least one IP per node.
               Keep in mind that in Cluster mode you cannot edit your Private Network after its creation so if you want to be able to
               scale your Cluster horizontally (adding nodes) later, you should provide more IPs than nodes.
               If not set, the IP network address within the private subnet is determined by the IP Address Management (IPAM) service.
               
               > The `private_network` conflicts with `acl`. Only one should be specified.
               
               > **Important:** The way to use private networks differs whether you are using Redis in Standalone or Cluster mode.
               
               - Standalone mode (`cluster_size` = 1) : you can attach as many Private Networks as you want (each must be a separate
               block). If you detach your only private network, your cluster won't be reachable until you define a new Private or
               Public Network. You can modify your `private_network` and its specs, you can have both a Private and Public Network side
               by side.
               
               - Cluster mode (`cluster_size` > 2) : you can define a single Private Network as you create your Cluster, you won't be
               able to edit or detach it afterward, unless you create another Cluster. This also means that, if you are using a static
               configuration (`service_ips`), you won't be able to scale your Cluster horizontally (add more nodes) since it would
               require updating the private network to add IPs.
               Your `service_ips` must be listed as follows:
               
               ```python
               import pulumi
               ```
        :param pulumi.Input[str] zone: `zone`) The zone in which the
               Redis Cluster should be created.
        """
        pulumi.set(__self__, "id", id)
        if endpoint_id is not None:
            pulumi.set(__self__, "endpoint_id", endpoint_id)
        if service_ips is not None:
            pulumi.set(__self__, "service_ips", service_ips)
        if zone is not None:
            pulumi.set(__self__, "zone", zone)

    @property
    @pulumi.getter
    def id(self) -> pulumi.Input[str]:
        """
        The UUID of the Private Network resource.
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: pulumi.Input[str]):
        pulumi.set(self, "id", value)

    @property
    @pulumi.getter(name="endpointId")
    def endpoint_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the endpoint.
        """
        return pulumi.get(self, "endpoint_id")

    @endpoint_id.setter
    def endpoint_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "endpoint_id", value)

    @property
    @pulumi.getter(name="serviceIps")
    def service_ips(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Endpoint IPv4 addresses in [CIDR notation](https://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing#CIDR_notation). You must provide at least one IP per node.
        Keep in mind that in Cluster mode you cannot edit your Private Network after its creation so if you want to be able to
        scale your Cluster horizontally (adding nodes) later, you should provide more IPs than nodes.
        If not set, the IP network address within the private subnet is determined by the IP Address Management (IPAM) service.

        > The `private_network` conflicts with `acl`. Only one should be specified.

        > **Important:** The way to use private networks differs whether you are using Redis in Standalone or Cluster mode.

        - Standalone mode (`cluster_size` = 1) : you can attach as many Private Networks as you want (each must be a separate
        block). If you detach your only private network, your cluster won't be reachable until you define a new Private or
        Public Network. You can modify your `private_network` and its specs, you can have both a Private and Public Network side
        by side.

        - Cluster mode (`cluster_size` > 2) : you can define a single Private Network as you create your Cluster, you won't be
        able to edit or detach it afterward, unless you create another Cluster. This also means that, if you are using a static
        configuration (`service_ips`), you won't be able to scale your Cluster horizontally (add more nodes) since it would
        require updating the private network to add IPs.
        Your `service_ips` must be listed as follows:

        ```python
        import pulumi
        ```
        """
        return pulumi.get(self, "service_ips")

    @service_ips.setter
    def service_ips(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "service_ips", value)

    @property
    @pulumi.getter
    def zone(self) -> Optional[pulumi.Input[str]]:
        """
        `zone`) The zone in which the
        Redis Cluster should be created.
        """
        return pulumi.get(self, "zone")

    @zone.setter
    def zone(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "zone", value)


@pulumi.input_type
class RedisClusterPublicNetworkArgs:
    def __init__(__self__, *,
                 id: Optional[pulumi.Input[str]] = None,
                 ips: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 port: Optional[pulumi.Input[int]] = None):
        """
        :param pulumi.Input[str] id: (Required) The UUID of the endpoint.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] ips: Lis of IPv4 address of the endpoint (IP address).
        :param pulumi.Input[int] port: TCP port of the endpoint.
        """
        if id is not None:
            pulumi.set(__self__, "id", id)
        if ips is not None:
            pulumi.set(__self__, "ips", ips)
        if port is not None:
            pulumi.set(__self__, "port", port)

    @property
    @pulumi.getter
    def id(self) -> Optional[pulumi.Input[str]]:
        """
        (Required) The UUID of the endpoint.
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "id", value)

    @property
    @pulumi.getter
    def ips(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Lis of IPv4 address of the endpoint (IP address).
        """
        return pulumi.get(self, "ips")

    @ips.setter
    def ips(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "ips", value)

    @property
    @pulumi.getter
    def port(self) -> Optional[pulumi.Input[int]]:
        """
        TCP port of the endpoint.
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "port", value)


@pulumi.input_type
class TemDomainReputationArgs:
    def __init__(__self__, *,
                 previous_score: Optional[pulumi.Input[int]] = None,
                 previous_scored_at: Optional[pulumi.Input[str]] = None,
                 score: Optional[pulumi.Input[int]] = None,
                 scored_at: Optional[pulumi.Input[str]] = None,
                 status: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[int] previous_score: The previously-calculated domain's reputation score.
        :param pulumi.Input[str] previous_scored_at: The time and date the previous reputation score was calculated.
        :param pulumi.Input[int] score: A range from 0 to 100 that determines your domain's reputation score.
        :param pulumi.Input[str] scored_at: The time and date the score was calculated.
        :param pulumi.Input[str] status: The status of the domain's reputation.
        """
        if previous_score is not None:
            pulumi.set(__self__, "previous_score", previous_score)
        if previous_scored_at is not None:
            pulumi.set(__self__, "previous_scored_at", previous_scored_at)
        if score is not None:
            pulumi.set(__self__, "score", score)
        if scored_at is not None:
            pulumi.set(__self__, "scored_at", scored_at)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter(name="previousScore")
    def previous_score(self) -> Optional[pulumi.Input[int]]:
        """
        The previously-calculated domain's reputation score.
        """
        return pulumi.get(self, "previous_score")

    @previous_score.setter
    def previous_score(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "previous_score", value)

    @property
    @pulumi.getter(name="previousScoredAt")
    def previous_scored_at(self) -> Optional[pulumi.Input[str]]:
        """
        The time and date the previous reputation score was calculated.
        """
        return pulumi.get(self, "previous_scored_at")

    @previous_scored_at.setter
    def previous_scored_at(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "previous_scored_at", value)

    @property
    @pulumi.getter
    def score(self) -> Optional[pulumi.Input[int]]:
        """
        A range from 0 to 100 that determines your domain's reputation score.
        """
        return pulumi.get(self, "score")

    @score.setter
    def score(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "score", value)

    @property
    @pulumi.getter(name="scoredAt")
    def scored_at(self) -> Optional[pulumi.Input[str]]:
        """
        The time and date the score was calculated.
        """
        return pulumi.get(self, "scored_at")

    @scored_at.setter
    def scored_at(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "scored_at", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[str]]:
        """
        The status of the domain's reputation.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "status", value)


@pulumi.input_type
class VpcGatewayNetworkIpamConfigArgs:
    def __init__(__self__, *,
                 ipam_ip_id: Optional[pulumi.Input[str]] = None,
                 push_default_route: Optional[pulumi.Input[bool]] = None):
        """
        :param pulumi.Input[str] ipam_ip_id: Use this IPAM-booked IP ID as the Gateway's IP in this Private Network.
        :param pulumi.Input[bool] push_default_route: Defines whether the default route is enabled on that Gateway Network.
        """
        if ipam_ip_id is not None:
            pulumi.set(__self__, "ipam_ip_id", ipam_ip_id)
        if push_default_route is not None:
            pulumi.set(__self__, "push_default_route", push_default_route)

    @property
    @pulumi.getter(name="ipamIpId")
    def ipam_ip_id(self) -> Optional[pulumi.Input[str]]:
        """
        Use this IPAM-booked IP ID as the Gateway's IP in this Private Network.
        """
        return pulumi.get(self, "ipam_ip_id")

    @ipam_ip_id.setter
    def ipam_ip_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ipam_ip_id", value)

    @property
    @pulumi.getter(name="pushDefaultRoute")
    def push_default_route(self) -> Optional[pulumi.Input[bool]]:
        """
        Defines whether the default route is enabled on that Gateway Network.
        """
        return pulumi.get(self, "push_default_route")

    @push_default_route.setter
    def push_default_route(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "push_default_route", value)


@pulumi.input_type
class VpcPrivateNetworkIpv4SubnetArgs:
    def __init__(__self__, *,
                 address: Optional[pulumi.Input[str]] = None,
                 created_at: Optional[pulumi.Input[str]] = None,
                 id: Optional[pulumi.Input[str]] = None,
                 prefix_length: Optional[pulumi.Input[int]] = None,
                 subnet: Optional[pulumi.Input[str]] = None,
                 subnet_mask: Optional[pulumi.Input[str]] = None,
                 updated_at: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] address: The network address of the subnet in dotted decimal notation, e.g., '192.168.0.0' for a '192.168.0.0/24' subnet.
        :param pulumi.Input[str] created_at: The date and time of the creation of the subnet.
        :param pulumi.Input[str] id: The subnet ID.
        :param pulumi.Input[int] prefix_length: The length of the network prefix, e.g., 24 for a 255.255.255.0 mask.
        :param pulumi.Input[str] subnet: The subnet CIDR.
        :param pulumi.Input[str] subnet_mask: The subnet mask expressed in dotted decimal notation, e.g., '255.255.255.0' for a /24 subnet
        :param pulumi.Input[str] updated_at: The date and time of the last update of the subnet.
        """
        if address is not None:
            pulumi.set(__self__, "address", address)
        if created_at is not None:
            pulumi.set(__self__, "created_at", created_at)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if prefix_length is not None:
            pulumi.set(__self__, "prefix_length", prefix_length)
        if subnet is not None:
            pulumi.set(__self__, "subnet", subnet)
        if subnet_mask is not None:
            pulumi.set(__self__, "subnet_mask", subnet_mask)
        if updated_at is not None:
            pulumi.set(__self__, "updated_at", updated_at)

    @property
    @pulumi.getter
    def address(self) -> Optional[pulumi.Input[str]]:
        """
        The network address of the subnet in dotted decimal notation, e.g., '192.168.0.0' for a '192.168.0.0/24' subnet.
        """
        return pulumi.get(self, "address")

    @address.setter
    def address(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "address", value)

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[pulumi.Input[str]]:
        """
        The date and time of the creation of the subnet.
        """
        return pulumi.get(self, "created_at")

    @created_at.setter
    def created_at(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "created_at", value)

    @property
    @pulumi.getter
    def id(self) -> Optional[pulumi.Input[str]]:
        """
        The subnet ID.
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "id", value)

    @property
    @pulumi.getter(name="prefixLength")
    def prefix_length(self) -> Optional[pulumi.Input[int]]:
        """
        The length of the network prefix, e.g., 24 for a 255.255.255.0 mask.
        """
        return pulumi.get(self, "prefix_length")

    @prefix_length.setter
    def prefix_length(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "prefix_length", value)

    @property
    @pulumi.getter
    def subnet(self) -> Optional[pulumi.Input[str]]:
        """
        The subnet CIDR.
        """
        return pulumi.get(self, "subnet")

    @subnet.setter
    def subnet(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "subnet", value)

    @property
    @pulumi.getter(name="subnetMask")
    def subnet_mask(self) -> Optional[pulumi.Input[str]]:
        """
        The subnet mask expressed in dotted decimal notation, e.g., '255.255.255.0' for a /24 subnet
        """
        return pulumi.get(self, "subnet_mask")

    @subnet_mask.setter
    def subnet_mask(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "subnet_mask", value)

    @property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> Optional[pulumi.Input[str]]:
        """
        The date and time of the last update of the subnet.
        """
        return pulumi.get(self, "updated_at")

    @updated_at.setter
    def updated_at(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "updated_at", value)


@pulumi.input_type
class VpcPrivateNetworkIpv6SubnetArgs:
    def __init__(__self__, *,
                 address: Optional[pulumi.Input[str]] = None,
                 created_at: Optional[pulumi.Input[str]] = None,
                 id: Optional[pulumi.Input[str]] = None,
                 prefix_length: Optional[pulumi.Input[int]] = None,
                 subnet: Optional[pulumi.Input[str]] = None,
                 subnet_mask: Optional[pulumi.Input[str]] = None,
                 updated_at: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] address: The network address of the subnet in dotted decimal notation, e.g., '192.168.0.0' for a '192.168.0.0/24' subnet.
        :param pulumi.Input[str] created_at: The date and time of the creation of the subnet.
        :param pulumi.Input[str] id: The subnet ID.
        :param pulumi.Input[int] prefix_length: The length of the network prefix, e.g., 24 for a 255.255.255.0 mask.
        :param pulumi.Input[str] subnet: The subnet CIDR.
        :param pulumi.Input[str] subnet_mask: The subnet mask expressed in dotted decimal notation, e.g., '255.255.255.0' for a /24 subnet
        :param pulumi.Input[str] updated_at: The date and time of the last update of the subnet.
        """
        if address is not None:
            pulumi.set(__self__, "address", address)
        if created_at is not None:
            pulumi.set(__self__, "created_at", created_at)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if prefix_length is not None:
            pulumi.set(__self__, "prefix_length", prefix_length)
        if subnet is not None:
            pulumi.set(__self__, "subnet", subnet)
        if subnet_mask is not None:
            pulumi.set(__self__, "subnet_mask", subnet_mask)
        if updated_at is not None:
            pulumi.set(__self__, "updated_at", updated_at)

    @property
    @pulumi.getter
    def address(self) -> Optional[pulumi.Input[str]]:
        """
        The network address of the subnet in dotted decimal notation, e.g., '192.168.0.0' for a '192.168.0.0/24' subnet.
        """
        return pulumi.get(self, "address")

    @address.setter
    def address(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "address", value)

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[pulumi.Input[str]]:
        """
        The date and time of the creation of the subnet.
        """
        return pulumi.get(self, "created_at")

    @created_at.setter
    def created_at(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "created_at", value)

    @property
    @pulumi.getter
    def id(self) -> Optional[pulumi.Input[str]]:
        """
        The subnet ID.
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "id", value)

    @property
    @pulumi.getter(name="prefixLength")
    def prefix_length(self) -> Optional[pulumi.Input[int]]:
        """
        The length of the network prefix, e.g., 24 for a 255.255.255.0 mask.
        """
        return pulumi.get(self, "prefix_length")

    @prefix_length.setter
    def prefix_length(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "prefix_length", value)

    @property
    @pulumi.getter
    def subnet(self) -> Optional[pulumi.Input[str]]:
        """
        The subnet CIDR.
        """
        return pulumi.get(self, "subnet")

    @subnet.setter
    def subnet(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "subnet", value)

    @property
    @pulumi.getter(name="subnetMask")
    def subnet_mask(self) -> Optional[pulumi.Input[str]]:
        """
        The subnet mask expressed in dotted decimal notation, e.g., '255.255.255.0' for a /24 subnet
        """
        return pulumi.get(self, "subnet_mask")

    @subnet_mask.setter
    def subnet_mask(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "subnet_mask", value)

    @property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> Optional[pulumi.Input[str]]:
        """
        The date and time of the last update of the subnet.
        """
        return pulumi.get(self, "updated_at")

    @updated_at.setter
    def updated_at(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "updated_at", value)


@pulumi.input_type
class WebhostingCpanelUrlArgs:
    def __init__(__self__, *,
                 dashboard: Optional[pulumi.Input[str]] = None,
                 webmail: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] dashboard: The URL of the Dashboard.
        :param pulumi.Input[str] webmail: The URL of the Webmail interface.
        """
        if dashboard is not None:
            pulumi.set(__self__, "dashboard", dashboard)
        if webmail is not None:
            pulumi.set(__self__, "webmail", webmail)

    @property
    @pulumi.getter
    def dashboard(self) -> Optional[pulumi.Input[str]]:
        """
        The URL of the Dashboard.
        """
        return pulumi.get(self, "dashboard")

    @dashboard.setter
    def dashboard(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "dashboard", value)

    @property
    @pulumi.getter
    def webmail(self) -> Optional[pulumi.Input[str]]:
        """
        The URL of the Webmail interface.
        """
        return pulumi.get(self, "webmail")

    @webmail.setter
    def webmail(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "webmail", value)


@pulumi.input_type
class WebhostingOptionArgs:
    def __init__(__self__, *,
                 id: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] id: The option ID.
        :param pulumi.Input[str] name: The option name.
        """
        if id is not None:
            pulumi.set(__self__, "id", id)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def id(self) -> Optional[pulumi.Input[str]]:
        """
        The option ID.
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "id", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The option name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class GetIpamIpResourceArgs:
    def __init__(__self__, *,
                 type: str,
                 id: Optional[str] = None,
                 name: Optional[str] = None):
        """
        :param str type: The type of the resource to get the IP from. [Documentation](https://pkg.go.dev/github.com/scaleway/scaleway-sdk-go@master/api/ipam/v1#pkg-constants) with type list.
        :param str id: The ID of the resource that the IP is bound to.
        :param str name: The name of the resource to get the IP from.
        """
        pulumi.set(__self__, "type", type)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        The type of the resource to get the IP from. [Documentation](https://pkg.go.dev/github.com/scaleway/scaleway-sdk-go@master/api/ipam/v1#pkg-constants) with type list.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: str):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        The ID of the resource that the IP is bound to.
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: Optional[str]):
        pulumi.set(self, "id", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        The name of the resource to get the IP from.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[str]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class GetIpamIpsResourceArgs:
    def __init__(__self__, *,
                 type: str,
                 id: Optional[str] = None,
                 name: Optional[str] = None):
        """
        :param str type: The type of the resource to get the IP from. [Documentation](https://pkg.go.dev/github.com/scaleway/scaleway-sdk-go@master/api/ipam/v1#pkg-constants) with type list.
        :param str id: The ID of the resource that the IP is bound to.
        :param str name: The name of the resource to get the IP from.
        """
        pulumi.set(__self__, "type", type)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        The type of the resource to get the IP from. [Documentation](https://pkg.go.dev/github.com/scaleway/scaleway-sdk-go@master/api/ipam/v1#pkg-constants) with type list.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: str):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        The ID of the resource that the IP is bound to.
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: Optional[str]):
        pulumi.set(self, "id", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        The name of the resource to get the IP from.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[str]):
        pulumi.set(self, "name", value)


