"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const aws_kms_1 = require("@aws-cdk/aws-kms");
const core_1 = require("@aws-cdk/core");
const lib_1 = require("../lib");
class SNSInteg extends core_1.Stack {
    constructor(scope, id, props) {
        super(scope, id, props);
        const key = new aws_kms_1.Key(this, "CustomKey");
        new lib_1.Topic(this, 'MyTopic', {
            topicName: 'fooTopic',
            displayName: 'fooDisplayName',
            masterKey: key,
        });
    }
}
const app = new core_1.App();
new SNSInteg(app, 'SNSInteg');
app.synth();
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiaW50ZWcuc25zLmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiaW50ZWcuc25zLnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7O0FBQUEsOENBQXVDO0FBQ3ZDLHdDQUF1RDtBQUN2RCxnQ0FBK0I7QUFFL0IsTUFBTSxRQUFTLFNBQVEsWUFBSztJQUMxQixZQUFZLEtBQVUsRUFBRSxFQUFVLEVBQUUsS0FBa0I7UUFDcEQsS0FBSyxDQUFDLEtBQUssRUFBRSxFQUFFLEVBQUUsS0FBSyxDQUFDLENBQUM7UUFFeEIsTUFBTSxHQUFHLEdBQUcsSUFBSSxhQUFHLENBQUMsSUFBSSxFQUFFLFdBQVcsQ0FBQyxDQUFDO1FBRXZDLElBQUksV0FBSyxDQUFDLElBQUksRUFBRSxTQUFTLEVBQUU7WUFDekIsU0FBUyxFQUFFLFVBQVU7WUFDckIsV0FBVyxFQUFFLGdCQUFnQjtZQUM3QixTQUFTLEVBQUUsR0FBRztTQUNmLENBQUMsQ0FBQztJQUNMLENBQUM7Q0FDRjtBQUVELE1BQU0sR0FBRyxHQUFHLElBQUksVUFBRyxFQUFFLENBQUM7QUFFdEIsSUFBSSxRQUFRLENBQUMsR0FBRyxFQUFFLFVBQVUsQ0FBQyxDQUFDO0FBRTlCLEdBQUcsQ0FBQyxLQUFLLEVBQUUsQ0FBQyIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCB7IEtleSB9IGZyb20gJ0Bhd3MtY2RrL2F3cy1rbXMnO1xuaW1wb3J0IHsgQXBwLCBTdGFjaywgU3RhY2tQcm9wcyB9IGZyb20gJ0Bhd3MtY2RrL2NvcmUnO1xuaW1wb3J0IHsgVG9waWMgfSBmcm9tICcuLi9saWInO1xuXG5jbGFzcyBTTlNJbnRlZyBleHRlbmRzIFN0YWNrIHtcbiAgY29uc3RydWN0b3Ioc2NvcGU6IEFwcCwgaWQ6IHN0cmluZywgcHJvcHM/OiBTdGFja1Byb3BzKSB7XG4gICAgc3VwZXIoc2NvcGUsIGlkLCBwcm9wcyk7XG5cbiAgICBjb25zdCBrZXkgPSBuZXcgS2V5KHRoaXMsIFwiQ3VzdG9tS2V5XCIpO1xuXG4gICAgbmV3IFRvcGljKHRoaXMsICdNeVRvcGljJywge1xuICAgICAgdG9waWNOYW1lOiAnZm9vVG9waWMnLFxuICAgICAgZGlzcGxheU5hbWU6ICdmb29EaXNwbGF5TmFtZScsXG4gICAgICBtYXN0ZXJLZXk6IGtleSxcbiAgICB9KTtcbiAgfVxufVxuXG5jb25zdCBhcHAgPSBuZXcgQXBwKCk7XG5cbm5ldyBTTlNJbnRlZyhhcHAsICdTTlNJbnRlZycpO1xuXG5hcHAuc3ludGgoKTtcbiJdfQ==