# coding: utf-8

"""
    FINBOURNE Luminesce Web API

    FINBOURNE Technology  # noqa: E501

    Contact: info@finbourne.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Any, Dict, Optional
from pydantic.v1 import BaseModel, Field, StrictBool, constr, Field

class CaseStatementItem(BaseModel):
    """
    Information about a case statement.  A typical case statement would look like:  CASE WHEN Field {Filter} Source THEN Target  For example: CASE WHEN 'currency' = 'USD' THEN 'US'  Here the Field is 'currency', the Source is 'USD', the Filter is '=', and the Target is 'US'  # noqa: E501
    """
    filter: constr(strict=True) = Field(...,alias="filter", description="The operator in the case statement SQL expression") 
    source: constr(strict=True) = Field(...,alias="source", description="The expression that is on the LHS of the operator  A typical case statement would look like:  CASE Field {Filter} Source THEN Target") 
    target: constr(strict=True) = Field(...,alias="target", description="The expression that is on the RHS of the operator  A typical case statement would look like:  CASE Field {Filter} Source THEN Target") 
    is_target_non_literal: Optional[StrictBool] = Field(None, alias="isTargetNonLiteral", description="The Target can be a literal value or a non literal (field) and  hence will be interpreted differently.  This can be determined from the UI and passed down as a true / false")
    __properties = ["filter", "source", "target", "isTargetNonLiteral"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def __str__(self):
        """For `print` and `pprint`"""
        return pprint.pformat(self.dict(by_alias=False))

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> CaseStatementItem:
        """Create an instance of CaseStatementItem from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> CaseStatementItem:
        """Create an instance of CaseStatementItem from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return CaseStatementItem.parse_obj(obj)

        _obj = CaseStatementItem.parse_obj({
            "filter": obj.get("filter"),
            "source": obj.get("source"),
            "target": obj.get("target"),
            "is_target_non_literal": obj.get("isTargetNonLiteral")
        })
        return _obj
