# coding: utf-8

"""
    FINBOURNE Luminesce Web API

    FINBOURNE Technology  # noqa: E501

    Contact: info@finbourne.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Any, Dict, Optional
from pydantic.v1 import BaseModel, Field, StrictBool, StrictStr, Field
from luminesce.models.background_query_state import BackgroundQueryState
from luminesce.models.task_status import TaskStatus

class BackgroundQueryCancelResponse(BaseModel):
    """
    BackgroundQueryCancelResponse
    """
    had_data: Optional[StrictBool] = Field(None, alias="hadData")
    previous_status: Optional[TaskStatus] = Field(None, alias="previousStatus")
    previous_state: Optional[BackgroundQueryState] = Field(None, alias="previousState")
    progress: constr(strict=True) = Field(None,alias="progress") 
    __properties = ["hadData", "previousStatus", "previousState", "progress"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def __str__(self):
        """For `print` and `pprint`"""
        return pprint.pformat(self.dict(by_alias=False))

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> BackgroundQueryCancelResponse:
        """Create an instance of BackgroundQueryCancelResponse from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # set to None if progress (nullable) is None
        # and __fields_set__ contains the field
        if self.progress is None and "progress" in self.__fields_set__:
            _dict['progress'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> BackgroundQueryCancelResponse:
        """Create an instance of BackgroundQueryCancelResponse from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return BackgroundQueryCancelResponse.parse_obj(obj)

        _obj = BackgroundQueryCancelResponse.parse_obj({
            "had_data": obj.get("hadData"),
            "previous_status": obj.get("previousStatus"),
            "previous_state": obj.get("previousState"),
            "progress": obj.get("progress")
        })
        return _obj
