# coding: utf-8

"""
    FINBOURNE Luminesce Web API

    FINBOURNE Technology  # noqa: E501

    Contact: info@finbourne.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Any, Dict, List, Optional
from pydantic.v1 import BaseModel, Field, StrictStr, conlist, Field
from luminesce.models.background_query_progress_response import BackgroundQueryProgressResponse
from luminesce.models.feedback_event_args import FeedbackEventArgs
from luminesce.models.task_status import TaskStatus

class BackgroundMultiQueryProgressResponse(BaseModel):
    """
    BackgroundMultiQueryProgressResponse
    """
    progress: constr(strict=True) = Field(None,alias="progress", description="The full progress log (up to this point at least)") 
    feedback: Optional[conlist(FeedbackEventArgs)] = Field(None, description="Individual Feedback Messages (to replace Progress).  A given message will be returned from only one call.")
    status: Optional[TaskStatus] = None
    queries: Optional[conlist(BackgroundQueryProgressResponse)] = None
    __properties = ["progress", "feedback", "status", "queries"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def __str__(self):
        """For `print` and `pprint`"""
        return pprint.pformat(self.dict(by_alias=False))

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> BackgroundMultiQueryProgressResponse:
        """Create an instance of BackgroundMultiQueryProgressResponse from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of each item in feedback (list)
        _items = []
        if self.feedback:
            for _item in self.feedback:
                if _item:
                    _items.append(_item.to_dict())
            _dict['feedback'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in queries (list)
        _items = []
        if self.queries:
            for _item in self.queries:
                if _item:
                    _items.append(_item.to_dict())
            _dict['queries'] = _items
        # set to None if progress (nullable) is None
        # and __fields_set__ contains the field
        if self.progress is None and "progress" in self.__fields_set__:
            _dict['progress'] = None

        # set to None if feedback (nullable) is None
        # and __fields_set__ contains the field
        if self.feedback is None and "feedback" in self.__fields_set__:
            _dict['feedback'] = None

        # set to None if queries (nullable) is None
        # and __fields_set__ contains the field
        if self.queries is None and "queries" in self.__fields_set__:
            _dict['queries'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> BackgroundMultiQueryProgressResponse:
        """Create an instance of BackgroundMultiQueryProgressResponse from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return BackgroundMultiQueryProgressResponse.parse_obj(obj)

        _obj = BackgroundMultiQueryProgressResponse.parse_obj({
            "progress": obj.get("progress"),
            "feedback": [FeedbackEventArgs.from_dict(_item) for _item in obj.get("feedback")] if obj.get("feedback") is not None else None,
            "status": obj.get("status"),
            "queries": [BackgroundQueryProgressResponse.from_dict(_item) for _item in obj.get("queries")] if obj.get("queries") is not None else None
        })
        return _obj
