# coding: utf-8

"""
    Xero Files API

    These endpoints are specific to Xero Files API  # noqa: E501

    Contact: api@xero.com
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401

from xero_python.models import BaseModel


class Folder(BaseModel):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        "name": "str",
        "file_count": "int",
        "email": "str",
        "is_inbox": "bool",
        "id": "str",
    }

    attribute_map = {
        "name": "Name",
        "file_count": "FileCount",
        "email": "Email",
        "is_inbox": "IsInbox",
        "id": "Id",
    }

    def __init__(
        self, name=None, file_count=None, email=None, is_inbox=None, id=None
    ):  # noqa: E501
        """Folder - a model defined in OpenAPI"""  # noqa: E501

        self._name = None
        self._file_count = None
        self._email = None
        self._is_inbox = None
        self._id = None
        self.discriminator = None

        if name is not None:
            self.name = name
        if file_count is not None:
            self.file_count = file_count
        if email is not None:
            self.email = email
        if is_inbox is not None:
            self.is_inbox = is_inbox
        if id is not None:
            self.id = id

    @property
    def name(self):
        """Gets the name of this Folder.  # noqa: E501

        The name of the folder  # noqa: E501

        :return: The name of this Folder.  # noqa: E501
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this Folder.

        The name of the folder  # noqa: E501

        :param name: The name of this Folder.  # noqa: E501
        :type: str
        """

        self._name = name

    @property
    def file_count(self):
        """Gets the file_count of this Folder.  # noqa: E501

        The number of files in the folder  # noqa: E501

        :return: The file_count of this Folder.  # noqa: E501
        :rtype: int
        """
        return self._file_count

    @file_count.setter
    def file_count(self, file_count):
        """Sets the file_count of this Folder.

        The number of files in the folder  # noqa: E501

        :param file_count: The file_count of this Folder.  # noqa: E501
        :type: int
        """

        self._file_count = file_count

    @property
    def email(self):
        """Gets the email of this Folder.  # noqa: E501

        The email address used to email files to the inbox. Only the inbox will have this element.  # noqa: E501

        :return: The email of this Folder.  # noqa: E501
        :rtype: str
        """
        return self._email

    @email.setter
    def email(self, email):
        """Sets the email of this Folder.

        The email address used to email files to the inbox. Only the inbox will have this element.  # noqa: E501

        :param email: The email of this Folder.  # noqa: E501
        :type: str
        """

        self._email = email

    @property
    def is_inbox(self):
        """Gets the is_inbox of this Folder.  # noqa: E501

        to indicate if the folder is the Inbox. The Inbox cannot be renamed or deleted.  # noqa: E501

        :return: The is_inbox of this Folder.  # noqa: E501
        :rtype: bool
        """
        return self._is_inbox

    @is_inbox.setter
    def is_inbox(self, is_inbox):
        """Sets the is_inbox of this Folder.

        to indicate if the folder is the Inbox. The Inbox cannot be renamed or deleted.  # noqa: E501

        :param is_inbox: The is_inbox of this Folder.  # noqa: E501
        :type: bool
        """

        self._is_inbox = is_inbox

    @property
    def id(self):
        """Gets the id of this Folder.  # noqa: E501

        Xero unique identifier for a folder  Files  # noqa: E501

        :return: The id of this Folder.  # noqa: E501
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """Sets the id of this Folder.

        Xero unique identifier for a folder  Files  # noqa: E501

        :param id: The id of this Folder.  # noqa: E501
        :type: str
        """

        self._id = id
