# coding: utf-8

"""
    Xero Files API

    These endpoints are specific to Xero Files API  # noqa: E501

    Contact: api@xero.com
    Generated by: https://openapi-generator.tech
"""

"""
    OpenAPI spec version: 2.25.0
"""

import importlib
import re  # noqa: F401

from xero_python import exceptions
from xero_python.api_client import ApiClient, ModelFinder

try:
    from .exception_handler import translate_status_exception
except ImportError:
    translate_status_exception = exceptions.translate_status_exception


class empty:
    """empty object to mark optional parameter not set"""


class FilesApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    base_url = "https://api.xero.com/files.xro/1.0"
    models_module = importlib.import_module("xero_python.file.models")

    def __init__(self, api_client=None, base_url=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client
        self.base_url = base_url or self.base_url

    def get_resource_url(self, resource_path):
        """
        Combine API base url with resource specific path
        :param str resource_path: API endpoint specific path
        :return: str full resource path
        """
        return self.base_url + resource_path

    def get_model_finder(self):
        return ModelFinder(self.models_module)

    def create_file_association(
        self,
        xero_tenant_id,
        file_id,
        association=empty,
        _return_http_data_only=True,
        _preload_content=True,
        _request_timeout=None,
    ):
        """Creates a new file association  # noqa: E501
        OAuth2 scope: files
        By passing in the appropriate options, you can create a new folder  # noqa: E501
        :param str xero_tenant_id: Xero identifier for Tenant (required)
        :param str file_id: File id for single object (required)
        :param Association association:
        :param bool _return_http_data_only: return received data only
        :param bool _preload_content: load received data in models
        :param bool _request_timeout: maximum wait time for response
        :return: Association
        """

        # verify the required parameter 'xero_tenant_id' is set
        if xero_tenant_id is None:
            raise ValueError(
                "Missing the required parameter `xero_tenant_id` "
                "when calling `create_file_association`"
            )
        # verify the required parameter 'file_id' is set
        if file_id is None:
            raise ValueError(
                "Missing the required parameter `file_id` "
                "when calling `create_file_association`"
            )

        collection_formats = {}
        path_params = {
            "FileId": file_id,
        }

        query_params = []

        header_params = {
            "xero-tenant-id": xero_tenant_id,
        }

        local_var_files = {}
        form_params = []

        body_params = association
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json"]
        )

        # HTTP header `Content-Type`
        header_params["Content-Type"] = self.api_client.select_header_content_type(
            ["application/json"]
        )

        # Authentication setting
        auth_settings = ["OAuth2"]
        url = self.get_resource_url("/Files/{FileId}/Associations")

        try:
            return self.api_client.call_api(
                url,
                "POST",
                path_params,
                query_params,
                header_params,
                body=body_params,
                post_params=form_params,
                files=local_var_files,
                response_type="Association",
                response_model_finder=self.get_model_finder(),
                auth_settings=auth_settings,
                _return_http_data_only=_return_http_data_only,
                _preload_content=_preload_content,
                _request_timeout=_request_timeout,
                collection_formats=collection_formats,
            )
        except exceptions.HTTPStatusException as error:
            raise translate_status_exception(error, self, "create_file_association")

    def create_folder(
        self,
        xero_tenant_id,
        folder=empty,
        _return_http_data_only=True,
        _preload_content=True,
        _request_timeout=None,
    ):
        """Creates a new folder  # noqa: E501
        OAuth2 scope: files
        By passing in the appropriate properties, you can create a new folder  # noqa: E501
        :param str xero_tenant_id: Xero identifier for Tenant (required)
        :param Folder folder:
        :param bool _return_http_data_only: return received data only
        :param bool _preload_content: load received data in models
        :param bool _request_timeout: maximum wait time for response
        :return: Folder
        """

        # verify the required parameter 'xero_tenant_id' is set
        if xero_tenant_id is None:
            raise ValueError(
                "Missing the required parameter `xero_tenant_id` "
                "when calling `create_folder`"
            )

        collection_formats = {}
        path_params = {}

        query_params = []

        header_params = {
            "xero-tenant-id": xero_tenant_id,
        }

        local_var_files = {}
        form_params = []

        body_params = folder
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json"]
        )

        # HTTP header `Content-Type`
        header_params["Content-Type"] = self.api_client.select_header_content_type(
            ["application/json"]
        )

        # Authentication setting
        auth_settings = ["OAuth2"]
        url = self.get_resource_url("/Folders")

        try:
            return self.api_client.call_api(
                url,
                "POST",
                path_params,
                query_params,
                header_params,
                body=body_params,
                post_params=form_params,
                files=local_var_files,
                response_type="Folder",
                response_model_finder=self.get_model_finder(),
                auth_settings=auth_settings,
                _return_http_data_only=_return_http_data_only,
                _preload_content=_preload_content,
                _request_timeout=_request_timeout,
                collection_formats=collection_formats,
            )
        except exceptions.HTTPStatusException as error:
            raise translate_status_exception(error, self, "create_folder")

    def delete_file(
        self,
        xero_tenant_id,
        file_id,
        _return_http_data_only=True,
        _preload_content=True,
        _request_timeout=None,
    ):
        """Deletes a specific file  # noqa: E501
        OAuth2 scope: files
        Delete a specific file  # noqa: E501
        :param str xero_tenant_id: Xero identifier for Tenant (required)
        :param str file_id: File id for single object (required)
        :param bool _return_http_data_only: return received data only
        :param bool _preload_content: load received data in models
        :param bool _request_timeout: maximum wait time for response
        :return: None
        """

        # verify the required parameter 'xero_tenant_id' is set
        if xero_tenant_id is None:
            raise ValueError(
                "Missing the required parameter `xero_tenant_id` "
                "when calling `delete_file`"
            )
        # verify the required parameter 'file_id' is set
        if file_id is None:
            raise ValueError(
                "Missing the required parameter `file_id` " "when calling `delete_file`"
            )

        collection_formats = {}
        path_params = {
            "FileId": file_id,
        }

        query_params = []

        header_params = {
            "xero-tenant-id": xero_tenant_id,
        }

        local_var_files = {}
        form_params = []

        body_params = None
        # Authentication setting
        auth_settings = ["OAuth2"]
        url = self.get_resource_url("/Files/{FileId}")

        try:
            return self.api_client.call_api(
                url,
                "DELETE",
                path_params,
                query_params,
                header_params,
                body=body_params,
                post_params=form_params,
                files=local_var_files,
                response_type=None,
                response_model_finder=self.get_model_finder(),
                auth_settings=auth_settings,
                _return_http_data_only=_return_http_data_only,
                _preload_content=_preload_content,
                _request_timeout=_request_timeout,
                collection_formats=collection_formats,
            )
        except exceptions.HTTPStatusException as error:
            raise translate_status_exception(error, self, "delete_file")

    def delete_file_association(
        self,
        xero_tenant_id,
        file_id,
        object_id,
        _return_http_data_only=True,
        _preload_content=True,
        _request_timeout=None,
    ):
        """Deletes an existing file association  # noqa: E501
        OAuth2 scope: files
        By passing in the appropriate options, you can create a new folder  # noqa: E501
        :param str xero_tenant_id: Xero identifier for Tenant (required)
        :param str file_id: File id for single object (required)
        :param str object_id: Object id for single object (required)
        :param bool _return_http_data_only: return received data only
        :param bool _preload_content: load received data in models
        :param bool _request_timeout: maximum wait time for response
        :return: None
        """

        # verify the required parameter 'xero_tenant_id' is set
        if xero_tenant_id is None:
            raise ValueError(
                "Missing the required parameter `xero_tenant_id` "
                "when calling `delete_file_association`"
            )
        # verify the required parameter 'file_id' is set
        if file_id is None:
            raise ValueError(
                "Missing the required parameter `file_id` "
                "when calling `delete_file_association`"
            )
        # verify the required parameter 'object_id' is set
        if object_id is None:
            raise ValueError(
                "Missing the required parameter `object_id` "
                "when calling `delete_file_association`"
            )

        collection_formats = {}
        path_params = {
            "FileId": file_id,
            "ObjectId": object_id,
        }

        query_params = []

        header_params = {
            "xero-tenant-id": xero_tenant_id,
        }

        local_var_files = {}
        form_params = []

        body_params = None
        # Authentication setting
        auth_settings = ["OAuth2"]
        url = self.get_resource_url("/Files/{FileId}/Associations/{ObjectId}")

        try:
            return self.api_client.call_api(
                url,
                "DELETE",
                path_params,
                query_params,
                header_params,
                body=body_params,
                post_params=form_params,
                files=local_var_files,
                response_type=None,
                response_model_finder=self.get_model_finder(),
                auth_settings=auth_settings,
                _return_http_data_only=_return_http_data_only,
                _preload_content=_preload_content,
                _request_timeout=_request_timeout,
                collection_formats=collection_formats,
            )
        except exceptions.HTTPStatusException as error:
            raise translate_status_exception(error, self, "delete_file_association")

    def delete_folder(
        self,
        xero_tenant_id,
        folder_id,
        _return_http_data_only=True,
        _preload_content=True,
        _request_timeout=None,
    ):
        """Deletes a folder  # noqa: E501
        OAuth2 scope: files
        By passing in the appropriate ID, you can delete a folder  # noqa: E501
        :param str xero_tenant_id: Xero identifier for Tenant (required)
        :param str folder_id: Folder id for single object (required)
        :param bool _return_http_data_only: return received data only
        :param bool _preload_content: load received data in models
        :param bool _request_timeout: maximum wait time for response
        :return: None
        """

        # verify the required parameter 'xero_tenant_id' is set
        if xero_tenant_id is None:
            raise ValueError(
                "Missing the required parameter `xero_tenant_id` "
                "when calling `delete_folder`"
            )
        # verify the required parameter 'folder_id' is set
        if folder_id is None:
            raise ValueError(
                "Missing the required parameter `folder_id` "
                "when calling `delete_folder`"
            )

        collection_formats = {}
        path_params = {
            "FolderId": folder_id,
        }

        query_params = []

        header_params = {
            "xero-tenant-id": xero_tenant_id,
        }

        local_var_files = {}
        form_params = []

        body_params = None
        # Authentication setting
        auth_settings = ["OAuth2"]
        url = self.get_resource_url("/Folders/{FolderId}")

        try:
            return self.api_client.call_api(
                url,
                "DELETE",
                path_params,
                query_params,
                header_params,
                body=body_params,
                post_params=form_params,
                files=local_var_files,
                response_type=None,
                response_model_finder=self.get_model_finder(),
                auth_settings=auth_settings,
                _return_http_data_only=_return_http_data_only,
                _preload_content=_preload_content,
                _request_timeout=_request_timeout,
                collection_formats=collection_formats,
            )
        except exceptions.HTTPStatusException as error:
            raise translate_status_exception(error, self, "delete_folder")

    def get_associations_by_object(
        self,
        xero_tenant_id,
        object_id,
        _return_http_data_only=True,
        _preload_content=True,
        _request_timeout=None,
    ):
        """Retrieves an association object using a unique object ID  # noqa: E501
        OAuth2 scope: files, files.read
        By passing in the appropriate options,  # noqa: E501
        :param str xero_tenant_id: Xero identifier for Tenant (required)
        :param str object_id: Object id for single object (required)
        :param bool _return_http_data_only: return received data only
        :param bool _preload_content: load received data in models
        :param bool _request_timeout: maximum wait time for response
        :return: list[Association]
        """

        # verify the required parameter 'xero_tenant_id' is set
        if xero_tenant_id is None:
            raise ValueError(
                "Missing the required parameter `xero_tenant_id` "
                "when calling `get_associations_by_object`"
            )
        # verify the required parameter 'object_id' is set
        if object_id is None:
            raise ValueError(
                "Missing the required parameter `object_id` "
                "when calling `get_associations_by_object`"
            )

        collection_formats = {}
        path_params = {
            "ObjectId": object_id,
        }

        query_params = []

        header_params = {
            "xero-tenant-id": xero_tenant_id,
        }

        local_var_files = {}
        form_params = []

        body_params = None
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json"]
        )

        # Authentication setting
        auth_settings = ["OAuth2"]
        url = self.get_resource_url("/Associations/{ObjectId}")

        try:
            return self.api_client.call_api(
                url,
                "GET",
                path_params,
                query_params,
                header_params,
                body=body_params,
                post_params=form_params,
                files=local_var_files,
                response_type="list[Association]",
                response_model_finder=self.get_model_finder(),
                auth_settings=auth_settings,
                _return_http_data_only=_return_http_data_only,
                _preload_content=_preload_content,
                _request_timeout=_request_timeout,
                collection_formats=collection_formats,
            )
        except exceptions.HTTPStatusException as error:
            raise translate_status_exception(error, self, "get_associations_by_object")

    def get_file(
        self,
        xero_tenant_id,
        file_id,
        _return_http_data_only=True,
        _preload_content=True,
        _request_timeout=None,
    ):
        """Retrieves a file by a unique file ID  # noqa: E501
        OAuth2 scope: files, files.read
        :param str xero_tenant_id: Xero identifier for Tenant (required)
        :param str file_id: File id for single object (required)
        :param bool _return_http_data_only: return received data only
        :param bool _preload_content: load received data in models
        :param bool _request_timeout: maximum wait time for response
        :return: FileObject
        """

        # verify the required parameter 'xero_tenant_id' is set
        if xero_tenant_id is None:
            raise ValueError(
                "Missing the required parameter `xero_tenant_id` "
                "when calling `get_file`"
            )
        # verify the required parameter 'file_id' is set
        if file_id is None:
            raise ValueError(
                "Missing the required parameter `file_id` " "when calling `get_file`"
            )

        collection_formats = {}
        path_params = {
            "FileId": file_id,
        }

        query_params = []

        header_params = {
            "xero-tenant-id": xero_tenant_id,
        }

        local_var_files = {}
        form_params = []

        body_params = None
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json"]
        )

        # Authentication setting
        auth_settings = ["OAuth2"]
        url = self.get_resource_url("/Files/{FileId}")

        try:
            return self.api_client.call_api(
                url,
                "GET",
                path_params,
                query_params,
                header_params,
                body=body_params,
                post_params=form_params,
                files=local_var_files,
                response_type="FileObject",
                response_model_finder=self.get_model_finder(),
                auth_settings=auth_settings,
                _return_http_data_only=_return_http_data_only,
                _preload_content=_preload_content,
                _request_timeout=_request_timeout,
                collection_formats=collection_formats,
            )
        except exceptions.HTTPStatusException as error:
            raise translate_status_exception(error, self, "get_file")

    def get_file_associations(
        self,
        xero_tenant_id,
        file_id,
        _return_http_data_only=True,
        _preload_content=True,
        _request_timeout=None,
    ):
        """Retrieves a specific file associations  # noqa: E501
        OAuth2 scope: files, files.read
        By passing in the appropriate options,    # noqa: E501
        :param str xero_tenant_id: Xero identifier for Tenant (required)
        :param str file_id: File id for single object (required)
        :param bool _return_http_data_only: return received data only
        :param bool _preload_content: load received data in models
        :param bool _request_timeout: maximum wait time for response
        :return: list[Association]
        """

        # verify the required parameter 'xero_tenant_id' is set
        if xero_tenant_id is None:
            raise ValueError(
                "Missing the required parameter `xero_tenant_id` "
                "when calling `get_file_associations`"
            )
        # verify the required parameter 'file_id' is set
        if file_id is None:
            raise ValueError(
                "Missing the required parameter `file_id` "
                "when calling `get_file_associations`"
            )

        collection_formats = {}
        path_params = {
            "FileId": file_id,
        }

        query_params = []

        header_params = {
            "xero-tenant-id": xero_tenant_id,
        }

        local_var_files = {}
        form_params = []

        body_params = None
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json"]
        )

        # Authentication setting
        auth_settings = ["OAuth2"]
        url = self.get_resource_url("/Files/{FileId}/Associations")

        try:
            return self.api_client.call_api(
                url,
                "GET",
                path_params,
                query_params,
                header_params,
                body=body_params,
                post_params=form_params,
                files=local_var_files,
                response_type="list[Association]",
                response_model_finder=self.get_model_finder(),
                auth_settings=auth_settings,
                _return_http_data_only=_return_http_data_only,
                _preload_content=_preload_content,
                _request_timeout=_request_timeout,
                collection_formats=collection_formats,
            )
        except exceptions.HTTPStatusException as error:
            raise translate_status_exception(error, self, "get_file_associations")

    def get_file_content(
        self,
        xero_tenant_id,
        file_id,
        _return_http_data_only=True,
        _preload_content=True,
        _request_timeout=None,
    ):
        """Retrieves the content of a specific file  # noqa: E501
        OAuth2 scope: files, files.read
        By passing in the appropriate options, retrieve data for specific file  # noqa: E501
        :param str xero_tenant_id: Xero identifier for Tenant (required)
        :param str file_id: File id for single object (required)
        :param bool _return_http_data_only: return received data only
        :param bool _preload_content: load received data in models
        :param bool _request_timeout: maximum wait time for response
        :return: file
        """

        # verify the required parameter 'xero_tenant_id' is set
        if xero_tenant_id is None:
            raise ValueError(
                "Missing the required parameter `xero_tenant_id` "
                "when calling `get_file_content`"
            )
        # verify the required parameter 'file_id' is set
        if file_id is None:
            raise ValueError(
                "Missing the required parameter `file_id` "
                "when calling `get_file_content`"
            )

        collection_formats = {}
        path_params = {
            "FileId": file_id,
        }

        query_params = []

        header_params = {
            "xero-tenant-id": xero_tenant_id,
        }

        local_var_files = {}
        form_params = []

        body_params = None
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(
            ["application/octet-stream"]
        )

        # Authentication setting
        auth_settings = ["OAuth2"]
        url = self.get_resource_url("/Files/{FileId}/Content")

        try:
            return self.api_client.call_api(
                url,
                "GET",
                path_params,
                query_params,
                header_params,
                body=body_params,
                post_params=form_params,
                files=local_var_files,
                response_type="file",
                response_model_finder=self.get_model_finder(),
                auth_settings=auth_settings,
                _return_http_data_only=_return_http_data_only,
                _preload_content=_preload_content,
                _request_timeout=_request_timeout,
                collection_formats=collection_formats,
            )
        except exceptions.HTTPStatusException as error:
            raise translate_status_exception(error, self, "get_file_content")

    def get_files(
        self,
        xero_tenant_id,
        pagesize=empty,
        page=empty,
        sort=empty,
        _return_http_data_only=True,
        _preload_content=True,
        _request_timeout=None,
    ):
        """Retrieves files  # noqa: E501
        OAuth2 scope: files, files.read
        :param str xero_tenant_id: Xero identifier for Tenant (required)
        :param int pagesize: pass an optional page size value
        :param int page: number of records to skip for pagination
        :param str sort: values to sort by
        :param bool _return_http_data_only: return received data only
        :param bool _preload_content: load received data in models
        :param bool _request_timeout: maximum wait time for response
        :return: Files
        """

        # verify the required parameter 'xero_tenant_id' is set
        if xero_tenant_id is None:
            raise ValueError(
                "Missing the required parameter `xero_tenant_id` "
                "when calling `get_files`"
            )

        if pagesize is not empty and pagesize > 100:
            raise ValueError(
                "Invalid value for parameter `pagesize` "
                "when calling `get_files`, must be a value "
                "less than or equal to "
                "`100`"
            )
        if page is not empty and page < 1:
            raise ValueError(
                "Invalid value for parameter `page` "
                "when calling `get_files`, must be a value "
                "greater than or equal to "
                "`1`"
            )
        collection_formats = {}
        path_params = {}

        query_params = []

        if pagesize is not empty:
            query_params.append(("pagesize", pagesize))

        if page is not empty:
            query_params.append(("page", page))

        if sort is not empty:
            query_params.append(("sort", sort))

        header_params = {
            "xero-tenant-id": xero_tenant_id,
        }

        local_var_files = {}
        form_params = []

        body_params = None
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json"]
        )

        # Authentication setting
        auth_settings = ["OAuth2"]
        url = self.get_resource_url("/Files")

        try:
            return self.api_client.call_api(
                url,
                "GET",
                path_params,
                query_params,
                header_params,
                body=body_params,
                post_params=form_params,
                files=local_var_files,
                response_type="Files",
                response_model_finder=self.get_model_finder(),
                auth_settings=auth_settings,
                _return_http_data_only=_return_http_data_only,
                _preload_content=_preload_content,
                _request_timeout=_request_timeout,
                collection_formats=collection_formats,
            )
        except exceptions.HTTPStatusException as error:
            raise translate_status_exception(error, self, "get_files")

    def get_folder(
        self,
        xero_tenant_id,
        folder_id,
        _return_http_data_only=True,
        _preload_content=True,
        _request_timeout=None,
    ):
        """Retrieves specific folder by using a unique folder ID  # noqa: E501
        OAuth2 scope: files, files.read
        By passing in the appropriate ID, you can search for specific folder  # noqa: E501
        :param str xero_tenant_id: Xero identifier for Tenant (required)
        :param str folder_id: Folder id for single object (required)
        :param bool _return_http_data_only: return received data only
        :param bool _preload_content: load received data in models
        :param bool _request_timeout: maximum wait time for response
        :return: Folder
        """

        # verify the required parameter 'xero_tenant_id' is set
        if xero_tenant_id is None:
            raise ValueError(
                "Missing the required parameter `xero_tenant_id` "
                "when calling `get_folder`"
            )
        # verify the required parameter 'folder_id' is set
        if folder_id is None:
            raise ValueError(
                "Missing the required parameter `folder_id` "
                "when calling `get_folder`"
            )

        collection_formats = {}
        path_params = {
            "FolderId": folder_id,
        }

        query_params = []

        header_params = {
            "xero-tenant-id": xero_tenant_id,
        }

        local_var_files = {}
        form_params = []

        body_params = None
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json"]
        )

        # Authentication setting
        auth_settings = ["OAuth2"]
        url = self.get_resource_url("/Folders/{FolderId}")

        try:
            return self.api_client.call_api(
                url,
                "GET",
                path_params,
                query_params,
                header_params,
                body=body_params,
                post_params=form_params,
                files=local_var_files,
                response_type="Folder",
                response_model_finder=self.get_model_finder(),
                auth_settings=auth_settings,
                _return_http_data_only=_return_http_data_only,
                _preload_content=_preload_content,
                _request_timeout=_request_timeout,
                collection_formats=collection_formats,
            )
        except exceptions.HTTPStatusException as error:
            raise translate_status_exception(error, self, "get_folder")

    def get_folders(
        self,
        xero_tenant_id,
        sort=empty,
        _return_http_data_only=True,
        _preload_content=True,
        _request_timeout=None,
    ):
        """Retrieves folders  # noqa: E501
        OAuth2 scope: files, files.read
        By passing in the appropriate options, you can search for available folders  # noqa: E501
        :param str xero_tenant_id: Xero identifier for Tenant (required)
        :param str sort: values to sort by
        :param bool _return_http_data_only: return received data only
        :param bool _preload_content: load received data in models
        :param bool _request_timeout: maximum wait time for response
        :return: list[Folder]
        """

        # verify the required parameter 'xero_tenant_id' is set
        if xero_tenant_id is None:
            raise ValueError(
                "Missing the required parameter `xero_tenant_id` "
                "when calling `get_folders`"
            )

        collection_formats = {}
        path_params = {}

        query_params = []

        if sort is not empty:
            query_params.append(("sort", sort))

        header_params = {
            "xero-tenant-id": xero_tenant_id,
        }

        local_var_files = {}
        form_params = []

        body_params = None
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json"]
        )

        # Authentication setting
        auth_settings = ["OAuth2"]
        url = self.get_resource_url("/Folders")

        try:
            return self.api_client.call_api(
                url,
                "GET",
                path_params,
                query_params,
                header_params,
                body=body_params,
                post_params=form_params,
                files=local_var_files,
                response_type="list[Folder]",
                response_model_finder=self.get_model_finder(),
                auth_settings=auth_settings,
                _return_http_data_only=_return_http_data_only,
                _preload_content=_preload_content,
                _request_timeout=_request_timeout,
                collection_formats=collection_formats,
            )
        except exceptions.HTTPStatusException as error:
            raise translate_status_exception(error, self, "get_folders")

    def get_inbox(
        self,
        xero_tenant_id,
        _return_http_data_only=True,
        _preload_content=True,
        _request_timeout=None,
    ):
        """Retrieves inbox folder  # noqa: E501
        OAuth2 scope: files, files.read
        Search for the user inbox  # noqa: E501
        :param str xero_tenant_id: Xero identifier for Tenant (required)
        :param bool _return_http_data_only: return received data only
        :param bool _preload_content: load received data in models
        :param bool _request_timeout: maximum wait time for response
        :return: Folder
        """

        # verify the required parameter 'xero_tenant_id' is set
        if xero_tenant_id is None:
            raise ValueError(
                "Missing the required parameter `xero_tenant_id` "
                "when calling `get_inbox`"
            )

        collection_formats = {}
        path_params = {}

        query_params = []

        header_params = {
            "xero-tenant-id": xero_tenant_id,
        }

        local_var_files = {}
        form_params = []

        body_params = None
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json"]
        )

        # Authentication setting
        auth_settings = ["OAuth2"]
        url = self.get_resource_url("/Inbox")

        try:
            return self.api_client.call_api(
                url,
                "GET",
                path_params,
                query_params,
                header_params,
                body=body_params,
                post_params=form_params,
                files=local_var_files,
                response_type="Folder",
                response_model_finder=self.get_model_finder(),
                auth_settings=auth_settings,
                _return_http_data_only=_return_http_data_only,
                _preload_content=_preload_content,
                _request_timeout=_request_timeout,
                collection_formats=collection_formats,
            )
        except exceptions.HTTPStatusException as error:
            raise translate_status_exception(error, self, "get_inbox")

    def update_file(
        self,
        xero_tenant_id,
        file_id,
        file_object=empty,
        _return_http_data_only=True,
        _preload_content=True,
        _request_timeout=None,
    ):
        """Update a file  # noqa: E501
        OAuth2 scope: files
        Updates file properties of a single file  # noqa: E501
        :param str xero_tenant_id: Xero identifier for Tenant (required)
        :param str file_id: File id for single object (required)
        :param FileObject file_object:
        :param bool _return_http_data_only: return received data only
        :param bool _preload_content: load received data in models
        :param bool _request_timeout: maximum wait time for response
        :return: FileObject
        """

        # verify the required parameter 'xero_tenant_id' is set
        if xero_tenant_id is None:
            raise ValueError(
                "Missing the required parameter `xero_tenant_id` "
                "when calling `update_file`"
            )
        # verify the required parameter 'file_id' is set
        if file_id is None:
            raise ValueError(
                "Missing the required parameter `file_id` " "when calling `update_file`"
            )

        collection_formats = {}
        path_params = {
            "FileId": file_id,
        }

        query_params = []

        header_params = {
            "xero-tenant-id": xero_tenant_id,
        }

        local_var_files = {}
        form_params = []

        body_params = file_object
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json"]
        )

        # HTTP header `Content-Type`
        header_params["Content-Type"] = self.api_client.select_header_content_type(
            ["application/json"]
        )

        # Authentication setting
        auth_settings = ["OAuth2"]
        url = self.get_resource_url("/Files/{FileId}")

        try:
            return self.api_client.call_api(
                url,
                "PUT",
                path_params,
                query_params,
                header_params,
                body=body_params,
                post_params=form_params,
                files=local_var_files,
                response_type="FileObject",
                response_model_finder=self.get_model_finder(),
                auth_settings=auth_settings,
                _return_http_data_only=_return_http_data_only,
                _preload_content=_preload_content,
                _request_timeout=_request_timeout,
                collection_formats=collection_formats,
            )
        except exceptions.HTTPStatusException as error:
            raise translate_status_exception(error, self, "update_file")

    def update_folder(
        self,
        xero_tenant_id,
        folder_id,
        folder,
        _return_http_data_only=True,
        _preload_content=True,
        _request_timeout=None,
    ):
        """Updates an existing folder  # noqa: E501
        OAuth2 scope: files
        By passing in the appropriate ID and properties, you can update a folder  # noqa: E501
        :param str xero_tenant_id: Xero identifier for Tenant (required)
        :param str folder_id: Folder id for single object (required)
        :param Folder folder: (required)
        :param bool _return_http_data_only: return received data only
        :param bool _preload_content: load received data in models
        :param bool _request_timeout: maximum wait time for response
        :return: Folder
        """

        # verify the required parameter 'xero_tenant_id' is set
        if xero_tenant_id is None:
            raise ValueError(
                "Missing the required parameter `xero_tenant_id` "
                "when calling `update_folder`"
            )
        # verify the required parameter 'folder_id' is set
        if folder_id is None:
            raise ValueError(
                "Missing the required parameter `folder_id` "
                "when calling `update_folder`"
            )
        # verify the required parameter 'folder' is set
        if folder is None:
            raise ValueError(
                "Missing the required parameter `folder` "
                "when calling `update_folder`"
            )

        collection_formats = {}
        path_params = {
            "FolderId": folder_id,
        }

        query_params = []

        header_params = {
            "xero-tenant-id": xero_tenant_id,
        }

        local_var_files = {}
        form_params = []

        body_params = folder
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json"]
        )

        # HTTP header `Content-Type`
        header_params["Content-Type"] = self.api_client.select_header_content_type(
            ["application/json"]
        )

        # Authentication setting
        auth_settings = ["OAuth2"]
        url = self.get_resource_url("/Folders/{FolderId}")

        try:
            return self.api_client.call_api(
                url,
                "PUT",
                path_params,
                query_params,
                header_params,
                body=body_params,
                post_params=form_params,
                files=local_var_files,
                response_type="Folder",
                response_model_finder=self.get_model_finder(),
                auth_settings=auth_settings,
                _return_http_data_only=_return_http_data_only,
                _preload_content=_preload_content,
                _request_timeout=_request_timeout,
                collection_formats=collection_formats,
            )
        except exceptions.HTTPStatusException as error:
            raise translate_status_exception(error, self, "update_folder")

    def upload_file(
        self,
        xero_tenant_id,
        body,
        name,
        filename,
        mime_type=empty,
        _return_http_data_only=True,
        _preload_content=True,
        _request_timeout=None,
    ):
        """Uploads a File to the inbox  # noqa: E501
        OAuth2 scope: files
        :param str xero_tenant_id: Xero identifier for Tenant (required)
        :param str body: (required)
        :param str name: exact name of the file you are uploading (required)
        :param str filename: (required)
        :param str mime_type:
        :param bool _return_http_data_only: return received data only
        :param bool _preload_content: load received data in models
        :param bool _request_timeout: maximum wait time for response
        :return: FileObject
        """

        # verify the required parameter 'xero_tenant_id' is set
        if xero_tenant_id is None:
            raise ValueError(
                "Missing the required parameter `xero_tenant_id` "
                "when calling `upload_file`"
            )
        # verify the required parameter 'body' is set
        if body is None:
            raise ValueError(
                "Missing the required parameter `body` " "when calling `upload_file`"
            )
        # verify the required parameter 'name' is set
        if name is None:
            raise ValueError(
                "Missing the required parameter `name` " "when calling `upload_file`"
            )
        # verify the required parameter 'filename' is set
        if filename is None:
            raise ValueError(
                "Missing the required parameter `filename` "
                "when calling `upload_file`"
            )

        collection_formats = {}
        path_params = {}

        query_params = []

        header_params = {
            "xero-tenant-id": xero_tenant_id,
        }

        local_var_files = {}
        form_params = [
            ("body", body),
            ("name", name),
            ("filename", filename),
            ("mimeType", mime_type),
        ]

        body_params = None
        body_params = body
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json"]
        )

        # HTTP header `Content-Type`
        header_params["Content-Type"] = self.api_client.select_header_content_type(
            ["multipart/form-data"]
        )

        # Authentication setting
        auth_settings = ["OAuth2"]
        url = self.get_resource_url("/Files")

        try:
            return self.api_client.call_api(
                url,
                "POST",
                path_params,
                query_params,
                header_params,
                body=body_params,
                post_params=form_params,
                files=local_var_files,
                response_type="FileObject",
                response_model_finder=self.get_model_finder(),
                auth_settings=auth_settings,
                _return_http_data_only=_return_http_data_only,
                _preload_content=_preload_content,
                _request_timeout=_request_timeout,
                collection_formats=collection_formats,
            )
        except exceptions.HTTPStatusException as error:
            raise translate_status_exception(error, self, "upload_file")

    def upload_file_to_folder(
        self,
        xero_tenant_id,
        folder_id,
        body,
        name,
        filename,
        mime_type=empty,
        _return_http_data_only=True,
        _preload_content=True,
        _request_timeout=None,
    ):
        """Uploads a File to a specific folder  # noqa: E501
        OAuth2 scope: files
        :param str xero_tenant_id: Xero identifier for Tenant (required)
        :param str folder_id: pass required folder id to save file to specific folder (required)
        :param str body: (required)
        :param str name: exact name of the file you are uploading (required)
        :param str filename: (required)
        :param str mime_type:
        :param bool _return_http_data_only: return received data only
        :param bool _preload_content: load received data in models
        :param bool _request_timeout: maximum wait time for response
        :return: FileObject
        """

        # verify the required parameter 'xero_tenant_id' is set
        if xero_tenant_id is None:
            raise ValueError(
                "Missing the required parameter `xero_tenant_id` "
                "when calling `upload_file_to_folder`"
            )
        # verify the required parameter 'folder_id' is set
        if folder_id is None:
            raise ValueError(
                "Missing the required parameter `folder_id` "
                "when calling `upload_file_to_folder`"
            )
        # verify the required parameter 'body' is set
        if body is None:
            raise ValueError(
                "Missing the required parameter `body` "
                "when calling `upload_file_to_folder`"
            )
        # verify the required parameter 'name' is set
        if name is None:
            raise ValueError(
                "Missing the required parameter `name` "
                "when calling `upload_file_to_folder`"
            )
        # verify the required parameter 'filename' is set
        if filename is None:
            raise ValueError(
                "Missing the required parameter `filename` "
                "when calling `upload_file_to_folder`"
            )

        collection_formats = {}
        path_params = {
            "FolderId": folder_id,
        }

        query_params = []

        header_params = {
            "xero-tenant-id": xero_tenant_id,
        }

        local_var_files = {}
        form_params = [
            ("body", body),
            ("name", name),
            ("filename", filename),
            ("mimeType", mime_type),
        ]

        body_params = None
        body_params = body
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json"]
        )

        # HTTP header `Content-Type`
        header_params["Content-Type"] = self.api_client.select_header_content_type(
            ["multipart/form-data"]
        )

        # Authentication setting
        auth_settings = ["OAuth2"]
        url = self.get_resource_url("/Files/{FolderId}")

        try:
            return self.api_client.call_api(
                url,
                "POST",
                path_params,
                query_params,
                header_params,
                body=body_params,
                post_params=form_params,
                files=local_var_files,
                response_type="FileObject",
                response_model_finder=self.get_model_finder(),
                auth_settings=auth_settings,
                _return_http_data_only=_return_http_data_only,
                _preload_content=_preload_content,
                _request_timeout=_request_timeout,
                collection_formats=collection_formats,
            )
        except exceptions.HTTPStatusException as error:
            raise translate_status_exception(error, self, "upload_file_to_folder")
