# coding: utf-8

"""
    Xero Assets API

    The Assets API exposes fixed asset related functions of the Xero Accounting application and can be used for a variety of purposes such as creating assets, retrieving asset valuations etc.  # noqa: E501

    Contact: api@xero.com
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401

from xero_python.models import BaseModel


class Asset(BaseModel):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        "asset_id": "str",
        "asset_name": "str",
        "asset_type_id": "str",
        "asset_number": "str",
        "purchase_date": "date",
        "purchase_price": "float",
        "disposal_date": "date",
        "disposal_price": "float",
        "asset_status": "AssetStatus",
        "warranty_expiry_date": "str",
        "serial_number": "str",
        "book_depreciation_setting": "BookDepreciationSetting",
        "book_depreciation_detail": "BookDepreciationDetail",
        "can_rollback": "bool",
        "accounting_book_value": "float",
        "is_delete_enabled_for_date": "bool",
    }

    attribute_map = {
        "asset_id": "assetId",
        "asset_name": "assetName",
        "asset_type_id": "assetTypeId",
        "asset_number": "assetNumber",
        "purchase_date": "purchaseDate",
        "purchase_price": "purchasePrice",
        "disposal_date": "disposalDate",
        "disposal_price": "disposalPrice",
        "asset_status": "assetStatus",
        "warranty_expiry_date": "warrantyExpiryDate",
        "serial_number": "serialNumber",
        "book_depreciation_setting": "bookDepreciationSetting",
        "book_depreciation_detail": "bookDepreciationDetail",
        "can_rollback": "canRollback",
        "accounting_book_value": "accountingBookValue",
        "is_delete_enabled_for_date": "isDeleteEnabledForDate",
    }

    def __init__(
        self,
        asset_id=None,
        asset_name=None,
        asset_type_id=None,
        asset_number=None,
        purchase_date=None,
        purchase_price=None,
        disposal_date=None,
        disposal_price=None,
        asset_status=None,
        warranty_expiry_date=None,
        serial_number=None,
        book_depreciation_setting=None,
        book_depreciation_detail=None,
        can_rollback=None,
        accounting_book_value=None,
        is_delete_enabled_for_date=None,
    ):  # noqa: E501
        """Asset - a model defined in OpenAPI"""  # noqa: E501

        self._asset_id = None
        self._asset_name = None
        self._asset_type_id = None
        self._asset_number = None
        self._purchase_date = None
        self._purchase_price = None
        self._disposal_date = None
        self._disposal_price = None
        self._asset_status = None
        self._warranty_expiry_date = None
        self._serial_number = None
        self._book_depreciation_setting = None
        self._book_depreciation_detail = None
        self._can_rollback = None
        self._accounting_book_value = None
        self._is_delete_enabled_for_date = None
        self.discriminator = None

        if asset_id is not None:
            self.asset_id = asset_id
        self.asset_name = asset_name
        if asset_type_id is not None:
            self.asset_type_id = asset_type_id
        if asset_number is not None:
            self.asset_number = asset_number
        if purchase_date is not None:
            self.purchase_date = purchase_date
        if purchase_price is not None:
            self.purchase_price = purchase_price
        if disposal_date is not None:
            self.disposal_date = disposal_date
        if disposal_price is not None:
            self.disposal_price = disposal_price
        if asset_status is not None:
            self.asset_status = asset_status
        if warranty_expiry_date is not None:
            self.warranty_expiry_date = warranty_expiry_date
        if serial_number is not None:
            self.serial_number = serial_number
        if book_depreciation_setting is not None:
            self.book_depreciation_setting = book_depreciation_setting
        if book_depreciation_detail is not None:
            self.book_depreciation_detail = book_depreciation_detail
        if can_rollback is not None:
            self.can_rollback = can_rollback
        if accounting_book_value is not None:
            self.accounting_book_value = accounting_book_value
        if is_delete_enabled_for_date is not None:
            self.is_delete_enabled_for_date = is_delete_enabled_for_date

    @property
    def asset_id(self):
        """Gets the asset_id of this Asset.  # noqa: E501

        The Xero-generated Id for the asset  # noqa: E501

        :return: The asset_id of this Asset.  # noqa: E501
        :rtype: str
        """
        return self._asset_id

    @asset_id.setter
    def asset_id(self, asset_id):
        """Sets the asset_id of this Asset.

        The Xero-generated Id for the asset  # noqa: E501

        :param asset_id: The asset_id of this Asset.  # noqa: E501
        :type: str
        """

        self._asset_id = asset_id

    @property
    def asset_name(self):
        """Gets the asset_name of this Asset.  # noqa: E501

        The name of the asset  # noqa: E501

        :return: The asset_name of this Asset.  # noqa: E501
        :rtype: str
        """
        return self._asset_name

    @asset_name.setter
    def asset_name(self, asset_name):
        """Sets the asset_name of this Asset.

        The name of the asset  # noqa: E501

        :param asset_name: The asset_name of this Asset.  # noqa: E501
        :type: str
        """
        if asset_name is None:
            raise ValueError(
                "Invalid value for `asset_name`, must not be `None`"
            )  # noqa: E501

        self._asset_name = asset_name

    @property
    def asset_type_id(self):
        """Gets the asset_type_id of this Asset.  # noqa: E501

        The Xero-generated Id for the asset type  # noqa: E501

        :return: The asset_type_id of this Asset.  # noqa: E501
        :rtype: str
        """
        return self._asset_type_id

    @asset_type_id.setter
    def asset_type_id(self, asset_type_id):
        """Sets the asset_type_id of this Asset.

        The Xero-generated Id for the asset type  # noqa: E501

        :param asset_type_id: The asset_type_id of this Asset.  # noqa: E501
        :type: str
        """

        self._asset_type_id = asset_type_id

    @property
    def asset_number(self):
        """Gets the asset_number of this Asset.  # noqa: E501

        Must be unique.  # noqa: E501

        :return: The asset_number of this Asset.  # noqa: E501
        :rtype: str
        """
        return self._asset_number

    @asset_number.setter
    def asset_number(self, asset_number):
        """Sets the asset_number of this Asset.

        Must be unique.  # noqa: E501

        :param asset_number: The asset_number of this Asset.  # noqa: E501
        :type: str
        """

        self._asset_number = asset_number

    @property
    def purchase_date(self):
        """Gets the purchase_date of this Asset.  # noqa: E501

        The date the asset was purchased YYYY-MM-DD  # noqa: E501

        :return: The purchase_date of this Asset.  # noqa: E501
        :rtype: date
        """
        return self._purchase_date

    @purchase_date.setter
    def purchase_date(self, purchase_date):
        """Sets the purchase_date of this Asset.

        The date the asset was purchased YYYY-MM-DD  # noqa: E501

        :param purchase_date: The purchase_date of this Asset.  # noqa: E501
        :type: date
        """

        self._purchase_date = purchase_date

    @property
    def purchase_price(self):
        """Gets the purchase_price of this Asset.  # noqa: E501

        The purchase price of the asset  # noqa: E501

        :return: The purchase_price of this Asset.  # noqa: E501
        :rtype: float
        """
        return self._purchase_price

    @purchase_price.setter
    def purchase_price(self, purchase_price):
        """Sets the purchase_price of this Asset.

        The purchase price of the asset  # noqa: E501

        :param purchase_price: The purchase_price of this Asset.  # noqa: E501
        :type: float
        """

        self._purchase_price = purchase_price

    @property
    def disposal_date(self):
        """Gets the disposal_date of this Asset.  # noqa: E501

        The date the asset was disposed  # noqa: E501

        :return: The disposal_date of this Asset.  # noqa: E501
        :rtype: date
        """
        return self._disposal_date

    @disposal_date.setter
    def disposal_date(self, disposal_date):
        """Sets the disposal_date of this Asset.

        The date the asset was disposed  # noqa: E501

        :param disposal_date: The disposal_date of this Asset.  # noqa: E501
        :type: date
        """

        self._disposal_date = disposal_date

    @property
    def disposal_price(self):
        """Gets the disposal_price of this Asset.  # noqa: E501

        The price the asset was disposed at  # noqa: E501

        :return: The disposal_price of this Asset.  # noqa: E501
        :rtype: float
        """
        return self._disposal_price

    @disposal_price.setter
    def disposal_price(self, disposal_price):
        """Sets the disposal_price of this Asset.

        The price the asset was disposed at  # noqa: E501

        :param disposal_price: The disposal_price of this Asset.  # noqa: E501
        :type: float
        """

        self._disposal_price = disposal_price

    @property
    def asset_status(self):
        """Gets the asset_status of this Asset.  # noqa: E501


        :return: The asset_status of this Asset.  # noqa: E501
        :rtype: AssetStatus
        """
        return self._asset_status

    @asset_status.setter
    def asset_status(self, asset_status):
        """Sets the asset_status of this Asset.


        :param asset_status: The asset_status of this Asset.  # noqa: E501
        :type: AssetStatus
        """

        self._asset_status = asset_status

    @property
    def warranty_expiry_date(self):
        """Gets the warranty_expiry_date of this Asset.  # noqa: E501

        The date the asset’s warranty expires (if needed) YYYY-MM-DD  # noqa: E501

        :return: The warranty_expiry_date of this Asset.  # noqa: E501
        :rtype: str
        """
        return self._warranty_expiry_date

    @warranty_expiry_date.setter
    def warranty_expiry_date(self, warranty_expiry_date):
        """Sets the warranty_expiry_date of this Asset.

        The date the asset’s warranty expires (if needed) YYYY-MM-DD  # noqa: E501

        :param warranty_expiry_date: The warranty_expiry_date of this Asset.  # noqa: E501
        :type: str
        """

        self._warranty_expiry_date = warranty_expiry_date

    @property
    def serial_number(self):
        """Gets the serial_number of this Asset.  # noqa: E501

        The asset's serial number  # noqa: E501

        :return: The serial_number of this Asset.  # noqa: E501
        :rtype: str
        """
        return self._serial_number

    @serial_number.setter
    def serial_number(self, serial_number):
        """Sets the serial_number of this Asset.

        The asset's serial number  # noqa: E501

        :param serial_number: The serial_number of this Asset.  # noqa: E501
        :type: str
        """

        self._serial_number = serial_number

    @property
    def book_depreciation_setting(self):
        """Gets the book_depreciation_setting of this Asset.  # noqa: E501


        :return: The book_depreciation_setting of this Asset.  # noqa: E501
        :rtype: BookDepreciationSetting
        """
        return self._book_depreciation_setting

    @book_depreciation_setting.setter
    def book_depreciation_setting(self, book_depreciation_setting):
        """Sets the book_depreciation_setting of this Asset.


        :param book_depreciation_setting: The book_depreciation_setting of this Asset.  # noqa: E501
        :type: BookDepreciationSetting
        """

        self._book_depreciation_setting = book_depreciation_setting

    @property
    def book_depreciation_detail(self):
        """Gets the book_depreciation_detail of this Asset.  # noqa: E501


        :return: The book_depreciation_detail of this Asset.  # noqa: E501
        :rtype: BookDepreciationDetail
        """
        return self._book_depreciation_detail

    @book_depreciation_detail.setter
    def book_depreciation_detail(self, book_depreciation_detail):
        """Sets the book_depreciation_detail of this Asset.


        :param book_depreciation_detail: The book_depreciation_detail of this Asset.  # noqa: E501
        :type: BookDepreciationDetail
        """

        self._book_depreciation_detail = book_depreciation_detail

    @property
    def can_rollback(self):
        """Gets the can_rollback of this Asset.  # noqa: E501

        Boolean to indicate whether depreciation can be rolled back for this asset individually. This is true if it doesn't have 'legacy' journal entries and if there is no lock period that would prevent this asset from rolling back.  # noqa: E501

        :return: The can_rollback of this Asset.  # noqa: E501
        :rtype: bool
        """
        return self._can_rollback

    @can_rollback.setter
    def can_rollback(self, can_rollback):
        """Sets the can_rollback of this Asset.

        Boolean to indicate whether depreciation can be rolled back for this asset individually. This is true if it doesn't have 'legacy' journal entries and if there is no lock period that would prevent this asset from rolling back.  # noqa: E501

        :param can_rollback: The can_rollback of this Asset.  # noqa: E501
        :type: bool
        """

        self._can_rollback = can_rollback

    @property
    def accounting_book_value(self):
        """Gets the accounting_book_value of this Asset.  # noqa: E501

        The accounting value of the asset  # noqa: E501

        :return: The accounting_book_value of this Asset.  # noqa: E501
        :rtype: float
        """
        return self._accounting_book_value

    @accounting_book_value.setter
    def accounting_book_value(self, accounting_book_value):
        """Sets the accounting_book_value of this Asset.

        The accounting value of the asset  # noqa: E501

        :param accounting_book_value: The accounting_book_value of this Asset.  # noqa: E501
        :type: float
        """

        self._accounting_book_value = accounting_book_value

    @property
    def is_delete_enabled_for_date(self):
        """Gets the is_delete_enabled_for_date of this Asset.  # noqa: E501

        Boolean to indicate whether delete is enabled  # noqa: E501

        :return: The is_delete_enabled_for_date of this Asset.  # noqa: E501
        :rtype: bool
        """
        return self._is_delete_enabled_for_date

    @is_delete_enabled_for_date.setter
    def is_delete_enabled_for_date(self, is_delete_enabled_for_date):
        """Sets the is_delete_enabled_for_date of this Asset.

        Boolean to indicate whether delete is enabled  # noqa: E501

        :param is_delete_enabled_for_date: The is_delete_enabled_for_date of this Asset.  # noqa: E501
        :type: bool
        """

        self._is_delete_enabled_for_date = is_delete_enabled_for_date
