/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.css.properties.svg;

import java.util.ArrayList;
import org.w3c.css.properties.css.CssProperty;
import org.w3c.css.properties.css3.CssColor;
import org.w3c.css.util.ApplContext;
import org.w3c.css.util.InvalidParamException;
import org.w3c.css.values.CssExpression;
import org.w3c.css.values.CssFunction;
import org.w3c.css.values.CssIdent;
import org.w3c.css.values.CssValue;
import org.w3c.css.values.CssValueList;

public class CssFill
extends org.w3c.css.properties.css.CssFill {
    public static final CssIdent currentColor = CssIdent.getIdent("currentColor");

    public CssFill() {
        this.value = initial;
    }

    public CssFill(ApplContext ac, CssExpression expression, boolean check) throws InvalidParamException {
        this.value = CssFill.parsePaint(ac, expression, check, this);
    }

    public CssFill(ApplContext ac, CssExpression expression) throws InvalidParamException {
        this(ac, expression, false);
    }

    static CssValue parsePaint(ApplContext ac, CssExpression expression, boolean check, CssProperty property) throws InvalidParamException {
        property.setByUser();
        if (check && expression.getCount() > 3) {
            throw new InvalidParamException("unrecognize", ac);
        }
        CssValue value = null;
        ArrayList<CssValue> values = new ArrayList<CssValue>();
        boolean gotColor = false;
        boolean gotFuncIRI = false;
        boolean gotIccColor = false;
        while (!expression.end()) {
            CssValue val = expression.getValue();
            char op = expression.getOperator();
            switch (val.getType()) {
                case 0: {
                    if (inherit.equals(val)) {
                        value = inherit;
                        if (expression.getCount() <= 1) break;
                        throw new InvalidParamException("value", val.toString(), property.getPropertyName(), ac);
                    }
                    if (none.equals(val)) {
                        if (expression.getCount() > 1 && !gotFuncIRI || expression.getCount() > 2 && gotFuncIRI) {
                            throw new InvalidParamException("value", val.toString(), property.getPropertyName(), ac);
                        }
                        values.add(none);
                        break;
                    }
                    if (currentColor.equals(val)) {
                        if (expression.getCount() > 1 && !gotFuncIRI || expression.getCount() > 2 && gotFuncIRI) {
                            throw new InvalidParamException("value", val.toString(), property.getPropertyName(), ac);
                        }
                        values.add(currentColor);
                        gotColor = true;
                        break;
                    }
                    if (expression.getCount() > 1) {
                        throw new InvalidParamException("value", val.toString(), property.getPropertyName(), ac);
                    }
                    if (gotColor) {
                        throw new InvalidParamException("value", val.toString(), property.getPropertyName(), ac);
                    }
                    CssExpression nex = new CssExpression();
                    nex.addValue(val);
                    switch (ac.getCssVersion()) {
                        case CSS1: {
                            throw new InvalidParamException("unrecognize", ac);
                        }
                        case CSS2: 
                        case CSS21: {
                            values.add(new org.w3c.css.properties.css21.CssColor(ac, nex, check).getColor());
                            break;
                        }
                        default: {
                            values.add(new CssColor(ac, nex, check).getColor());
                        }
                    }
                    gotColor = true;
                    break;
                }
                case 15: {
                    if (gotColor) {
                        throw new InvalidParamException("value", val.toString(), property.getPropertyName(), ac);
                    }
                    org.w3c.css.values.CssColor c = new org.w3c.css.values.CssColor();
                    c.setShortRGBColor(ac, val.toString());
                    gotColor = true;
                    values.add(c);
                    break;
                }
                case 3: {
                    if (gotColor) {
                        throw new InvalidParamException("value", val.toString(), property.getPropertyName(), ac);
                    }
                    gotColor = true;
                    values.add(val);
                    break;
                }
                case 2: {
                    if (gotColor || gotFuncIRI || !values.isEmpty()) {
                        throw new InvalidParamException("value", val.toString(), property.getPropertyName(), ac);
                    }
                    gotFuncIRI = true;
                    values.add(val);
                    break;
                }
                case 11: {
                    CssFunction f = (CssFunction)val;
                    if (gotColor || gotFuncIRI || gotIccColor) {
                        throw new InvalidParamException("value", val.toString(), property.getPropertyName(), ac);
                    }
                    if ("icc-color".equals(f.getName())) {
                        values.add(CssFill.parseIccColor(ac, f, check));
                        gotIccColor = true;
                        break;
                    }
                }
                default: {
                    throw new InvalidParamException("value", val.toString(), property.getPropertyName(), ac);
                }
            }
            if (op != ' ') {
                throw new InvalidParamException("operator", Character.toString(op), ac);
            }
            expression.next();
        }
        if (!values.isEmpty()) {
            value = values.size() == 1 ? (CssValue)values.get(0) : new CssValueList(values);
        }
        return value;
    }

    static CssValue parseIccColor(ApplContext ac, CssFunction f, boolean check) throws InvalidParamException {
        boolean gitIdent = false;
        CssExpression expression = f.getParameters();
        while (!expression.end()) {
            CssValue val = expression.getValue();
            char op = expression.getOperator();
            switch (val.getType()) {
                case 5: {
                    if (gitIdent) break;
                    throw new InvalidParamException("value", val.toString(), f.getName(), ac);
                }
                case 0: {
                    if (!gitIdent) {
                        gitIdent = true;
                        break;
                    }
                }
                default: {
                    throw new InvalidParamException("value", val.toString(), f.getName(), ac);
                }
            }
            if (op != ' ' && op != ',') {
                throw new InvalidParamException("operator", Character.toString(op), ac);
            }
            expression.next();
        }
        return f;
    }
}

