/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.css.properties.css3;

import java.util.ArrayList;
import org.w3c.css.util.ApplContext;
import org.w3c.css.util.InvalidParamException;
import org.w3c.css.values.CssExpression;
import org.w3c.css.values.CssIdent;
import org.w3c.css.values.CssValue;
import org.w3c.css.values.CssValueList;

public class CssTransformOrigin
extends org.w3c.css.properties.css.CssTransformOrigin {
    public static CssIdent[] allowed_values;
    public static CssIdent center;
    public static CssIdent top;
    public static CssIdent bottom;
    public static CssIdent left;
    public static CssIdent right;

    public static CssIdent getMatchingIdent(CssIdent ident) {
        for (CssIdent id : allowed_values) {
            if (!id.equals(ident)) continue;
            return id;
        }
        return null;
    }

    public boolean isVerticalIdent(CssIdent ident) {
        return top.equals(ident) || bottom.equals(ident);
    }

    public boolean isHorizontalIdent(CssIdent ident) {
        return left.equals(ident) || right.equals(ident);
    }

    public CssTransformOrigin() {
        this.value = initial;
    }

    public CssTransformOrigin(ApplContext ac, CssExpression expression, boolean check) throws InvalidParamException {
        int nb_val = expression.getCount();
        if (check && nb_val > 3) {
            throw new InvalidParamException("unrecognize", ac);
        }
        this.setByUser();
        ArrayList<CssValue> values = new ArrayList<CssValue>();
        while (!expression.end()) {
            CssValue val = expression.getValue();
            char op = expression.getOperator();
            if (inherit.equals(val)) {
                if (expression.getCount() > 1) {
                    throw new InvalidParamException("value", val, this.getPropertyName(), ac);
                }
                this.value = inherit;
                expression.next();
                return;
            }
            values.add(val);
            expression.next();
            if (op == ' ') continue;
            throw new InvalidParamException("operator", Character.toString(op), ac);
        }
        this.check(values, ac);
        this.value = values.size() == 1 ? values.get(0) : new CssValueList(values);
    }

    private void check(ArrayList<CssValue> values, ApplContext ac) throws InvalidParamException {
        CssValue v;
        int nb_keyword = 0;
        int nb_values = values.size();
        if (nb_values > 3 || nb_values == 0) {
            throw new InvalidParamException("unrecognize", ac);
        }
        block5: for (CssValue aValue : values) {
            switch (aValue.getType()) {
                case 5: {
                    aValue.getCheckableValue().checkEqualsZero(ac, this);
                }
                case 4: 
                case 6: {
                    continue block5;
                }
                case 0: {
                    ++nb_keyword;
                    continue block5;
                }
            }
            throw new InvalidParamException("value", aValue, this.getPropertyName(), ac);
        }
        if (nb_keyword > 0 && nb_values >= 2) {
            CssIdent id;
            boolean got_horizontal = false;
            boolean got_vertical = false;
            CssValue v2 = values.get(0);
            if (v2.getType() == 0 && !(got_horizontal = this.isHorizontalIdent(id = (CssIdent)v2))) {
                got_vertical = this.isVerticalIdent(id);
            }
            if ((v2 = values.get(1)).getType() == 0) {
                id = (CssIdent)v2;
                if (got_horizontal && this.isHorizontalIdent(id)) {
                    throw new InvalidParamException("value", id, this.getPropertyName(), ac);
                }
                if (got_vertical && this.isVerticalIdent(id)) {
                    throw new InvalidParamException("value", id, this.getPropertyName(), ac);
                }
            } else if (got_vertical) {
                throw new InvalidParamException("value", v2, this.getPropertyName(), ac);
            }
        }
        if (nb_values == 3 && (v = values.get(2)).getType() != 6 && v.getType() != 5) {
            throw new InvalidParamException("value", v, this.getPropertyName(), ac);
        }
    }

    public CssTransformOrigin(ApplContext ac, CssExpression expression) throws InvalidParamException {
        this(ac, expression, false);
    }

    static {
        top = CssIdent.getIdent("top");
        bottom = CssIdent.getIdent("bottom");
        left = CssIdent.getIdent("left");
        right = CssIdent.getIdent("right");
        center = CssIdent.getIdent("center");
        allowed_values = new CssIdent[5];
        CssTransformOrigin.allowed_values[0] = top;
        CssTransformOrigin.allowed_values[1] = bottom;
        CssTransformOrigin.allowed_values[2] = left;
        CssTransformOrigin.allowed_values[3] = right;
        CssTransformOrigin.allowed_values[4] = center;
    }
}

