/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.css.properties.css3;

import java.util.ArrayList;
import org.w3c.css.util.ApplContext;
import org.w3c.css.util.InvalidParamException;
import org.w3c.css.values.CssExpression;
import org.w3c.css.values.CssIdent;
import org.w3c.css.values.CssString;
import org.w3c.css.values.CssValue;
import org.w3c.css.values.CssValueList;

public class CssTextEmphasisStyle
extends org.w3c.css.properties.css.CssTextEmphasisStyle {
    public static final CssIdent[] shapeStyle;
    public static final CssIdent[] shapeForm;

    public static final CssIdent getShapeStyle(CssIdent ident) {
        for (CssIdent id : shapeStyle) {
            if (!id.equals(ident)) continue;
            return id;
        }
        return null;
    }

    public static final CssIdent getShapeForm(CssIdent ident) {
        for (CssIdent id : shapeForm) {
            if (!id.equals(ident)) continue;
            return id;
        }
        return null;
    }

    public static final CssIdent getAllowedValue(CssIdent ident) {
        if (none.equals(ident)) {
            return none;
        }
        CssIdent v = CssTextEmphasisStyle.getShapeStyle(ident);
        if (v == null) {
            v = CssTextEmphasisStyle.getShapeForm(ident);
        }
        return v;
    }

    public CssTextEmphasisStyle() {
        this.value = initial;
    }

    public CssTextEmphasisStyle(ApplContext ac, CssExpression expression, boolean check) throws InvalidParamException {
        if (check && expression.getCount() > 2) {
            throw new InvalidParamException("unrecognize", ac);
        }
        this.setByUser();
        CssIdent styleValue = null;
        CssIdent formValue = null;
        CssValue val = expression.getValue();
        char op = expression.getOperator();
        switch (val.getType()) {
            case 1: {
                CssString s = (CssString)val;
                if (s.toString().length() != 3) {
                    throw new InvalidParamException("value", s, this.getPropertyName(), ac);
                }
                if (check && expression.getCount() != 1) {
                    throw new InvalidParamException("value", val.toString(), this.getPropertyName(), ac);
                }
                this.value = s;
                break;
            }
            case 0: {
                CssIdent ident = (CssIdent)val;
                if (inherit.equals(ident)) {
                    this.value = inherit;
                    if (!check || expression.getCount() == 1) break;
                    throw new InvalidParamException("value", val.toString(), this.getPropertyName(), ac);
                }
                if (none.equals(ident)) {
                    this.value = none;
                    if (!check || expression.getCount() == 1) break;
                    throw new InvalidParamException("value", val.toString(), this.getPropertyName(), ac);
                }
                boolean match = false;
                int nbgot = 0;
                do {
                    match = false;
                    if (styleValue == null) {
                        styleValue = CssTextEmphasisStyle.getShapeStyle(ident);
                        boolean bl = match = styleValue != null;
                    }
                    if (!match && formValue == null) {
                        formValue = CssTextEmphasisStyle.getShapeForm(ident);
                        boolean bl = match = formValue != null;
                    }
                    if (!match) {
                        throw new InvalidParamException("value", val.toString(), this.getPropertyName(), ac);
                    }
                    if (expression.getRemainingCount() == 1 || ++nbgot == 2) break;
                    if (op != ' ') {
                        throw new InvalidParamException("operator", Character.toString(op), ac);
                    }
                    expression.next();
                    val = expression.getValue();
                    op = expression.getOperator();
                    if (val.getType() != 0) {
                        throw new InvalidParamException("value", val.toString(), this.getPropertyName(), ac);
                    }
                    ident = (CssIdent)val;
                } while (!expression.end());
                if (formValue != null && styleValue != null) {
                    ArrayList<CssValue> v = new ArrayList<CssValue>(2);
                    v.add(styleValue);
                    v.add(formValue);
                    this.value = new CssValueList(v);
                    break;
                }
                this.value = formValue == null ? styleValue : formValue;
                break;
            }
            default: {
                throw new InvalidParamException("value", val.toString(), this.getPropertyName(), ac);
            }
        }
        expression.next();
    }

    public CssTextEmphasisStyle(ApplContext ac, CssExpression expression) throws InvalidParamException {
        this(ac, expression, false);
    }

    static {
        String[] _shapeStyle = new String[]{"filled", "open"};
        String[] _shapeForm = new String[]{"dot", "circle", "double-circle", "triangle", "sesame"};
        shapeStyle = new CssIdent[_shapeStyle.length];
        int i = 0;
        for (String s : _shapeStyle) {
            CssTextEmphasisStyle.shapeStyle[i++] = CssIdent.getIdent(s);
        }
        shapeForm = new CssIdent[_shapeForm.length];
        i = 0;
        for (String s : _shapeForm) {
            CssTextEmphasisStyle.shapeForm[i++] = CssIdent.getIdent(s);
        }
    }
}

