/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.css.properties.css3;

import java.util.ArrayList;
import org.w3c.css.util.ApplContext;
import org.w3c.css.util.InvalidParamException;
import org.w3c.css.values.CssExpression;
import org.w3c.css.values.CssIdent;
import org.w3c.css.values.CssValue;
import org.w3c.css.values.CssValueList;

public class CssTextDecorationLine
extends org.w3c.css.properties.css.CssTextDecorationLine {
    public static final CssIdent underline = CssIdent.getIdent("underline");
    public static final CssIdent overline = CssIdent.getIdent("overline");
    public static final CssIdent line_through = CssIdent.getIdent("line-through");

    public static final CssIdent getAllowedValue(CssIdent ident) {
        if (none.equals(ident)) {
            return none;
        }
        if (underline.equals(ident)) {
            return underline;
        }
        if (overline.equals(ident)) {
            return overline;
        }
        if (line_through.equals(ident)) {
            return line_through;
        }
        return null;
    }

    public CssTextDecorationLine() {
        this.value = initial;
    }

    public CssTextDecorationLine(ApplContext ac, CssExpression expression, boolean check) throws InvalidParamException {
        if (check && expression.getCount() > 3) {
            throw new InvalidParamException("unrecognize", ac);
        }
        this.setByUser();
        CssIdent underlineValue = null;
        CssIdent overlineValue = null;
        CssIdent lineThroughValue = null;
        CssValue val = expression.getValue();
        char op = expression.getOperator();
        if (val.getType() != 0) {
            throw new InvalidParamException("value", val.toString(), this.getPropertyName(), ac);
        }
        CssIdent ident = (CssIdent)val;
        if (inherit.equals(ident)) {
            this.value = inherit;
            if (check && expression.getCount() != 1) {
                throw new InvalidParamException("value", val.toString(), this.getPropertyName(), ac);
            }
        } else if (none.equals(ident)) {
            this.value = none;
            if (check && expression.getCount() != 1) {
                throw new InvalidParamException("value", val.toString(), this.getPropertyName(), ac);
            }
        } else {
            int nbgot = 0;
            do {
                if (underlineValue == null && underline.equals(ident)) {
                    underlineValue = underline;
                } else if (overlineValue == null && overline.equals(ident)) {
                    overlineValue = overline;
                } else if (lineThroughValue == null && line_through.equals(ident)) {
                    lineThroughValue = line_through;
                } else {
                    throw new InvalidParamException("value", val.toString(), this.getPropertyName(), ac);
                }
                if (expression.getRemainingCount() == 1 || !check && ++nbgot == 3) break;
                if (op != ' ') {
                    throw new InvalidParamException("operator", Character.toString(op), ac);
                }
                expression.next();
                val = expression.getValue();
                op = expression.getOperator();
                if (val.getType() != 0) {
                    throw new InvalidParamException("value", val.toString(), this.getPropertyName(), ac);
                }
                ident = (CssIdent)val;
            } while (!expression.end());
            ArrayList<CssValue> v = new ArrayList<CssValue>(nbgot);
            if (underlineValue != null) {
                v.add(underlineValue);
            }
            if (overlineValue != null) {
                v.add(overlineValue);
            }
            if (lineThroughValue != null) {
                v.add(lineThroughValue);
            }
            this.value = nbgot > 1 ? new CssValueList(v) : (CssValue)v.get(0);
        }
        expression.next();
    }

    public CssTextDecorationLine(ApplContext ac, CssExpression expression) throws InvalidParamException {
        this(ac, expression, false);
    }
}

