/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.css.properties.css3;

import java.util.ArrayList;
import java.util.Arrays;
import org.w3c.css.util.ApplContext;
import org.w3c.css.util.InvalidParamException;
import org.w3c.css.values.CssExpression;
import org.w3c.css.values.CssIdent;
import org.w3c.css.values.CssValue;
import org.w3c.css.values.CssValueList;

public class CssFontVariantEastAsian
extends org.w3c.css.properties.css.CssFontVariantEastAsian {
    public static final CssIdent[] eastAsianVariantValues;
    public static final CssIdent[] eastAsianWidthValues;
    public static final CssIdent normal;
    public static final CssIdent ruby;

    public static final CssIdent getEastAsianVariantValue(CssIdent ident) {
        int idx = Arrays.binarySearch(eastAsianVariantValues, ident);
        if (idx >= 0) {
            return eastAsianVariantValues[idx];
        }
        return null;
    }

    public static final CssIdent getEastAsianWidthValue(CssIdent ident) {
        for (CssIdent id : eastAsianWidthValues) {
            if (!id.equals(ident)) continue;
            return id;
        }
        return null;
    }

    public static final CssIdent getAllowedValue(CssIdent ident) {
        if (ruby.equals(ident)) {
            return ruby;
        }
        CssIdent id = CssFontVariantEastAsian.getEastAsianWidthValue(ident);
        if (id == null) {
            id = CssFontVariantEastAsian.getEastAsianVariantValue(ident);
        }
        return id;
    }

    public CssFontVariantEastAsian() {
        this.value = initial;
    }

    public CssFontVariantEastAsian(ApplContext ac, CssExpression expression, boolean check) throws InvalidParamException {
        if (check && expression.getCount() > 3) {
            throw new InvalidParamException("unrecognize", ac);
        }
        this.setByUser();
        CssIdent varValue = null;
        CssIdent widValue = null;
        CssIdent rubValue = null;
        while (!expression.end()) {
            CssValue val = expression.getValue();
            char op = expression.getOperator();
            if (val.getType() == 0) {
                CssIdent ident = (CssIdent)val;
                if (inherit.equals(ident)) {
                    if (expression.getCount() != 1) {
                        throw new InvalidParamException("value", val.toString(), this.getPropertyName(), ac);
                    }
                    this.value = inherit;
                } else if (normal.equals(ident)) {
                    if (expression.getCount() != 1) {
                        throw new InvalidParamException("value", val.toString(), this.getPropertyName(), ac);
                    }
                    this.value = normal;
                } else {
                    boolean match = false;
                    if (varValue == null) {
                        varValue = CssFontVariantEastAsian.getEastAsianVariantValue(ident);
                        this.value = varValue;
                        boolean bl = match = varValue != null;
                    }
                    if (!match && widValue == null) {
                        widValue = CssFontVariantEastAsian.getEastAsianWidthValue(ident);
                        this.value = widValue;
                        boolean bl = match = widValue != null;
                    }
                    if (!match && rubValue == null && (match = ruby.equals(ident))) {
                        rubValue = ruby;
                        this.value = ruby;
                    }
                    if (!match) {
                        throw new InvalidParamException("value", val.toString(), this.getPropertyName(), ac);
                    }
                }
            } else {
                throw new InvalidParamException("value", val.toString(), this.getPropertyName(), ac);
            }
            if (op != ' ') {
                throw new InvalidParamException("operator", Character.toString(op), ac);
            }
            expression.next();
        }
        if (expression.getCount() > 1) {
            ArrayList<CssValue> v = new ArrayList<CssValue>();
            if (varValue != null) {
                v.add(varValue);
            }
            if (widValue != null) {
                v.add(widValue);
            }
            if (rubValue != null) {
                v.add(rubValue);
            }
            this.value = new CssValueList(v);
        }
    }

    public CssFontVariantEastAsian(ApplContext ac, CssExpression expression) throws InvalidParamException {
        this(ac, expression, false);
    }

    static {
        int i;
        normal = CssIdent.getIdent("normal");
        ruby = CssIdent.getIdent("ruby");
        String[] _eastAsianVariantValues = new String[]{"jis78", "jis83", "jis90", "jis04", "simplified", "traditional"};
        String[] _eastAsianWidthValues = new String[]{"full-width", "proportional-width"};
        eastAsianVariantValues = new CssIdent[_eastAsianVariantValues.length];
        for (i = 0; i < eastAsianVariantValues.length; ++i) {
            CssFontVariantEastAsian.eastAsianVariantValues[i] = CssIdent.getIdent(_eastAsianVariantValues[i]);
        }
        Arrays.sort(eastAsianVariantValues);
        eastAsianWidthValues = new CssIdent[_eastAsianWidthValues.length];
        for (i = 0; i < eastAsianWidthValues.length; ++i) {
            CssFontVariantEastAsian.eastAsianWidthValues[i] = CssIdent.getIdent(_eastAsianWidthValues[i]);
        }
        Arrays.sort(eastAsianWidthValues);
    }
}

