/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.css.properties.css3;

import org.w3c.css.util.ApplContext;
import org.w3c.css.util.InvalidParamException;
import org.w3c.css.values.CssExpression;
import org.w3c.css.values.CssIdent;
import org.w3c.css.values.CssValue;
import org.w3c.css.values.CssValueList;

public class CssDisplay
extends org.w3c.css.properties.css.CssDisplay {
    public static CssIdent[] display_outside;
    public static CssIdent[] display_inside;
    public static CssIdent[] display_listitem;
    public static CssIdent[] display_internal;
    public static CssIdent[] display_box;
    public static CssIdent[] display_legacy;
    public static CssIdent[] display_flow;

    public static CssIdent getMatchingIdentInArray(CssIdent ident, CssIdent[] identArray) {
        for (CssIdent id : identArray) {
            if (!id.equals(ident)) continue;
            return id;
        }
        return null;
    }

    public CssDisplay() {
        this.value = initial;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public CssDisplay(ApplContext ac, CssExpression expression, boolean check) throws InvalidParamException {
        int count = expression.getCount();
        if (check && count > 3) {
            throw new InvalidParamException("unrecognize", ac);
        }
        this.setByUser();
        boolean inside = false;
        boolean outside = false;
        boolean listitem = false;
        boolean flow = false;
        CssValueList v = new CssValueList();
        while (!expression.end()) {
            CssValue val = expression.getValue();
            char op = expression.getOperator();
            if (val.getType() != 0) throw new InvalidParamException("value", expression.getValue(), this.getPropertyName(), ac);
            CssIdent id_val = (CssIdent)val;
            CssIdent id = null;
            if (count == 1) {
                if (inherit.equals(id_val)) {
                    id = inherit;
                    this.value = inherit;
                } else {
                    id = CssDisplay.getMatchingIdentInArray(id_val, display_box);
                    if (id != null) {
                        this.value = id;
                    } else {
                        id = CssDisplay.getMatchingIdentInArray(id_val, display_internal);
                        if (id != null) {
                            this.value = id;
                        } else {
                            id = CssDisplay.getMatchingIdentInArray(id_val, display_legacy);
                            if (id != null) {
                                this.value = id;
                            }
                        }
                    }
                }
            }
            if (id == null) {
                id = CssDisplay.getMatchingIdentInArray(id_val, display_outside);
                if (id != null) {
                    if (outside) throw new InvalidParamException("value", id_val, this.getPropertyName(), ac);
                    outside = true;
                    v.add(id);
                } else {
                    id = CssDisplay.getMatchingIdentInArray(id_val, display_listitem);
                    if (id != null) {
                        if (listitem || inside && !flow) throw new InvalidParamException("value", id_val, this.getPropertyName(), ac);
                        listitem = true;
                        v.add(id);
                    } else {
                        id = CssDisplay.getMatchingIdentInArray(id_val, display_inside);
                        if (id == null || inside) {
                            throw new InvalidParamException("value", id_val, this.getPropertyName(), ac);
                        }
                        v.add(id);
                        inside = true;
                        flow = CssDisplay.getMatchingIdentInArray(id_val, display_flow) != null;
                    }
                }
            }
            if (op != ' ') {
                throw new InvalidParamException("operator", Character.toString(op), ac);
            }
            expression.next();
        }
        if (v.size() <= 0) return;
        this.value = v.size() == 1 ? v.get(0) : v;
    }

    public CssDisplay(ApplContext ac, CssExpression expression) throws InvalidParamException {
        this(ac, expression, false);
    }

    @Override
    public boolean isDefault() {
        return this.value == inline;
    }

    static {
        String[] DISPLAY_OUTSIDE = new String[]{"block", "inline", "run-in"};
        String[] DISPLAY_INSIDE = new String[]{"flow", "flow-root", "table", "flex", "grid", "ruby", "subgrid"};
        String[] DISPLAY_LISTITEM = new String[]{"list-item"};
        String[] DISPLAY_INTERNAL = new String[]{"table-row-group", "table-header-group", "table-footer-group", "table-row", "table-cell", "table-column-group", "table-column", "table-caption", "ruby-base", "ruby-text", "ruby-base-container", "ruby-text-container"};
        String[] DISPLAY_BOX = new String[]{"contents", "none"};
        String[] DISPLAY_LEGACY = new String[]{"inline-block", "inline-list-item", "inline-table", "inline-flex", "inline-grid"};
        String[] DISPLAY_FLOW = new String[]{"flow", "flow-root"};
        display_outside = new CssIdent[DISPLAY_OUTSIDE.length];
        int i = 0;
        for (String aDISPLAY : DISPLAY_OUTSIDE) {
            CssDisplay.display_outside[i++] = CssIdent.getIdent(aDISPLAY);
        }
        i = 0;
        display_inside = new CssIdent[DISPLAY_INSIDE.length];
        for (String aDISPLAY : DISPLAY_INSIDE) {
            CssDisplay.display_inside[i++] = CssIdent.getIdent(aDISPLAY);
        }
        i = 0;
        display_listitem = new CssIdent[DISPLAY_LISTITEM.length];
        for (String aDISPLAY : DISPLAY_LISTITEM) {
            CssDisplay.display_listitem[i++] = CssIdent.getIdent(aDISPLAY);
        }
        i = 0;
        display_internal = new CssIdent[DISPLAY_INTERNAL.length];
        for (String aDISPLAY : DISPLAY_INTERNAL) {
            CssDisplay.display_internal[i++] = CssIdent.getIdent(aDISPLAY);
        }
        i = 0;
        display_box = new CssIdent[DISPLAY_BOX.length];
        for (String aDISPLAY : DISPLAY_BOX) {
            CssDisplay.display_box[i++] = CssIdent.getIdent(aDISPLAY);
        }
        i = 0;
        display_legacy = new CssIdent[DISPLAY_LEGACY.length];
        for (String aDISPLAY : DISPLAY_LEGACY) {
            CssDisplay.display_legacy[i++] = CssIdent.getIdent(aDISPLAY);
        }
        i = 0;
        display_flow = new CssIdent[DISPLAY_FLOW.length];
        for (String aDISPLAY : DISPLAY_FLOW) {
            CssDisplay.display_flow[i++] = CssIdent.getIdent(aDISPLAY);
        }
    }
}

