/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.css.properties.css3;

import java.util.ArrayList;
import org.w3c.css.util.ApplContext;
import org.w3c.css.util.InvalidParamException;
import org.w3c.css.values.CssExpression;
import org.w3c.css.values.CssIdent;
import org.w3c.css.values.CssValue;
import org.w3c.css.values.CssValueList;

public class CssColorScheme
extends org.w3c.css.properties.css.CssColorScheme {
    private static CssIdent[] allowed_values;
    private static CssIdent light;
    private static CssIdent only;
    private static CssIdent normal;

    public static CssIdent getMatchingIdent(CssIdent ident) {
        for (CssIdent id : allowed_values) {
            if (!id.equals(ident)) continue;
            return id;
        }
        return null;
    }

    public CssColorScheme() {
        this.value = initial;
    }

    public CssColorScheme(ApplContext ac, CssExpression expression, boolean check) throws InvalidParamException {
        this.setByUser();
        boolean gotLight = false;
        boolean gotOnly = false;
        ArrayList<CssValue> values = new ArrayList<CssValue>();
        while (!expression.end()) {
            CssValue val = expression.getValue();
            char op = expression.getOperator();
            if (val.getType() != 0) {
                throw new InvalidParamException("value", expression.getValue(), this.getPropertyName(), ac);
            }
            if (inherit.equals(val)) {
                if (expression.getCount() > 1) {
                    throw new InvalidParamException("unrecognize", ac);
                }
                this.value = inherit;
            } else if (normal.equals(val)) {
                if (expression.getCount() > 1) {
                    throw new InvalidParamException("unrecognize", ac);
                }
                this.value = normal;
            } else if (only.equals(val)) {
                if (gotOnly) {
                    throw new InvalidParamException("unrecognize", ac);
                }
                if (expression.getCount() > 2) {
                    throw new InvalidParamException("unrecognize", ac);
                }
                gotOnly = true;
                values.add(only);
            } else if (light.equals(val)) {
                gotLight = true;
                values.add(light);
            } else {
                values.add(val);
            }
            if (op != ' ') {
                throw new InvalidParamException("operator", Character.toString(op), ac);
            }
            expression.next();
        }
        if (gotOnly && !gotLight) {
            throw new InvalidParamException("unrecognize", ac);
        }
        if (!values.isEmpty()) {
            this.value = values.size() == 1 ? (CssValue)values.get(0) : new CssValueList(values);
        }
    }

    public CssColorScheme(ApplContext ac, CssExpression expression) throws InvalidParamException {
        this(ac, expression, false);
    }

    static {
        String[] id_values = new String[]{"light", "dark"};
        allowed_values = new CssIdent[id_values.length];
        int i = 0;
        for (String s : id_values) {
            CssColorScheme.allowed_values[i++] = CssIdent.getIdent(s);
        }
        light = CssIdent.getIdent("light");
        only = CssIdent.getIdent("only");
        normal = CssIdent.getIdent("normal");
    }
}

