/*
 * Decompiled with CFR 0.152.
 */
package nu.validator.checker.schematronequiv;

import java.io.ByteArrayInputStream;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.http.HttpServletRequest;
import nu.validator.checker.AttributeUtil;
import nu.validator.checker.Checker;
import nu.validator.checker.LocatorImpl;
import nu.validator.checker.TaintableLocatorImpl;
import nu.validator.checker.VnuBadAttrValueException;
import nu.validator.checker.VnuBadElementNameException;
import nu.validator.client.TestRunner;
import nu.validator.datatype.AutocompleteDetailsAny;
import nu.validator.datatype.AutocompleteDetailsDate;
import nu.validator.datatype.AutocompleteDetailsEmail;
import nu.validator.datatype.AutocompleteDetailsMonth;
import nu.validator.datatype.AutocompleteDetailsNumeric;
import nu.validator.datatype.AutocompleteDetailsPassword;
import nu.validator.datatype.AutocompleteDetailsTel;
import nu.validator.datatype.AutocompleteDetailsText;
import nu.validator.datatype.AutocompleteDetailsUrl;
import nu.validator.datatype.Color;
import nu.validator.datatype.CustomElementName;
import nu.validator.datatype.Html5DatatypeException;
import nu.validator.datatype.ImageCandidateStrings;
import nu.validator.datatype.ImageCandidateStringsWidthRequired;
import nu.validator.datatype.ImageCandidateURL;
import nu.validator.htmlparser.impl.NCName;
import nu.validator.messages.MessageEmitterAdapter;
import org.apache.log4j.Logger;
import org.relaxng.datatype.DatatypeException;
import org.w3c.css.css.StyleSheetParser;
import org.w3c.css.parser.CssError;
import org.w3c.css.parser.CssParseException;
import org.w3c.css.parser.Errors;
import org.w3c.css.util.ApplContext;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class Assertions
extends Checker {
    private static final Logger log4j = Logger.getLogger(Assertions.class);
    private static final Map<String, String[]> INPUT_ATTRIBUTES = new HashMap<String, String[]>();
    private static final Map<String, String> OBSOLETE_ELEMENTS;
    private static final Map<String, String[]> OBSOLETE_ATTRIBUTES;
    private static final Map<String, String> OBSOLETE_ATTRIBUTES_MSG;
    private static final Map<String, String[]> OBSOLETE_STYLE_ATTRS;
    private static final HashSet<String> JAVASCRIPT_MIME_TYPES;
    private static final String[] INTERACTIVE_ELEMENTS;
    private static final String[] INTERACTIVE_ROLES;
    private static final String[] PROHIBITED_INTERACTIVE_ANCESTOR_ROLES;
    private static final String[] PROHIBITED_MAIN_ANCESTORS;
    private static final String[] SPECIAL_ANCESTORS;
    private static Map<String, Integer> ANCESTOR_MASK_BY_DESCENDANT;
    private static final int BODY_MASK;
    private static final int A_BUTTON_MASK;
    private static final int FIGCAPTION_MASK;
    private static final int FIGURE_MASK;
    private static final int H1_MASK;
    private static final int H2_MASK;
    private static final int H3_MASK;
    private static final int H4_MASK;
    private static final int H5_MASK;
    private static final int H6_MASK;
    private static final int MAP_MASK;
    private static final int HREF_MASK = 0x40000000;
    private static final int LABEL_FOR_MASK = 0x20000000;
    private static final Map<String, Set<String>> REQUIRED_ROLE_ANCESTOR_BY_DESCENDANT;
    private static final Map<String, Set<String>> ariaOwnsIdsByRole;
    private static final Set<String> MUST_NOT_DANGLE_IDREFS;
    private static final Map<String, String> ELEMENTS_WITH_IMPLICIT_ROLE;
    private static final Map<String, String[]> ELEMENTS_WITH_IMPLICIT_ROLES;
    private static final Map<String, String> ELEMENTS_THAT_NEVER_NEED_ROLE;
    private static final Map<String, String> INPUT_TYPES_WITH_IMPLICIT_ROLE;
    private static final Set<String> ATTRIBUTES_WITH_IMPLICIT_STATE_OR_PROPERTY;
    private static final String h1WarningMessage = "Consider using the \u201ch1\u201d element as a top-level heading only (all \u201ch1\u201d elements are treated as top-level headings by many screen readers and other tools).";
    private StackNode[] stack;
    private int currentPtr;
    private int currentSectioningDepth;
    private HttpServletRequest request;
    private boolean sourceIsCss;
    private Map<StackNode, Locator> openSingleSelects = new HashMap<StackNode, Locator>();
    private Map<StackNode, Locator> openLabels = new HashMap<StackNode, Locator>();
    private Map<StackNode, TaintableLocatorImpl> openMediaElements = new HashMap<StackNode, TaintableLocatorImpl>();
    private Map<StackNode, Locator> openActiveDescendants = new HashMap<StackNode, Locator>();
    private LinkedHashSet<IdrefLocator> formControlReferences = new LinkedHashSet();
    private LinkedHashSet<IdrefLocator> formElementReferences = new LinkedHashSet();
    private LinkedHashSet<IdrefLocator> needsAriaOwner = new LinkedHashSet();
    private Set<String> formControlIds = new HashSet<String>();
    private Set<String> formElementIds = new HashSet<String>();
    private LinkedHashSet<IdrefLocator> listReferences = new LinkedHashSet();
    private Set<String> listIds = new HashSet<String>();
    private LinkedHashSet<IdrefLocator> ariaReferences = new LinkedHashSet();
    private Set<String> allIds = new HashSet<String>();
    private int currentFigurePtr;
    private int currentHeadingPtr;
    private int currentSectioningElementPtr;
    private boolean hasVisibleMain;
    private boolean hasMetaCharset;
    private boolean hasMetaDescription;
    private boolean hasContentTypePragma;
    private boolean hasAutofocus;
    private boolean hasTopLevelH1;
    private int numberOfTemplatesDeep = 0;
    private Set<Locator> secondLevelH1s = new HashSet<Locator>();
    private Map<Locator, Map<String, String>> siblingSources = new ConcurrentHashMap<Locator, Map<String, String>>();

    private static boolean equalsIgnoreAsciiCase(String one, String other) {
        if (other == null) {
            return one == null;
        }
        if (one.length() != other.length()) {
            return false;
        }
        for (int i = 0; i < one.length(); ++i) {
            char c0 = one.charAt(i);
            char c1 = other.charAt(i);
            if (c0 >= 'A' && c0 <= 'Z') {
                c0 = (char)(c0 + 32);
            }
            if (c1 >= 'A' && c1 <= 'Z') {
                c1 = (char)(c1 + 32);
            }
            if (c0 == c1) continue;
            return false;
        }
        return true;
    }

    private static final String trimSpaces(String str) {
        return Assertions.trimLeadingSpaces(Assertions.trimTrailingSpaces(str));
    }

    private static final String trimLeadingSpaces(String str) {
        if (str == null) {
            return null;
        }
        for (int i = str.length(); i > 0; --i) {
            char c = str.charAt(str.length() - i);
            if (' ' == c || '\t' == c || '\n' == c || '\f' == c || '\r' == c) continue;
            return str.substring(str.length() - i, str.length());
        }
        return "";
    }

    private static final String trimTrailingSpaces(String str) {
        if (str == null) {
            return null;
        }
        for (int i = str.length() - 1; i >= 0; --i) {
            char c = str.charAt(i);
            if (' ' == c || '\t' == c || '\n' == c || '\f' == c || '\r' == c) continue;
            return str.substring(0, i + 1);
        }
        return "";
    }

    private static int specialAncestorNumber(String name) {
        for (int i = 0; i < SPECIAL_ANCESTORS.length; ++i) {
            if (name != SPECIAL_ANCESTORS[i]) continue;
            return i;
        }
        return -1;
    }

    private static void registerProhibitedAncestor(String ancestor, String descendant) {
        int number = Assertions.specialAncestorNumber(ancestor);
        if (number == -1) {
            throw new IllegalStateException("Ancestor not found in array: " + ancestor);
        }
        Integer maskAsObject = ANCESTOR_MASK_BY_DESCENDANT.get(descendant);
        int mask = 0;
        if (maskAsObject != null) {
            mask = maskAsObject;
        }
        ANCESTOR_MASK_BY_DESCENDANT.put(descendant, mask |= 1 << number);
    }

    private static void registerRequiredAncestorRole(String parent, String child) {
        Set<String> parents = REQUIRED_ROLE_ANCESTOR_BY_DESCENDANT.get(child);
        if (parents == null) {
            parents = new HashSet<String>();
        }
        parents.add(parent);
        REQUIRED_ROLE_ANCESTOR_BY_DESCENDANT.put(child, parents);
    }

    public void setSourceIsCss(boolean sourceIsCss) {
        this.sourceIsCss = sourceIsCss;
    }

    private boolean hasPageEmitterInCallStack() {
        for (StackTraceElement el : Thread.currentThread().getStackTrace()) {
            if (!el.getClassName().equals("nu.validator.servlet.PageEmitter")) continue;
            return true;
        }
        return false;
    }

    private boolean isAriaLabelMisuse(String ariaLabel, String localName, String role, Attributes atts) {
        if (ariaLabel == null) {
            return false;
        }
        if (Arrays.binarySearch(INTERACTIVE_ELEMENTS, localName) >= 0) {
            return false;
        }
        if (this.isLabelableElement(localName, atts)) {
            return false;
        }
        if ("main" == localName || "nav" == localName || "table" == localName || "td" == localName || "th" == localName || "aside" == localName || "header" == localName || "footer" == localName || "section" == localName || "article" == localName || "form" == localName || "img" == localName || "audio" == localName || "video" == localName || "area" == localName || "fieldset" == localName || "summary" == localName || "figure" == localName) {
            return false;
        }
        return role == null;
    }

    private boolean isLabelableElement(String localName, Attributes atts) {
        return "button" == localName || "input" == localName && !AttributeUtil.lowerCaseLiteralEqualsIgnoreAsciiCaseString("hidden", atts.getValue("", "type")) || "meter" == localName || "output" == localName || "progress" == localName || "select" == localName || "textarea" == localName;
    }

    private void incrementUseCounter(String useCounterName) {
        if (this.request != null) {
            this.request.setAttribute("http://validator.nu/properties/" + useCounterName, true);
        }
    }

    private void push(StackNode node) {
        ++this.currentPtr;
        if (this.currentPtr == this.stack.length) {
            StackNode[] newStack = new StackNode[this.stack.length + 64];
            System.arraycopy(this.stack, 0, newStack, 0, this.stack.length);
            this.stack = newStack;
        }
        this.stack[this.currentPtr] = node;
    }

    private StackNode pop() {
        return this.stack[this.currentPtr--];
    }

    private StackNode peek() {
        return this.stack[this.currentPtr];
    }

    private final void errContainedInOrOwnedBy(String role, Locator locator) throws SAXException {
        this.err("An element with \u201crole=" + role + "\u201d must be contained in, or owned by, an element with " + this.renderRoleSet(REQUIRED_ROLE_ANCESTOR_BY_DESCENDANT.get(role)) + ".", locator);
    }

    private final void errObsoleteAttribute(String attribute, String element, String suggestion) throws SAXException {
        this.err("The \u201c" + attribute + "\u201d attribute on the \u201c" + element + "\u201d element is obsolete." + suggestion);
    }

    private final void warnObsoleteAttribute(String attribute, String element, String suggestion) throws SAXException {
        this.warn("The \u201c" + attribute + "\u201d attribute on the \u201c" + element + "\u201d element is obsolete." + suggestion);
    }

    private final void warnExplicitRoleUnnecessaryForType(String element, String role, String type) throws SAXException {
        this.warn("The \u201c" + role + "\u201d role is unnecessary for element \u201c" + element + "\u201d whose type is \u201c" + type + "\u201d.");
    }

    private boolean currentElementHasRequiredAncestorRole(Set<String> requiredAncestorRoles) {
        for (String role : requiredAncestorRoles) {
            for (int i = 0; i < this.currentPtr; ++i) {
                if (role.equals(this.stack[this.currentPtr - i].getRole())) {
                    return true;
                }
                String openElementName = this.stack[this.currentPtr - i].getName();
                if (ELEMENTS_WITH_IMPLICIT_ROLE.containsKey(openElementName) && ELEMENTS_WITH_IMPLICIT_ROLE.get(openElementName).equals(role)) {
                    return true;
                }
                if (!ELEMENTS_WITH_IMPLICIT_ROLES.containsKey(openElementName) || Arrays.binarySearch(ELEMENTS_WITH_IMPLICIT_ROLES.get(openElementName), role) < 0) continue;
                return true;
            }
        }
        return false;
    }

    private void checkForInteractiveAncestorRole(String descendantUiString) throws SAXException {
        for (int i = 0; i < this.currentPtr; ++i) {
            String ancestorRole = this.stack[this.currentPtr - i].getRole();
            if (ancestorRole == null || ancestorRole == "" || Arrays.binarySearch(PROHIBITED_INTERACTIVE_ANCESTOR_ROLES, ancestorRole) < 0) continue;
            this.err(descendantUiString + " must not appear as a descendant of an element with the attribute \u201crole=" + ancestorRole + "\u201d.");
        }
    }

    @Override
    public void endDocument() throws SAXException {
        for (IdrefLocator idrefLocator : this.formControlReferences) {
            if (this.formControlIds.contains(idrefLocator.getIdref())) continue;
            this.err("The value of the \u201cfor\u201d attribute of the \u201clabel\u201d element must be the ID of a non-hidden form control.", idrefLocator.getLocator());
        }
        for (IdrefLocator idrefLocator : this.formElementReferences) {
            if (this.formElementIds.contains(idrefLocator.getIdref())) continue;
            this.err("The \u201cform\u201d attribute must refer to a form element.", idrefLocator.getLocator());
        }
        for (IdrefLocator idrefLocator : this.listReferences) {
            if (this.listIds.contains(idrefLocator.getIdref())) continue;
            this.err("The \u201clist\u201d attribute of the \u201cinput\u201d element must refer to a \u201cdatalist\u201d element.", idrefLocator.getLocator());
        }
        for (IdrefLocator idrefLocator : this.ariaReferences) {
            if (this.allIds.contains(idrefLocator.getIdref())) continue;
            this.err("The \u201c" + idrefLocator.getAdditional() + "\u201d attribute must point to an element in the same document.", idrefLocator.getLocator());
        }
        for (IdrefLocator idrefLocator : this.needsAriaOwner) {
            boolean foundOwner = false;
            String role = idrefLocator.getAdditional();
            for (String ownerRole : REQUIRED_ROLE_ANCESTOR_BY_DESCENDANT.get(role)) {
                if (ariaOwnsIdsByRole.size() == 0 || ariaOwnsIdsByRole.get(ownerRole) == null || !ariaOwnsIdsByRole.get(ownerRole).contains(idrefLocator.getIdref())) continue;
                foundOwner = true;
                break;
            }
            if (foundOwner) continue;
            this.errContainedInOrOwnedBy(role, idrefLocator.getLocator());
        }
        if (this.hasTopLevelH1) {
            for (Locator locator : this.secondLevelH1s) {
                this.warn(h1WarningMessage, locator);
            }
        }
        this.reset();
        this.stack = null;
    }

    private static double getDoubleAttribute(Attributes atts, String name) {
        String str = atts.getValue("", name);
        if (str == null) {
            return Double.NaN;
        }
        try {
            return Double.parseDouble(str);
        }
        catch (NumberFormatException e) {
            return Double.NaN;
        }
    }

    @Override
    public void endElement(String uri, String localName, String name) throws SAXException {
        if ("http://www.w3.org/1999/xhtml" == uri && "template".equals(localName)) {
            --this.numberOfTemplatesDeep;
            if (this.numberOfTemplatesDeep != 0) {
                return;
            }
        } else if (this.numberOfTemplatesDeep > 0) {
            return;
        }
        StackNode node = this.pop();
        String systemId = node.locator().getSystemId();
        String publicId = node.locator().getPublicId();
        Locator locator = null;
        this.openSingleSelects.remove(node);
        this.openLabels.remove(node);
        this.openMediaElements.remove(node);
        if ("http://www.w3.org/1999/xhtml" == uri) {
            if ("figure" == localName) {
                if (node.needsFigcaption() && !node.hasFigcaptionContent() || node.hasTextNode() || node.hasEmbeddedContent()) {
                    for (Locator imgLocator : node.getImagesLackingAlt()) {
                        this.err("An \u201cimg\u201d element must have an \u201calt\u201d attribute, except under certain conditions. For details, consult guidance on providing text alternatives for images.", imgLocator);
                    }
                }
            } else if ("picture" == localName) {
                this.siblingSources.clear();
            } else if ("select" == localName && node.isOptionNeeded()) {
                if (!node.hasOption()) {
                    this.err("A \u201cselect\u201d element with a \u201crequired\u201d attribute, and without a \u201cmultiple\u201d attribute, and without a \u201csize\u201d attribute whose value is greater than \u201c1\u201d, must have a child \u201coption\u201d element.");
                }
                if (node.nonEmptyOptionLocator() != null) {
                    this.err("The first child \u201coption\u201d element of a \u201cselect\u201d element with a \u201crequired\u201d attribute, and without a \u201cmultiple\u201d attribute, and without a \u201csize\u201d attribute whose value is greater than \u201c1\u201d, must have either an empty \u201cvalue\u201d attribute, or must have no text content. Consider either adding a placeholder option label, or adding a \u201csize\u201d attribute with a value equal to the number of \u201coption\u201d elements.", node.nonEmptyOptionLocator());
                }
            } else if ("section" == localName && !node.hasHeading()) {
                this.warn("Section lacks heading. Consider using \u201ch2\u201d-\u201ch6\u201d elements to add identifying headings to all sections.", node.locator());
            } else if ("article" == localName && !node.hasHeading()) {
                this.warn("Article lacks heading. Consider using \u201ch2\u201d-\u201ch6\u201d elements to add identifying headings to all articles.", node.locator());
            } else if (!("h1" != localName && "h2" != localName && "h3" != localName && "h4" != localName && "h5" != localName && "h6" != localName || node.hasTextNode() || node.hasImg())) {
                this.warn("Empty heading.", node.locator());
            } else if ("option" == localName && !this.stack[this.currentPtr].hasOption()) {
                this.stack[this.currentPtr].setOptionFound();
            } else if ("style" == localName) {
                String styleContents = node.getTextContent().toString();
                int lineOffset = 0;
                if (styleContents.startsWith("\n")) {
                    lineOffset = 1;
                }
                ApplContext ac = new ApplContext("en");
                ac.setCssVersionAndProfile("css3svg");
                ac.setMedium("all");
                ac.setSuggestPropertyName(false);
                ac.setTreatVendorExtensionsAsWarnings(true);
                ac.setTreatCssHacksAsWarnings(true);
                ac.setWarningLevel(-1);
                ac.setFakeURL("file://localhost/StyleElement");
                StyleSheetParser styleSheetParser = new StyleSheetParser();
                styleSheetParser.parseStyleSheet(ac, new StringReader(styleContents.substring(lineOffset)), null);
                styleSheetParser.getStyleSheet().findConflicts(ac);
                Errors errors = styleSheetParser.getStyleSheet().getErrors();
                if (errors.getErrorCount() > 0) {
                    this.incrementUseCounter("style-element-errors-found");
                }
                for (int i = 0; i < errors.getErrorCount(); ++i) {
                    String message = "";
                    String cssProperty = "";
                    String cssMessage = "";
                    CssError error = errors.getErrorAt(i);
                    int beginLine = error.getBeginLine() + lineOffset;
                    int beginColumn = error.getBeginColumn();
                    int endLine = error.getEndLine() + lineOffset;
                    int endColumn = error.getEndColumn();
                    if (beginLine == 0) continue;
                    Throwable ex = error.getException();
                    if (ex instanceof CssParseException) {
                        CssParseException cpe = (CssParseException)ex;
                        if ("generator.unrecognize".equals(cpe.getErrorType())) {
                            cssMessage = "Parse Error";
                        }
                        if (cpe.getProperty() != null) {
                            cssProperty = String.format("\u201c%s\u201d: ", cpe.getProperty());
                        }
                        if (cpe.getMessage() != null) {
                            cssMessage = cpe.getMessage();
                        }
                        if (!"".equals(cssMessage) && !".".equals((message = cssProperty + cssMessage.trim()).substring(message.length() - 1))) {
                            message = message + ".";
                        }
                    } else {
                        message = ex.getMessage();
                    }
                    if ("".equals(message)) continue;
                    int lastLine = node.locator.getLineNumber() + endLine - 1;
                    int lastColumn = endColumn;
                    int columnOffset = node.locator.getColumnNumber();
                    if (error.getBeginLine() == 1) {
                        if (lineOffset != 0) {
                            columnOffset = 0;
                        }
                    } else {
                        columnOffset = 0;
                    }
                    String prefix = this.sourceIsCss ? "" : "CSS: ";
                    SAXParseException spe = new SAXParseException(prefix + message, publicId, systemId, lastLine, lastColumn);
                    int[] start = new int[]{node.locator.getLineNumber() + beginLine - 1, beginColumn, columnOffset};
                    if (this.getErrorHandler() instanceof MessageEmitterAdapter && !(this.getErrorHandler() instanceof TestRunner)) {
                        ((MessageEmitterAdapter)this.getErrorHandler()).errorWithStart(spe, start);
                        continue;
                    }
                    this.getErrorHandler().error(spe);
                }
            }
            if ("article" == localName || "aside" == localName || "nav" == localName || "section" == localName) {
                this.currentSectioningElementPtr = this.currentPtr - 1;
                --this.currentSectioningDepth;
            }
        }
        if ((locator = this.openActiveDescendants.remove(node)) != null) {
            this.warn("Attribute \u201caria-activedescendant\u201d value should either refer to a descendant element, or should be accompanied by attribute \u201caria-owns\u201d.", locator);
        }
    }

    @Override
    public void startDocument() throws SAXException {
        this.reset();
        this.request = this.getRequest();
        this.stack = new StackNode[32];
        this.currentPtr = 0;
        this.currentFigurePtr = -1;
        this.currentHeadingPtr = -1;
        this.currentSectioningElementPtr = -1;
        this.currentSectioningDepth = 0;
        this.stack[0] = null;
        this.hasVisibleMain = false;
        this.hasMetaCharset = false;
        this.hasMetaDescription = false;
        this.hasContentTypePragma = false;
        this.hasAutofocus = false;
        this.hasTopLevelH1 = false;
        this.numberOfTemplatesDeep = 0;
    }

    @Override
    public void reset() {
        this.openSingleSelects.clear();
        this.openLabels.clear();
        this.openMediaElements.clear();
        this.openActiveDescendants.clear();
        ariaOwnsIdsByRole.clear();
        this.needsAriaOwner.clear();
        this.formControlReferences.clear();
        this.formElementReferences.clear();
        this.formControlIds.clear();
        this.formElementIds.clear();
        this.listReferences.clear();
        this.listIds.clear();
        this.ariaReferences.clear();
        this.allIds.clear();
        this.siblingSources.clear();
        this.secondLevelH1s.clear();
    }

    @Override
    public void startElement(String uri, String localName, String name, Attributes atts) throws SAXException {
        if ("http://www.w3.org/1999/xhtml" == uri && "template".equals(localName)) {
            ++this.numberOfTemplatesDeep;
            if (this.numberOfTemplatesDeep != 1) {
                return;
            }
        } else if (this.numberOfTemplatesDeep > 0) {
            return;
        }
        HashSet<String> ids = new HashSet<String>();
        String role = null;
        String inputTypeVal = null;
        String activeDescendant = null;
        String ariaLabel = null;
        String owns = null;
        String forAttr = null;
        boolean href = false;
        boolean activeDescendantWithAriaOwns = false;
        System.setProperty("nu.validator.checker.imageCandidateString.hasWidth", "0");
        StackNode parent = this.peek();
        int ancestorMask = 0;
        String parentRole = null;
        String parentName = null;
        if (parent != null) {
            ancestorMask = parent.getAncestorMask();
            parentName = parent.getName();
            parentRole = parent.getRole();
        }
        if ("http://www.w3.org/1998/Math/MathML" == uri && "math".equals(localName) && atts.getIndex("", "role") > -1 && "math".equals(atts.getValue("", "role"))) {
            this.warn("Element \u201cmath\u201d does not need a \u201crole\u201d attribute.");
        }
        if ("http://www.w3.org/1999/xhtml" == uri) {
            String formVal;
            String forVal;
            int maskHit;
            boolean controls = false;
            boolean hidden = false;
            boolean toolbar = false;
            boolean usemap = false;
            boolean ismap = false;
            boolean selected = false;
            int itemid = 0;
            int itemref = 0;
            boolean itemscope = false;
            boolean itemtype = false;
            boolean tabindex = false;
            boolean languageJavaScript = false;
            boolean typeNotTextJavaScript = false;
            boolean hasAriaAttributesOtherThanAriaHidden = false;
            boolean isCustomElement = false;
            String xmlLang = null;
            String lang = null;
            String id = null;
            String list = null;
            int len = atts.getLength();
            for (int i = 0; i < len; ++i) {
                String attVal;
                String attUri = atts.getURI(i);
                if (attUri.length() == 0) {
                    String stateOrProperty;
                    String attLocal = atts.getLocalName(i);
                    if (attLocal.startsWith("aria-") && !"aria-hidden".equals(attLocal)) {
                        hasAriaAttributesOtherThanAriaHidden = true;
                    }
                    if ("embed".equals(localName)) {
                        for (int j = 0; j < attLocal.length(); ++j) {
                            char c = attLocal.charAt(j);
                            if (c < 'A' || c > 'Z') continue;
                            this.err("Bad attribute name \u201c" + attLocal + "\u201d. Attribute names for the \u201cembed\u201d element must not contain uppercase ASCII letters.");
                        }
                        if (!NCName.isNCName(attLocal)) {
                            this.err("Bad attribute name \u201c" + attLocal + "\u201d. Attribute names for the \u201cembed\u201d element must be XML-compatible.");
                        }
                    }
                    if ("style" == attLocal) {
                        String styleContents = atts.getValue(i);
                        ApplContext ac = new ApplContext("en");
                        ac.setCssVersionAndProfile("css3svg");
                        ac.setMedium("all");
                        ac.setSuggestPropertyName(false);
                        ac.setTreatVendorExtensionsAsWarnings(true);
                        ac.setTreatCssHacksAsWarnings(true);
                        ac.setWarningLevel(-1);
                        ac.setFakeURL("file://localhost/StyleAttribute");
                        StyleSheetParser styleSheetParser = new StyleSheetParser();
                        styleSheetParser.parseStyleAttribute(ac, new ByteArrayInputStream(styleContents.getBytes()), "", ac.getFakeURL(), this.getDocumentLocator().getLineNumber());
                        styleSheetParser.getStyleSheet().findConflicts(ac);
                        Errors errors = styleSheetParser.getStyleSheet().getErrors();
                        if (errors.getErrorCount() > 0) {
                            this.incrementUseCounter("style-attribute-errors-found");
                        }
                        for (int j = 0; j < errors.getErrorCount(); ++j) {
                            String message = "";
                            String cssProperty = "";
                            String cssMessage = "";
                            CssError error = errors.getErrorAt(j);
                            Throwable ex = error.getException();
                            if (ex instanceof CssParseException) {
                                CssParseException cpe = (CssParseException)ex;
                                if ("generator.unrecognize".equals(cpe.getErrorType())) {
                                    cssMessage = "Parse Error";
                                }
                                if (cpe.getProperty() != null) {
                                    cssProperty = String.format("\u201c%s\u201d: ", cpe.getProperty());
                                }
                                if (cpe.getMessage() != null) {
                                    cssMessage = cpe.getMessage();
                                }
                                if (!"".equals(cssMessage) && !".".equals((message = cssProperty + cssMessage.trim()).substring(message.length() - 1))) {
                                    message = message + ".";
                                }
                            } else {
                                message = ex.getMessage();
                            }
                            if ("".equals(message)) continue;
                            this.err("CSS: " + message);
                        }
                    } else if ("tabindex" == attLocal) {
                        tabindex = true;
                    } else if ("href" == attLocal) {
                        href = true;
                    } else if ("controls" == attLocal) {
                        controls = true;
                    } else if ("type" == attLocal && "param" != localName && "ol" != localName && "ul" != localName && "li" != localName) {
                        String attValue;
                        if ("input" == localName) {
                            inputTypeVal = atts.getValue(i).toLowerCase();
                        }
                        if (AttributeUtil.lowerCaseLiteralEqualsIgnoreAsciiCaseString("hidden", attValue = atts.getValue(i))) {
                            hidden = true;
                        } else if (AttributeUtil.lowerCaseLiteralEqualsIgnoreAsciiCaseString("toolbar", attValue)) {
                            toolbar = true;
                        }
                        if (!AttributeUtil.lowerCaseLiteralEqualsIgnoreAsciiCaseString("text/javascript", attValue)) {
                            typeNotTextJavaScript = true;
                        }
                    } else if ("role" == attLocal) {
                        role = atts.getValue(i);
                    } else if ("aria-activedescendant" == attLocal) {
                        activeDescendant = atts.getValue(i);
                    } else if ("aria-label" == attLocal) {
                        ariaLabel = atts.getValue(i);
                    } else if ("aria-owns" == attLocal) {
                        owns = atts.getValue(i);
                    } else if ("list" == attLocal) {
                        list = atts.getValue(i);
                    } else if ("lang" == attLocal) {
                        lang = atts.getValue(i);
                    } else if ("id" == attLocal) {
                        id = atts.getValue(i);
                    } else if ("for" == attLocal && "label" == localName) {
                        forAttr = atts.getValue(i);
                        ancestorMask |= 0x20000000;
                    } else if ("ismap" == attLocal) {
                        ismap = true;
                    } else if ("selected" == attLocal) {
                        selected = true;
                    } else if ("usemap" == attLocal && "input" != localName) {
                        usemap = true;
                    } else if ("itemid" == attLocal) {
                        itemid = 1;
                    } else if ("itemref" == attLocal) {
                        itemref = 1;
                    } else if ("itemscope" == attLocal) {
                        itemscope = true;
                    } else if ("itemtype" == attLocal) {
                        itemtype = true;
                    } else if ("language" == attLocal && AttributeUtil.lowerCaseLiteralEqualsIgnoreAsciiCaseString("javascript", atts.getValue(i))) {
                        languageJavaScript = true;
                    } else if ("rev" == attLocal && !"1".equals(System.getProperty("nu.validator.schema.rdfa-full"))) {
                        this.errObsoleteAttribute("rev", localName, " Use the \u201crel\u201d attribute instead, with a term having the opposite meaning.");
                    } else if (OBSOLETE_ATTRIBUTES.containsKey(attLocal) && "ol" != localName && "ul" != localName && "li" != localName) {
                        Object[] elementNames = OBSOLETE_ATTRIBUTES.get(attLocal);
                        if (Arrays.binarySearch(elementNames, localName) >= 0) {
                            String suggestion = OBSOLETE_ATTRIBUTES_MSG.containsKey(attLocal) ? " " + OBSOLETE_ATTRIBUTES_MSG.get(attLocal) : "";
                            this.errObsoleteAttribute(attLocal, localName, suggestion);
                        }
                    } else if (OBSOLETE_STYLE_ATTRS.containsKey(attLocal)) {
                        Object[] elementNames = OBSOLETE_STYLE_ATTRS.get(attLocal);
                        if (Arrays.binarySearch(elementNames, localName) >= 0) {
                            this.errObsoleteAttribute(attLocal, localName, " Use CSS instead.");
                        }
                    } else if (INPUT_ATTRIBUTES.containsKey(attLocal) && "input" == localName) {
                        Object[] allowedTypes = INPUT_ATTRIBUTES.get(attLocal);
                        String string = inputTypeVal = inputTypeVal == null ? "text" : inputTypeVal;
                        if (Arrays.binarySearch(allowedTypes, inputTypeVal) < 0) {
                            this.err("Attribute \u201c" + attLocal + "\u201d is only allowed when the input type is " + this.renderTypeList((String[])allowedTypes) + ".");
                        }
                    } else if ("autofocus" == attLocal) {
                        if (this.hasAutofocus) {
                            this.err("A document must not include more than one \u201cautofocus\u201d attribute.");
                        }
                        this.hasAutofocus = true;
                    } else if (ATTRIBUTES_WITH_IMPLICIT_STATE_OR_PROPERTY.contains(attLocal) && atts.getIndex("", stateOrProperty = "aria-" + attLocal) > -1 && "true".equals(atts.getValue("", stateOrProperty))) {
                        this.warn("Attribute \u201c" + stateOrProperty + "\u201d is unnecessary for elements that have attribute \u201c" + attLocal + "\u201d.");
                    }
                } else if ("http://www.w3.org/XML/1998/namespace" == attUri && "lang" == atts.getLocalName(i)) {
                    xmlLang = atts.getValue(i);
                }
                if (atts.getType(i) != "ID" && "id" != atts.getLocalName(i) || (attVal = atts.getValue(i)).length() == 0) continue;
                ids.add(attVal);
            }
            if (localName.contains("-")) {
                isCustomElement = true;
                if (atts.getIndex("", "is") > -1) {
                    this.err("Autonomous custom elements must not specify the \u201cis\u201d attribute.");
                }
                try {
                    CustomElementName.THE_INSTANCE.checkValid(localName);
                }
                catch (DatatypeException e) {
                    try {
                        if (this.getErrorHandler() != null) {
                            String msg = e.getMessage();
                            if (e instanceof Html5DatatypeException) {
                                msg = msg.substring(msg.indexOf(": ") + 2);
                            }
                            VnuBadElementNameException ex = new VnuBadElementNameException(localName, uri, msg, this.getDocumentLocator(), CustomElementName.class, false);
                            this.getErrorHandler().error(ex);
                        }
                    }
                    catch (ClassNotFoundException msg) {
                        // empty catch block
                    }
                }
            }
            if ("input".equals(localName)) {
                if (atts.getIndex("", "name") > -1 && "isindex".equals(atts.getValue("", "name"))) {
                    this.err("The value \u201cisindex\u201d for the \u201cname\u201d attribute of the \u201cinput\u201d element is not allowed.");
                }
                String string = inputTypeVal = inputTypeVal == null ? "text" : inputTypeVal;
                if (atts.getIndex("", "autocomplete") > -1) {
                    Class datatypeClass = null;
                    String autocompleteVal = atts.getValue("", "autocomplete");
                    try {
                        if (!"on".equals(autocompleteVal) && !"off".equals(autocompleteVal)) {
                            if ("hidden".equals(inputTypeVal)) {
                                AutocompleteDetailsAny.THE_INSTANCE.checkValid(autocompleteVal);
                                datatypeClass = AutocompleteDetailsAny.class;
                            } else if ("text".equals(inputTypeVal) || "search".equals(autocompleteVal)) {
                                AutocompleteDetailsText.THE_INSTANCE.checkValid(autocompleteVal);
                                datatypeClass = AutocompleteDetailsText.class;
                            } else if ("password".equals(inputTypeVal)) {
                                AutocompleteDetailsPassword.THE_INSTANCE.checkValid(autocompleteVal);
                                datatypeClass = AutocompleteDetailsPassword.class;
                            } else if ("url".equals(inputTypeVal)) {
                                AutocompleteDetailsUrl.THE_INSTANCE.checkValid(autocompleteVal);
                                datatypeClass = AutocompleteDetailsUrl.class;
                            } else if ("email".equals(inputTypeVal)) {
                                AutocompleteDetailsEmail.THE_INSTANCE.checkValid(autocompleteVal);
                                datatypeClass = AutocompleteDetailsEmail.class;
                            } else if ("tel".equals(inputTypeVal)) {
                                AutocompleteDetailsTel.THE_INSTANCE.checkValid(autocompleteVal);
                                datatypeClass = AutocompleteDetailsTel.class;
                            } else if ("number".equals(inputTypeVal)) {
                                AutocompleteDetailsNumeric.THE_INSTANCE.checkValid(autocompleteVal);
                                datatypeClass = AutocompleteDetailsNumeric.class;
                            } else if ("month".equals(inputTypeVal)) {
                                AutocompleteDetailsMonth.THE_INSTANCE.checkValid(autocompleteVal);
                                datatypeClass = AutocompleteDetailsMonth.class;
                            } else if ("date".equals(inputTypeVal)) {
                                AutocompleteDetailsDate.THE_INSTANCE.checkValid(autocompleteVal);
                                datatypeClass = AutocompleteDetailsDate.class;
                            }
                        }
                    }
                    catch (DatatypeException e) {
                        try {
                            if (this.getErrorHandler() != null) {
                                String msg = e.getMessage();
                                msg = msg.substring(msg.indexOf(": ") + 2);
                                VnuBadAttrValueException ex = new VnuBadAttrValueException(localName, uri, "autocomplete", autocompleteVal, msg, this.getDocumentLocator(), datatypeClass, false);
                                this.getErrorHandler().error(ex);
                            }
                        }
                        catch (ClassNotFoundException msg) {
                            // empty catch block
                        }
                    }
                }
            }
            if ("img".equals(localName) || "source".equals(localName)) {
                if (atts.getIndex("", "srcset") > -1) {
                    String srcsetVal = atts.getValue("", "srcset");
                    try {
                        if (atts.getIndex("", "sizes") > -1) {
                            ImageCandidateStringsWidthRequired.THE_INSTANCE.checkValid(srcsetVal);
                        } else {
                            ImageCandidateStrings.THE_INSTANCE.checkValid(srcsetVal);
                        }
                        if ("1".equals(System.getProperty("nu.validator.checker.imageCandidateString.hasWidth")) && atts.getIndex("", "sizes") < 0) {
                            this.err("When the \u201csrcset\u201d attribute has any image candidate string with a width descriptor, the \u201csizes\u201d attribute must also be present.");
                        }
                    }
                    catch (DatatypeException e) {
                        Class<ImageCandidateStrings> datatypeClass = ImageCandidateStrings.class;
                        if (atts.getIndex("", "sizes") > -1) {
                            datatypeClass = ImageCandidateStringsWidthRequired.class;
                        }
                        try {
                            if (this.getErrorHandler() != null) {
                                Html5DatatypeException ex5;
                                String msg = e.getMessage();
                                if (e instanceof Html5DatatypeException && !(ex5 = (Html5DatatypeException)e).getDatatypeClass().equals(ImageCandidateURL.class)) {
                                    msg = msg.substring(msg.indexOf(": ") + 2);
                                }
                                VnuBadAttrValueException ex = new VnuBadAttrValueException(localName, uri, "srcset", srcsetVal, msg, this.getDocumentLocator(), datatypeClass, false);
                                this.getErrorHandler().error(ex);
                            }
                        }
                        catch (ClassNotFoundException msg) {
                            // empty catch block
                        }
                    }
                    if ("picture".equals(parentName) && !this.siblingSources.isEmpty()) {
                        for (Map.Entry<Locator, Map<String, String>> entry : this.siblingSources.entrySet()) {
                            Locator locator = entry.getKey();
                            Map<String, String> sourceAtts = entry.getValue();
                            String media = sourceAtts.get("media");
                            if (media == null && sourceAtts.get("type") == null) {
                                this.err("A \u201csource\u201d element that has a following sibling \u201csource\u201d element or \u201cimg\u201d element with a \u201csrcset\u201d attribute must have a \u201cmedia\u201d attribute and/or \u201ctype\u201d attribute.", locator);
                                this.siblingSources.remove(locator);
                                continue;
                            }
                            if (media != null && "".equals(Assertions.trimSpaces(media))) {
                                this.err("Value of \u201cmedia\u201d attribute here must not be empty.", locator);
                                continue;
                            }
                            if (media == null || !AttributeUtil.lowerCaseLiteralEqualsIgnoreAsciiCaseString("all", Assertions.trimSpaces(media))) continue;
                            this.err("Value of \u201cmedia\u201d attribute here must not be \u201call\u201d.", locator);
                        }
                    }
                } else if (atts.getIndex("", "sizes") > -1) {
                    this.err("The \u201csizes\u201d attribute may be specified only if the \u201csrcset\u201d attribute is also present.");
                }
            }
            if ("picture".equals(parentName) && "source".equals(localName)) {
                HashMap<String, String> sourceAtts = new HashMap<String, String>();
                for (int i = 0; i < atts.getLength(); ++i) {
                    sourceAtts.put(atts.getLocalName(i), atts.getValue(i));
                }
                this.siblingSources.put(new LocatorImpl(this.getDocumentLocator()), sourceAtts);
            }
            if ("figure" == localName) {
                this.currentFigurePtr = this.currentPtr + 1;
            }
            if ((ancestorMask & FIGURE_MASK) != 0) {
                if ("img" == localName) {
                    if (this.stack[this.currentFigurePtr].hasImg()) {
                        this.stack[this.currentFigurePtr].setEmbeddedContentFound();
                    } else {
                        this.stack[this.currentFigurePtr].setImgFound();
                    }
                } else if ("audio" == localName || "canvas" == localName || "embed" == localName || "iframe" == localName || "math" == localName || "object" == localName || "svg" == localName || "video" == localName) {
                    this.stack[this.currentFigurePtr].setEmbeddedContentFound();
                }
            }
            if ("article" == localName || "aside" == localName || "nav" == localName || "section" == localName) {
                this.currentSectioningElementPtr = this.currentPtr + 1;
                ++this.currentSectioningDepth;
            }
            if ("h1" == localName || "h2" == localName || "h3" == localName || "h4" == localName || "h5" == localName || "h6" == localName) {
                this.currentHeadingPtr = this.currentPtr + 1;
                if (this.currentSectioningElementPtr > -1) {
                    this.stack[this.currentSectioningElementPtr].setHeadingFound();
                }
            }
            if (!((ancestorMask & H1_MASK) == 0 && (ancestorMask & H2_MASK) == 0 && (ancestorMask & H3_MASK) == 0 && (ancestorMask & H4_MASK) == 0 && (ancestorMask & H5_MASK) == 0 && (ancestorMask & H6_MASK) == 0 || "img" != localName || atts.getIndex("", "alt") <= -1 || "".equals(atts.getValue("", "alt")))) {
                this.stack[this.currentHeadingPtr].setImgFound();
            }
            if ("option" == localName && !parent.hasOption()) {
                if (atts.getIndex("", "value") < 0) {
                    parent.setNoValueOptionFound();
                } else if (atts.getIndex("", "value") > -1 && "".equals(atts.getValue("", "value"))) {
                    parent.setEmptyValueOptionFound();
                } else {
                    parent.setNonEmptyOption(new LocatorImpl(this.getDocumentLocator()));
                }
            }
            if (OBSOLETE_ELEMENTS.get(localName) != null) {
                String suggestion = "";
                if (!"".equals(OBSOLETE_ELEMENTS.get(localName))) {
                    suggestion = " " + OBSOLETE_ELEMENTS.get(localName);
                }
                this.err("The \u201c" + localName + "\u201d element is obsolete." + suggestion);
            }
            int mask = 0;
            String descendantUiString = "The element \u201c" + localName + "\u201d";
            Integer maskAsObject = ANCESTOR_MASK_BY_DESCENDANT.get(localName);
            if (maskAsObject != null) {
                mask = maskAsObject;
            } else if ("video" == localName && controls) {
                mask = A_BUTTON_MASK;
                descendantUiString = "The element \u201cvideo\u201d with the attribute \u201ccontrols\u201d";
                this.checkForInteractiveAncestorRole(descendantUiString);
            } else if ("audio" == localName && controls) {
                mask = A_BUTTON_MASK;
                descendantUiString = "The element \u201caudio\u201d with the attribute \u201ccontrols\u201d";
                this.checkForInteractiveAncestorRole(descendantUiString);
            } else if ("menu" == localName && toolbar) {
                mask = A_BUTTON_MASK;
                descendantUiString = "The element \u201cmenu\u201d with the attribute \u201ctype=toolbar\u201d";
                this.checkForInteractiveAncestorRole(descendantUiString);
            } else if ("img" == localName && usemap) {
                mask = A_BUTTON_MASK;
                descendantUiString = "The element \u201cimg\u201d with the attribute \u201cusemap\u201d";
                this.checkForInteractiveAncestorRole(descendantUiString);
            } else if ("object" == localName && usemap) {
                mask = A_BUTTON_MASK;
                descendantUiString = "The element \u201cobject\u201d with the attribute \u201cusemap\u201d";
                this.checkForInteractiveAncestorRole(descendantUiString);
            } else if ("input" == localName && !hidden) {
                mask = A_BUTTON_MASK;
                this.checkForInteractiveAncestorRole(descendantUiString);
            } else if (tabindex) {
                mask = A_BUTTON_MASK;
                descendantUiString = "An element with the attribute \u201ctabindex\u201d";
                this.checkForInteractiveAncestorRole(descendantUiString);
            } else if (role != null && role != "" && Arrays.binarySearch(INTERACTIVE_ROLES, role) >= 0) {
                mask = A_BUTTON_MASK;
                descendantUiString = "An element with the attribute \u201crole=" + role + "\u201d";
                this.checkForInteractiveAncestorRole(descendantUiString);
            }
            if (mask != 0 && (maskHit = ancestorMask & mask) != 0) {
                for (String ancestor : SPECIAL_ANCESTORS) {
                    if ((maskHit & 1) != 0) {
                        this.err(descendantUiString + " must not appear as a descendant of the \u201c" + ancestor + "\u201d element.");
                    }
                    maskHit >>= 1;
                }
            }
            if (Arrays.binarySearch(INTERACTIVE_ELEMENTS, localName) >= 0) {
                this.checkForInteractiveAncestorRole("The element \u201c" + localName + "\u201d");
            }
            if ("area" == localName && (ancestorMask & MAP_MASK) == 0) {
                this.err("The \u201carea\u201d element must have a \u201cmap\u201d ancestor.");
            } else if ("img" == localName) {
                List<String> roles = null;
                if (role != null) {
                    roles = Arrays.asList(role.trim().toLowerCase().split("\\s+"));
                }
                String titleVal = atts.getValue("", "title");
                if (ismap && (ancestorMask & 0x40000000) == 0) {
                    this.err("The \u201cimg\u201d element with the \u201cismap\u201d attribute set must have an \u201ca\u201d ancestor with the \u201chref\u201d attribute.");
                }
                if (atts.getIndex("", "alt") < 0) {
                    if (role != null) {
                        this.err("An \u201cimg\u201d element with no \u201calt\u201d attribute must not have a \u201crole\u201d attribute.");
                    }
                    if (hasAriaAttributesOtherThanAriaHidden) {
                        this.err("An \u201cimg\u201d element with no \u201calt\u201d attribute must not have any \u201caria-*\u201d attributes other than \u201caria-hidden\u201d.");
                    }
                    if (titleVal == null || "".equals(titleVal)) {
                        if ((ancestorMask & FIGURE_MASK) == 0) {
                            this.err("An \u201cimg\u201d element must have an \u201calt\u201d attribute, except under certain conditions. For details, consult guidance on providing text alternatives for images.");
                        } else {
                            this.stack[this.currentFigurePtr].setFigcaptionNeeded();
                            this.stack[this.currentFigurePtr].addImageLackingAlt(new LocatorImpl(this.getDocumentLocator()));
                        }
                    }
                } else if (role != null) {
                    if ("".equals(atts.getValue("", "alt"))) {
                        for (String roleValue : roles) {
                            if ("none".equals(roleValue) || "presentation".equals(roleValue)) continue;
                            this.err("An \u201cimg\u201d element which has an \u201calt\u201d attribute whose value is the empty string must not have a \u201crole\u201d attribute with any value other than \u201cnone\u201d or \u201cpresentation\u201d");
                        }
                    } else {
                        for (String roleValue : roles) {
                            if (!"none".equals(roleValue) && !"presentation".equals(roleValue)) continue;
                            this.err("Bad value \u201c" + roleValue + "\u201d for attribute \u201crole\u201d on element \u201cimg\u201d");
                        }
                    }
                }
            } else if ("table" == localName) {
                if (atts.getIndex("", "summary") >= 0) {
                    this.errObsoleteAttribute("summary", "table", " Consider describing the structure of the \u201ctable\u201d in a \u201ccaption\u201d  element or in a \u201cfigure\u201d element  containing the \u201ctable\u201d; or, simplify the structure of the \u201ctable\u201d so that no description is needed.");
                }
                if (atts.getIndex("", "border") > -1) {
                    this.errObsoleteAttribute("border", "table", " Use CSS instead.");
                }
            } else if ("track" == localName && atts.getIndex("", "default") >= 0) {
                for (Map.Entry<StackNode, TaintableLocatorImpl> entry : this.openMediaElements.entrySet()) {
                    StackNode node = entry.getKey();
                    TaintableLocatorImpl locator = entry.getValue();
                    if (node.isTrackDescendant()) {
                        this.err("The \u201cdefault\u201d attribute must not occur on more than one \u201ctrack\u201d element within the same \u201caudio\u201d or \u201cvideo\u201d element.");
                        if (locator.isTainted()) continue;
                        this.warn("\u201caudio\u201d or \u201cvideo\u201d element has more than one \u201ctrack\u201d child element with a \u201cdefault\u201d attribute.", locator);
                        locator.markTainted();
                        continue;
                    }
                    node.setTrackDescendants();
                }
            } else if ("hgroup" == localName) {
                this.incrementUseCounter("hgroup-found");
            } else if ("main" == localName) {
                for (int i = 0; i < this.currentPtr; ++i) {
                    String ancestorName = this.stack[this.currentPtr - i].getName();
                    if (ancestorName == null || Arrays.binarySearch(PROHIBITED_MAIN_ANCESTORS, ancestorName) < 0) continue;
                    this.err("The \u201cmain\u201d element must not appear as a descendant of the \u201c" + ancestorName + "\u201d element.");
                }
                if (atts.getIndex("", "hidden") < 0) {
                    if (this.hasVisibleMain) {
                        this.err("A document must not include more than one visible \u201cmain\u201d element.");
                    }
                    this.hasVisibleMain = true;
                }
            } else if ("h1" == localName) {
                if (this.currentSectioningDepth > 1) {
                    this.warn(h1WarningMessage);
                } else if (this.currentSectioningDepth == 1) {
                    this.secondLevelH1s.add(new LocatorImpl(this.getDocumentLocator()));
                } else {
                    this.hasTopLevelH1 = true;
                }
            } else if ("progress" == localName) {
                double value = Assertions.getDoubleAttribute(atts, "value");
                if (!Double.isNaN(value)) {
                    double max = Assertions.getDoubleAttribute(atts, "max");
                    if (Double.isNaN(max)) {
                        if (!(value <= 1.0)) {
                            this.err("The value of the  \u201cvalue\u201d attribute must be less than or equal to one when the \u201cmax\u201d attribute is absent.");
                        }
                    } else if (!(value <= max)) {
                        this.err("The value of the  \u201cvalue\u201d attribute must be less than or equal to the value of the \u201cmax\u201d attribute.");
                    }
                }
            } else if ("meter" == localName) {
                double value = Assertions.getDoubleAttribute(atts, "value");
                double min = Assertions.getDoubleAttribute(atts, "min");
                double max = Assertions.getDoubleAttribute(atts, "max");
                double optimum = Assertions.getDoubleAttribute(atts, "optimum");
                double low = Assertions.getDoubleAttribute(atts, "low");
                double high = Assertions.getDoubleAttribute(atts, "high");
                if (!(Double.isNaN(min) || Double.isNaN(value) || min <= value)) {
                    this.err("The value of the \u201cmin\u201d attribute must be less than or equal to the value of the \u201cvalue\u201d attribute.");
                }
                if (Double.isNaN(min) && !Double.isNaN(value) && !(0.0 <= value)) {
                    this.err("The value of the \u201cvalue\u201d attribute must be greater than or equal to zero when the \u201cmin\u201d attribute is absent.");
                }
                if (!(Double.isNaN(value) || Double.isNaN(max) || value <= max)) {
                    this.err("The value of the \u201cvalue\u201d attribute must be less than or equal to the value of the \u201cmax\u201d attribute.");
                }
                if (!Double.isNaN(value) && Double.isNaN(max) && !(value <= 1.0)) {
                    this.err("The value of the \u201cvalue\u201d attribute must be less than or equal to one when the \u201cmax\u201d attribute is absent.");
                }
                if (!(Double.isNaN(min) || Double.isNaN(max) || min <= max)) {
                    this.err("The value of the \u201cmin\u201d attribute must be less than or equal to the value of the \u201cmax\u201d attribute.");
                }
                if (Double.isNaN(min) && !Double.isNaN(max) && !(0.0 <= max)) {
                    this.err("The value of the \u201cmax\u201d attribute must be greater than or equal to zero when the \u201cmin\u201d attribute is absent.");
                }
                if (!Double.isNaN(min) && Double.isNaN(max) && !(min <= 1.0)) {
                    this.err("The value of the \u201cmin\u201d attribute must be less than or equal to one when the \u201cmax\u201d attribute is absent.");
                }
                if (!(Double.isNaN(min) || Double.isNaN(low) || min <= low)) {
                    this.err("The value of the \u201cmin\u201d attribute must be less than or equal to the value of the \u201clow\u201d attribute.");
                }
                if (Double.isNaN(min) && !Double.isNaN(low) && !(0.0 <= low)) {
                    this.err("The value of the \u201clow\u201d attribute must be greater than or equal to zero when the \u201cmin\u201d attribute is absent.");
                }
                if (!(Double.isNaN(min) || Double.isNaN(high) || min <= high)) {
                    this.err("The value of the \u201cmin\u201d attribute must be less than or equal to the value of the \u201chigh\u201d attribute.");
                }
                if (Double.isNaN(min) && !Double.isNaN(high) && !(0.0 <= high)) {
                    this.err("The value of the \u201chigh\u201d attribute must be greater than or equal to zero when the \u201cmin\u201d attribute is absent.");
                }
                if (!(Double.isNaN(low) || Double.isNaN(high) || low <= high)) {
                    this.err("The value of the \u201clow\u201d attribute must be less than or equal to the value of the \u201chigh\u201d attribute.");
                }
                if (!(Double.isNaN(high) || Double.isNaN(max) || high <= max)) {
                    this.err("The value of the \u201chigh\u201d attribute must be less than or equal to the value of the \u201cmax\u201d attribute.");
                }
                if (!Double.isNaN(high) && Double.isNaN(max) && !(high <= 1.0)) {
                    this.err("The value of the \u201chigh\u201d attribute must be less than or equal to one when the \u201cmax\u201d attribute is absent.");
                }
                if (!(Double.isNaN(low) || Double.isNaN(max) || low <= max)) {
                    this.err("The value of the \u201clow\u201d attribute must be less than or equal to the value of the \u201cmax\u201d attribute.");
                }
                if (!Double.isNaN(low) && Double.isNaN(max) && !(low <= 1.0)) {
                    this.err("The value of the \u201clow\u201d attribute must be less than or equal to one when the \u201cmax\u201d attribute is absent.");
                }
                if (!(Double.isNaN(min) || Double.isNaN(optimum) || min <= optimum)) {
                    this.err("The value of the \u201cmin\u201d attribute must be less than or equal to the value of the \u201coptimum\u201d attribute.");
                }
                if (Double.isNaN(min) && !Double.isNaN(optimum) && !(0.0 <= optimum)) {
                    this.err("The value of the \u201coptimum\u201d attribute must be greater than or equal to zero when the \u201cmin\u201d attribute is absent.");
                }
                if (!(Double.isNaN(optimum) || Double.isNaN(max) || optimum <= max)) {
                    this.err("The value of the \u201coptimum\u201d attribute must be less than or equal to the value of the \u201cmax\u201d attribute.");
                }
                if (!Double.isNaN(optimum) && Double.isNaN(max) && !(optimum <= 1.0)) {
                    this.err("The value of the \u201coptimum\u201d attribute must be less than or equal to one when the \u201cmax\u201d attribute is absent.");
                }
            } else if ("map" == localName && id != null) {
                String nameVal = atts.getValue("", "name");
                if (nameVal != null && !nameVal.equals(id)) {
                    this.err("The \u201cid\u201d attribute on a \u201cmap\u201d element must have an the same value as the \u201cname\u201d attribute.");
                }
            } else if ("object" == localName) {
                if (atts.getIndex("", "typemustmatch") >= 0 && (atts.getIndex("", "data") < 0 || atts.getIndex("", "type") < 0)) {
                    this.err("Element \u201cobject\u201d must not have attribute \u201ctypemustmatch\u201d unless both attribute \u201cdata\u201d and attribute \u201ctype\u201d are also specified.");
                }
            } else if ("form" == localName) {
                if (atts.getIndex("", "accept-charset") >= 0 && !"utf-8".equals(atts.getValue("", "accept-charset").toLowerCase())) {
                    this.err("The only allowed value for the \u201caccept-charset\u201d attribute for the \u201cform\u201d element is \u201cutf-8\u201d.");
                }
            } else if ("script" == localName) {
                if (languageJavaScript && typeNotTextJavaScript) {
                    this.err("A \u201cscript\u201d element with the \u201clanguage=\"JavaScript\"\u201d attribute set must not have a \u201ctype\u201d attribute whose value is not \u201ctext/javascript\u201d.");
                }
                if (atts.getIndex("", "charset") >= 0) {
                    this.warnObsoleteAttribute("charset", "script", "");
                    if (!"utf-8".equals(atts.getValue("", "charset").toLowerCase())) {
                        this.err("The only allowed value for the \u201ccharset\u201d attribute for the \u201cscript\u201d element is \u201cutf-8\u201d. (But the attribute is not needed and should be omitted altogether.)");
                    }
                }
                if (atts.getIndex("", "src") < 0) {
                    if (atts.getIndex("", "charset") >= 0) {
                        this.err("Element \u201cscript\u201d must not have attribute \u201ccharset\u201d unless attribute \u201csrc\u201d is also specified.");
                    }
                    if (atts.getIndex("", "defer") >= 0) {
                        this.err("Element \u201cscript\u201d must not have attribute \u201cdefer\u201d unless attribute \u201csrc\u201d is also specified.");
                    }
                    if (!(atts.getIndex("", "async") < 0 || atts.getIndex("", "type") > -1 && "module".equals(atts.getValue("", "type").toLowerCase()))) {
                        this.err("Element \u201cscript\u201d must not have attribute \u201casync\u201d unless attribute \u201csrc\u201d is also specified or unless attribute \u201ctype\u201d is specified with value \u201cmodule\u201d.");
                    }
                    if (atts.getIndex("", "integrity") >= 0) {
                        this.err("Element \u201cscript\u201d must not have attribute \u201cintegrity\u201d unless attribute \u201csrc\u201d is also specified.");
                    }
                }
                if (atts.getIndex("", "type") > -1) {
                    String scriptType = atts.getValue("", "type").toLowerCase();
                    if (JAVASCRIPT_MIME_TYPES.contains(scriptType) || "".equals(scriptType)) {
                        this.warn("The \u201ctype\u201d attribute is unnecessary for JavaScript resources.");
                    } else if ("module".equals(scriptType)) {
                        if (atts.getIndex("", "defer") > -1) {
                            this.err("A \u201cscript\u201d element with a \u201cdefer\u201d attribute must not have a \u201ctype\u201d attribute with the value \u201cmodule\u201d.");
                        }
                        if (atts.getIndex("", "nomodule") > -1) {
                            this.err("A \u201cscript\u201d element with a \u201cnomodule\u201d attribute must not have a \u201ctype\u201d attribute with the value \u201cmodule\u201d.");
                        }
                    } else if (atts.getIndex("", "src") > -1) {
                        this.err("A \u201cscript\u201d element with a \u201csrc\u201d attribute must not have a \u201ctype\u201d attribute whose value is anything other than the empty string, a JavaScript MIME type, or \u201cmodule\u201d.");
                    }
                }
            } else if ("style" == localName) {
                if (atts.getIndex("", "type") > -1) {
                    String styleType = atts.getValue("", "type").toLowerCase();
                    if ("text/css".equals(styleType)) {
                        this.warn("The \u201ctype\u201d attribute for the \u201cstyle\u201d element is not needed and should be omitted.");
                    } else {
                        this.err("The only allowed value for the \u201ctype\u201d attribute for the \u201cstyle\u201d element is \u201ctext/css\u201d (with no parameters). (But the attribute is not needed and should be omitted altogether.)");
                    }
                }
            } else if ("bdo" == localName && atts.getIndex("", "dir") < 0) {
                this.err("Element \u201cbdo\u201d must have attribute \u201cdir\u201d.");
            }
            if (this.isLabelableElement(localName, atts)) {
                for (Map.Entry<StackNode, Locator> entry : this.openLabels.entrySet()) {
                    StackNode node = entry.getKey();
                    Locator locator = entry.getValue();
                    if (node.isLabeledDescendants()) {
                        this.err("The \u201clabel\u201d element may contain at most one \u201cbutton\u201d, \u201cinput\u201d, \u201cmeter\u201d, \u201coutput\u201d, \u201cprogress\u201d, \u201cselect\u201d, or \u201ctextarea\u201d descendant.");
                        this.warn("\u201clabel\u201d element with multiple labelable descendants.", locator);
                        continue;
                    }
                    node.setLabeledDescendants();
                }
                if ((ancestorMask & 0x20000000) != 0) {
                    boolean hasMatchingFor = false;
                    int i = 0;
                    while ((this.stack[this.currentPtr - i].getAncestorMask() & 0x20000000) != 0) {
                        String forVal2 = this.stack[this.currentPtr - i].getForAttr();
                        if (forVal2 != null && forVal2.equals(id)) {
                            hasMatchingFor = true;
                            break;
                        }
                        ++i;
                    }
                    if (id == null || !hasMatchingFor) {
                        this.err("Any \u201c" + localName + "\u201d descendant of a \u201clabel\u201d element with a \u201cfor\u201d attribute must have an ID value that matches that \u201cfor\u201d attribute.");
                    }
                }
            }
            if (lang != null && xmlLang != null && !Assertions.equalsIgnoreAsciiCase(lang, xmlLang)) {
                this.err("When the attribute \u201clang\u201d in no namespace and the attribute \u201clang\u201d in the XML namespace are both present, they must have the same value.");
            }
            if (role != null && owns != null) {
                for (Set<String> value : REQUIRED_ROLE_ANCESTOR_BY_DESCENDANT.values()) {
                    String[] ownedIds;
                    if (!value.contains(role)) continue;
                    for (String ownedId : ownedIds = AttributeUtil.split(owns)) {
                        Set<String> ownedIdsForThisRole = ariaOwnsIdsByRole.get(role);
                        if (ownedIdsForThisRole == null) {
                            ownedIdsForThisRole = new HashSet<String>();
                        }
                        ownedIdsForThisRole.add(ownedId);
                        ariaOwnsIdsByRole.put(role, ownedIdsForThisRole);
                    }
                }
            }
            if ("datalist" == localName) {
                this.listIds.addAll(ids);
            }
            if ("label" == localName && (forVal = atts.getValue("", "for")) != null) {
                this.formControlReferences.add(new IdrefLocator(new LocatorImpl(this.getDocumentLocator()), forVal));
            }
            if ("form" == localName) {
                this.formElementIds.addAll(ids);
            }
            if ("button" == localName || "input" == localName && !hidden || "meter" == localName || "output" == localName || "progress" == localName || "select" == localName || "textarea" == localName || isCustomElement) {
                this.formControlIds.addAll(ids);
            }
            if (("button" == localName || "fieldset" == localName || "input" == localName && !hidden || "object" == localName || "output" == localName || "select" == localName || "textarea" == localName) && (formVal = atts.getValue("", "form")) != null) {
                this.formElementReferences.add(new IdrefLocator(new LocatorImpl(this.getDocumentLocator()), formVal));
            }
            if ("input" == localName && list != null) {
                this.listReferences.add(new IdrefLocator(new LocatorImpl(this.getDocumentLocator()), list));
            }
            if ("input" == localName && AttributeUtil.lowerCaseLiteralEqualsIgnoreAsciiCaseString("button", atts.getValue("", "type")) && (atts.getValue("", "value") == null || "".equals(atts.getValue("", "value")))) {
                this.err("Element \u201cinput\u201d with attribute \u201ctype\u201d whose value is \u201cbutton\u201d must have non-empty attribute \u201cvalue\u201d.");
            }
            if ("track" == localName && "".equals(atts.getValue("", "label"))) {
                this.err("Attribute \u201clabel\u201d for element \u201ctrack\u201d must have non-empty value.");
            }
            if ("option" == localName && selected) {
                for (Map.Entry<StackNode, Locator> entry : this.openSingleSelects.entrySet()) {
                    StackNode node = entry.getKey();
                    if (node.isSelectedOptions()) {
                        this.err("The \u201cselect\u201d element cannot have more than one selected \u201coption\u201d descendant unless the \u201cmultiple\u201d attribute is specified.");
                        continue;
                    }
                    node.setSelectedOptions();
                }
            }
            if ("meta" == localName) {
                if (AttributeUtil.lowerCaseLiteralEqualsIgnoreAsciiCaseString("content-language", atts.getValue("", "http-equiv"))) {
                    this.err("Using the \u201cmeta\u201d element to specify the document-wide default language is obsolete. Consider specifying the language on the root element instead.");
                } else if (AttributeUtil.lowerCaseLiteralEqualsIgnoreAsciiCaseString("x-ua-compatible", atts.getValue("", "http-equiv")) && !AttributeUtil.lowerCaseLiteralEqualsIgnoreAsciiCaseString("ie=edge", atts.getValue("", "content"))) {
                    this.err("A \u201cmeta\u201d element with an \u201chttp-equiv\u201d attribute whose value is \u201cX-UA-Compatible\u201d must have a \u201ccontent\u201d attribute with the value \u201cIE=edge\u201d.");
                }
                if (atts.getIndex("", "charset") > -1) {
                    if (!"utf-8".equals(atts.getValue("", "charset").toLowerCase())) {
                        this.err("The only allowed value for the \u201ccharset\u201d attribute for the \u201cmeta\u201d element is \u201cutf-8\u201d.");
                    }
                    if (this.hasMetaCharset) {
                        this.err("A document must not include more than one \u201cmeta\u201d element with a \u201ccharset\u201d attribute.");
                    }
                    if (this.hasContentTypePragma) {
                        this.err("A document must not include both a \u201cmeta\u201d element with an \u201chttp-equiv\u201d attribute whose value is \u201ccontent-type\u201d, and a \u201cmeta\u201d element with a \u201ccharset\u201d attribute.");
                    }
                    this.hasMetaCharset = true;
                }
                if (atts.getIndex("", "name") > -1) {
                    String contentVal;
                    if ("description".equals(atts.getValue("", "name"))) {
                        if (this.hasMetaDescription) {
                            this.err("A document must not include more than one \u201cmeta\u201d element with its \u201cname\u201d attribute set to the value \u201cdescription\u201d.");
                        }
                        this.hasMetaDescription = true;
                    }
                    if ("viewport".equals(atts.getValue("", "name")) && atts.getIndex("", "content") > -1 && ((contentVal = atts.getValue("", "content").toLowerCase()).contains("user-scalable=no") || contentVal.contains("maximum-scale=1.0"))) {
                        this.warn("Consider avoiding viewport values that prevent users from resizing documents.");
                    }
                    if ("theme-color".equals(atts.getValue("", "name")) && atts.getIndex("", "content") > -1) {
                        contentVal = atts.getValue("", "content").toLowerCase();
                        try {
                            Color.THE_INSTANCE.checkValid(contentVal);
                        }
                        catch (DatatypeException e) {
                            try {
                                if (this.getErrorHandler() != null) {
                                    String msg = e.getMessage();
                                    if (e instanceof Html5DatatypeException) {
                                        msg = msg.substring(msg.indexOf(": ") + 2);
                                    }
                                    VnuBadAttrValueException ex = new VnuBadAttrValueException(localName, uri, "content", contentVal, msg, this.getDocumentLocator(), Color.class, false);
                                    this.getErrorHandler().error(ex);
                                }
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                // empty catch block
                            }
                        }
                    }
                }
                if (atts.getIndex("", "http-equiv") > -1 && AttributeUtil.lowerCaseLiteralEqualsIgnoreAsciiCaseString("content-type", atts.getValue("", "http-equiv"))) {
                    if (this.hasMetaCharset) {
                        this.err("A document must not include both a \u201cmeta\u201d element with an \u201chttp-equiv\u201d attribute whose value is \u201ccontent-type\u201d, and a \u201cmeta\u201d element with a \u201ccharset\u201d attribute.");
                    }
                    if (this.hasContentTypePragma) {
                        this.err("A document must not include more than one \u201cmeta\u201d element with a \u201chttp-equiv\u201d attribute whose value is \u201ccontent-type\u201d.");
                    }
                    this.hasContentTypePragma = true;
                }
            }
            if ("link" == localName) {
                boolean hasRel = false;
                ArrayList relList = new ArrayList();
                if (atts.getIndex("", "rel") > -1) {
                    hasRel = true;
                    Collections.addAll(relList, atts.getValue("", "rel").toLowerCase().split("\\s+"));
                }
                if (relList.contains("preload") && atts.getIndex("", "as") < 0) {
                    this.err("A \u201clink\u201d element with a \u201crel\u201d attribute that contains the value \u201cpreload\u201d must have an \u201cas\u201d attribute.");
                }
                if (!(atts.getIndex("", "as") <= -1 || (relList.contains("preload") || relList.contains("modulepreload") || relList.contains("prefetch")) && hasRel)) {
                    this.err("A \u201clink\u201d element with an \u201cas\u201d attribute must have a \u201crel\u201d attribute that contains the value \u201cpreload\u201d or the value \u201cmodulepreload\u201d or the value \u201cprefetch\u201d.");
                }
                if (!(atts.getIndex("", "integrity") <= -1 || (relList.contains("stylesheet") || relList.contains("preload") || relList.contains("modulepreload")) && hasRel)) {
                    this.err("A \u201clink\u201d element with an \u201cintegrity\u201d attribute must have a \u201crel\u201d attribute that contains the value \u201cstylesheet\u201d or the value \u201cpreload\u201d or the value \u201cmodulepreload\u201d.");
                }
                if (!(atts.getIndex("", "disabled") <= -1 || relList.contains("stylesheet") && hasRel)) {
                    this.err("A \u201clink\u201d element with a \u201cdisabled\u201d attribute must have a \u201crel\u201d attribute that contains the value \u201cstylesheet\u201d.");
                }
                if (!(atts.getIndex("", "sizes") <= -1 || (relList.contains("icon") || relList.contains("apple-touch-icon") || relList.contains("apple-touch-icon-precomposed")) && hasRel)) {
                    this.err("A \u201clink\u201d element with a \u201csizes\u201d attribute must have a \u201crel\u201d attribute that contains the value \u201cicon\u201d or the value \u201capple-touch-icon\u201d or the value \u201capple-touch-icon-precomposed\u201d.");
                }
                if (!(atts.getIndex("", "color") <= -1 || relList.contains("mask-icon") && hasRel)) {
                    this.err("A \u201clink\u201d element with a \u201ccolor\u201d attribute must have a \u201crel\u201d attribute that contains the value \u201cmask-icon\u201d.");
                }
                if (!(atts.getIndex("", "scope") <= -1 || relList.contains("serviceworker") && hasRel)) {
                    this.err("A \u201clink\u201d element with a \u201cscope\u201d attribute must have a \u201crel\u201d attribute that contains the value \u201cserviceworker\u201d.");
                }
                if (!(atts.getIndex("", "updateviacache") <= -1 || relList.contains("serviceworker") && hasRel)) {
                    this.err("A \u201clink\u201d element with an \u201cupdateviacache\u201d attribute must have a \u201crel\u201d attribute that contains the value \u201cserviceworker\u201d.");
                }
                if (!(atts.getIndex("", "workertype") <= -1 || relList.contains("serviceworker") && hasRel)) {
                    this.err("A \u201clink\u201d element with a \u201cworkertype\u201d attribute must have a \u201crel\u201d attribute that contains the value \u201cserviceworker\u201d.");
                }
                if (!((ancestorMask & BODY_MASK) == 0 || relList == null || relList.contains("dns-prefetch") || relList.contains("modulepreload") || relList.contains("pingback") || relList.contains("preconnect") || relList.contains("prefetch") || relList.contains("preload") || relList.contains("prerender") || relList.contains("stylesheet") || atts.getIndex("", "itemprop") >= 0 || atts.getIndex("", "property") >= 0)) {
                    this.err("A \u201clink\u201d element must not appear as a descendant of a \u201cbody\u201d element unless the \u201clink\u201d element has an \u201citemprop\u201d attribute or has a \u201crel\u201d attribute whose value contains \u201cdns-prefetch\u201d, \u201cmodulepreload\u201d, \u201cpingback\u201d, \u201cpreconnect\u201d, \u201cprefetch\u201d, \u201cpreload\u201d, \u201cprerender\u201d, or \u201cstylesheet\u201d.");
                }
            }
            if (!(itemid == 0 || itemscope && itemtype)) {
                this.err("The \u201citemid\u201d attribute must not be specified on elements that do not have both an \u201citemscope\u201d attribute and an \u201citemtype\u201d attribute specified.");
            }
            if (itemref != 0 && !itemscope) {
                this.err("The \u201citemref\u201d attribute must not be specified on elements that do not have an \u201citemscope\u201d attribute specified.");
            }
            if (itemtype && !itemscope) {
                this.err("The \u201citemtype\u201d attribute must not be specified on elements that do not have an \u201citemscope\u201d attribute specified.");
            }
            if (ELEMENTS_WITH_IMPLICIT_ROLE.containsKey(localName) && ELEMENTS_WITH_IMPLICIT_ROLE.get(localName).equals(role)) {
                if (!"img".equals(localName) || !"".equals(atts.getValue("", "alt"))) {
                    this.warn("The \u201c" + role + "\u201d role is unnecessary for element \u201c" + localName + "\u201d.");
                }
            } else if (ELEMENTS_WITH_IMPLICIT_ROLES.containsKey(localName) && role != null && Arrays.binarySearch(ELEMENTS_WITH_IMPLICIT_ROLES.get(localName), role) >= 0) {
                this.warn("The \u201c" + role + "\u201d role is unnecessary for element \u201c" + localName + "\u201d.");
            } else if (ELEMENTS_THAT_NEVER_NEED_ROLE.containsKey(localName) && ELEMENTS_THAT_NEVER_NEED_ROLE.get(localName).equals(role)) {
                this.warn("Element \u201c" + localName + "\u201d does not need a \u201crole\u201d attribute.");
            } else if ("input" == localName) {
                String string = inputTypeVal = inputTypeVal == null ? "text" : inputTypeVal;
                if (INPUT_TYPES_WITH_IMPLICIT_ROLE.containsKey(inputTypeVal) && INPUT_TYPES_WITH_IMPLICIT_ROLE.get(inputTypeVal).equals(role)) {
                    this.warnExplicitRoleUnnecessaryForType("input", role, inputTypeVal);
                } else if ("email".equals(inputTypeVal) || "search".equals(inputTypeVal) || "tel".equals(inputTypeVal) || "text".equals(inputTypeVal) || "url".equals(inputTypeVal)) {
                    if (atts.getIndex("", "list") < 0) {
                        if ("textbox".equals(role) && !"search".equals(inputTypeVal)) {
                            this.warn("The \u201ctextbox\u201d role is unnecessary for an \u201cinput\u201d element that has no \u201clist\u201d attribute and whose type is \u201c" + inputTypeVal + "\u201d.");
                        }
                        if ("searchbox".equals(role) && "search".equals(inputTypeVal)) {
                            this.warn("The \u201csearchbox\u201d role is unnecessary for an \u201cinput\u201d element that has no \u201clist\u201d attribute and whose type is \u201c" + inputTypeVal + "\u201d.");
                        }
                    } else if ("combobox".equals(role)) {
                        this.warn("The \u201ccombobox\u201d role is unnecessary for an \u201cinput\u201d element that has a \u201clist\u201d attribute and whose type is \u201c" + inputTypeVal + "\u201d.");
                    }
                }
            } else if (atts.getIndex("", "href") > -1 && "link".equals(role) && ("a".equals(localName) || "area".equals(localName) || "link".equals(localName))) {
                this.warn("The \u201clink\u201d role is unnecessary for element \u201c" + localName + "\u201d with attribute \u201chref\u201d.");
            } else if (atts.getIndex("", "href") > -1 && "link".equals(role) && ("a".equals(localName) || "area".equals(localName) || "link".equals(localName))) {
                this.warn("The \u201clink\u201d role is unnecessary for element \u201c" + localName + "\u201d with attribute \u201chref\u201d.");
            } else if (("tbody".equals(localName) || "tfoot".equals(localName) || "thead".equals(localName)) && "rowgroup".equals(role)) {
                this.warn("The \u201crowgroup\u201d role is unnecessary for element \u201c" + localName + "\u201d.");
            } else if ("th" == localName && ("columnheader".equals(role) || "columnheader".equals(role))) {
                this.warn("The \u201c" + role + "\u201d role is unnecessary for element \u201cth\u201d.");
            } else if ("li" == localName && "listitem".equals(role) && !"menu".equals(parentName)) {
                this.warn("The \u201clistitem\u201d role is unnecessary for an \u201cli\u201d element whose parent is an \u201col\u201d element or a \u201cul\u201d element.");
            } else if ("button" == localName && "button".equals(role) && "menu".equals(atts.getValue("", "type"))) {
                this.warnExplicitRoleUnnecessaryForType("button", "button", "menu");
            } else if ("menu" == localName && "toolbar".equals(role) && "toolbar".equals(atts.getValue("", "type"))) {
                this.warnExplicitRoleUnnecessaryForType("menu", "toolbar", "toolbar");
            } else if ("li" == localName && "listitem".equals(role) && !"menu".equals(parentName)) {
                this.warn("The \u201clistitem\u201d role is unnecessary for an \u201cli\u201d element whose parent is an \u201col\u201d element or a \u201cul\u201d element.");
            }
        } else {
            int len = atts.getLength();
            for (int i = 0; i < len; ++i) {
                String attVal;
                if (atts.getType(i) == "ID" && (attVal = atts.getValue(i)).length() != 0) {
                    ids.add(attVal);
                }
                String attLocal = atts.getLocalName(i);
                if (atts.getURI(i).length() != 0) continue;
                if ("role" == attLocal) {
                    role = atts.getValue(i);
                    continue;
                }
                if ("aria-activedescendant" == attLocal) {
                    activeDescendant = atts.getValue(i);
                    continue;
                }
                if ("aria-owns" != attLocal) continue;
                owns = atts.getValue(i);
            }
            this.allIds.addAll(ids);
        }
        Set<String> requiredAncestorRoles = REQUIRED_ROLE_ANCESTOR_BY_DESCENDANT.get(role);
        if (!(requiredAncestorRoles == null || "presentation".equals(parentRole) || "tbody".equals(localName) || "tfoot".equals(localName) || "thead".equals(localName) || this.currentElementHasRequiredAncestorRole(requiredAncestorRoles))) {
            if (atts.getIndex("", "id") > -1 && !"".equals(atts.getValue("", "id"))) {
                this.needsAriaOwner.add(new IdrefLocator(new LocatorImpl(this.getDocumentLocator()), atts.getValue("", "id"), role));
            } else {
                this.errContainedInOrOwnedBy(role, this.getDocumentLocator());
            }
        }
        for (String att : MUST_NOT_DANGLE_IDREFS) {
            String[] tokens;
            String attVal = atts.getValue("", att);
            if (attVal == null) continue;
            for (String token : tokens = AttributeUtil.split(attVal)) {
                this.ariaReferences.add(new IdrefLocator(this.getDocumentLocator(), token, att));
            }
        }
        this.allIds.addAll(ids);
        if (this.isAriaLabelMisuse(ariaLabel, localName, role, atts)) {
            this.warn("Possible misuse of \u201caria-label\u201d. (If you disagree with this warning, file an issue report or send e-mail to www-validator@w3.org.)");
            this.incrementUseCounter("aria-label-misuse-found");
            String systemId = this.getDocumentLocator().getSystemId();
            if (systemId != null && this.hasPageEmitterInCallStack()) {
                log4j.info("aria-label misuse " + systemId);
            }
        }
        if (activeDescendant != null && !"".equals(activeDescendant) && owns != null && !"".equals(owns)) {
            activeDescendantWithAriaOwns = true;
        }
        Iterator<Map.Entry<StackNode, Locator>> iterator = this.openActiveDescendants.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<StackNode, Locator> entry = iterator.next();
            if (!ids.contains(entry.getKey().getActiveDescendant())) continue;
            iterator.remove();
        }
        if ("http://www.w3.org/1999/xhtml" == uri) {
            int number = Assertions.specialAncestorNumber(localName);
            if (number > -1) {
                ancestorMask |= 1 << number;
            }
            if ("a" == localName && href) {
                ancestorMask |= 0x40000000;
            }
            StackNode child = new StackNode(ancestorMask, localName, role, activeDescendant, forAttr);
            if ("style" == localName) {
                child.setIsCollectingCharacters(true);
            }
            if ("script" == localName) {
                child.setIsCollectingCharacters(true);
            }
            if (activeDescendant != null && !activeDescendantWithAriaOwns) {
                this.openActiveDescendants.put(child, new LocatorImpl(this.getDocumentLocator()));
            }
            if ("select" == localName && atts.getIndex("", "multiple") == -1) {
                this.openSingleSelects.put(child, this.getDocumentLocator());
            } else if ("label" == localName) {
                this.openLabels.put(child, new LocatorImpl(this.getDocumentLocator()));
            } else if ("video" == localName || "audio" == localName) {
                this.openMediaElements.put(child, new TaintableLocatorImpl(this.getDocumentLocator()));
            }
            this.push(child);
            if (!("article" != localName && "aside" != localName && "nav" != localName && "section" != localName || atts.getIndex("", "aria-label") <= -1 || "".equals(atts.getValue("", "aria-label")))) {
                child.setHeadingFound();
            }
            if ("select" == localName) {
                boolean hasMultiple;
                boolean hasSize = false;
                boolean sizeIsOne = false;
                boolean sizeIsGreaterThanOne = false;
                boolean bl = hasMultiple = atts.getIndex("", "multiple") > -1;
                if (atts.getIndex("", "size") > -1) {
                    hasSize = true;
                    String size = Assertions.trimSpaces(atts.getValue("", "size"));
                    if (!"".equals(size)) {
                        try {
                            if (size.length() > 1 && size.charAt(0) == '+' && Integer.parseInt(size.substring(1)) == 1 || Integer.parseInt(size) == 1) {
                                sizeIsOne = true;
                            } else if (size.length() > 1 && size.charAt(0) == '+' && Integer.parseInt(size.substring(1)) > 1 || Integer.parseInt(size) > 1) {
                                sizeIsGreaterThanOne = true;
                            }
                        }
                        catch (NumberFormatException numberFormatException) {
                            // empty catch block
                        }
                    }
                }
                if (sizeIsGreaterThanOne || hasMultiple) {
                    if ("listbox".equals(role)) {
                        this.warn("The \u201clistbox\u201d role is unnecessary for element \u201cselect\u201d with a \u201cmultiple\u201d attribute or with a \u201csize\u201d attribute whose value is greater than 1.");
                    } else if (role != null) {
                        this.err("A \u201cselect\u201d element with a \u201cmultiple\u201d attribute or with a \u201csize\u201d attribute whose value is greater than 1 must not have any \u201crole\u201d attribute.");
                    }
                }
                if (!hasMultiple) {
                    if (!sizeIsGreaterThanOne && role != null) {
                        if ("combobox".equals(role)) {
                            this.warn("The \u201ccombobox\u201d role is unnecessary for element \u201cselect\u201d without a \u201cmultiple\u201d attribute and without a \u201csize\u201d attribute whose value is greater than 1.");
                        } else if (!"menu".equals(role)) {
                            this.err("The \u201c" + role + "\u201d role is not allowed for element \u201cselect\u201d without a \u201cmultiple\u201d attribute and without a \u201csize\u201d attribute whose value is greater than 1.");
                        }
                    }
                    if (atts.getIndex("", "required") > -1) {
                        if (hasSize) {
                            if (sizeIsOne) {
                                child.setOptionNeeded();
                            }
                        } else {
                            child.setOptionNeeded();
                        }
                    }
                }
            }
        } else if ("http://n.validator.nu/custom-elements/" == uri) {
            this.err("Element \u201c" + localName + "\u201d from namespace \u201chttp://n.validator.nu/custom-elements/\u201d not allowed.");
        } else {
            StackNode child = new StackNode(ancestorMask, null, role, activeDescendant, forAttr);
            if (activeDescendant != null) {
                this.openActiveDescendants.put(child, new LocatorImpl(this.getDocumentLocator()));
            }
            this.push(child);
        }
        this.stack[this.currentPtr].setLocator(new LocatorImpl(this.getDocumentLocator()));
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.numberOfTemplatesDeep > 0) {
            return;
        }
        if (this.stack[this.currentPtr].getIsCollectingCharacters()) {
            this.stack[this.currentPtr].appendToTextContent(ch, start, length);
        }
        StackNode node = this.peek();
        block3: for (int i = start; i < start + length; ++i) {
            char c = ch[i];
            switch (c) {
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': {
                    continue block3;
                }
                default: {
                    if ("h1".equals(node.name) || "h2".equals(node.name) || "h3".equals(node.name) || "h4".equals(node.name) || "h5".equals(node.name) || "h6".equals(node.name) || (node.ancestorMask & H1_MASK) != 0 || (node.ancestorMask & H2_MASK) != 0 || (node.ancestorMask & H3_MASK) != 0 || (node.ancestorMask & H4_MASK) != 0 || (node.ancestorMask & H5_MASK) != 0 || (node.ancestorMask & H6_MASK) != 0) {
                        this.stack[this.currentHeadingPtr].setTextNodeFound();
                    } else if ("figcaption".equals(node.name) || (node.ancestorMask & FIGCAPTION_MASK) != 0) {
                        if ((node.ancestorMask & FIGURE_MASK) != 0) {
                            this.stack[this.currentFigurePtr].setFigcaptionContentFound();
                        }
                        for (int j = 1; j < this.currentFigurePtr; ++j) {
                            if (!"figure".equals(this.stack[this.currentFigurePtr - j].getName())) continue;
                            this.stack[this.currentFigurePtr - j].setTextNodeFound();
                        }
                    } else if ("figure".equals(node.name) || (node.ancestorMask & FIGURE_MASK) != 0) {
                        this.stack[this.currentFigurePtr].setTextNodeFound();
                        for (int k = 1; k < this.currentFigurePtr; ++k) {
                            if (!"figure".equals(this.stack[this.currentFigurePtr - k].getName())) continue;
                            this.stack[this.currentFigurePtr - k].setTextNodeFound();
                        }
                    } else if ("option".equals(node.name) && !this.stack[this.currentPtr - 1].hasOption() && (!this.stack[this.currentPtr - 1].hasEmptyValueOption() || this.stack[this.currentPtr - 1].hasNoValueOption()) && this.stack[this.currentPtr - 1].nonEmptyOptionLocator() == null) {
                        this.stack[this.currentPtr - 1].setNonEmptyOption(new LocatorImpl(this.getDocumentLocator()));
                    }
                    return;
                }
            }
        }
    }

    private CharSequence renderTypeList(String[] types) {
        StringBuilder sb = new StringBuilder();
        int len = types.length;
        for (int i = 0; i < len; ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            if (i == len - 1) {
                sb.append("or ");
            }
            sb.append("\u201c");
            sb.append(types[i]);
            sb.append('\u201d');
        }
        return sb;
    }

    private CharSequence renderRoleSet(Set<String> roles) {
        boolean first = true;
        StringBuilder sb = new StringBuilder();
        for (String role : roles) {
            if (first) {
                first = false;
            } else {
                sb.append(" or ");
            }
            sb.append("\u201crole=");
            sb.append(role);
            sb.append('\u201d');
        }
        return sb;
    }

    static {
        INPUT_ATTRIBUTES.put("autocomplete", new String[]{"hidden", "text", "search", "url", "tel", "email", "password", "date", "month", "week", "time", "datetime-local", "number", "range", "color"});
        INPUT_ATTRIBUTES.put("list", new String[]{"text", "search", "url", "tel", "email", "date", "month", "week", "time", "datetime-local", "number", "range", "color"});
        INPUT_ATTRIBUTES.put("maxlength", new String[]{"text", "search", "url", "tel", "email", "password"});
        INPUT_ATTRIBUTES.put("minlength", new String[]{"text", "search", "url", "tel", "email", "password"});
        INPUT_ATTRIBUTES.put("pattern", new String[]{"text", "search", "url", "tel", "email", "password"});
        INPUT_ATTRIBUTES.put("placeholder", new String[]{"text", "search", "url", "tel", "email", "password", "number"});
        INPUT_ATTRIBUTES.put("readonly", new String[]{"text", "search", "url", "tel", "email", "password", "date", "month", "week", "time", "datetime-local", "number"});
        INPUT_ATTRIBUTES.put("required", new String[]{"text", "search", "url", "tel", "email", "password", "date", "month", "week", "time", "datetime-local", "number", "checkbox", "radio", "file"});
        INPUT_ATTRIBUTES.put("size", new String[]{"text", "search", "url", "tel", "email", "password"});
        for (Object[] objectArray : INPUT_ATTRIBUTES.values()) {
            Arrays.sort(objectArray);
        }
        OBSOLETE_ELEMENTS = new HashMap<String, String>();
        OBSOLETE_ELEMENTS.put("keygen", "");
        OBSOLETE_ELEMENTS.put("center", "Use CSS instead.");
        OBSOLETE_ELEMENTS.put("font", "Use CSS instead.");
        OBSOLETE_ELEMENTS.put("big", "Use CSS instead.");
        OBSOLETE_ELEMENTS.put("strike", "Use CSS instead.");
        OBSOLETE_ELEMENTS.put("tt", "Use CSS instead.");
        OBSOLETE_ELEMENTS.put("acronym", "Use the \u201cabbr\u201d element instead.");
        OBSOLETE_ELEMENTS.put("dir", "Use the \u201cul\u201d element instead.");
        OBSOLETE_ELEMENTS.put("applet", "Use the \u201cobject\u201d element instead.");
        OBSOLETE_ELEMENTS.put("basefont", "Use CSS instead.");
        OBSOLETE_ELEMENTS.put("frameset", "Use the \u201ciframe\u201d element and CSS instead, or use server-side includes.");
        OBSOLETE_ELEMENTS.put("noframes", "Use the \u201ciframe\u201d element and CSS instead, or use server-side includes.");
        OBSOLETE_ATTRIBUTES = new HashMap<String, String[]>();
        OBSOLETE_ATTRIBUTES.put("abbr", new String[]{"td"});
        OBSOLETE_ATTRIBUTES.put("archive", new String[]{"object"});
        OBSOLETE_ATTRIBUTES.put("axis", new String[]{"td", "th"});
        OBSOLETE_ATTRIBUTES.put("charset", new String[]{"link", "a"});
        OBSOLETE_ATTRIBUTES.put("classid", new String[]{"object"});
        OBSOLETE_ATTRIBUTES.put("code", new String[]{"object"});
        OBSOLETE_ATTRIBUTES.put("codebase", new String[]{"object"});
        OBSOLETE_ATTRIBUTES.put("codetype", new String[]{"object"});
        OBSOLETE_ATTRIBUTES.put("coords", new String[]{"a"});
        OBSOLETE_ATTRIBUTES.put("datafld", new String[]{"span", "div", "object", "input", "select", "textarea", "button", "table"});
        OBSOLETE_ATTRIBUTES.put("dataformatas", new String[]{"span", "div", "object", "input", "select", "textarea", "button", "table"});
        OBSOLETE_ATTRIBUTES.put("datasrc", new String[]{"span", "div", "object", "input", "select", "textarea", "button", "table"});
        OBSOLETE_ATTRIBUTES.put("datapagesize", new String[]{"table"});
        OBSOLETE_ATTRIBUTES.put("declare", new String[]{"object"});
        OBSOLETE_ATTRIBUTES.put("event", new String[]{"script"});
        OBSOLETE_ATTRIBUTES.put("for", new String[]{"script"});
        OBSOLETE_ATTRIBUTES.put("language", new String[]{"script"});
        OBSOLETE_ATTRIBUTES.put("longdesc", new String[]{"img", "iframe"});
        OBSOLETE_ATTRIBUTES.put("methods", new String[]{"link", "a"});
        OBSOLETE_ATTRIBUTES.put("name", new String[]{"img", "embed", "option"});
        OBSOLETE_ATTRIBUTES.put("nohref", new String[]{"area"});
        OBSOLETE_ATTRIBUTES.put("profile", new String[]{"head"});
        OBSOLETE_ATTRIBUTES.put("scheme", new String[]{"meta"});
        OBSOLETE_ATTRIBUTES.put("scope", new String[]{"td"});
        OBSOLETE_ATTRIBUTES.put("shape", new String[]{"a"});
        OBSOLETE_ATTRIBUTES.put("standby", new String[]{"object"});
        OBSOLETE_ATTRIBUTES.put("target", new String[]{"link"});
        OBSOLETE_ATTRIBUTES.put("type", new String[]{"param"});
        OBSOLETE_ATTRIBUTES.put("urn", new String[]{"a", "link"});
        OBSOLETE_ATTRIBUTES.put("usemap", new String[]{"input"});
        OBSOLETE_ATTRIBUTES.put("valuetype", new String[]{"param"});
        OBSOLETE_ATTRIBUTES.put("version", new String[]{"html"});
        for (Object[] objectArray : OBSOLETE_ATTRIBUTES.values()) {
            Arrays.sort(objectArray);
        }
        OBSOLETE_ATTRIBUTES_MSG = new HashMap<String, String>();
        OBSOLETE_ATTRIBUTES_MSG.put("abbr", "Consider instead beginning the cell contents with concise text, followed by further elaboration if needed.");
        OBSOLETE_ATTRIBUTES_MSG.put("archive", "Use the \u201cdata\u201d and \u201ctype\u201d attributes to invoke plugins. To set a parameter with the name \u201carchive\u201d, use the \u201cparam\u201d element.");
        OBSOLETE_ATTRIBUTES_MSG.put("axis", "Use the \u201cscope\u201d attribute.");
        OBSOLETE_ATTRIBUTES_MSG.put("charset", "Use an HTTP Content-Type header on the linked resource instead.");
        OBSOLETE_ATTRIBUTES_MSG.put("classid", "Use the \u201cdata\u201d and \u201ctype\u201d attributes to invoke plugins. To set a parameter with the name \u201cclassid\u201d, use the \u201cparam\u201d element.");
        OBSOLETE_ATTRIBUTES_MSG.put("code", "Use the \u201cdata\u201d and \u201ctype\u201d attributes to invoke plugins. To set a parameter with the name \u201ccode\u201d, use the \u201cparam\u201d element.");
        OBSOLETE_ATTRIBUTES_MSG.put("codebase", "Use the \u201cdata\u201d and \u201ctype\u201d attributes to invoke plugins. To set a parameter with the name \u201ccodebase\u201d, use the \u201cparam\u201d element.");
        OBSOLETE_ATTRIBUTES_MSG.put("codetype", "Use the \u201cdata\u201d and \u201ctype\u201d attributes to invoke plugins. To set a parameter with the name \u201ccodetype\u201d, use the \u201cparam\u201d element.");
        OBSOLETE_ATTRIBUTES_MSG.put("coords", "Use \u201carea\u201d instead of \u201ca\u201d for image maps.");
        OBSOLETE_ATTRIBUTES_MSG.put("datapagesize", "You can safely omit it.");
        OBSOLETE_ATTRIBUTES_MSG.put("datafld", "Use script and a mechanism such as XMLHttpRequest to populate the page dynamically");
        OBSOLETE_ATTRIBUTES_MSG.put("dataformatas", "Use script and a mechanism such as XMLHttpRequest to populate the page dynamically");
        OBSOLETE_ATTRIBUTES_MSG.put("datasrc", "Use script and a mechanism such as XMLHttpRequest to populate the page dynamically");
        OBSOLETE_ATTRIBUTES_MSG.put("for", "Use DOM Events mechanisms to register event listeners.");
        OBSOLETE_ATTRIBUTES_MSG.put("event", "Use DOM Events mechanisms to register event listeners.");
        OBSOLETE_ATTRIBUTES_MSG.put("declare", "Repeat the \u201cobject\u201d element completely each time the resource is to be reused.");
        OBSOLETE_ATTRIBUTES_MSG.put("language", "Use the \u201ctype\u201d attribute instead.");
        OBSOLETE_ATTRIBUTES_MSG.put("longdesc", "Use a regular \u201ca\u201d element to link to the description.");
        OBSOLETE_ATTRIBUTES_MSG.put("methods", "Use the HTTP OPTIONS feature instead.");
        OBSOLETE_ATTRIBUTES_MSG.put("name", "Use the \u201cid\u201d attribute instead.");
        OBSOLETE_ATTRIBUTES_MSG.put("nohref", "Omitting the \u201chref\u201d attribute is sufficient.");
        OBSOLETE_ATTRIBUTES_MSG.put("profile", "To declare which \u201cmeta\u201d terms are used in the document, instead register the names as meta extensions. To trigger specific UA behaviors, use a \u201clink\u201d element instead.");
        OBSOLETE_ATTRIBUTES_MSG.put("scheme", "Use only one scheme per field, or make the scheme declaration part of the value.");
        OBSOLETE_ATTRIBUTES_MSG.put("scope", "Use the \u201cscope\u201d attribute on a \u201cth\u201d element instead.");
        OBSOLETE_ATTRIBUTES_MSG.put("shape", "Use \u201carea\u201d instead of \u201ca\u201d for image maps.");
        OBSOLETE_ATTRIBUTES_MSG.put("standby", "Optimise the linked resource so that it loads quickly or, at least, incrementally.");
        OBSOLETE_ATTRIBUTES_MSG.put("target", "You can safely omit it.");
        OBSOLETE_ATTRIBUTES_MSG.put("type", "Use the \u201cname\u201d and \u201cvalue\u201d attributes without declaring value types.");
        OBSOLETE_ATTRIBUTES_MSG.put("urn", "Specify the preferred persistent identifier using the \u201chref\u201d attribute instead.");
        OBSOLETE_ATTRIBUTES_MSG.put("usemap", "Use the \u201cimg\u201d element instead of the \u201cinput\u201d element for image maps.");
        OBSOLETE_ATTRIBUTES_MSG.put("valuetype", "Use the \u201cname\u201d and \u201cvalue\u201d attributes without declaring value types.");
        OBSOLETE_ATTRIBUTES_MSG.put("version", "You can safely omit it.");
        OBSOLETE_STYLE_ATTRS = new HashMap<String, String[]>();
        OBSOLETE_STYLE_ATTRS.put("align", new String[]{"caption", "iframe", "img", "input", "object", "embed", "legend", "table", "hr", "div", "h1", "h2", "h3", "h4", "h5", "h6", "p", "col", "colgroup", "tbody", "td", "tfoot", "th", "thead", "tr"});
        OBSOLETE_STYLE_ATTRS.put("alink", new String[]{"body"});
        OBSOLETE_STYLE_ATTRS.put("allowtransparency", new String[]{"iframe"});
        OBSOLETE_STYLE_ATTRS.put("background", new String[]{"body"});
        OBSOLETE_STYLE_ATTRS.put("bgcolor", new String[]{"table", "tr", "td", "th", "body"});
        OBSOLETE_STYLE_ATTRS.put("cellpadding", new String[]{"table"});
        OBSOLETE_STYLE_ATTRS.put("cellspacing", new String[]{"table"});
        OBSOLETE_STYLE_ATTRS.put("char", new String[]{"col", "colgroup", "tbody", "td", "tfoot", "th", "thead", "tr"});
        OBSOLETE_STYLE_ATTRS.put("charoff", new String[]{"col", "colgroup", "tbody", "td", "tfoot", "th", "thead", "tr"});
        OBSOLETE_STYLE_ATTRS.put("clear", new String[]{"br"});
        OBSOLETE_STYLE_ATTRS.put("color", new String[]{"hr"});
        OBSOLETE_STYLE_ATTRS.put("compact", new String[]{"dl", "menu", "ol", "ul"});
        OBSOLETE_STYLE_ATTRS.put("frameborder", new String[]{"iframe"});
        OBSOLETE_STYLE_ATTRS.put("frame", new String[]{"table"});
        OBSOLETE_STYLE_ATTRS.put("height", new String[]{"td", "th"});
        OBSOLETE_STYLE_ATTRS.put("hspace", new String[]{"embed", "iframe", "input", "img", "object"});
        OBSOLETE_STYLE_ATTRS.put("link", new String[]{"body"});
        OBSOLETE_STYLE_ATTRS.put("bottommargin", new String[]{"body"});
        OBSOLETE_STYLE_ATTRS.put("marginheight", new String[]{"iframe", "body"});
        OBSOLETE_STYLE_ATTRS.put("leftmargin", new String[]{"body"});
        OBSOLETE_STYLE_ATTRS.put("rightmargin", new String[]{"body"});
        OBSOLETE_STYLE_ATTRS.put("topmargin", new String[]{"body"});
        OBSOLETE_STYLE_ATTRS.put("marginwidth", new String[]{"iframe", "body"});
        OBSOLETE_STYLE_ATTRS.put("noshade", new String[]{"hr"});
        OBSOLETE_STYLE_ATTRS.put("nowrap", new String[]{"td", "th"});
        OBSOLETE_STYLE_ATTRS.put("rules", new String[]{"table"});
        OBSOLETE_STYLE_ATTRS.put("scrolling", new String[]{"iframe"});
        OBSOLETE_STYLE_ATTRS.put("size", new String[]{"hr"});
        OBSOLETE_STYLE_ATTRS.put("text", new String[]{"body"});
        OBSOLETE_STYLE_ATTRS.put("type", new String[]{"li", "ul"});
        OBSOLETE_STYLE_ATTRS.put("valign", new String[]{"col", "colgroup", "tbody", "td", "tfoot", "th", "thead", "tr"});
        OBSOLETE_STYLE_ATTRS.put("vlink", new String[]{"body"});
        OBSOLETE_STYLE_ATTRS.put("vspace", new String[]{"embed", "iframe", "input", "img", "object"});
        OBSOLETE_STYLE_ATTRS.put("width", new String[]{"hr", "table", "td", "th", "col", "colgroup", "pre"});
        for (Object[] objectArray : OBSOLETE_STYLE_ATTRS.values()) {
            Arrays.sort(objectArray);
        }
        JAVASCRIPT_MIME_TYPES = new HashSet();
        JAVASCRIPT_MIME_TYPES.add("application/ecmascript");
        JAVASCRIPT_MIME_TYPES.add("application/javascript");
        JAVASCRIPT_MIME_TYPES.add("application/x-ecmascript");
        JAVASCRIPT_MIME_TYPES.add("application/x-javascript");
        JAVASCRIPT_MIME_TYPES.add("text/ecmascript");
        JAVASCRIPT_MIME_TYPES.add("text/javascript");
        JAVASCRIPT_MIME_TYPES.add("text/javascript1.0");
        JAVASCRIPT_MIME_TYPES.add("text/javascript1.1");
        JAVASCRIPT_MIME_TYPES.add("text/javascript1.2");
        JAVASCRIPT_MIME_TYPES.add("text/javascript1.3");
        JAVASCRIPT_MIME_TYPES.add("text/javascript1.4");
        JAVASCRIPT_MIME_TYPES.add("text/javascript1.5");
        JAVASCRIPT_MIME_TYPES.add("text/jscript");
        JAVASCRIPT_MIME_TYPES.add("text/livescript");
        JAVASCRIPT_MIME_TYPES.add("text/x-ecmascript");
        JAVASCRIPT_MIME_TYPES.add("text/x-javascript");
        INTERACTIVE_ELEMENTS = new String[]{"a", "button", "details", "embed", "iframe", "label", "select", "textarea"};
        INTERACTIVE_ROLES = new String[]{"button", "checkbox", "combobox", "grid", "gridcell", "listbox", "menu", "menubar", "menuitem", "menuitemcheckbox", "menuitemradio", "option", "radio", "scrollbar", "searchbox", "slider", "spinbutton", "switch", "tab", "textbox", "treeitem"};
        PROHIBITED_INTERACTIVE_ANCESTOR_ROLES = new String[]{"button", "link"};
        PROHIBITED_MAIN_ANCESTORS = new String[]{"a", "address", "article", "aside", "audio", "blockquote", "canvas", "caption", "dd", "del", "details", "dialog", "dt", "fieldset", "figure", "footer", "header", "ins", "li", "main", "map", "nav", "noscript", "object", "section", "slot", "td", "th", "video"};
        SPECIAL_ANCESTORS = new String[]{"a", "address", "body", "button", "caption", "dfn", "dt", "figcaption", "figure", "footer", "form", "header", "label", "map", "noscript", "th", "time", "progress", "meter", "article", "section", "aside", "nav", "h1", "h2", "h3", "h4", "h5", "h6"};
        ANCESTOR_MASK_BY_DESCENDANT = new HashMap<String, Integer>();
        Assertions.registerProhibitedAncestor("form", "form");
        Assertions.registerProhibitedAncestor("progress", "progress");
        Assertions.registerProhibitedAncestor("meter", "meter");
        Assertions.registerProhibitedAncestor("dfn", "dfn");
        Assertions.registerProhibitedAncestor("noscript", "noscript");
        Assertions.registerProhibitedAncestor("label", "label");
        Assertions.registerProhibitedAncestor("address", "address");
        Assertions.registerProhibitedAncestor("address", "section");
        Assertions.registerProhibitedAncestor("address", "nav");
        Assertions.registerProhibitedAncestor("address", "article");
        Assertions.registerProhibitedAncestor("header", "header");
        Assertions.registerProhibitedAncestor("footer", "header");
        Assertions.registerProhibitedAncestor("address", "header");
        Assertions.registerProhibitedAncestor("header", "footer");
        Assertions.registerProhibitedAncestor("footer", "footer");
        Assertions.registerProhibitedAncestor("dt", "header");
        Assertions.registerProhibitedAncestor("dt", "footer");
        Assertions.registerProhibitedAncestor("dt", "article");
        Assertions.registerProhibitedAncestor("dt", "nav");
        Assertions.registerProhibitedAncestor("dt", "section");
        Assertions.registerProhibitedAncestor("dt", "h1");
        Assertions.registerProhibitedAncestor("dt", "h2");
        Assertions.registerProhibitedAncestor("dt", "h2");
        Assertions.registerProhibitedAncestor("dt", "h3");
        Assertions.registerProhibitedAncestor("dt", "h4");
        Assertions.registerProhibitedAncestor("dt", "h5");
        Assertions.registerProhibitedAncestor("dt", "h6");
        Assertions.registerProhibitedAncestor("dt", "hgroup");
        Assertions.registerProhibitedAncestor("th", "header");
        Assertions.registerProhibitedAncestor("th", "footer");
        Assertions.registerProhibitedAncestor("th", "article");
        Assertions.registerProhibitedAncestor("th", "nav");
        Assertions.registerProhibitedAncestor("th", "section");
        Assertions.registerProhibitedAncestor("th", "h1");
        Assertions.registerProhibitedAncestor("th", "h2");
        Assertions.registerProhibitedAncestor("th", "h2");
        Assertions.registerProhibitedAncestor("th", "h3");
        Assertions.registerProhibitedAncestor("th", "h4");
        Assertions.registerProhibitedAncestor("th", "h5");
        Assertions.registerProhibitedAncestor("th", "h6");
        Assertions.registerProhibitedAncestor("th", "hgroup");
        Assertions.registerProhibitedAncestor("address", "footer");
        Assertions.registerProhibitedAncestor("address", "h1");
        Assertions.registerProhibitedAncestor("address", "h2");
        Assertions.registerProhibitedAncestor("address", "h3");
        Assertions.registerProhibitedAncestor("address", "h4");
        Assertions.registerProhibitedAncestor("address", "h5");
        Assertions.registerProhibitedAncestor("address", "h6");
        Assertions.registerProhibitedAncestor("caption", "table");
        for (String elementName : INTERACTIVE_ELEMENTS) {
            Assertions.registerProhibitedAncestor("a", elementName);
            Assertions.registerProhibitedAncestor("button", elementName);
        }
        BODY_MASK = 1 << Assertions.specialAncestorNumber("body");
        A_BUTTON_MASK = 1 << Assertions.specialAncestorNumber("a") | 1 << Assertions.specialAncestorNumber("button");
        FIGCAPTION_MASK = 1 << Assertions.specialAncestorNumber("figcaption");
        FIGURE_MASK = 1 << Assertions.specialAncestorNumber("figure");
        H1_MASK = 1 << Assertions.specialAncestorNumber("h1");
        H2_MASK = 1 << Assertions.specialAncestorNumber("h2");
        H3_MASK = 1 << Assertions.specialAncestorNumber("h3");
        H4_MASK = 1 << Assertions.specialAncestorNumber("h4");
        H5_MASK = 1 << Assertions.specialAncestorNumber("h5");
        H6_MASK = 1 << Assertions.specialAncestorNumber("h6");
        MAP_MASK = 1 << Assertions.specialAncestorNumber("map");
        REQUIRED_ROLE_ANCESTOR_BY_DESCENDANT = new HashMap<String, Set<String>>();
        ariaOwnsIdsByRole = new HashMap<String, Set<String>>();
        Assertions.registerRequiredAncestorRole("listbox", "option");
        Assertions.registerRequiredAncestorRole("menu", "menuitem");
        Assertions.registerRequiredAncestorRole("menu", "menuitemcheckbox");
        Assertions.registerRequiredAncestorRole("menu", "menuitemradio");
        Assertions.registerRequiredAncestorRole("menubar", "menuitem");
        Assertions.registerRequiredAncestorRole("menubar", "menuitemcheckbox");
        Assertions.registerRequiredAncestorRole("menubar", "menuitemradio");
        Assertions.registerRequiredAncestorRole("tablist", "tab");
        Assertions.registerRequiredAncestorRole("tree", "treeitem");
        Assertions.registerRequiredAncestorRole("group", "treeitem");
        Assertions.registerRequiredAncestorRole("group", "listitem");
        Assertions.registerRequiredAncestorRole("group", "menuitemradio");
        Assertions.registerRequiredAncestorRole("list", "listitem");
        Assertions.registerRequiredAncestorRole("row", "cell");
        Assertions.registerRequiredAncestorRole("row", "gridcell");
        Assertions.registerRequiredAncestorRole("row", "columnheader");
        Assertions.registerRequiredAncestorRole("row", "rowheader");
        Assertions.registerRequiredAncestorRole("grid", "row");
        Assertions.registerRequiredAncestorRole("grid", "rowgroup");
        Assertions.registerRequiredAncestorRole("rowgroup", "row");
        Assertions.registerRequiredAncestorRole("treegrid", "row");
        Assertions.registerRequiredAncestorRole("treegrid", "rowgroup");
        Assertions.registerRequiredAncestorRole("table", "rowgroup");
        Assertions.registerRequiredAncestorRole("table", "row");
        MUST_NOT_DANGLE_IDREFS = new HashSet<String>();
        MUST_NOT_DANGLE_IDREFS.add("aria-controls");
        MUST_NOT_DANGLE_IDREFS.add("aria-describedby");
        MUST_NOT_DANGLE_IDREFS.add("aria-flowto");
        MUST_NOT_DANGLE_IDREFS.add("aria-labelledby");
        MUST_NOT_DANGLE_IDREFS.add("aria-owns");
        ELEMENTS_WITH_IMPLICIT_ROLE = new HashMap<String, String>();
        ELEMENTS_WITH_IMPLICIT_ROLE.put("article", "article");
        ELEMENTS_WITH_IMPLICIT_ROLE.put("aside", "complementary");
        ELEMENTS_WITH_IMPLICIT_ROLE.put("body", "document");
        ELEMENTS_WITH_IMPLICIT_ROLE.put("button", "button");
        ELEMENTS_WITH_IMPLICIT_ROLE.put("datalist", "listbox");
        ELEMENTS_WITH_IMPLICIT_ROLE.put("dd", "definition");
        ELEMENTS_WITH_IMPLICIT_ROLE.put("details", "group");
        ELEMENTS_WITH_IMPLICIT_ROLE.put("dialog", "dialog");
        ELEMENTS_WITH_IMPLICIT_ROLE.put("dt", "term");
        ELEMENTS_WITH_IMPLICIT_ROLE.put("fieldset", "group");
        ELEMENTS_WITH_IMPLICIT_ROLE.put("figure", "figure");
        ELEMENTS_WITH_IMPLICIT_ROLE.put("form", "form");
        ELEMENTS_WITH_IMPLICIT_ROLE.put("footer", "contentinfo");
        ELEMENTS_WITH_IMPLICIT_ROLE.put("h1", "heading");
        ELEMENTS_WITH_IMPLICIT_ROLE.put("h2", "heading");
        ELEMENTS_WITH_IMPLICIT_ROLE.put("h3", "heading");
        ELEMENTS_WITH_IMPLICIT_ROLE.put("h4", "heading");
        ELEMENTS_WITH_IMPLICIT_ROLE.put("h5", "heading");
        ELEMENTS_WITH_IMPLICIT_ROLE.put("h6", "heading");
        ELEMENTS_WITH_IMPLICIT_ROLE.put("hr", "separator");
        ELEMENTS_WITH_IMPLICIT_ROLE.put("header", "banner");
        ELEMENTS_WITH_IMPLICIT_ROLE.put("img", "img");
        ELEMENTS_WITH_IMPLICIT_ROLE.put("li", "listitem");
        ELEMENTS_WITH_IMPLICIT_ROLE.put("link", "link");
        ELEMENTS_WITH_IMPLICIT_ROLE.put("main", "main");
        ELEMENTS_WITH_IMPLICIT_ROLE.put("nav", "navigation");
        ELEMENTS_WITH_IMPLICIT_ROLE.put("ol", "list");
        ELEMENTS_WITH_IMPLICIT_ROLE.put("output", "status");
        ELEMENTS_WITH_IMPLICIT_ROLE.put("progress", "progressbar");
        ELEMENTS_WITH_IMPLICIT_ROLE.put("section", "region");
        ELEMENTS_WITH_IMPLICIT_ROLE.put("summary", "button");
        ELEMENTS_WITH_IMPLICIT_ROLE.put("table", "table");
        ELEMENTS_WITH_IMPLICIT_ROLE.put("tbody", "rowgroup");
        ELEMENTS_WITH_IMPLICIT_ROLE.put("textarea", "textbox");
        ELEMENTS_WITH_IMPLICIT_ROLE.put("tfoot", "rowgroup");
        ELEMENTS_WITH_IMPLICIT_ROLE.put("thead", "rowgroup");
        ELEMENTS_WITH_IMPLICIT_ROLE.put("td", "cell");
        ELEMENTS_WITH_IMPLICIT_ROLE.put("tr", "row");
        ELEMENTS_WITH_IMPLICIT_ROLE.put("ul", "list");
        ELEMENTS_WITH_IMPLICIT_ROLES = new HashMap<String, String[]>();
        ELEMENTS_WITH_IMPLICIT_ROLES.put("th", new String[]{"columnheader", "rowheader"});
        ELEMENTS_THAT_NEVER_NEED_ROLE = new HashMap<String, String>();
        ELEMENTS_THAT_NEVER_NEED_ROLE.put("body", "document");
        ELEMENTS_THAT_NEVER_NEED_ROLE.put("datalist", "listbox");
        ELEMENTS_THAT_NEVER_NEED_ROLE.put("details", "group");
        ELEMENTS_THAT_NEVER_NEED_ROLE.put("form", "form");
        ELEMENTS_THAT_NEVER_NEED_ROLE.put("main", "main");
        ELEMENTS_THAT_NEVER_NEED_ROLE.put("meter", "progressbar");
        ELEMENTS_THAT_NEVER_NEED_ROLE.put("nav", "navigation");
        ELEMENTS_THAT_NEVER_NEED_ROLE.put("option", "option");
        ELEMENTS_THAT_NEVER_NEED_ROLE.put("optgroup", "group");
        ELEMENTS_THAT_NEVER_NEED_ROLE.put("progress", "progressbar");
        ELEMENTS_THAT_NEVER_NEED_ROLE.put("summary", "button");
        ELEMENTS_THAT_NEVER_NEED_ROLE.put("textarea", "textbox");
        INPUT_TYPES_WITH_IMPLICIT_ROLE = new HashMap<String, String>();
        INPUT_TYPES_WITH_IMPLICIT_ROLE.put("button", "button");
        INPUT_TYPES_WITH_IMPLICIT_ROLE.put("checkbox", "checkbox");
        INPUT_TYPES_WITH_IMPLICIT_ROLE.put("image", "button");
        INPUT_TYPES_WITH_IMPLICIT_ROLE.put("number", "spinbutton");
        INPUT_TYPES_WITH_IMPLICIT_ROLE.put("radio", "radio");
        INPUT_TYPES_WITH_IMPLICIT_ROLE.put("range", "slider");
        INPUT_TYPES_WITH_IMPLICIT_ROLE.put("reset", "button");
        INPUT_TYPES_WITH_IMPLICIT_ROLE.put("submit", "button");
        ATTRIBUTES_WITH_IMPLICIT_STATE_OR_PROPERTY = new HashSet<String>();
        ATTRIBUTES_WITH_IMPLICIT_STATE_OR_PROPERTY.add("disabled");
        ATTRIBUTES_WITH_IMPLICIT_STATE_OR_PROPERTY.add("hidden");
        ATTRIBUTES_WITH_IMPLICIT_STATE_OR_PROPERTY.add("readonly");
        ATTRIBUTES_WITH_IMPLICIT_STATE_OR_PROPERTY.add("required");
    }

    private class StackNode {
        private final int ancestorMask;
        private final String name;
        private final StringBuilder textContent;
        private final String role;
        private final String activeDescendant;
        private final String forAttr;
        private Set<Locator> imagesLackingAlt = new HashSet<Locator>();
        private Locator nonEmptyOption = null;
        private Locator locator = null;
        private boolean selectedOptions = false;
        private boolean labeledDescendants = false;
        private boolean trackDescendants = false;
        private boolean textNodeFound = false;
        private boolean imgFound = false;
        private boolean embeddedContentFound = false;
        private boolean figcaptionNeeded = false;
        private boolean figcaptionContentFound = false;
        private boolean headingFound = false;
        private boolean optionNeeded = false;
        private boolean optionFound = false;
        private boolean noValueOptionFound = false;
        private boolean emptyValueOptionFound = false;
        private boolean isCollectingCharacters = false;

        public StackNode(int ancestorMask, String name, String role, String activeDescendant, String forAttr) {
            this.ancestorMask = ancestorMask;
            this.name = name;
            this.role = role;
            this.activeDescendant = activeDescendant;
            this.forAttr = forAttr;
            this.textContent = new StringBuilder();
        }

        public int getAncestorMask() {
            return this.ancestorMask;
        }

        public String getName() {
            return this.name;
        }

        public boolean isSelectedOptions() {
            return this.selectedOptions;
        }

        public void setSelectedOptions() {
            this.selectedOptions = true;
        }

        public boolean isLabeledDescendants() {
            return this.labeledDescendants;
        }

        public void setLabeledDescendants() {
            this.labeledDescendants = true;
        }

        public boolean isTrackDescendant() {
            return this.trackDescendants;
        }

        public void setTrackDescendants() {
            this.trackDescendants = true;
        }

        public String getRole() {
            return this.role;
        }

        public String getActiveDescendant() {
            return this.activeDescendant;
        }

        public String getForAttr() {
            return this.forAttr;
        }

        public boolean hasTextNode() {
            return this.textNodeFound;
        }

        public void setTextNodeFound() {
            this.textNodeFound = true;
        }

        public boolean hasImg() {
            return this.imgFound;
        }

        public void setImgFound() {
            this.imgFound = true;
        }

        public boolean hasEmbeddedContent() {
            return this.embeddedContentFound;
        }

        public void setEmbeddedContentFound() {
            this.embeddedContentFound = true;
        }

        public boolean needsFigcaption() {
            return this.figcaptionNeeded;
        }

        public void setFigcaptionNeeded() {
            this.figcaptionNeeded = true;
        }

        public boolean hasFigcaptionContent() {
            return this.figcaptionContentFound;
        }

        public void setFigcaptionContentFound() {
            this.figcaptionContentFound = true;
        }

        public boolean hasHeading() {
            return this.headingFound;
        }

        public void setHeadingFound() {
            this.headingFound = true;
        }

        public Set<Locator> getImagesLackingAlt() {
            return this.imagesLackingAlt;
        }

        public void addImageLackingAlt(Locator locator) {
            this.imagesLackingAlt.add(locator);
        }

        public boolean isOptionNeeded() {
            return this.optionNeeded;
        }

        public void setOptionNeeded() {
            this.optionNeeded = true;
        }

        public boolean hasOption() {
            return this.optionFound;
        }

        public void setOptionFound() {
            this.optionFound = true;
        }

        public boolean hasNoValueOption() {
            return this.noValueOptionFound;
        }

        public void setNoValueOptionFound() {
            this.noValueOptionFound = true;
        }

        public boolean hasEmptyValueOption() {
            return this.emptyValueOptionFound;
        }

        public void setEmptyValueOptionFound() {
            this.emptyValueOptionFound = true;
        }

        public Locator nonEmptyOptionLocator() {
            return this.nonEmptyOption;
        }

        public void setNonEmptyOption(Locator locator) {
            this.nonEmptyOption = locator;
        }

        public void setIsCollectingCharacters(boolean isCollectingCharacters) {
            this.isCollectingCharacters = isCollectingCharacters;
        }

        public boolean getIsCollectingCharacters() {
            return this.isCollectingCharacters;
        }

        public void appendToTextContent(char[] ch, int start, int length) {
            this.textContent.append(ch, start, length);
        }

        public StringBuilder getTextContent() {
            return this.textContent;
        }

        public Locator locator() {
            return this.locator;
        }

        public void setLocator(Locator locator) {
            this.locator = locator;
        }
    }

    private class IdrefLocator {
        private final Locator locator;
        private final String idref;
        private final String additional;

        public IdrefLocator(Locator locator, String idref) {
            this.locator = new LocatorImpl(locator);
            this.idref = idref;
            this.additional = null;
        }

        public IdrefLocator(Locator locator, String idref, String additional) {
            this.locator = new LocatorImpl(locator);
            this.idref = idref;
            this.additional = additional;
        }

        public Locator getLocator() {
            return this.locator;
        }

        public String getIdref() {
            return this.idref;
        }

        public String getAdditional() {
            return this.additional;
        }
    }
}

