# coding: utf-8

"""
    Platform API Documentation

    Combined API documentation for all platform services

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictFloat, StrictInt, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional, Union
from typing import Optional, Set
from typing_extensions import Self

class UpdateSubscriptionSchemaDto(BaseModel):
    """
    UpdateSubscriptionSchemaDto
    """ # noqa: E501
    subscription_id: Optional[StrictStr] = Field(default=None, alias="subscriptionId")
    plan_id: StrictStr = Field(alias="planId")
    qty: Union[StrictFloat, StrictInt]
    org_friendly_id: StrictStr = Field(alias="orgFriendlyId")
    period: StrictStr
    group_id: StrictStr = Field(alias="groupId")
    existing_id: Optional[StrictStr] = Field(default=None, alias="existingId")
    payment_id: Optional[StrictStr] = Field(default=None, alias="paymentId")
    __properties: ClassVar[List[str]] = ["subscriptionId", "planId", "qty", "orgFriendlyId", "period", "groupId", "existingId", "paymentId"]

    @field_validator('period')
    def period_validate_enum(cls, value):
        """Validates the enum"""
        if value not in set(['Monthly', 'Yearly', 'Quarterly', 'SemiAnnual', '1', '2', '3', '4']):
            raise ValueError("must be one of enum values ('Monthly', 'Yearly', 'Quarterly', 'SemiAnnual', '1', '2', '3', '4')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of UpdateSubscriptionSchemaDto from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of UpdateSubscriptionSchemaDto from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "subscriptionId": obj.get("subscriptionId"),
            "planId": obj.get("planId"),
            "qty": obj.get("qty"),
            "orgFriendlyId": obj.get("orgFriendlyId"),
            "period": obj.get("period"),
            "groupId": obj.get("groupId"),
            "existingId": obj.get("existingId"),
            "paymentId": obj.get("paymentId")
        })
        return _obj


