# coding: utf-8

"""
    Platform API Documentation

    Combined API documentation for all platform services

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from typing import Optional, Set
from typing_extensions import Self

class UpdateMeInputSchemaDto(BaseModel):
    """
    UpdateMeInputSchemaDto
    """ # noqa: E501
    title: StrictStr
    industries: StrictStr
    expertise: StrictStr
    company: StrictStr
    first_name: Optional[StrictStr] = Field(default=None, alias="firstName")
    last_name: Optional[StrictStr] = Field(default=None, alias="lastName")
    new_password: Optional[StrictStr] = Field(default=None, alias="newPassword")
    email_notifications_disabled: Optional[StrictBool] = Field(default=None, alias="emailNotificationsDisabled")
    notifications_disabled: Optional[StrictBool] = Field(default=None, alias="notificationsDisabled")
    app_notifications_disabled: Optional[StrictBool] = Field(default=None, alias="appNotificationsDisabled")
    __properties: ClassVar[List[str]] = ["title", "industries", "expertise", "company", "firstName", "lastName", "newPassword", "emailNotificationsDisabled", "notificationsDisabled", "appNotificationsDisabled"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of UpdateMeInputSchemaDto from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of UpdateMeInputSchemaDto from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "title": obj.get("title"),
            "industries": obj.get("industries"),
            "expertise": obj.get("expertise"),
            "company": obj.get("company"),
            "firstName": obj.get("firstName"),
            "lastName": obj.get("lastName"),
            "newPassword": obj.get("newPassword"),
            "emailNotificationsDisabled": obj.get("emailNotificationsDisabled"),
            "notificationsDisabled": obj.get("notificationsDisabled"),
            "appNotificationsDisabled": obj.get("appNotificationsDisabled")
        })
        return _obj


