# coding: utf-8

"""
    Platform API Documentation

    Combined API documentation for all platform services

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from do_sdk_platform.models.update_execution_input_schema_dto_resources_used import UpdateExecutionInputSchemaDtoResourcesUsed
from typing import Optional, Set
from typing_extensions import Self

class UpdateExecutionInputSchemaDto(BaseModel):
    """
    UpdateExecutionInputSchemaDto
    """ # noqa: E501
    status: Optional[StrictStr] = None
    started_at: Optional[StrictStr] = Field(default=None, alias="startedAt")
    completed_at: Optional[StrictStr] = Field(default=None, alias="completedAt")
    job_outputs: Optional[Dict[str, Any]] = Field(default=None, alias="jobOutputs")
    resources_used: Optional[UpdateExecutionInputSchemaDtoResourcesUsed] = Field(default=None, alias="resourcesUsed")
    progress_report: Optional[StrictStr] = Field(default=None, alias="progressReport")
    metadata: Optional[Dict[str, Any]] = None
    name: Optional[StrictStr] = None
    __properties: ClassVar[List[str]] = ["status", "startedAt", "completedAt", "jobOutputs", "resourcesUsed", "progressReport", "metadata", "name"]

    @field_validator('status')
    def status_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['Quoted', 'FailedQuotation', 'Created', 'Accepted', 'Queued', 'Running', 'Suspended', 'Finishing', 'Succeeded', 'Failed', 'Cancelled', 'InsufficientFunds']):
            raise ValueError("must be one of enum values ('Quoted', 'FailedQuotation', 'Created', 'Accepted', 'Queued', 'Running', 'Suspended', 'Finishing', 'Succeeded', 'Failed', 'Cancelled', 'InsufficientFunds')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of UpdateExecutionInputSchemaDto from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of resources_used
        if self.resources_used:
            _dict['resourcesUsed'] = self.resources_used.to_dict()
        # set to None if started_at (nullable) is None
        # and model_fields_set contains the field
        if self.started_at is None and "started_at" in self.model_fields_set:
            _dict['startedAt'] = None

        # set to None if completed_at (nullable) is None
        # and model_fields_set contains the field
        if self.completed_at is None and "completed_at" in self.model_fields_set:
            _dict['completedAt'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of UpdateExecutionInputSchemaDto from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "status": obj.get("status"),
            "startedAt": obj.get("startedAt"),
            "completedAt": obj.get("completedAt"),
            "jobOutputs": obj.get("jobOutputs"),
            "resourcesUsed": UpdateExecutionInputSchemaDtoResourcesUsed.from_dict(obj["resourcesUsed"]) if obj.get("resourcesUsed") is not None else None,
            "progressReport": obj.get("progressReport"),
            "metadata": obj.get("metadata"),
            "name": obj.get("name")
        })
        return _obj


