# coding: utf-8

"""
    Platform API Documentation

    Combined API documentation for all platform services

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictFloat, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional, Union
from do_sdk_platform.models.tool_definition_schema_dto_inputs_const import ToolDefinitionSchemaDtoInputsConst
from do_sdk_platform.models.tool_definition_schema_dto_inputs_default import ToolDefinitionSchemaDtoInputsDefault
from do_sdk_platform.models.tool_definition_schema_dto_inputs_error_message_value import ToolDefinitionSchemaDtoInputsErrorMessageValue
from do_sdk_platform.models.tool_definition_schema_dto_inputs_exclusive_minimum import ToolDefinitionSchemaDtoInputsExclusiveMinimum
from do_sdk_platform.models.tool_definition_schema_dto_inputs_required import ToolDefinitionSchemaDtoInputsRequired
from do_sdk_platform.models.tool_definition_schema_dto_inputs_type import ToolDefinitionSchemaDtoInputsType
from typing import Optional, Set
from typing_extensions import Self

class ToolDefinitionSchemaDtoInputs(BaseModel):
    """
    ToolDefinitionSchemaDtoInputs
    """ # noqa: E501
    type: Optional[ToolDefinitionSchemaDtoInputsType] = None
    properties: Optional[Dict[str, Any]] = None
    additional_properties: Optional[StrictBool] = Field(default=None, alias="additionalProperties")
    unevaluated_properties: Optional[Any] = Field(default=None, alias="unevaluatedProperties")
    pattern_properties: Optional[Dict[str, Any]] = Field(default=None, alias="patternProperties")
    min_properties: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="minProperties")
    max_properties: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="maxProperties")
    required: Optional[ToolDefinitionSchemaDtoInputsRequired] = None
    property_names: Optional[Any] = Field(default=None, alias="propertyNames")
    x_deeporigin_path: Optional[StrictStr] = Field(default=None, alias="x-deeporigin-path")
    items: Optional[List[Any]] = None
    additional_items: Optional[Any] = Field(default=None, alias="additionalItems")
    min_items: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="minItems")
    max_items: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="maxItems")
    unique_items: Optional[StrictBool] = Field(default=None, alias="uniqueItems")
    min_length: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="minLength")
    max_length: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="maxLength")
    pattern: Optional[StrictStr] = None
    format: Optional[StrictStr] = None
    minimum: Optional[Union[StrictFloat, StrictInt]] = None
    maximum: Optional[Union[StrictFloat, StrictInt]] = None
    exclusive_minimum: Optional[ToolDefinitionSchemaDtoInputsExclusiveMinimum] = Field(default=None, alias="exclusiveMinimum")
    exclusive_maximum: Optional[ToolDefinitionSchemaDtoInputsExclusiveMinimum] = Field(default=None, alias="exclusiveMaximum")
    multiple_of: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="multipleOf")
    any_of: Optional[List[Any]] = Field(default=None, alias="anyOf")
    all_of: Optional[List[Any]] = Field(default=None, alias="allOf")
    one_of: Optional[List[Any]] = Field(default=None, alias="oneOf")
    var_if: Optional[Any] = Field(default=None, alias="if")
    then: Optional[Any] = None
    var_else: Optional[Any] = Field(default=None, alias="else")
    const: Optional[ToolDefinitionSchemaDtoInputsConst] = None
    enum: Optional[ToolDefinitionSchemaDtoInputsConst] = None
    default: Optional[ToolDefinitionSchemaDtoInputsDefault] = None
    error_message: Optional[Dict[str, Optional[ToolDefinitionSchemaDtoInputsErrorMessageValue]]] = Field(default=None, alias="errorMessage")
    __properties: ClassVar[List[str]] = ["type", "properties", "additionalProperties", "unevaluatedProperties", "patternProperties", "minProperties", "maxProperties", "required", "propertyNames", "x-deeporigin-path", "items", "additionalItems", "minItems", "maxItems", "uniqueItems", "minLength", "maxLength", "pattern", "format", "minimum", "maximum", "exclusiveMinimum", "exclusiveMaximum", "multipleOf", "anyOf", "allOf", "oneOf", "if", "then", "else", "const", "enum", "default", "errorMessage"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ToolDefinitionSchemaDtoInputs from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of type
        if self.type:
            _dict['type'] = self.type.to_dict()
        # override the default output from pydantic by calling `to_dict()` of required
        if self.required:
            _dict['required'] = self.required.to_dict()
        # override the default output from pydantic by calling `to_dict()` of exclusive_minimum
        if self.exclusive_minimum:
            _dict['exclusiveMinimum'] = self.exclusive_minimum.to_dict()
        # override the default output from pydantic by calling `to_dict()` of exclusive_maximum
        if self.exclusive_maximum:
            _dict['exclusiveMaximum'] = self.exclusive_maximum.to_dict()
        # override the default output from pydantic by calling `to_dict()` of const
        if self.const:
            _dict['const'] = self.const.to_dict()
        # override the default output from pydantic by calling `to_dict()` of enum
        if self.enum:
            _dict['enum'] = self.enum.to_dict()
        # override the default output from pydantic by calling `to_dict()` of default
        if self.default:
            _dict['default'] = self.default.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each value in error_message (dict)
        _field_dict = {}
        if self.error_message:
            for _key_error_message in self.error_message:
                if self.error_message[_key_error_message]:
                    _field_dict[_key_error_message] = self.error_message[_key_error_message].to_dict()
            _dict['errorMessage'] = _field_dict
        # set to None if unevaluated_properties (nullable) is None
        # and model_fields_set contains the field
        if self.unevaluated_properties is None and "unevaluated_properties" in self.model_fields_set:
            _dict['unevaluatedProperties'] = None

        # set to None if property_names (nullable) is None
        # and model_fields_set contains the field
        if self.property_names is None and "property_names" in self.model_fields_set:
            _dict['propertyNames'] = None

        # set to None if items (nullable) is None
        # and model_fields_set contains the field
        if self.items is None and "items" in self.model_fields_set:
            _dict['items'] = None

        # set to None if additional_items (nullable) is None
        # and model_fields_set contains the field
        if self.additional_items is None and "additional_items" in self.model_fields_set:
            _dict['additionalItems'] = None

        # set to None if var_if (nullable) is None
        # and model_fields_set contains the field
        if self.var_if is None and "var_if" in self.model_fields_set:
            _dict['if'] = None

        # set to None if then (nullable) is None
        # and model_fields_set contains the field
        if self.then is None and "then" in self.model_fields_set:
            _dict['then'] = None

        # set to None if var_else (nullable) is None
        # and model_fields_set contains the field
        if self.var_else is None and "var_else" in self.model_fields_set:
            _dict['else'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ToolDefinitionSchemaDtoInputs from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "type": ToolDefinitionSchemaDtoInputsType.from_dict(obj["type"]) if obj.get("type") is not None else None,
            "properties": obj.get("properties"),
            "additionalProperties": obj.get("additionalProperties"),
            "unevaluatedProperties": obj.get("unevaluatedProperties"),
            "patternProperties": obj.get("patternProperties"),
            "minProperties": obj.get("minProperties"),
            "maxProperties": obj.get("maxProperties"),
            "required": ToolDefinitionSchemaDtoInputsRequired.from_dict(obj["required"]) if obj.get("required") is not None else None,
            "propertyNames": obj.get("propertyNames"),
            "x-deeporigin-path": obj.get("x-deeporigin-path"),
            "items": obj.get("items"),
            "additionalItems": obj.get("additionalItems"),
            "minItems": obj.get("minItems"),
            "maxItems": obj.get("maxItems"),
            "uniqueItems": obj.get("uniqueItems"),
            "minLength": obj.get("minLength"),
            "maxLength": obj.get("maxLength"),
            "pattern": obj.get("pattern"),
            "format": obj.get("format"),
            "minimum": obj.get("minimum"),
            "maximum": obj.get("maximum"),
            "exclusiveMinimum": ToolDefinitionSchemaDtoInputsExclusiveMinimum.from_dict(obj["exclusiveMinimum"]) if obj.get("exclusiveMinimum") is not None else None,
            "exclusiveMaximum": ToolDefinitionSchemaDtoInputsExclusiveMinimum.from_dict(obj["exclusiveMaximum"]) if obj.get("exclusiveMaximum") is not None else None,
            "multipleOf": obj.get("multipleOf"),
            "anyOf": obj.get("anyOf"),
            "allOf": obj.get("allOf"),
            "oneOf": obj.get("oneOf"),
            "if": obj.get("if"),
            "then": obj.get("then"),
            "else": obj.get("else"),
            "const": ToolDefinitionSchemaDtoInputsConst.from_dict(obj["const"]) if obj.get("const") is not None else None,
            "enum": ToolDefinitionSchemaDtoInputsConst.from_dict(obj["enum"]) if obj.get("enum") is not None else None,
            "default": ToolDefinitionSchemaDtoInputsDefault.from_dict(obj["default"]) if obj.get("default") is not None else None,
            "errorMessage": dict(
                (_k, ToolDefinitionSchemaDtoInputsErrorMessageValue.from_dict(_v))
                for _k, _v in obj["errorMessage"].items()
            )
            if obj.get("errorMessage") is not None
            else None
        })
        return _obj


