# coding: utf-8

"""
    Platform API Documentation

    Combined API documentation for all platform services

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictFloat, StrictInt, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional, Union
from do_sdk_platform.models.tool_definition_schema_dto_executors_inner_environment_inner import ToolDefinitionSchemaDtoExecutorsInnerEnvironmentInner
from do_sdk_platform.models.tool_definition_schema_dto_executors_inner_ports_inner import ToolDefinitionSchemaDtoExecutorsInnerPortsInner
from do_sdk_platform.models.tool_definition_schema_dto_executors_inner_resource_requirements import ToolDefinitionSchemaDtoExecutorsInnerResourceRequirements
from do_sdk_platform.models.tool_definition_schema_dto_executors_inner_storage_requirements_inner import ToolDefinitionSchemaDtoExecutorsInnerStorageRequirementsInner
from typing import Optional, Set
from typing_extensions import Self

class ToolDefinitionSchemaDtoExecutorsInner(BaseModel):
    """
    ToolDefinitionSchemaDtoExecutorsInner
    """ # noqa: E501
    name: StrictStr
    head: StrictBool
    type: StrictStr
    restart_policy: StrictStr = Field(alias="restartPolicy")
    phase: Optional[Union[StrictFloat, StrictInt]] = None
    image: StrictStr
    command: Optional[List[StrictStr]] = None
    args: Optional[List[StrictStr]] = None
    working_directory: Optional[StrictStr] = Field(default=None, alias="workingDirectory")
    stdin: Optional[StrictStr] = None
    stdout: Optional[StrictStr] = None
    stderr: Optional[StrictStr] = None
    environment: List[ToolDefinitionSchemaDtoExecutorsInnerEnvironmentInner]
    ports: Optional[List[ToolDefinitionSchemaDtoExecutorsInnerPortsInner]] = None
    resource_requirements: ToolDefinitionSchemaDtoExecutorsInnerResourceRequirements = Field(alias="resourceRequirements")
    storage_requirements: List[ToolDefinitionSchemaDtoExecutorsInnerStorageRequirementsInner] = Field(alias="storageRequirements")
    active_deadline_seconds: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="activeDeadlineSeconds")
    backoff_limit: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="backoffLimit")
    __properties: ClassVar[List[str]] = ["name", "head", "type", "restartPolicy", "phase", "image", "command", "args", "workingDirectory", "stdin", "stdout", "stderr", "environment", "ports", "resourceRequirements", "storageRequirements", "activeDeadlineSeconds", "backoffLimit"]

    @field_validator('type')
    def type_validate_enum(cls, value):
        """Validates the enum"""
        if value not in set(['job', 'service']):
            raise ValueError("must be one of enum values ('job', 'service')")
        return value

    @field_validator('restart_policy')
    def restart_policy_validate_enum(cls, value):
        """Validates the enum"""
        if value not in set(['never', 'always', 'on-failure', 'exit-code']):
            raise ValueError("must be one of enum values ('never', 'always', 'on-failure', 'exit-code')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ToolDefinitionSchemaDtoExecutorsInner from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in environment (list)
        _items = []
        if self.environment:
            for _item_environment in self.environment:
                if _item_environment:
                    _items.append(_item_environment.to_dict())
            _dict['environment'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in ports (list)
        _items = []
        if self.ports:
            for _item_ports in self.ports:
                if _item_ports:
                    _items.append(_item_ports.to_dict())
            _dict['ports'] = _items
        # override the default output from pydantic by calling `to_dict()` of resource_requirements
        if self.resource_requirements:
            _dict['resourceRequirements'] = self.resource_requirements.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in storage_requirements (list)
        _items = []
        if self.storage_requirements:
            for _item_storage_requirements in self.storage_requirements:
                if _item_storage_requirements:
                    _items.append(_item_storage_requirements.to_dict())
            _dict['storageRequirements'] = _items
        # set to None if ports (nullable) is None
        # and model_fields_set contains the field
        if self.ports is None and "ports" in self.model_fields_set:
            _dict['ports'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ToolDefinitionSchemaDtoExecutorsInner from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "name": obj.get("name"),
            "head": obj.get("head"),
            "type": obj.get("type"),
            "restartPolicy": obj.get("restartPolicy"),
            "phase": obj.get("phase"),
            "image": obj.get("image"),
            "command": obj.get("command"),
            "args": obj.get("args"),
            "workingDirectory": obj.get("workingDirectory"),
            "stdin": obj.get("stdin"),
            "stdout": obj.get("stdout"),
            "stderr": obj.get("stderr"),
            "environment": [ToolDefinitionSchemaDtoExecutorsInnerEnvironmentInner.from_dict(_item) for _item in obj["environment"]] if obj.get("environment") is not None else None,
            "ports": [ToolDefinitionSchemaDtoExecutorsInnerPortsInner.from_dict(_item) for _item in obj["ports"]] if obj.get("ports") is not None else None,
            "resourceRequirements": ToolDefinitionSchemaDtoExecutorsInnerResourceRequirements.from_dict(obj["resourceRequirements"]) if obj.get("resourceRequirements") is not None else None,
            "storageRequirements": [ToolDefinitionSchemaDtoExecutorsInnerStorageRequirementsInner.from_dict(_item) for _item in obj["storageRequirements"]] if obj.get("storageRequirements") is not None else None,
            "activeDeadlineSeconds": obj.get("activeDeadlineSeconds"),
            "backoffLimit": obj.get("backoffLimit")
        })
        return _obj


