# coding: utf-8

"""
    Platform API Documentation

    Combined API documentation for all platform services

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictFloat, StrictInt, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional, Union
from typing_extensions import Annotated
from do_sdk_platform.models.tool_definition_schema_dto_billing_parser_executor_resource_requirements import ToolDefinitionSchemaDtoBillingParserExecutorResourceRequirements
from do_sdk_platform.models.tool_definition_schema_dto_executors_inner_environment_inner import ToolDefinitionSchemaDtoExecutorsInnerEnvironmentInner
from do_sdk_platform.models.tool_definition_schema_dto_executors_inner_ports_inner import ToolDefinitionSchemaDtoExecutorsInnerPortsInner
from typing import Optional, Set
from typing_extensions import Self

class ToolDefinitionSchemaDtoBillingParserExecutor(BaseModel):
    """
    ToolDefinitionSchemaDtoBillingParserExecutor
    """ # noqa: E501
    name: Annotated[str, Field(min_length=1, strict=True, max_length=63)]
    image: StrictStr
    port: Optional[ToolDefinitionSchemaDtoExecutorsInnerPortsInner] = None
    path: Optional[StrictStr] = None
    method: StrictStr
    timeout_seconds: Union[StrictFloat, StrictInt] = Field(alias="timeoutSeconds")
    response_start_timeout_seconds: Union[StrictFloat, StrictInt] = Field(alias="responseStartTimeoutSeconds")
    container_concurrency: Union[StrictFloat, StrictInt] = Field(alias="containerConcurrency")
    min_scale: Union[StrictFloat, StrictInt] = Field(alias="minScale")
    max_scale: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="maxScale")
    environment: Optional[List[ToolDefinitionSchemaDtoExecutorsInnerEnvironmentInner]] = None
    resource_requirements: ToolDefinitionSchemaDtoBillingParserExecutorResourceRequirements = Field(alias="resourceRequirements")
    scale_down_delay_seconds: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="scaleDownDelaySeconds")
    url: Optional[StrictStr] = None
    __properties: ClassVar[List[str]] = ["name", "image", "port", "path", "method", "timeoutSeconds", "responseStartTimeoutSeconds", "containerConcurrency", "minScale", "maxScale", "environment", "resourceRequirements", "scaleDownDelaySeconds", "url"]

    @field_validator('method')
    def method_validate_enum(cls, value):
        """Validates the enum"""
        if value not in set(['POST']):
            raise ValueError("must be one of enum values ('POST')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ToolDefinitionSchemaDtoBillingParserExecutor from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of port
        if self.port:
            _dict['port'] = self.port.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in environment (list)
        _items = []
        if self.environment:
            for _item_environment in self.environment:
                if _item_environment:
                    _items.append(_item_environment.to_dict())
            _dict['environment'] = _items
        # override the default output from pydantic by calling `to_dict()` of resource_requirements
        if self.resource_requirements:
            _dict['resourceRequirements'] = self.resource_requirements.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ToolDefinitionSchemaDtoBillingParserExecutor from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "name": obj.get("name"),
            "image": obj.get("image"),
            "port": ToolDefinitionSchemaDtoExecutorsInnerPortsInner.from_dict(obj["port"]) if obj.get("port") is not None else None,
            "path": obj.get("path"),
            "method": obj.get("method"),
            "timeoutSeconds": obj.get("timeoutSeconds"),
            "responseStartTimeoutSeconds": obj.get("responseStartTimeoutSeconds"),
            "containerConcurrency": obj.get("containerConcurrency"),
            "minScale": obj.get("minScale"),
            "maxScale": obj.get("maxScale"),
            "environment": [ToolDefinitionSchemaDtoExecutorsInnerEnvironmentInner.from_dict(_item) for _item in obj["environment"]] if obj.get("environment") is not None else None,
            "resourceRequirements": ToolDefinitionSchemaDtoBillingParserExecutorResourceRequirements.from_dict(obj["resourceRequirements"]) if obj.get("resourceRequirements") is not None else None,
            "scaleDownDelaySeconds": obj.get("scaleDownDelaySeconds"),
            "url": obj.get("url")
        })
        return _obj


