# coding: utf-8

"""
    Platform API Documentation

    Combined API documentation for all platform services

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from do_sdk_platform.models.tool_definition_schema_dto_billing_parser_executor import ToolDefinitionSchemaDtoBillingParserExecutor
from do_sdk_platform.models.tool_definition_schema_dto_changes import ToolDefinitionSchemaDtoChanges
from do_sdk_platform.models.tool_definition_schema_dto_examples_value import ToolDefinitionSchemaDtoExamplesValue
from do_sdk_platform.models.tool_definition_schema_dto_executors_inner import ToolDefinitionSchemaDtoExecutorsInner
from do_sdk_platform.models.tool_definition_schema_dto_inputs import ToolDefinitionSchemaDtoInputs
from typing import Optional, Set
from typing_extensions import Self

class ToolDefinitionInputSchemaDto(BaseModel):
    """
    ToolDefinitionInputSchemaDto
    """ # noqa: E501
    key: StrictStr
    version: StrictStr
    tool_manifest_version: StrictStr = Field(alias="toolManifestVersion")
    executors: List[ToolDefinitionSchemaDtoExecutorsInner]
    inputs: ToolDefinitionSchemaDtoInputs
    outputs: Optional[Any] = None
    examples: Optional[Dict[str, ToolDefinitionSchemaDtoExamplesValue]] = None
    example: Optional[Any] = None
    changes: Optional[ToolDefinitionSchemaDtoChanges] = None
    description: Optional[StrictStr] = None
    billing_parser: Optional[ToolDefinitionSchemaDtoBillingParserExecutor] = Field(default=None, alias="billingParser")
    __properties: ClassVar[List[str]] = ["key", "version", "toolManifestVersion", "executors", "inputs", "outputs", "examples", "example", "changes", "description", "billingParser"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ToolDefinitionInputSchemaDto from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in executors (list)
        _items = []
        if self.executors:
            for _item_executors in self.executors:
                if _item_executors:
                    _items.append(_item_executors.to_dict())
            _dict['executors'] = _items
        # override the default output from pydantic by calling `to_dict()` of inputs
        if self.inputs:
            _dict['inputs'] = self.inputs.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each value in examples (dict)
        _field_dict = {}
        if self.examples:
            for _key_examples in self.examples:
                if self.examples[_key_examples]:
                    _field_dict[_key_examples] = self.examples[_key_examples].to_dict()
            _dict['examples'] = _field_dict
        # override the default output from pydantic by calling `to_dict()` of changes
        if self.changes:
            _dict['changes'] = self.changes.to_dict()
        # override the default output from pydantic by calling `to_dict()` of billing_parser
        if self.billing_parser:
            _dict['billingParser'] = self.billing_parser.to_dict()
        # set to None if outputs (nullable) is None
        # and model_fields_set contains the field
        if self.outputs is None and "outputs" in self.model_fields_set:
            _dict['outputs'] = None

        # set to None if example (nullable) is None
        # and model_fields_set contains the field
        if self.example is None and "example" in self.model_fields_set:
            _dict['example'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ToolDefinitionInputSchemaDto from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "key": obj.get("key"),
            "version": obj.get("version"),
            "toolManifestVersion": obj.get("toolManifestVersion"),
            "executors": [ToolDefinitionSchemaDtoExecutorsInner.from_dict(_item) for _item in obj["executors"]] if obj.get("executors") is not None else None,
            "inputs": ToolDefinitionSchemaDtoInputs.from_dict(obj["inputs"]) if obj.get("inputs") is not None else None,
            "outputs": obj.get("outputs"),
            "examples": dict(
                (_k, ToolDefinitionSchemaDtoExamplesValue.from_dict(_v))
                for _k, _v in obj["examples"].items()
            )
            if obj.get("examples") is not None
            else None,
            "example": obj.get("example"),
            "changes": ToolDefinitionSchemaDtoChanges.from_dict(obj["changes"]) if obj.get("changes") is not None else None,
            "description": obj.get("description"),
            "billingParser": ToolDefinitionSchemaDtoBillingParserExecutor.from_dict(obj["billingParser"]) if obj.get("billingParser") is not None else None
        })
        return _obj


