# coding: utf-8

"""
    Platform API Documentation

    Combined API documentation for all platform services

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictFloat, StrictInt, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional, Union
from do_sdk_platform.models.get_subscriptions_results_schema_dto_subscriptions_inner_plans_inner_meta import GetSubscriptionsResultsSchemaDtoSubscriptionsInnerPlansInnerMeta
from typing import Optional, Set
from typing_extensions import Self

class SubscriptionsPlansSchemaDto(BaseModel):
    """
    SubscriptionsPlansSchemaDto
    """ # noqa: E501
    id: Optional[StrictStr]
    plan_id: StrictStr = Field(alias="planId")
    group_id: StrictStr = Field(alias="groupId")
    group: StrictStr
    description: StrictStr
    period: StrictStr
    name: StrictStr
    qty: Union[StrictFloat, StrictInt]
    price: StrictStr
    enabled: StrictBool
    is_available: StrictBool = Field(alias="isAvailable")
    qty_required: StrictBool = Field(alias="qtyRequired")
    can_delete: StrictBool = Field(alias="canDelete")
    auto_set_qty: StrictBool = Field(alias="autoSetQty")
    meta: GetSubscriptionsResultsSchemaDtoSubscriptionsInnerPlansInnerMeta
    auto_renew: StrictBool = Field(alias="autoRenew")
    to_date: StrictStr = Field(alias="toDate")
    monthly_price: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="monthlyPrice")
    annually_price: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="annuallyPrice")
    semi_annually_price: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="semiAnnuallyPrice")
    quarterly_price: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="quarterlyPrice")
    __properties: ClassVar[List[str]] = ["id", "planId", "groupId", "group", "description", "period", "name", "qty", "price", "enabled", "isAvailable", "qtyRequired", "canDelete", "autoSetQty", "meta", "autoRenew", "toDate", "monthlyPrice", "annuallyPrice", "semiAnnuallyPrice", "quarterlyPrice"]

    @field_validator('period')
    def period_validate_enum(cls, value):
        """Validates the enum"""
        if value not in set(['Monthly', 'Yearly', 'Quarterly', 'SemiAnnual', '1', '2', '3', '4']):
            raise ValueError("must be one of enum values ('Monthly', 'Yearly', 'Quarterly', 'SemiAnnual', '1', '2', '3', '4')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of SubscriptionsPlansSchemaDto from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of meta
        if self.meta:
            _dict['meta'] = self.meta.to_dict()
        # set to None if id (nullable) is None
        # and model_fields_set contains the field
        if self.id is None and "id" in self.model_fields_set:
            _dict['id'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of SubscriptionsPlansSchemaDto from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "planId": obj.get("planId"),
            "groupId": obj.get("groupId"),
            "group": obj.get("group"),
            "description": obj.get("description"),
            "period": obj.get("period"),
            "name": obj.get("name"),
            "qty": obj.get("qty"),
            "price": obj.get("price"),
            "enabled": obj.get("enabled"),
            "isAvailable": obj.get("isAvailable"),
            "qtyRequired": obj.get("qtyRequired"),
            "canDelete": obj.get("canDelete"),
            "autoSetQty": obj.get("autoSetQty"),
            "meta": GetSubscriptionsResultsSchemaDtoSubscriptionsInnerPlansInnerMeta.from_dict(obj["meta"]) if obj.get("meta") is not None else None,
            "autoRenew": obj.get("autoRenew"),
            "toDate": obj.get("toDate"),
            "monthlyPrice": obj.get("monthlyPrice"),
            "annuallyPrice": obj.get("annuallyPrice"),
            "semiAnnuallyPrice": obj.get("semiAnnuallyPrice"),
            "quarterlyPrice": obj.get("quarterlyPrice")
        })
        return _obj


