# coding: utf-8

"""
    Platform API Documentation

    Combined API documentation for all platform services

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List
from typing_extensions import Annotated
from typing import Optional, Set
from typing_extensions import Self

class RowFilterJoin(BaseModel):
    """
    RowFilterJoin
    """ # noqa: E501
    filter_type: StrictStr = Field(alias="filterType")
    join_type: StrictStr = Field(alias="joinType")
    conditions: Annotated[List[RowFilterJoinConditionsInner], Field(min_length=1)]
    __properties: ClassVar[List[str]] = ["filterType", "joinType", "conditions"]

    @field_validator('filter_type')
    def filter_type_validate_enum(cls, value):
        """Validates the enum"""
        if value not in set(['join']):
            raise ValueError("must be one of enum values ('join')")
        return value

    @field_validator('join_type')
    def join_type_validate_enum(cls, value):
        """Validates the enum"""
        if value not in set(['and', 'or']):
            raise ValueError("must be one of enum values ('and', 'or')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of RowFilterJoin from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in conditions (list)
        _items = []
        if self.conditions:
            for _item_conditions in self.conditions:
                if _item_conditions:
                    _items.append(_item_conditions.to_dict())
            _dict['conditions'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of RowFilterJoin from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "filterType": obj.get("filterType"),
            "joinType": obj.get("joinType"),
            "conditions": [RowFilterJoinConditionsInner.from_dict(_item) for _item in obj["conditions"]] if obj.get("conditions") is not None else None
        })
        return _obj

from do_sdk_platform.models.row_filter_join_conditions_inner import RowFilterJoinConditionsInner
# TODO: Rewrite to not use raise_errors
RowFilterJoin.model_rebuild(raise_errors=False)

