# coding: utf-8

"""
    Platform API Documentation

    Combined API documentation for all platform services

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
from inspect import getfullargspec
import json
import pprint
import re  # noqa: F401
from pydantic import BaseModel, ConfigDict, Field, StrictStr, ValidationError, field_validator
from typing import Optional
from do_sdk_platform.models.row_filter_boolean import RowFilterBoolean
from do_sdk_platform.models.row_filter_nullity import RowFilterNullity
from do_sdk_platform.models.row_filter_number import RowFilterNumber
from do_sdk_platform.models.row_filter_text import RowFilterText
from typing import Union, Any, List, Set, TYPE_CHECKING, Optional, Dict
from typing_extensions import Literal, Self
from pydantic import Field

ROWFILTERANYOF_ANY_OF_SCHEMAS = ["RowFilterBoolean", "RowFilterNullity", "RowFilterNumber", "RowFilterText"]

class RowFilterAnyOf(BaseModel):
    """
    RowFilterAnyOf
    """

    # data type: RowFilterText
    anyof_schema_1_validator: Optional[RowFilterText] = None
    # data type: RowFilterNumber
    anyof_schema_2_validator: Optional[RowFilterNumber] = None
    # data type: RowFilterBoolean
    anyof_schema_3_validator: Optional[RowFilterBoolean] = None
    # data type: RowFilterNullity
    anyof_schema_4_validator: Optional[RowFilterNullity] = None
    if TYPE_CHECKING:
        actual_instance: Optional[Union[RowFilterBoolean, RowFilterNullity, RowFilterNumber, RowFilterText]] = None
    else:
        actual_instance: Any = None
    any_of_schemas: Set[str] = { "RowFilterBoolean", "RowFilterNullity", "RowFilterNumber", "RowFilterText" }

    model_config = {
        "validate_assignment": True,
        "protected_namespaces": (),
    }

    def __init__(self, *args, **kwargs) -> None:
        if args:
            if len(args) > 1:
                raise ValueError("If a position argument is used, only 1 is allowed to set `actual_instance`")
            if kwargs:
                raise ValueError("If a position argument is used, keyword arguments cannot be used.")
            super().__init__(actual_instance=args[0])
        else:
            super().__init__(**kwargs)

    @field_validator('actual_instance')
    def actual_instance_must_validate_anyof(cls, v):
        instance = RowFilterAnyOf.model_construct()
        error_messages = []
        # validate data type: RowFilterText
        if not isinstance(v, RowFilterText):
            error_messages.append(f"Error! Input type `{type(v)}` is not `RowFilterText`")
        else:
            return v

        # validate data type: RowFilterNumber
        if not isinstance(v, RowFilterNumber):
            error_messages.append(f"Error! Input type `{type(v)}` is not `RowFilterNumber`")
        else:
            return v

        # validate data type: RowFilterBoolean
        if not isinstance(v, RowFilterBoolean):
            error_messages.append(f"Error! Input type `{type(v)}` is not `RowFilterBoolean`")
        else:
            return v

        # validate data type: RowFilterNullity
        if not isinstance(v, RowFilterNullity):
            error_messages.append(f"Error! Input type `{type(v)}` is not `RowFilterNullity`")
        else:
            return v

        if error_messages:
            # no match
            raise ValueError("No match found when setting the actual_instance in RowFilterAnyOf with anyOf schemas: RowFilterBoolean, RowFilterNullity, RowFilterNumber, RowFilterText. Details: " + ", ".join(error_messages))
        else:
            return v

    @classmethod
    def from_dict(cls, obj: Dict[str, Any]) -> Self:
        return cls.from_json(json.dumps(obj))

    @classmethod
    def from_json(cls, json_str: str) -> Self:
        """Returns the object represented by the json string"""
        instance = cls.model_construct()
        error_messages = []
        # anyof_schema_1_validator: Optional[RowFilterText] = None
        try:
            instance.actual_instance = RowFilterText.from_json(json_str)
            return instance
        except (ValidationError, ValueError) as e:
             error_messages.append(str(e))
        # anyof_schema_2_validator: Optional[RowFilterNumber] = None
        try:
            instance.actual_instance = RowFilterNumber.from_json(json_str)
            return instance
        except (ValidationError, ValueError) as e:
             error_messages.append(str(e))
        # anyof_schema_3_validator: Optional[RowFilterBoolean] = None
        try:
            instance.actual_instance = RowFilterBoolean.from_json(json_str)
            return instance
        except (ValidationError, ValueError) as e:
             error_messages.append(str(e))
        # anyof_schema_4_validator: Optional[RowFilterNullity] = None
        try:
            instance.actual_instance = RowFilterNullity.from_json(json_str)
            return instance
        except (ValidationError, ValueError) as e:
             error_messages.append(str(e))

        if error_messages:
            # no match
            raise ValueError("No match found when deserializing the JSON string into RowFilterAnyOf with anyOf schemas: RowFilterBoolean, RowFilterNullity, RowFilterNumber, RowFilterText. Details: " + ", ".join(error_messages))
        else:
            return instance

    def to_json(self) -> str:
        """Returns the JSON representation of the actual instance"""
        if self.actual_instance is None:
            return "null"

        if hasattr(self.actual_instance, "to_json") and callable(self.actual_instance.to_json):
            return self.actual_instance.to_json()
        else:
            return json.dumps(self.actual_instance)

    def to_dict(self) -> Optional[Union[Dict[str, Any], RowFilterBoolean, RowFilterNullity, RowFilterNumber, RowFilterText]]:
        """Returns the dict representation of the actual instance"""
        if self.actual_instance is None:
            return None

        if hasattr(self.actual_instance, "to_dict") and callable(self.actual_instance.to_dict):
            return self.actual_instance.to_dict()
        else:
            return self.actual_instance

    def to_str(self) -> str:
        """Returns the string representation of the actual instance"""
        return pprint.pformat(self.model_dump())


