# coding: utf-8

"""
    Platform API Documentation

    Combined API documentation for all platform services

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
from inspect import getfullargspec
import json
import pprint
import re  # noqa: F401
from pydantic import BaseModel, ConfigDict, Field, StrictStr, ValidationError, field_validator
from typing import Optional
from do_sdk_platform.models.row_filter_any_of import RowFilterAnyOf
from do_sdk_platform.models.row_filter_join import RowFilterJoin
from do_sdk_platform.models.row_filter_set import RowFilterSet
from do_sdk_platform.models.row_filter_substructure import RowFilterSubstructure
from typing import Union, Any, List, Set, TYPE_CHECKING, Optional, Dict
from typing_extensions import Literal, Self
from pydantic import Field

ROWFILTER_ANY_OF_SCHEMAS = ["RowFilterAnyOf", "RowFilterJoin", "RowFilterSet", "RowFilterSubstructure"]

class RowFilter(BaseModel):
    """
    RowFilter
    """

    # data type: RowFilterAnyOf
    anyof_schema_1_validator: Optional[RowFilterAnyOf] = None
    # data type: RowFilterSet
    anyof_schema_2_validator: Optional[RowFilterSet] = None
    # data type: RowFilterSubstructure
    anyof_schema_3_validator: Optional[RowFilterSubstructure] = None
    # data type: RowFilterJoin
    anyof_schema_4_validator: Optional[RowFilterJoin] = None
    if TYPE_CHECKING:
        actual_instance: Optional[Union[RowFilterAnyOf, RowFilterJoin, RowFilterSet, RowFilterSubstructure]] = None
    else:
        actual_instance: Any = None
    any_of_schemas: Set[str] = { "RowFilterAnyOf", "RowFilterJoin", "RowFilterSet", "RowFilterSubstructure" }

    model_config = {
        "validate_assignment": True,
        "protected_namespaces": (),
    }

    def __init__(self, *args, **kwargs) -> None:
        if args:
            if len(args) > 1:
                raise ValueError("If a position argument is used, only 1 is allowed to set `actual_instance`")
            if kwargs:
                raise ValueError("If a position argument is used, keyword arguments cannot be used.")
            super().__init__(actual_instance=args[0])
        else:
            super().__init__(**kwargs)

    @field_validator('actual_instance')
    def actual_instance_must_validate_anyof(cls, v):
        instance = RowFilter.model_construct()
        error_messages = []
        # validate data type: RowFilterAnyOf
        if not isinstance(v, RowFilterAnyOf):
            error_messages.append(f"Error! Input type `{type(v)}` is not `RowFilterAnyOf`")
        else:
            return v

        # validate data type: RowFilterSet
        if not isinstance(v, RowFilterSet):
            error_messages.append(f"Error! Input type `{type(v)}` is not `RowFilterSet`")
        else:
            return v

        # validate data type: RowFilterSubstructure
        if not isinstance(v, RowFilterSubstructure):
            error_messages.append(f"Error! Input type `{type(v)}` is not `RowFilterSubstructure`")
        else:
            return v

        # validate data type: RowFilterJoin
        if not isinstance(v, RowFilterJoin):
            error_messages.append(f"Error! Input type `{type(v)}` is not `RowFilterJoin`")
        else:
            return v

        if error_messages:
            # no match
            raise ValueError("No match found when setting the actual_instance in RowFilter with anyOf schemas: RowFilterAnyOf, RowFilterJoin, RowFilterSet, RowFilterSubstructure. Details: " + ", ".join(error_messages))
        else:
            return v

    @classmethod
    def from_dict(cls, obj: Dict[str, Any]) -> Self:
        return cls.from_json(json.dumps(obj))

    @classmethod
    def from_json(cls, json_str: str) -> Self:
        """Returns the object represented by the json string"""
        instance = cls.model_construct()
        error_messages = []
        # anyof_schema_1_validator: Optional[RowFilterAnyOf] = None
        try:
            instance.actual_instance = RowFilterAnyOf.from_json(json_str)
            return instance
        except (ValidationError, ValueError) as e:
             error_messages.append(str(e))
        # anyof_schema_2_validator: Optional[RowFilterSet] = None
        try:
            instance.actual_instance = RowFilterSet.from_json(json_str)
            return instance
        except (ValidationError, ValueError) as e:
             error_messages.append(str(e))
        # anyof_schema_3_validator: Optional[RowFilterSubstructure] = None
        try:
            instance.actual_instance = RowFilterSubstructure.from_json(json_str)
            return instance
        except (ValidationError, ValueError) as e:
             error_messages.append(str(e))
        # anyof_schema_4_validator: Optional[RowFilterJoin] = None
        try:
            instance.actual_instance = RowFilterJoin.from_json(json_str)
            return instance
        except (ValidationError, ValueError) as e:
             error_messages.append(str(e))

        if error_messages:
            # no match
            raise ValueError("No match found when deserializing the JSON string into RowFilter with anyOf schemas: RowFilterAnyOf, RowFilterJoin, RowFilterSet, RowFilterSubstructure. Details: " + ", ".join(error_messages))
        else:
            return instance

    def to_json(self) -> str:
        """Returns the JSON representation of the actual instance"""
        if self.actual_instance is None:
            return "null"

        if hasattr(self.actual_instance, "to_json") and callable(self.actual_instance.to_json):
            return self.actual_instance.to_json()
        else:
            return json.dumps(self.actual_instance)

    def to_dict(self) -> Optional[Union[Dict[str, Any], RowFilterAnyOf, RowFilterJoin, RowFilterSet, RowFilterSubstructure]]:
        """Returns the dict representation of the actual instance"""
        if self.actual_instance is None:
            return None

        if hasattr(self.actual_instance, "to_dict") and callable(self.actual_instance.to_dict):
            return self.actual_instance.to_dict()
        else:
            return self.actual_instance

    def to_str(self) -> str:
        """Returns the string representation of the actual instance"""
        return pprint.pformat(self.model_dump())


