# coding: utf-8

"""
    Platform API Documentation

    Combined API documentation for all platform services

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictFloat, StrictInt, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional, Union
from typing import Optional, Set
from typing_extensions import Self

class OrganizationSchemaDto(BaseModel):
    """
    OrganizationSchemaDto
    """ # noqa: E501
    org_key: StrictStr = Field(alias="orgKey")
    name: StrictStr
    status: StrictStr
    mfa_enabled: StrictBool = Field(alias="mfaEnabled")
    roles: Optional[List[StrictStr]] = None
    threshold: Optional[Union[StrictFloat, StrictInt]] = None
    __properties: ClassVar[List[str]] = ["orgKey", "name", "status", "mfaEnabled", "roles", "threshold"]

    @field_validator('status')
    def status_validate_enum(cls, value):
        """Validates the enum"""
        if value not in set(['PENDING', 'READY', 'FAILED']):
            raise ValueError("must be one of enum values ('PENDING', 'READY', 'FAILED')")
        return value

    @field_validator('roles')
    def roles_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        for i in value:
            if i not in set(['Owner', 'Admin', 'BillingManager', 'InfrastructureManager', 'Member']):
                raise ValueError("each list item must be one of ('Owner', 'Admin', 'BillingManager', 'InfrastructureManager', 'Member')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of OrganizationSchemaDto from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of OrganizationSchemaDto from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "orgKey": obj.get("orgKey"),
            "name": obj.get("name"),
            "status": obj.get("status"),
            "mfaEnabled": obj.get("mfaEnabled"),
            "roles": obj.get("roles"),
            "threshold": obj.get("threshold")
        })
        return _obj


