# coding: utf-8

"""
    Platform API Documentation

    Combined API documentation for all platform services

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from typing import Optional, Set
from typing_extensions import Self

class NotificationSchemaDto(BaseModel):
    """
    NotificationSchemaDto
    """ # noqa: E501
    id: StrictStr
    org_key: StrictStr = Field(alias="orgKey")
    user_id: StrictStr = Field(alias="userId")
    subject: StrictStr
    body: StrictStr
    read: Optional[Any] = None
    created_at: Optional[Any] = Field(alias="createdAt")
    when_enabled: Optional[Any] = Field(default=None, alias="whenEnabled")
    buttons: StrictStr
    severity: StrictStr
    type: StrictStr
    high_priority: StrictBool = Field(alias="highPriority")
    __properties: ClassVar[List[str]] = ["id", "orgKey", "userId", "subject", "body", "read", "createdAt", "whenEnabled", "buttons", "severity", "type", "highPriority"]

    @field_validator('buttons')
    def buttons_validate_enum(cls, value):
        """Validates the enum"""
        if value not in set(['ok', 'add_payment']):
            raise ValueError("must be one of enum values ('ok', 'add_payment')")
        return value

    @field_validator('severity')
    def severity_validate_enum(cls, value):
        """Validates the enum"""
        if value not in set(['success', 'warning', 'danger']):
            raise ValueError("must be one of enum values ('success', 'warning', 'danger')")
        return value

    @field_validator('type')
    def type_validate_enum(cls, value):
        """Validates the enum"""
        if value not in set(['toast', 'dialog', 'none']):
            raise ValueError("must be one of enum values ('toast', 'dialog', 'none')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of NotificationSchemaDto from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # set to None if read (nullable) is None
        # and model_fields_set contains the field
        if self.read is None and "read" in self.model_fields_set:
            _dict['read'] = None

        # set to None if created_at (nullable) is None
        # and model_fields_set contains the field
        if self.created_at is None and "created_at" in self.model_fields_set:
            _dict['createdAt'] = None

        # set to None if when_enabled (nullable) is None
        # and model_fields_set contains the field
        if self.when_enabled is None and "when_enabled" in self.model_fields_set:
            _dict['whenEnabled'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of NotificationSchemaDto from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "orgKey": obj.get("orgKey"),
            "userId": obj.get("userId"),
            "subject": obj.get("subject"),
            "body": obj.get("body"),
            "read": obj.get("read"),
            "createdAt": obj.get("createdAt"),
            "whenEnabled": obj.get("whenEnabled"),
            "buttons": obj.get("buttons"),
            "severity": obj.get("severity"),
            "type": obj.get("type"),
            "highPriority": obj.get("highPriority")
        })
        return _obj


