# coding: utf-8

"""
    Platform API Documentation

    Combined API documentation for all platform services

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import json
import pprint
from pydantic import BaseModel, ConfigDict, Field, StrictStr, ValidationError, field_validator
from typing import Any, List, Optional
from do_sdk_platform.models.field_boolean import FieldBoolean
from do_sdk_platform.models.field_date import FieldDate
from do_sdk_platform.models.field_editor import FieldEditor
from do_sdk_platform.models.field_expression import FieldExpression
from do_sdk_platform.models.field_file import FieldFile
from do_sdk_platform.models.field_float import FieldFloat
from do_sdk_platform.models.field_integer import FieldInteger
from do_sdk_platform.models.field_lookup import FieldLookup
from do_sdk_platform.models.field_reference import FieldReference
from do_sdk_platform.models.field_select import FieldSelect
from do_sdk_platform.models.field_text import FieldText
from do_sdk_platform.models.field_url import FieldUrl
from do_sdk_platform.models.field_user import FieldUser
from pydantic import StrictStr, Field
from typing import Union, List, Set, Optional, Dict
from typing_extensions import Literal, Self

MODELFIELD_ONE_OF_SCHEMAS = ["FieldBoolean", "FieldDate", "FieldEditor", "FieldExpression", "FieldFile", "FieldFloat", "FieldInteger", "FieldLookup", "FieldReference", "FieldSelect", "FieldText", "FieldUrl", "FieldUser"]

class ModelField(BaseModel):
    """
    ModelField
    """
    # data type: FieldText
    oneof_schema_1_validator: Optional[FieldText] = None
    # data type: FieldInteger
    oneof_schema_2_validator: Optional[FieldInteger] = None
    # data type: FieldFloat
    oneof_schema_3_validator: Optional[FieldFloat] = None
    # data type: FieldBoolean
    oneof_schema_4_validator: Optional[FieldBoolean] = None
    # data type: FieldReference
    oneof_schema_5_validator: Optional[FieldReference] = None
    # data type: FieldEditor
    oneof_schema_6_validator: Optional[FieldEditor] = None
    # data type: FieldFile
    oneof_schema_7_validator: Optional[FieldFile] = None
    # data type: FieldSelect
    oneof_schema_8_validator: Optional[FieldSelect] = None
    # data type: FieldDate
    oneof_schema_9_validator: Optional[FieldDate] = None
    # data type: FieldUrl
    oneof_schema_10_validator: Optional[FieldUrl] = None
    # data type: FieldUser
    oneof_schema_11_validator: Optional[FieldUser] = None
    # data type: FieldExpression
    oneof_schema_12_validator: Optional[FieldExpression] = None
    # data type: FieldLookup
    oneof_schema_13_validator: Optional[FieldLookup] = None
    actual_instance: Optional[Union[FieldBoolean, FieldDate, FieldEditor, FieldExpression, FieldFile, FieldFloat, FieldInteger, FieldLookup, FieldReference, FieldSelect, FieldText, FieldUrl, FieldUser]] = None
    one_of_schemas: Set[str] = { "FieldBoolean", "FieldDate", "FieldEditor", "FieldExpression", "FieldFile", "FieldFloat", "FieldInteger", "FieldLookup", "FieldReference", "FieldSelect", "FieldText", "FieldUrl", "FieldUser" }

    model_config = ConfigDict(
        validate_assignment=True,
        protected_namespaces=(),
    )


    discriminator_value_class_map: Dict[str, str] = {
    }

    def __init__(self, *args, **kwargs) -> None:
        if args:
            if len(args) > 1:
                raise ValueError("If a position argument is used, only 1 is allowed to set `actual_instance`")
            if kwargs:
                raise ValueError("If a position argument is used, keyword arguments cannot be used.")
            super().__init__(actual_instance=args[0])
        else:
            super().__init__(**kwargs)

    @field_validator('actual_instance')
    def actual_instance_must_validate_oneof(cls, v):
        instance = ModelField.model_construct()
        error_messages = []
        match = 0
        # validate data type: FieldText
        if not isinstance(v, FieldText):
            error_messages.append(f"Error! Input type `{type(v)}` is not `FieldText`")
        else:
            match += 1
        # validate data type: FieldInteger
        if not isinstance(v, FieldInteger):
            error_messages.append(f"Error! Input type `{type(v)}` is not `FieldInteger`")
        else:
            match += 1
        # validate data type: FieldFloat
        if not isinstance(v, FieldFloat):
            error_messages.append(f"Error! Input type `{type(v)}` is not `FieldFloat`")
        else:
            match += 1
        # validate data type: FieldBoolean
        if not isinstance(v, FieldBoolean):
            error_messages.append(f"Error! Input type `{type(v)}` is not `FieldBoolean`")
        else:
            match += 1
        # validate data type: FieldReference
        if not isinstance(v, FieldReference):
            error_messages.append(f"Error! Input type `{type(v)}` is not `FieldReference`")
        else:
            match += 1
        # validate data type: FieldEditor
        if not isinstance(v, FieldEditor):
            error_messages.append(f"Error! Input type `{type(v)}` is not `FieldEditor`")
        else:
            match += 1
        # validate data type: FieldFile
        if not isinstance(v, FieldFile):
            error_messages.append(f"Error! Input type `{type(v)}` is not `FieldFile`")
        else:
            match += 1
        # validate data type: FieldSelect
        if not isinstance(v, FieldSelect):
            error_messages.append(f"Error! Input type `{type(v)}` is not `FieldSelect`")
        else:
            match += 1
        # validate data type: FieldDate
        if not isinstance(v, FieldDate):
            error_messages.append(f"Error! Input type `{type(v)}` is not `FieldDate`")
        else:
            match += 1
        # validate data type: FieldUrl
        if not isinstance(v, FieldUrl):
            error_messages.append(f"Error! Input type `{type(v)}` is not `FieldUrl`")
        else:
            match += 1
        # validate data type: FieldUser
        if not isinstance(v, FieldUser):
            error_messages.append(f"Error! Input type `{type(v)}` is not `FieldUser`")
        else:
            match += 1
        # validate data type: FieldExpression
        if not isinstance(v, FieldExpression):
            error_messages.append(f"Error! Input type `{type(v)}` is not `FieldExpression`")
        else:
            match += 1
        # validate data type: FieldLookup
        if not isinstance(v, FieldLookup):
            error_messages.append(f"Error! Input type `{type(v)}` is not `FieldLookup`")
        else:
            match += 1
        if match > 1:
            # more than 1 match
            raise ValueError("Multiple matches found when setting `actual_instance` in ModelField with oneOf schemas: FieldBoolean, FieldDate, FieldEditor, FieldExpression, FieldFile, FieldFloat, FieldInteger, FieldLookup, FieldReference, FieldSelect, FieldText, FieldUrl, FieldUser. Details: " + ", ".join(error_messages))
        elif match == 0:
            # no match
            raise ValueError("No match found when setting `actual_instance` in ModelField with oneOf schemas: FieldBoolean, FieldDate, FieldEditor, FieldExpression, FieldFile, FieldFloat, FieldInteger, FieldLookup, FieldReference, FieldSelect, FieldText, FieldUrl, FieldUser. Details: " + ", ".join(error_messages))
        else:
            return v

    @classmethod
    def from_dict(cls, obj: Union[str, Dict[str, Any]]) -> Self:
        return cls.from_json(json.dumps(obj))

    @classmethod
    def from_json(cls, json_str: str) -> Self:
        """Returns the object represented by the json string"""
        instance = cls.model_construct()
        error_messages = []
        match = 0

        # deserialize data into FieldText
        try:
            instance.actual_instance = FieldText.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))
        # deserialize data into FieldInteger
        try:
            instance.actual_instance = FieldInteger.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))
        # deserialize data into FieldFloat
        try:
            instance.actual_instance = FieldFloat.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))
        # deserialize data into FieldBoolean
        try:
            instance.actual_instance = FieldBoolean.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))
        # deserialize data into FieldReference
        try:
            instance.actual_instance = FieldReference.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))
        # deserialize data into FieldEditor
        try:
            instance.actual_instance = FieldEditor.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))
        # deserialize data into FieldFile
        try:
            instance.actual_instance = FieldFile.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))
        # deserialize data into FieldSelect
        try:
            instance.actual_instance = FieldSelect.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))
        # deserialize data into FieldDate
        try:
            instance.actual_instance = FieldDate.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))
        # deserialize data into FieldUrl
        try:
            instance.actual_instance = FieldUrl.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))
        # deserialize data into FieldUser
        try:
            instance.actual_instance = FieldUser.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))
        # deserialize data into FieldExpression
        try:
            instance.actual_instance = FieldExpression.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))
        # deserialize data into FieldLookup
        try:
            instance.actual_instance = FieldLookup.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))

        if match > 1:
            # more than 1 match
            raise ValueError("Multiple matches found when deserializing the JSON string into ModelField with oneOf schemas: FieldBoolean, FieldDate, FieldEditor, FieldExpression, FieldFile, FieldFloat, FieldInteger, FieldLookup, FieldReference, FieldSelect, FieldText, FieldUrl, FieldUser. Details: " + ", ".join(error_messages))
        elif match == 0:
            # no match
            raise ValueError("No match found when deserializing the JSON string into ModelField with oneOf schemas: FieldBoolean, FieldDate, FieldEditor, FieldExpression, FieldFile, FieldFloat, FieldInteger, FieldLookup, FieldReference, FieldSelect, FieldText, FieldUrl, FieldUser. Details: " + ", ".join(error_messages))
        else:
            return instance

    def to_json(self) -> str:
        """Returns the JSON representation of the actual instance"""
        if self.actual_instance is None:
            return "null"

        if hasattr(self.actual_instance, "to_json") and callable(self.actual_instance.to_json):
            return self.actual_instance.to_json()
        else:
            return json.dumps(self.actual_instance)

    def to_dict(self) -> Optional[Union[Dict[str, Any], FieldBoolean, FieldDate, FieldEditor, FieldExpression, FieldFile, FieldFloat, FieldInteger, FieldLookup, FieldReference, FieldSelect, FieldText, FieldUrl, FieldUser]]:
        """Returns the dict representation of the actual instance"""
        if self.actual_instance is None:
            return None

        if hasattr(self.actual_instance, "to_dict") and callable(self.actual_instance.to_dict):
            return self.actual_instance.to_dict()
        else:
            # primitive type
            return self.actual_instance

    def to_str(self) -> str:
        """Returns the string representation of the actual instance"""
        return pprint.pformat(self.model_dump())


