# coding: utf-8

"""
    Platform API Documentation

    Combined API documentation for all platform services

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, StrictBool, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from typing import Optional, Set
from typing_extensions import Self

class MetaColumnsAddDto(BaseModel):
    """
    MetaColumnsAddDto
    """ # noqa: E501
    name: StrictStr
    logical_type: StrictStr
    attribute_id: Optional[StrictStr] = None
    source: Optional[StrictStr] = None
    nullable: Optional[StrictBool] = None
    default_spec: Optional[Dict[str, Any]] = None
    index_hints: Optional[List[StrictStr]] = None
    part_of_unique: Optional[StrictStr] = None
    storage_type: Optional[StrictStr] = None
    computed: Optional[Dict[str, Any]] = None
    policy: Optional[StrictStr] = None
    revive_if_deleted: Optional[StrictBool] = None
    description: Optional[StrictStr] = None
    validation_hints: Optional[Dict[str, Any]] = None
    modified_by: Optional[StrictStr] = None
    __properties: ClassVar[List[str]] = ["name", "logical_type", "attribute_id", "source", "nullable", "default_spec", "index_hints", "part_of_unique", "storage_type", "computed", "policy", "revive_if_deleted", "description", "validation_hints", "modified_by"]

    @field_validator('source')
    def source_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['local', 'catalog']):
            raise ValueError("must be one of enum values ('local', 'catalog')")
        return value

    @field_validator('policy')
    def policy_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['follow', 'pin', 'validate_only']):
            raise ValueError("must be one of enum values ('follow', 'pin', 'validate_only')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of MetaColumnsAddDto from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of MetaColumnsAddDto from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "name": obj.get("name"),
            "logical_type": obj.get("logical_type"),
            "attribute_id": obj.get("attribute_id"),
            "source": obj.get("source"),
            "nullable": obj.get("nullable"),
            "default_spec": obj.get("default_spec"),
            "index_hints": obj.get("index_hints"),
            "part_of_unique": obj.get("part_of_unique"),
            "storage_type": obj.get("storage_type"),
            "computed": obj.get("computed"),
            "policy": obj.get("policy"),
            "revive_if_deleted": obj.get("revive_if_deleted"),
            "description": obj.get("description"),
            "validation_hints": obj.get("validation_hints"),
            "modified_by": obj.get("modified_by")
        })
        return _obj


