# coding: utf-8

"""
    Platform API Documentation

    Combined API documentation for all platform services

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field
from typing import Any, ClassVar, Dict, List
from do_sdk_platform.models.function_creation_response_schema_dto_deployment_statuses_inner import FunctionCreationResponseSchemaDtoDeploymentStatusesInner
from do_sdk_platform.models.function_creation_response_schema_dto_function import FunctionCreationResponseSchemaDtoFunction
from typing import Optional, Set
from typing_extensions import Self

class FunctionCreationResponseSchemaDto(BaseModel):
    """
    FunctionCreationResponseSchemaDto
    """ # noqa: E501
    deployment_statuses: List[FunctionCreationResponseSchemaDtoDeploymentStatusesInner] = Field(alias="deploymentStatuses")
    function: FunctionCreationResponseSchemaDtoFunction
    __properties: ClassVar[List[str]] = ["deploymentStatuses", "function"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of FunctionCreationResponseSchemaDto from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in deployment_statuses (list)
        _items = []
        if self.deployment_statuses:
            for _item_deployment_statuses in self.deployment_statuses:
                if _item_deployment_statuses:
                    _items.append(_item_deployment_statuses.to_dict())
            _dict['deploymentStatuses'] = _items
        # override the default output from pydantic by calling `to_dict()` of function
        if self.function:
            _dict['function'] = self.function.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of FunctionCreationResponseSchemaDto from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "deploymentStatuses": [FunctionCreationResponseSchemaDtoDeploymentStatusesInner.from_dict(_item) for _item in obj["deploymentStatuses"]] if obj.get("deploymentStatuses") is not None else None,
            "function": FunctionCreationResponseSchemaDtoFunction.from_dict(obj["function"]) if obj.get("function") is not None else None
        })
        return _obj


