# coding: utf-8

"""
    Platform API Documentation

    Combined API documentation for all platform services

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictFloat, StrictInt, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional, Union
from do_sdk_platform.models.field_user_value import FieldUserValue
from do_sdk_platform.models.invalid_data import InvalidData
from typing import Optional, Set
from typing_extensions import Self

class FieldUser(BaseModel):
    """
    FieldUser
    """ # noqa: E501
    column_id: StrictStr = Field(alias="columnId")
    version: Optional[Union[StrictFloat, StrictInt]] = None
    validation_status: StrictStr = Field(alias="validationStatus")
    invalid_data: Optional[InvalidData] = Field(default=None, alias="invalidData")
    type: StrictStr
    system_type: Optional[StrictStr] = Field(default=None, alias="systemType")
    value: Optional[FieldUserValue] = None
    __properties: ClassVar[List[str]] = ["columnId", "version", "validationStatus", "invalidData", "type", "systemType", "value"]

    @field_validator('validation_status')
    def validation_status_validate_enum(cls, value):
        """Validates the enum"""
        if value not in set(['valid', 'invalid']):
            raise ValueError("must be one of enum values ('valid', 'invalid')")
        return value

    @field_validator('type')
    def type_validate_enum(cls, value):
        """Validates the enum"""
        if value not in set(['user']):
            raise ValueError("must be one of enum values ('user')")
        return value

    @field_validator('system_type')
    def system_type_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['name', 'bodyDocument']):
            raise ValueError("must be one of enum values ('name', 'bodyDocument')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of FieldUser from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of invalid_data
        if self.invalid_data:
            _dict['invalidData'] = self.invalid_data.to_dict()
        # override the default output from pydantic by calling `to_dict()` of value
        if self.value:
            _dict['value'] = self.value.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of FieldUser from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "columnId": obj.get("columnId"),
            "version": obj.get("version"),
            "validationStatus": obj.get("validationStatus"),
            "invalidData": InvalidData.from_dict(obj["invalidData"]) if obj.get("invalidData") is not None else None,
            "type": obj.get("type"),
            "systemType": obj.get("systemType"),
            "value": FieldUserValue.from_dict(obj["value"]) if obj.get("value") is not None else None
        })
        return _obj


