# coding: utf-8

"""
    Platform API Documentation

    Combined API documentation for all platform services

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
from inspect import getfullargspec
import json
import pprint
import re  # noqa: F401
from pydantic import BaseModel, ConfigDict, Field, StrictStr, ValidationError, field_validator
from typing import Optional
from do_sdk_platform.models.field_boolean import FieldBoolean
from do_sdk_platform.models.field_date import FieldDate
from do_sdk_platform.models.field_editor import FieldEditor
from do_sdk_platform.models.field_file import FieldFile
from do_sdk_platform.models.field_float import FieldFloat
from do_sdk_platform.models.field_integer import FieldInteger
from do_sdk_platform.models.field_reference import FieldReference
from do_sdk_platform.models.field_select import FieldSelect
from do_sdk_platform.models.field_text import FieldText
from do_sdk_platform.models.field_url import FieldUrl
from do_sdk_platform.models.field_user import FieldUser
from typing import Union, Any, List, Set, TYPE_CHECKING, Optional, Dict
from typing_extensions import Literal, Self
from pydantic import Field

FIELDLOOKUPVALUE_ANY_OF_SCHEMAS = ["FieldBoolean", "FieldDate", "FieldEditor", "FieldFile", "FieldFloat", "FieldInteger", "FieldReference", "FieldSelect", "FieldText", "FieldUrl", "FieldUser"]

class FieldLookupValue(BaseModel):
    """
    FieldLookupValue
    """

    # data type: FieldText
    anyof_schema_1_validator: Optional[FieldText] = None
    # data type: FieldInteger
    anyof_schema_2_validator: Optional[FieldInteger] = None
    # data type: FieldFloat
    anyof_schema_3_validator: Optional[FieldFloat] = None
    # data type: FieldBoolean
    anyof_schema_4_validator: Optional[FieldBoolean] = None
    # data type: FieldReference
    anyof_schema_5_validator: Optional[FieldReference] = None
    # data type: FieldEditor
    anyof_schema_6_validator: Optional[FieldEditor] = None
    # data type: FieldFile
    anyof_schema_7_validator: Optional[FieldFile] = None
    # data type: FieldSelect
    anyof_schema_8_validator: Optional[FieldSelect] = None
    # data type: FieldDate
    anyof_schema_9_validator: Optional[FieldDate] = None
    # data type: FieldUrl
    anyof_schema_10_validator: Optional[FieldUrl] = None
    # data type: FieldUser
    anyof_schema_11_validator: Optional[FieldUser] = None
    if TYPE_CHECKING:
        actual_instance: Optional[Union[FieldBoolean, FieldDate, FieldEditor, FieldFile, FieldFloat, FieldInteger, FieldReference, FieldSelect, FieldText, FieldUrl, FieldUser]] = None
    else:
        actual_instance: Any = None
    any_of_schemas: Set[str] = { "FieldBoolean", "FieldDate", "FieldEditor", "FieldFile", "FieldFloat", "FieldInteger", "FieldReference", "FieldSelect", "FieldText", "FieldUrl", "FieldUser" }

    model_config = {
        "validate_assignment": True,
        "protected_namespaces": (),
    }

    def __init__(self, *args, **kwargs) -> None:
        if args:
            if len(args) > 1:
                raise ValueError("If a position argument is used, only 1 is allowed to set `actual_instance`")
            if kwargs:
                raise ValueError("If a position argument is used, keyword arguments cannot be used.")
            super().__init__(actual_instance=args[0])
        else:
            super().__init__(**kwargs)

    @field_validator('actual_instance')
    def actual_instance_must_validate_anyof(cls, v):
        instance = FieldLookupValue.model_construct()
        error_messages = []
        # validate data type: FieldText
        if not isinstance(v, FieldText):
            error_messages.append(f"Error! Input type `{type(v)}` is not `FieldText`")
        else:
            return v

        # validate data type: FieldInteger
        if not isinstance(v, FieldInteger):
            error_messages.append(f"Error! Input type `{type(v)}` is not `FieldInteger`")
        else:
            return v

        # validate data type: FieldFloat
        if not isinstance(v, FieldFloat):
            error_messages.append(f"Error! Input type `{type(v)}` is not `FieldFloat`")
        else:
            return v

        # validate data type: FieldBoolean
        if not isinstance(v, FieldBoolean):
            error_messages.append(f"Error! Input type `{type(v)}` is not `FieldBoolean`")
        else:
            return v

        # validate data type: FieldReference
        if not isinstance(v, FieldReference):
            error_messages.append(f"Error! Input type `{type(v)}` is not `FieldReference`")
        else:
            return v

        # validate data type: FieldEditor
        if not isinstance(v, FieldEditor):
            error_messages.append(f"Error! Input type `{type(v)}` is not `FieldEditor`")
        else:
            return v

        # validate data type: FieldFile
        if not isinstance(v, FieldFile):
            error_messages.append(f"Error! Input type `{type(v)}` is not `FieldFile`")
        else:
            return v

        # validate data type: FieldSelect
        if not isinstance(v, FieldSelect):
            error_messages.append(f"Error! Input type `{type(v)}` is not `FieldSelect`")
        else:
            return v

        # validate data type: FieldDate
        if not isinstance(v, FieldDate):
            error_messages.append(f"Error! Input type `{type(v)}` is not `FieldDate`")
        else:
            return v

        # validate data type: FieldUrl
        if not isinstance(v, FieldUrl):
            error_messages.append(f"Error! Input type `{type(v)}` is not `FieldUrl`")
        else:
            return v

        # validate data type: FieldUser
        if not isinstance(v, FieldUser):
            error_messages.append(f"Error! Input type `{type(v)}` is not `FieldUser`")
        else:
            return v

        if error_messages:
            # no match
            raise ValueError("No match found when setting the actual_instance in FieldLookupValue with anyOf schemas: FieldBoolean, FieldDate, FieldEditor, FieldFile, FieldFloat, FieldInteger, FieldReference, FieldSelect, FieldText, FieldUrl, FieldUser. Details: " + ", ".join(error_messages))
        else:
            return v

    @classmethod
    def from_dict(cls, obj: Dict[str, Any]) -> Self:
        return cls.from_json(json.dumps(obj))

    @classmethod
    def from_json(cls, json_str: str) -> Self:
        """Returns the object represented by the json string"""
        instance = cls.model_construct()
        error_messages = []
        # anyof_schema_1_validator: Optional[FieldText] = None
        try:
            instance.actual_instance = FieldText.from_json(json_str)
            return instance
        except (ValidationError, ValueError) as e:
             error_messages.append(str(e))
        # anyof_schema_2_validator: Optional[FieldInteger] = None
        try:
            instance.actual_instance = FieldInteger.from_json(json_str)
            return instance
        except (ValidationError, ValueError) as e:
             error_messages.append(str(e))
        # anyof_schema_3_validator: Optional[FieldFloat] = None
        try:
            instance.actual_instance = FieldFloat.from_json(json_str)
            return instance
        except (ValidationError, ValueError) as e:
             error_messages.append(str(e))
        # anyof_schema_4_validator: Optional[FieldBoolean] = None
        try:
            instance.actual_instance = FieldBoolean.from_json(json_str)
            return instance
        except (ValidationError, ValueError) as e:
             error_messages.append(str(e))
        # anyof_schema_5_validator: Optional[FieldReference] = None
        try:
            instance.actual_instance = FieldReference.from_json(json_str)
            return instance
        except (ValidationError, ValueError) as e:
             error_messages.append(str(e))
        # anyof_schema_6_validator: Optional[FieldEditor] = None
        try:
            instance.actual_instance = FieldEditor.from_json(json_str)
            return instance
        except (ValidationError, ValueError) as e:
             error_messages.append(str(e))
        # anyof_schema_7_validator: Optional[FieldFile] = None
        try:
            instance.actual_instance = FieldFile.from_json(json_str)
            return instance
        except (ValidationError, ValueError) as e:
             error_messages.append(str(e))
        # anyof_schema_8_validator: Optional[FieldSelect] = None
        try:
            instance.actual_instance = FieldSelect.from_json(json_str)
            return instance
        except (ValidationError, ValueError) as e:
             error_messages.append(str(e))
        # anyof_schema_9_validator: Optional[FieldDate] = None
        try:
            instance.actual_instance = FieldDate.from_json(json_str)
            return instance
        except (ValidationError, ValueError) as e:
             error_messages.append(str(e))
        # anyof_schema_10_validator: Optional[FieldUrl] = None
        try:
            instance.actual_instance = FieldUrl.from_json(json_str)
            return instance
        except (ValidationError, ValueError) as e:
             error_messages.append(str(e))
        # anyof_schema_11_validator: Optional[FieldUser] = None
        try:
            instance.actual_instance = FieldUser.from_json(json_str)
            return instance
        except (ValidationError, ValueError) as e:
             error_messages.append(str(e))

        if error_messages:
            # no match
            raise ValueError("No match found when deserializing the JSON string into FieldLookupValue with anyOf schemas: FieldBoolean, FieldDate, FieldEditor, FieldFile, FieldFloat, FieldInteger, FieldReference, FieldSelect, FieldText, FieldUrl, FieldUser. Details: " + ", ".join(error_messages))
        else:
            return instance

    def to_json(self) -> str:
        """Returns the JSON representation of the actual instance"""
        if self.actual_instance is None:
            return "null"

        if hasattr(self.actual_instance, "to_json") and callable(self.actual_instance.to_json):
            return self.actual_instance.to_json()
        else:
            return json.dumps(self.actual_instance)

    def to_dict(self) -> Optional[Union[Dict[str, Any], FieldBoolean, FieldDate, FieldEditor, FieldFile, FieldFloat, FieldInteger, FieldReference, FieldSelect, FieldText, FieldUrl, FieldUser]]:
        """Returns the dict representation of the actual instance"""
        if self.actual_instance is None:
            return None

        if hasattr(self.actual_instance, "to_dict") and callable(self.actual_instance.to_dict):
            return self.actual_instance.to_dict()
        else:
            return self.actual_instance

    def to_str(self) -> str:
        """Returns the string representation of the actual instance"""
        return pprint.pformat(self.model_dump())


