# coding: utf-8

"""
    Platform API Documentation

    Combined API documentation for all platform services

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from do_sdk_platform.models.column_selection import ColumnSelection
from do_sdk_platform.models.row_filter import RowFilter
from do_sdk_platform.models.row_sort_inner import RowSortInner
from typing import Optional, Set
from typing_extensions import Self

class DatabaseViewUpdate(BaseModel):
    """
    DatabaseViewUpdate
    """ # noqa: E501
    name: Optional[StrictStr] = None
    filter: Optional[RowFilter] = None
    row_sort: Optional[List[RowSortInner]] = Field(default=None, description="Sort rows by column.", alias="rowSort")
    column_selection: Optional[ColumnSelection] = Field(default=None, alias="columnSelection")
    __properties: ClassVar[List[str]] = ["name", "filter", "rowSort", "columnSelection"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of DatabaseViewUpdate from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of filter
        if self.filter:
            _dict['filter'] = self.filter.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in row_sort (list)
        _items = []
        if self.row_sort:
            for _item_row_sort in self.row_sort:
                if _item_row_sort:
                    _items.append(_item_row_sort.to_dict())
            _dict['rowSort'] = _items
        # override the default output from pydantic by calling `to_dict()` of column_selection
        if self.column_selection:
            _dict['columnSelection'] = self.column_selection.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of DatabaseViewUpdate from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "name": obj.get("name"),
            "filter": RowFilter.from_dict(obj["filter"]) if obj.get("filter") is not None else None,
            "rowSort": [RowSortInner.from_dict(_item) for _item in obj["rowSort"]] if obj.get("rowSort") is not None else None,
            "columnSelection": ColumnSelection.from_dict(obj["columnSelection"]) if obj.get("columnSelection") is not None else None
        })
        return _obj


