# coding: utf-8

"""
    Platform API Documentation

    Combined API documentation for all platform services

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from typing_extensions import Annotated
from do_sdk_platform.models.model_field import ModelField
from typing import Optional, Set
from typing_extensions import Self

class DatabaseRow(BaseModel):
    """
    DatabaseRow
    """ # noqa: E501
    id: StrictStr = Field(description="Deep Origin system ID.")
    type: StrictStr
    hid: Annotated[str, Field(strict=True, max_length=250)]
    name: Optional[StrictStr] = None
    date_created: Optional[StrictStr] = Field(default=None, alias="dateCreated")
    date_updated: Optional[StrictStr] = Field(default=None, alias="dateUpdated")
    created_by_user_drn: Optional[StrictStr] = Field(default=None, alias="createdByUserDrn")
    edited_by_user_drn: Optional[StrictStr] = Field(default=None, alias="editedByUserDrn")
    parent_id: Optional[StrictStr] = Field(default=None, alias="parentId")
    parent_hid: Optional[StrictStr] = Field(default=None, alias="parentHid")
    creation_parent_id: Optional[StrictStr] = Field(default=None, alias="creationParentId")
    creation_block_id: Optional[StrictStr] = Field(default=None, alias="creationBlockId")
    fields: Optional[List[ModelField]] = None
    is_template: Optional[StrictBool] = Field(default=None, alias="isTemplate")
    validation_status: Optional[StrictStr] = Field(default=None, alias="validationStatus")
    __properties: ClassVar[List[str]] = ["id", "type", "hid", "name", "dateCreated", "dateUpdated", "createdByUserDrn", "editedByUserDrn", "parentId", "parentHid", "creationParentId", "creationBlockId", "fields", "isTemplate", "validationStatus"]

    @field_validator('type')
    def type_validate_enum(cls, value):
        """Validates the enum"""
        if value not in set(['row']):
            raise ValueError("must be one of enum values ('row')")
        return value

    @field_validator('validation_status')
    def validation_status_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['valid', 'invalid']):
            raise ValueError("must be one of enum values ('valid', 'invalid')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of DatabaseRow from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in fields (list)
        _items = []
        if self.fields:
            for _item_fields in self.fields:
                if _item_fields:
                    _items.append(_item_fields.to_dict())
            _dict['fields'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of DatabaseRow from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "type": obj.get("type"),
            "hid": obj.get("hid"),
            "name": obj.get("name"),
            "dateCreated": obj.get("dateCreated"),
            "dateUpdated": obj.get("dateUpdated"),
            "createdByUserDrn": obj.get("createdByUserDrn"),
            "editedByUserDrn": obj.get("editedByUserDrn"),
            "parentId": obj.get("parentId"),
            "parentHid": obj.get("parentHid"),
            "creationParentId": obj.get("creationParentId"),
            "creationBlockId": obj.get("creationBlockId"),
            "fields": [ModelField.from_dict(_item) for _item in obj["fields"]] if obj.get("fields") is not None else None,
            "isTemplate": obj.get("isTemplate"),
            "validationStatus": obj.get("validationStatus")
        })
        return _obj


