# coding: utf-8

"""
    Platform API Documentation

    Combined API documentation for all platform services

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from typing_extensions import Annotated
from do_sdk_platform.models.column import Column
from typing import Optional, Set
from typing_extensions import Self

class Database(BaseModel):
    """
    Database
    """ # noqa: E501
    id: StrictStr = Field(description="Deep Origin system ID.")
    type: StrictStr
    hid: Annotated[str, Field(strict=True, max_length=250)]
    name: StrictStr
    date_created: Optional[StrictStr] = Field(default=None, alias="dateCreated")
    date_updated: Optional[StrictStr] = Field(default=None, alias="dateUpdated")
    created_by_user_drn: Optional[StrictStr] = Field(default=None, alias="createdByUserDrn")
    edited_by_user_drn: Optional[StrictStr] = Field(default=None, alias="editedByUserDrn")
    parent_id: Optional[StrictStr] = Field(default=None, alias="parentId")
    parent_hid: Optional[StrictStr] = Field(default=None, alias="parentHid")
    creation_parent_id: Optional[StrictStr] = Field(default=None, alias="creationParentId")
    creation_block_id: Optional[StrictStr] = Field(default=None, alias="creationBlockId")
    hid_prefix: Annotated[str, Field(strict=True, max_length=250)] = Field(alias="hidPrefix")
    cols: Optional[List[Column]] = None
    row_json_schema: Optional[Dict[str, Any]] = Field(default=None, alias="rowJsonSchema")
    editor: Optional[Any] = None
    is_inline_database: Optional[StrictBool] = Field(default=None, alias="isInlineDatabase")
    is_locked: Optional[StrictBool] = Field(default=None, alias="isLocked")
    __properties: ClassVar[List[str]] = ["id", "type", "hid", "name", "dateCreated", "dateUpdated", "createdByUserDrn", "editedByUserDrn", "parentId", "parentHid", "creationParentId", "creationBlockId", "hidPrefix", "cols", "rowJsonSchema", "editor", "isInlineDatabase", "isLocked"]

    @field_validator('type')
    def type_validate_enum(cls, value):
        """Validates the enum"""
        if value not in set(['database']):
            raise ValueError("must be one of enum values ('database')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of Database from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in cols (list)
        _items = []
        if self.cols:
            for _item_cols in self.cols:
                if _item_cols:
                    _items.append(_item_cols.to_dict())
            _dict['cols'] = _items
        # set to None if editor (nullable) is None
        # and model_fields_set contains the field
        if self.editor is None and "editor" in self.model_fields_set:
            _dict['editor'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of Database from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "type": obj.get("type"),
            "hid": obj.get("hid"),
            "name": obj.get("name"),
            "dateCreated": obj.get("dateCreated"),
            "dateUpdated": obj.get("dateUpdated"),
            "createdByUserDrn": obj.get("createdByUserDrn"),
            "editedByUserDrn": obj.get("editedByUserDrn"),
            "parentId": obj.get("parentId"),
            "parentHid": obj.get("parentHid"),
            "creationParentId": obj.get("creationParentId"),
            "creationBlockId": obj.get("creationBlockId"),
            "hidPrefix": obj.get("hidPrefix"),
            "cols": [Column.from_dict(_item) for _item in obj["cols"]] if obj.get("cols") is not None else None,
            "rowJsonSchema": obj.get("rowJsonSchema"),
            "editor": obj.get("editor"),
            "isInlineDatabase": obj.get("isInlineDatabase"),
            "isLocked": obj.get("isLocked")
        })
        return _obj


