# coding: utf-8

"""
    Platform API Documentation

    Combined API documentation for all platform services

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from typing import Optional, Set
from typing_extensions import Self

class CreateNotificationInputSchemaDto(BaseModel):
    """
    CreateNotificationInputSchemaDto
    """ # noqa: E501
    key: Optional[StrictStr] = None
    subject: StrictStr
    body: StrictStr
    buttons: StrictStr
    severity: StrictStr
    type: StrictStr
    high_priority: Optional[StrictBool] = Field(default=None, alias="highPriority")
    email: Optional[StrictBool] = None
    __properties: ClassVar[List[str]] = ["key", "subject", "body", "buttons", "severity", "type", "highPriority", "email"]

    @field_validator('buttons')
    def buttons_validate_enum(cls, value):
        """Validates the enum"""
        if value not in set(['ok', 'add_payment']):
            raise ValueError("must be one of enum values ('ok', 'add_payment')")
        return value

    @field_validator('severity')
    def severity_validate_enum(cls, value):
        """Validates the enum"""
        if value not in set(['success', 'warning', 'danger']):
            raise ValueError("must be one of enum values ('success', 'warning', 'danger')")
        return value

    @field_validator('type')
    def type_validate_enum(cls, value):
        """Validates the enum"""
        if value not in set(['toast', 'dialog', 'none']):
            raise ValueError("must be one of enum values ('toast', 'dialog', 'none')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of CreateNotificationInputSchemaDto from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of CreateNotificationInputSchemaDto from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "key": obj.get("key"),
            "subject": obj.get("subject"),
            "body": obj.get("body"),
            "buttons": obj.get("buttons"),
            "severity": obj.get("severity"),
            "type": obj.get("type"),
            "highPriority": obj.get("highPriority"),
            "email": obj.get("email")
        })
        return _obj


