# coding: utf-8

"""
    Platform API Documentation

    Combined API documentation for all platform services

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import json
import pprint
from pydantic import BaseModel, ConfigDict, Field, StrictStr, ValidationError, field_validator
from typing import Any, List, Optional
from do_sdk_platform.models.column_boolean_base import ColumnBooleanBase
from do_sdk_platform.models.column_date_base import ColumnDateBase
from do_sdk_platform.models.column_editor_base import ColumnEditorBase
from do_sdk_platform.models.column_expression_base import ColumnExpressionBase
from do_sdk_platform.models.column_file_base import ColumnFileBase
from do_sdk_platform.models.column_float_base import ColumnFloatBase
from do_sdk_platform.models.column_integer_base import ColumnIntegerBase
from do_sdk_platform.models.column_lookup_base import ColumnLookupBase
from do_sdk_platform.models.column_reference_base import ColumnReferenceBase
from do_sdk_platform.models.column_select_base import ColumnSelectBase
from do_sdk_platform.models.column_text_base import ColumnTextBase
from do_sdk_platform.models.column_url_base import ColumnUrlBase
from do_sdk_platform.models.column_user_base import ColumnUserBase
from pydantic import StrictStr, Field
from typing import Union, List, Set, Optional, Dict
from typing_extensions import Literal, Self

COLUMNTYPEBASE_ONE_OF_SCHEMAS = ["ColumnBooleanBase", "ColumnDateBase", "ColumnEditorBase", "ColumnExpressionBase", "ColumnFileBase", "ColumnFloatBase", "ColumnIntegerBase", "ColumnLookupBase", "ColumnReferenceBase", "ColumnSelectBase", "ColumnTextBase", "ColumnUrlBase", "ColumnUserBase"]

class ColumnTypeBase(BaseModel):
    """
    ColumnTypeBase
    """
    # data type: ColumnBooleanBase
    oneof_schema_1_validator: Optional[ColumnBooleanBase] = None
    # data type: ColumnDateBase
    oneof_schema_2_validator: Optional[ColumnDateBase] = None
    # data type: ColumnEditorBase
    oneof_schema_3_validator: Optional[ColumnEditorBase] = None
    # data type: ColumnExpressionBase
    oneof_schema_4_validator: Optional[ColumnExpressionBase] = None
    # data type: ColumnFileBase
    oneof_schema_5_validator: Optional[ColumnFileBase] = None
    # data type: ColumnFloatBase
    oneof_schema_6_validator: Optional[ColumnFloatBase] = None
    # data type: ColumnIntegerBase
    oneof_schema_7_validator: Optional[ColumnIntegerBase] = None
    # data type: ColumnReferenceBase
    oneof_schema_8_validator: Optional[ColumnReferenceBase] = None
    # data type: ColumnSelectBase
    oneof_schema_9_validator: Optional[ColumnSelectBase] = None
    # data type: ColumnTextBase
    oneof_schema_10_validator: Optional[ColumnTextBase] = None
    # data type: ColumnUrlBase
    oneof_schema_11_validator: Optional[ColumnUrlBase] = None
    # data type: ColumnUserBase
    oneof_schema_12_validator: Optional[ColumnUserBase] = None
    # data type: ColumnLookupBase
    oneof_schema_13_validator: Optional[ColumnLookupBase] = None
    actual_instance: Optional[Union[ColumnBooleanBase, ColumnDateBase, ColumnEditorBase, ColumnExpressionBase, ColumnFileBase, ColumnFloatBase, ColumnIntegerBase, ColumnLookupBase, ColumnReferenceBase, ColumnSelectBase, ColumnTextBase, ColumnUrlBase, ColumnUserBase]] = None
    one_of_schemas: Set[str] = { "ColumnBooleanBase", "ColumnDateBase", "ColumnEditorBase", "ColumnExpressionBase", "ColumnFileBase", "ColumnFloatBase", "ColumnIntegerBase", "ColumnLookupBase", "ColumnReferenceBase", "ColumnSelectBase", "ColumnTextBase", "ColumnUrlBase", "ColumnUserBase" }

    model_config = ConfigDict(
        validate_assignment=True,
        protected_namespaces=(),
    )


    discriminator_value_class_map: Dict[str, str] = {
        'Column': 'Column',
        'UpdateColumn': 'UpdateColumn'
    }

    def __init__(self, *args, **kwargs) -> None:
        if args:
            if len(args) > 1:
                raise ValueError("If a position argument is used, only 1 is allowed to set `actual_instance`")
            if kwargs:
                raise ValueError("If a position argument is used, keyword arguments cannot be used.")
            super().__init__(actual_instance=args[0])
        else:
            super().__init__(**kwargs)

    @field_validator('actual_instance')
    def actual_instance_must_validate_oneof(cls, v):
        instance = ColumnTypeBase.model_construct()
        error_messages = []
        match = 0
        # validate data type: ColumnBooleanBase
        if not isinstance(v, ColumnBooleanBase):
            error_messages.append(f"Error! Input type `{type(v)}` is not `ColumnBooleanBase`")
        else:
            match += 1
        # validate data type: ColumnDateBase
        if not isinstance(v, ColumnDateBase):
            error_messages.append(f"Error! Input type `{type(v)}` is not `ColumnDateBase`")
        else:
            match += 1
        # validate data type: ColumnEditorBase
        if not isinstance(v, ColumnEditorBase):
            error_messages.append(f"Error! Input type `{type(v)}` is not `ColumnEditorBase`")
        else:
            match += 1
        # validate data type: ColumnExpressionBase
        if not isinstance(v, ColumnExpressionBase):
            error_messages.append(f"Error! Input type `{type(v)}` is not `ColumnExpressionBase`")
        else:
            match += 1
        # validate data type: ColumnFileBase
        if not isinstance(v, ColumnFileBase):
            error_messages.append(f"Error! Input type `{type(v)}` is not `ColumnFileBase`")
        else:
            match += 1
        # validate data type: ColumnFloatBase
        if not isinstance(v, ColumnFloatBase):
            error_messages.append(f"Error! Input type `{type(v)}` is not `ColumnFloatBase`")
        else:
            match += 1
        # validate data type: ColumnIntegerBase
        if not isinstance(v, ColumnIntegerBase):
            error_messages.append(f"Error! Input type `{type(v)}` is not `ColumnIntegerBase`")
        else:
            match += 1
        # validate data type: ColumnReferenceBase
        if not isinstance(v, ColumnReferenceBase):
            error_messages.append(f"Error! Input type `{type(v)}` is not `ColumnReferenceBase`")
        else:
            match += 1
        # validate data type: ColumnSelectBase
        if not isinstance(v, ColumnSelectBase):
            error_messages.append(f"Error! Input type `{type(v)}` is not `ColumnSelectBase`")
        else:
            match += 1
        # validate data type: ColumnTextBase
        if not isinstance(v, ColumnTextBase):
            error_messages.append(f"Error! Input type `{type(v)}` is not `ColumnTextBase`")
        else:
            match += 1
        # validate data type: ColumnUrlBase
        if not isinstance(v, ColumnUrlBase):
            error_messages.append(f"Error! Input type `{type(v)}` is not `ColumnUrlBase`")
        else:
            match += 1
        # validate data type: ColumnUserBase
        if not isinstance(v, ColumnUserBase):
            error_messages.append(f"Error! Input type `{type(v)}` is not `ColumnUserBase`")
        else:
            match += 1
        # validate data type: ColumnLookupBase
        if not isinstance(v, ColumnLookupBase):
            error_messages.append(f"Error! Input type `{type(v)}` is not `ColumnLookupBase`")
        else:
            match += 1
        if match > 1:
            # more than 1 match
            raise ValueError("Multiple matches found when setting `actual_instance` in ColumnTypeBase with oneOf schemas: ColumnBooleanBase, ColumnDateBase, ColumnEditorBase, ColumnExpressionBase, ColumnFileBase, ColumnFloatBase, ColumnIntegerBase, ColumnLookupBase, ColumnReferenceBase, ColumnSelectBase, ColumnTextBase, ColumnUrlBase, ColumnUserBase. Details: " + ", ".join(error_messages))
        elif match == 0:
            # no match
            raise ValueError("No match found when setting `actual_instance` in ColumnTypeBase with oneOf schemas: ColumnBooleanBase, ColumnDateBase, ColumnEditorBase, ColumnExpressionBase, ColumnFileBase, ColumnFloatBase, ColumnIntegerBase, ColumnLookupBase, ColumnReferenceBase, ColumnSelectBase, ColumnTextBase, ColumnUrlBase, ColumnUserBase. Details: " + ", ".join(error_messages))
        else:
            return v

    @classmethod
    def from_dict(cls, obj: Union[str, Dict[str, Any]]) -> Self:
        return cls.from_json(json.dumps(obj))

    @classmethod
    def from_json(cls, json_str: str) -> Self:
        """Returns the object represented by the json string"""
        instance = cls.model_construct()
        error_messages = []
        match = 0

        # deserialize data into ColumnBooleanBase
        try:
            instance.actual_instance = ColumnBooleanBase.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))
        # deserialize data into ColumnDateBase
        try:
            instance.actual_instance = ColumnDateBase.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))
        # deserialize data into ColumnEditorBase
        try:
            instance.actual_instance = ColumnEditorBase.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))
        # deserialize data into ColumnExpressionBase
        try:
            instance.actual_instance = ColumnExpressionBase.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))
        # deserialize data into ColumnFileBase
        try:
            instance.actual_instance = ColumnFileBase.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))
        # deserialize data into ColumnFloatBase
        try:
            instance.actual_instance = ColumnFloatBase.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))
        # deserialize data into ColumnIntegerBase
        try:
            instance.actual_instance = ColumnIntegerBase.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))
        # deserialize data into ColumnReferenceBase
        try:
            instance.actual_instance = ColumnReferenceBase.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))
        # deserialize data into ColumnSelectBase
        try:
            instance.actual_instance = ColumnSelectBase.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))
        # deserialize data into ColumnTextBase
        try:
            instance.actual_instance = ColumnTextBase.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))
        # deserialize data into ColumnUrlBase
        try:
            instance.actual_instance = ColumnUrlBase.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))
        # deserialize data into ColumnUserBase
        try:
            instance.actual_instance = ColumnUserBase.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))
        # deserialize data into ColumnLookupBase
        try:
            instance.actual_instance = ColumnLookupBase.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))

        if match > 1:
            # more than 1 match
            raise ValueError("Multiple matches found when deserializing the JSON string into ColumnTypeBase with oneOf schemas: ColumnBooleanBase, ColumnDateBase, ColumnEditorBase, ColumnExpressionBase, ColumnFileBase, ColumnFloatBase, ColumnIntegerBase, ColumnLookupBase, ColumnReferenceBase, ColumnSelectBase, ColumnTextBase, ColumnUrlBase, ColumnUserBase. Details: " + ", ".join(error_messages))
        elif match == 0:
            # no match
            raise ValueError("No match found when deserializing the JSON string into ColumnTypeBase with oneOf schemas: ColumnBooleanBase, ColumnDateBase, ColumnEditorBase, ColumnExpressionBase, ColumnFileBase, ColumnFloatBase, ColumnIntegerBase, ColumnLookupBase, ColumnReferenceBase, ColumnSelectBase, ColumnTextBase, ColumnUrlBase, ColumnUserBase. Details: " + ", ".join(error_messages))
        else:
            return instance

    def to_json(self) -> str:
        """Returns the JSON representation of the actual instance"""
        if self.actual_instance is None:
            return "null"

        if hasattr(self.actual_instance, "to_json") and callable(self.actual_instance.to_json):
            return self.actual_instance.to_json()
        else:
            return json.dumps(self.actual_instance)

    def to_dict(self) -> Optional[Union[Dict[str, Any], ColumnBooleanBase, ColumnDateBase, ColumnEditorBase, ColumnExpressionBase, ColumnFileBase, ColumnFloatBase, ColumnIntegerBase, ColumnLookupBase, ColumnReferenceBase, ColumnSelectBase, ColumnTextBase, ColumnUrlBase, ColumnUserBase]]:
        """Returns the dict representation of the actual instance"""
        if self.actual_instance is None:
            return None

        if hasattr(self.actual_instance, "to_dict") and callable(self.actual_instance.to_dict):
            return self.actual_instance.to_dict()
        else:
            # primitive type
            return self.actual_instance

    def to_str(self) -> str:
        """Returns the string representation of the actual instance"""
        return pprint.pformat(self.model_dump())


