# coding: utf-8

"""
    Platform API Documentation

    Combined API documentation for all platform services

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import ConfigDict, Field, StrictBool, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from typing_extensions import Annotated
from do_sdk_platform.models.column_file_base_config_file import ColumnFileBaseConfigFile
from do_sdk_platform.models.column_float_base_config_numeric import ColumnFloatBaseConfigNumeric
from do_sdk_platform.models.column_primitive import ColumnPrimitive
from do_sdk_platform.models.column_select_base_config_select import ColumnSelectBaseConfigSelect
from do_sdk_platform.models.column_type_base import ColumnTypeBase
from typing import Optional, Set
from typing_extensions import Self

class Column(ColumnTypeBase):
    """
    Column
    """ # noqa: E501
    id: StrictStr = Field(description="Deep Origin system ID.")
    parent_id: Optional[StrictStr] = Field(default=None, alias="parentId")
    name: Annotated[str, Field(strict=True)]
    type: StrictStr
    json_field: Optional[StrictStr] = Field(default=None, alias="jsonField")
    cardinality: StrictStr
    system_type: Optional[StrictStr] = Field(default=None, alias="systemType")
    is_required: Optional[StrictBool] = Field(default=None, alias="isRequired")
    enabled_viewers: Optional[List[StrictStr]] = Field(default=None, alias="enabledViewers")
    cell_json_schema: Optional[Any] = Field(default=None, alias="cellJsonSchema")
    inline_viewer: Optional[StrictStr] = Field(default=None, alias="inlineViewer")
    __properties: ClassVar[List[str]] = ["type", "expressionCode", "expressionReturnType", "configFile", "configNumeric", "referenceDatabaseRowId", "configSelect", "lookupSourceColumnId", "lookupExternalColumnId", "lookupExternalColumn", "id", "parentId", "name", "jsonField", "cardinality", "systemType", "isRequired", "enabledViewers", "cellJsonSchema", "inlineViewer"]

    @field_validator('name')
    def name_validate_regular_expression(cls, value):
        """Validates the regular expression"""
        if not re.match(r"^(?!_)[^]{1,250}$", value):
            raise ValueError(r"must validate the regular expression /^(?!_)[^]{1,250}$/")
        return value

    @field_validator('type')
    def type_validate_enum(cls, value):
        """Validates the enum"""
        if value not in set(['boolean', 'date', 'editor', 'expression', 'file', 'float', 'integer', 'lookup', 'reference', 'select', 'text', 'url', 'user']):
            raise ValueError("must be one of enum values ('boolean', 'date', 'editor', 'expression', 'file', 'float', 'integer', 'lookup', 'reference', 'select', 'text', 'url', 'user')")
        return value

    @field_validator('cardinality')
    def cardinality_validate_enum(cls, value):
        """Validates the enum"""
        if value not in set(['one', 'many']):
            raise ValueError("must be one of enum values ('one', 'many')")
        return value

    @field_validator('system_type')
    def system_type_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['name', 'bodyDocument']):
            raise ValueError("must be one of enum values ('name', 'bodyDocument')")
        return value

    @field_validator('enabled_viewers')
    def enabled_viewers_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        for i in value:
            if i not in set(['code', 'html', 'image', 'molecule', 'notebook', 'sequence', 'smiles', 'spreadsheet']):
                raise ValueError("each list item must be one of ('code', 'html', 'image', 'molecule', 'notebook', 'sequence', 'smiles', 'spreadsheet')")
        return value

    @field_validator('inline_viewer')
    def inline_viewer_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['molecule2d']):
            raise ValueError("must be one of enum values ('molecule2d')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of Column from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of config_file
        if self.config_file:
            _dict['configFile'] = self.config_file.to_dict()
        # override the default output from pydantic by calling `to_dict()` of config_numeric
        if self.config_numeric:
            _dict['configNumeric'] = self.config_numeric.to_dict()
        # override the default output from pydantic by calling `to_dict()` of config_select
        if self.config_select:
            _dict['configSelect'] = self.config_select.to_dict()
        # override the default output from pydantic by calling `to_dict()` of lookup_external_column
        if self.lookup_external_column:
            _dict['lookupExternalColumn'] = self.lookup_external_column.to_dict()
        # set to None if cell_json_schema (nullable) is None
        # and model_fields_set contains the field
        if self.cell_json_schema is None and "cell_json_schema" in self.model_fields_set:
            _dict['cellJsonSchema'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of Column from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "type": obj.get("type"),
            "expressionCode": obj.get("expressionCode"),
            "expressionReturnType": obj.get("expressionReturnType"),
            "configFile": ColumnFileBaseConfigFile.from_dict(obj["configFile"]) if obj.get("configFile") is not None else None,
            "configNumeric": ColumnFloatBaseConfigNumeric.from_dict(obj["configNumeric"]) if obj.get("configNumeric") is not None else None,
            "referenceDatabaseRowId": obj.get("referenceDatabaseRowId"),
            "configSelect": ColumnSelectBaseConfigSelect.from_dict(obj["configSelect"]) if obj.get("configSelect") is not None else None,
            "lookupSourceColumnId": obj.get("lookupSourceColumnId"),
            "lookupExternalColumnId": obj.get("lookupExternalColumnId"),
            "lookupExternalColumn": ColumnPrimitive.from_dict(obj["lookupExternalColumn"]) if obj.get("lookupExternalColumn") is not None else None,
            "id": obj.get("id"),
            "parentId": obj.get("parentId"),
            "name": obj.get("name"),
            "jsonField": obj.get("jsonField"),
            "cardinality": obj.get("cardinality"),
            "systemType": obj.get("systemType"),
            "isRequired": obj.get("isRequired"),
            "enabledViewers": obj.get("enabledViewers"),
            "cellJsonSchema": obj.get("cellJsonSchema"),
            "inlineViewer": obj.get("inlineViewer")
        })
        return _obj


