# coding: utf-8

"""
    Platform API Documentation

    Combined API documentation for all platform services

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from typing import Optional, Set
from typing_extensions import Self

class CodeExeuction(BaseModel):
    """
    CodeExeuction
    """ # noqa: E501
    id: StrictStr = Field(description="Deep Origin system ID.")
    status: StrictStr
    start_date: Optional[StrictStr] = Field(default=None, alias="startDate")
    finished_date: Optional[StrictStr] = Field(default=None, alias="finishedDate")
    created_by_user_drn: Optional[StrictStr] = Field(default=None, alias="createdByUserDrn")
    code: Optional[StrictStr] = None
    code_language: Optional[StrictStr] = Field(default=None, alias="codeLanguage")
    result_uri: Optional[StrictStr] = Field(default=None, alias="resultUri")
    execution_error_message: Optional[StrictStr] = Field(default=None, alias="executionErrorMessage")
    __properties: ClassVar[List[str]] = ["id", "status", "startDate", "finishedDate", "createdByUserDrn", "code", "codeLanguage", "resultUri", "executionErrorMessage"]

    @field_validator('status')
    def status_validate_enum(cls, value):
        """Validates the enum"""
        if value not in set(['pending', 'success', 'fail']):
            raise ValueError("must be one of enum values ('pending', 'success', 'fail')")
        return value

    @field_validator('code_language')
    def code_language_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['python']):
            raise ValueError("must be one of enum values ('python')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of CodeExeuction from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of CodeExeuction from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "status": obj.get("status"),
            "startDate": obj.get("startDate"),
            "finishedDate": obj.get("finishedDate"),
            "createdByUserDrn": obj.get("createdByUserDrn"),
            "code": obj.get("code"),
            "codeLanguage": obj.get("codeLanguage"),
            "resultUri": obj.get("resultUri"),
            "executionErrorMessage": obj.get("executionErrorMessage")
        })
        return _obj


