# coding: utf-8

"""
    Platform API Documentation

    Combined API documentation for all platform services

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from do_sdk_platform.models.capture_event_schema_dto_event_name import CaptureEventSchemaDtoEventName
from typing import Optional, Set
from typing_extensions import Self

class CaptureEventSchemaDto(BaseModel):
    """
    CaptureEventSchemaDto
    """ # noqa: E501
    event_name: CaptureEventSchemaDtoEventName = Field(alias="eventName")
    org_key: Optional[StrictStr] = Field(default=None, alias="orgKey")
    properties: Optional[Dict[str, Any]] = None
    __properties: ClassVar[List[str]] = ["eventName", "orgKey", "properties"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of CaptureEventSchemaDto from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of event_name
        if self.event_name:
            _dict['eventName'] = self.event_name.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of CaptureEventSchemaDto from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "eventName": CaptureEventSchemaDtoEventName.from_dict(obj["eventName"]) if obj.get("eventName") is not None else None,
            "orgKey": obj.get("orgKey"),
            "properties": obj.get("properties")
        })
        return _obj


