# coding: utf-8

"""
    Platform API Documentation

    Combined API documentation for all platform services

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from do_sdk_platform.models.entities_check200_response_error_value import EntitiesCheck200ResponseErrorValue
from typing import Optional, Set
from typing_extensions import Self

class BillingCheck200Response(BaseModel):
    """
    BillingCheck200Response
    """ # noqa: E501
    status: Optional[StrictStr] = None
    info: Optional[Dict[str, EntitiesCheck200ResponseErrorValue]] = None
    error: Optional[Dict[str, EntitiesCheck200ResponseErrorValue]] = None
    details: Optional[Dict[str, EntitiesCheck200ResponseErrorValue]] = None
    __properties: ClassVar[List[str]] = ["status", "info", "error", "details"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of BillingCheck200Response from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each value in info (dict)
        _field_dict = {}
        if self.info:
            for _key_info in self.info:
                if self.info[_key_info]:
                    _field_dict[_key_info] = self.info[_key_info].to_dict()
            _dict['info'] = _field_dict
        # override the default output from pydantic by calling `to_dict()` of each value in error (dict)
        _field_dict = {}
        if self.error:
            for _key_error in self.error:
                if self.error[_key_error]:
                    _field_dict[_key_error] = self.error[_key_error].to_dict()
            _dict['error'] = _field_dict
        # override the default output from pydantic by calling `to_dict()` of each value in details (dict)
        _field_dict = {}
        if self.details:
            for _key_details in self.details:
                if self.details[_key_details]:
                    _field_dict[_key_details] = self.details[_key_details].to_dict()
            _dict['details'] = _field_dict
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of BillingCheck200Response from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "status": obj.get("status"),
            "info": dict(
                (_k, EntitiesCheck200ResponseErrorValue.from_dict(_v))
                for _k, _v in obj["info"].items()
            )
            if obj.get("info") is not None
            else None,
            "error": dict(
                (_k, EntitiesCheck200ResponseErrorValue.from_dict(_v))
                for _k, _v in obj["error"].items()
            )
            if obj.get("error") is not None
            else None,
            "details": dict(
                (_k, EntitiesCheck200ResponseErrorValue.from_dict(_v))
                for _k, _v in obj["details"].items()
            )
            if obj.get("details") is not None
            else None
        })
        return _obj


