# coding: utf-8

"""
    Platform API Documentation

    Combined API documentation for all platform services

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import json
import pprint
from pydantic import BaseModel, ConfigDict, Field, StrictStr, ValidationError, field_validator
from typing import Any, List, Optional
from do_sdk_platform.models.add_column_boolean import AddColumnBoolean
from do_sdk_platform.models.add_column_date import AddColumnDate
from do_sdk_platform.models.add_column_editor import AddColumnEditor
from do_sdk_platform.models.add_column_expression import AddColumnExpression
from do_sdk_platform.models.add_column_file import AddColumnFile
from do_sdk_platform.models.add_column_float import AddColumnFloat
from do_sdk_platform.models.add_column_integer import AddColumnInteger
from do_sdk_platform.models.add_column_lookup import AddColumnLookup
from do_sdk_platform.models.add_column_reference import AddColumnReference
from do_sdk_platform.models.add_column_select import AddColumnSelect
from do_sdk_platform.models.add_column_text import AddColumnText
from do_sdk_platform.models.add_column_url import AddColumnUrl
from do_sdk_platform.models.add_column_user import AddColumnUser
from pydantic import StrictStr, Field
from typing import Union, List, Set, Optional, Dict
from typing_extensions import Literal, Self

ADDCOLUMN_ONE_OF_SCHEMAS = ["AddColumnBoolean", "AddColumnDate", "AddColumnEditor", "AddColumnExpression", "AddColumnFile", "AddColumnFloat", "AddColumnInteger", "AddColumnLookup", "AddColumnReference", "AddColumnSelect", "AddColumnText", "AddColumnUrl", "AddColumnUser"]

class AddColumn(BaseModel):
    """
    AddColumn
    """
    # data type: AddColumnLookup
    oneof_schema_1_validator: Optional[AddColumnLookup] = None
    # data type: AddColumnBoolean
    oneof_schema_2_validator: Optional[AddColumnBoolean] = None
    # data type: AddColumnDate
    oneof_schema_3_validator: Optional[AddColumnDate] = None
    # data type: AddColumnEditor
    oneof_schema_4_validator: Optional[AddColumnEditor] = None
    # data type: AddColumnExpression
    oneof_schema_5_validator: Optional[AddColumnExpression] = None
    # data type: AddColumnFile
    oneof_schema_6_validator: Optional[AddColumnFile] = None
    # data type: AddColumnFloat
    oneof_schema_7_validator: Optional[AddColumnFloat] = None
    # data type: AddColumnInteger
    oneof_schema_8_validator: Optional[AddColumnInteger] = None
    # data type: AddColumnReference
    oneof_schema_9_validator: Optional[AddColumnReference] = None
    # data type: AddColumnSelect
    oneof_schema_10_validator: Optional[AddColumnSelect] = None
    # data type: AddColumnText
    oneof_schema_11_validator: Optional[AddColumnText] = None
    # data type: AddColumnUrl
    oneof_schema_12_validator: Optional[AddColumnUrl] = None
    # data type: AddColumnUser
    oneof_schema_13_validator: Optional[AddColumnUser] = None
    actual_instance: Optional[Union[AddColumnBoolean, AddColumnDate, AddColumnEditor, AddColumnExpression, AddColumnFile, AddColumnFloat, AddColumnInteger, AddColumnLookup, AddColumnReference, AddColumnSelect, AddColumnText, AddColumnUrl, AddColumnUser]] = None
    one_of_schemas: Set[str] = { "AddColumnBoolean", "AddColumnDate", "AddColumnEditor", "AddColumnExpression", "AddColumnFile", "AddColumnFloat", "AddColumnInteger", "AddColumnLookup", "AddColumnReference", "AddColumnSelect", "AddColumnText", "AddColumnUrl", "AddColumnUser" }

    model_config = ConfigDict(
        validate_assignment=True,
        protected_namespaces=(),
    )


    discriminator_value_class_map: Dict[str, str] = {
    }

    def __init__(self, *args, **kwargs) -> None:
        if args:
            if len(args) > 1:
                raise ValueError("If a position argument is used, only 1 is allowed to set `actual_instance`")
            if kwargs:
                raise ValueError("If a position argument is used, keyword arguments cannot be used.")
            super().__init__(actual_instance=args[0])
        else:
            super().__init__(**kwargs)

    @field_validator('actual_instance')
    def actual_instance_must_validate_oneof(cls, v):
        instance = AddColumn.model_construct()
        error_messages = []
        match = 0
        # validate data type: AddColumnLookup
        if not isinstance(v, AddColumnLookup):
            error_messages.append(f"Error! Input type `{type(v)}` is not `AddColumnLookup`")
        else:
            match += 1
        # validate data type: AddColumnBoolean
        if not isinstance(v, AddColumnBoolean):
            error_messages.append(f"Error! Input type `{type(v)}` is not `AddColumnBoolean`")
        else:
            match += 1
        # validate data type: AddColumnDate
        if not isinstance(v, AddColumnDate):
            error_messages.append(f"Error! Input type `{type(v)}` is not `AddColumnDate`")
        else:
            match += 1
        # validate data type: AddColumnEditor
        if not isinstance(v, AddColumnEditor):
            error_messages.append(f"Error! Input type `{type(v)}` is not `AddColumnEditor`")
        else:
            match += 1
        # validate data type: AddColumnExpression
        if not isinstance(v, AddColumnExpression):
            error_messages.append(f"Error! Input type `{type(v)}` is not `AddColumnExpression`")
        else:
            match += 1
        # validate data type: AddColumnFile
        if not isinstance(v, AddColumnFile):
            error_messages.append(f"Error! Input type `{type(v)}` is not `AddColumnFile`")
        else:
            match += 1
        # validate data type: AddColumnFloat
        if not isinstance(v, AddColumnFloat):
            error_messages.append(f"Error! Input type `{type(v)}` is not `AddColumnFloat`")
        else:
            match += 1
        # validate data type: AddColumnInteger
        if not isinstance(v, AddColumnInteger):
            error_messages.append(f"Error! Input type `{type(v)}` is not `AddColumnInteger`")
        else:
            match += 1
        # validate data type: AddColumnReference
        if not isinstance(v, AddColumnReference):
            error_messages.append(f"Error! Input type `{type(v)}` is not `AddColumnReference`")
        else:
            match += 1
        # validate data type: AddColumnSelect
        if not isinstance(v, AddColumnSelect):
            error_messages.append(f"Error! Input type `{type(v)}` is not `AddColumnSelect`")
        else:
            match += 1
        # validate data type: AddColumnText
        if not isinstance(v, AddColumnText):
            error_messages.append(f"Error! Input type `{type(v)}` is not `AddColumnText`")
        else:
            match += 1
        # validate data type: AddColumnUrl
        if not isinstance(v, AddColumnUrl):
            error_messages.append(f"Error! Input type `{type(v)}` is not `AddColumnUrl`")
        else:
            match += 1
        # validate data type: AddColumnUser
        if not isinstance(v, AddColumnUser):
            error_messages.append(f"Error! Input type `{type(v)}` is not `AddColumnUser`")
        else:
            match += 1
        if match > 1:
            # more than 1 match
            raise ValueError("Multiple matches found when setting `actual_instance` in AddColumn with oneOf schemas: AddColumnBoolean, AddColumnDate, AddColumnEditor, AddColumnExpression, AddColumnFile, AddColumnFloat, AddColumnInteger, AddColumnLookup, AddColumnReference, AddColumnSelect, AddColumnText, AddColumnUrl, AddColumnUser. Details: " + ", ".join(error_messages))
        elif match == 0:
            # no match
            raise ValueError("No match found when setting `actual_instance` in AddColumn with oneOf schemas: AddColumnBoolean, AddColumnDate, AddColumnEditor, AddColumnExpression, AddColumnFile, AddColumnFloat, AddColumnInteger, AddColumnLookup, AddColumnReference, AddColumnSelect, AddColumnText, AddColumnUrl, AddColumnUser. Details: " + ", ".join(error_messages))
        else:
            return v

    @classmethod
    def from_dict(cls, obj: Union[str, Dict[str, Any]]) -> Self:
        return cls.from_json(json.dumps(obj))

    @classmethod
    def from_json(cls, json_str: str) -> Self:
        """Returns the object represented by the json string"""
        instance = cls.model_construct()
        error_messages = []
        match = 0

        # deserialize data into AddColumnLookup
        try:
            instance.actual_instance = AddColumnLookup.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))
        # deserialize data into AddColumnBoolean
        try:
            instance.actual_instance = AddColumnBoolean.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))
        # deserialize data into AddColumnDate
        try:
            instance.actual_instance = AddColumnDate.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))
        # deserialize data into AddColumnEditor
        try:
            instance.actual_instance = AddColumnEditor.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))
        # deserialize data into AddColumnExpression
        try:
            instance.actual_instance = AddColumnExpression.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))
        # deserialize data into AddColumnFile
        try:
            instance.actual_instance = AddColumnFile.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))
        # deserialize data into AddColumnFloat
        try:
            instance.actual_instance = AddColumnFloat.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))
        # deserialize data into AddColumnInteger
        try:
            instance.actual_instance = AddColumnInteger.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))
        # deserialize data into AddColumnReference
        try:
            instance.actual_instance = AddColumnReference.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))
        # deserialize data into AddColumnSelect
        try:
            instance.actual_instance = AddColumnSelect.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))
        # deserialize data into AddColumnText
        try:
            instance.actual_instance = AddColumnText.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))
        # deserialize data into AddColumnUrl
        try:
            instance.actual_instance = AddColumnUrl.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))
        # deserialize data into AddColumnUser
        try:
            instance.actual_instance = AddColumnUser.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))

        if match > 1:
            # more than 1 match
            raise ValueError("Multiple matches found when deserializing the JSON string into AddColumn with oneOf schemas: AddColumnBoolean, AddColumnDate, AddColumnEditor, AddColumnExpression, AddColumnFile, AddColumnFloat, AddColumnInteger, AddColumnLookup, AddColumnReference, AddColumnSelect, AddColumnText, AddColumnUrl, AddColumnUser. Details: " + ", ".join(error_messages))
        elif match == 0:
            # no match
            raise ValueError("No match found when deserializing the JSON string into AddColumn with oneOf schemas: AddColumnBoolean, AddColumnDate, AddColumnEditor, AddColumnExpression, AddColumnFile, AddColumnFloat, AddColumnInteger, AddColumnLookup, AddColumnReference, AddColumnSelect, AddColumnText, AddColumnUrl, AddColumnUser. Details: " + ", ".join(error_messages))
        else:
            return instance

    def to_json(self) -> str:
        """Returns the JSON representation of the actual instance"""
        if self.actual_instance is None:
            return "null"

        if hasattr(self.actual_instance, "to_json") and callable(self.actual_instance.to_json):
            return self.actual_instance.to_json()
        else:
            return json.dumps(self.actual_instance)

    def to_dict(self) -> Optional[Union[Dict[str, Any], AddColumnBoolean, AddColumnDate, AddColumnEditor, AddColumnExpression, AddColumnFile, AddColumnFloat, AddColumnInteger, AddColumnLookup, AddColumnReference, AddColumnSelect, AddColumnText, AddColumnUrl, AddColumnUser]]:
        """Returns the dict representation of the actual instance"""
        if self.actual_instance is None:
            return None

        if hasattr(self.actual_instance, "to_dict") and callable(self.actual_instance.to_dict):
            return self.actual_instance.to_dict()
        else:
            # primitive type
            return self.actual_instance

    def to_str(self) -> str:
        """Returns the string representation of the actual instance"""
        return pprint.pformat(self.model_dump())


