# do-sdk-platform
Combined API documentation for all platform services

This Python package is automatically generated by the [OpenAPI Generator](https://openapi-generator.tech) project:

- API version: 1.0.0
- Package version: 1.0.0
- Generator version: 7.16.0
- Build package: org.openapitools.codegen.languages.PythonClientCodegen

## Requirements.

Python 3.9+

## Installation & Usage
### pip install

If the python package is hosted on a repository, you can install directly using:

```sh
pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git
```
(you may need to run `pip` with root permission: `sudo pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git`)

Then import the package:
```python
import do_sdk_platform
```

### Setuptools

Install via [Setuptools](http://pypi.python.org/pypi/setuptools).

```sh
python setup.py install --user
```
(or `sudo python setup.py install` to install the package for all users)

Then import the package:
```python
import do_sdk_platform
```

### Tests

Execute `pytest` to run the tests.

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```python

import do_sdk_platform
from do_sdk_platform.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost
# See configuration.py for a list of all supported configuration parameters.
configuration = do_sdk_platform.Configuration(
    host = "http://localhost"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure HTTP basic authorization: basic
configuration = do_sdk_platform.Configuration(
    username = os.environ["USERNAME"],
    password = os.environ["PASSWORD"]
)


# Enter a context with an instance of the API client
with do_sdk_platform.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = do_sdk_platform.AuthenticationApi(api_client)

    try:
        # Get Keycloak Token
        api_response = api_instance.entities_get_protected_service_token()
        print("The response of AuthenticationApi->entities_get_protected_service_token:\n")
        pprint(api_response)
    except ApiException as e:
        print("Exception when calling AuthenticationApi->entities_get_protected_service_token: %s\n" % e)

```

## Documentation for API Endpoints

All URIs are relative to *http://localhost*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*AuthenticationApi* | [**entities_get_protected_service_token**](docs/AuthenticationApi.md#entities_get_protected_service_token) | **GET** /entities/protected/service/token:create | Get Keycloak Token
*AuthenticationApi* | [**entities_get_public_jwks**](docs/AuthenticationApi.md#entities_get_public_jwks) | **GET** /entities/public/jwks | Get Keycloak JWKS
*AuthenticationApi* | [**entities_refresh_token**](docs/AuthenticationApi.md#entities_refresh_token) | **GET** /entities/{orgKey}/token/{serviceName}:refresh | Get Keycloak JWKS
*BillingApi* | [**billing_add_credits**](docs/BillingApi.md#billing_add_credits) | **POST** /billing/{orgKey}/credits | Add Credits
*BillingApi* | [**billing_check**](docs/BillingApi.md#billing_check) | **GET** /billing/health | 
*BillingApi* | [**billing_delete_payment**](docs/BillingApi.md#billing_delete_payment) | **DELETE** /billing/{orgKey}/payments/{paymentId} | Delete payment
*BillingApi* | [**billing_delete_subscription**](docs/BillingApi.md#billing_delete_subscription) | **DELETE** /billing/{orgKey}/subscriptions/{subscriptionId}/{immediately} | Delete Subscriptions
*BillingApi* | [**billing_get_active_subscriptions**](docs/BillingApi.md#billing_get_active_subscriptions) | **GET** /billing/{orgKey}/subscriptions | Get Active Subscriptions
*BillingApi* | [**billing_get_all_subscriptions**](docs/BillingApi.md#billing_get_all_subscriptions) | **GET** /billing/{orgKey}/subscriptions/all | Gets All Subscriptions
*BillingApi* | [**billing_get_billing_address**](docs/BillingApi.md#billing_get_billing_address) | **GET** /billing/{orgKey}/address | Retrieve billing address
*BillingApi* | [**billing_get_countries**](docs/BillingApi.md#billing_get_countries) | **GET** /billing/{orgKey}/countries | Retrieve available countries
*BillingApi* | [**billing_get_credit_balance**](docs/BillingApi.md#billing_get_credit_balance) | **GET** /billing/{orgKey}/credits/balance | Get Credit Balance
*BillingApi* | [**billing_get_credit_line**](docs/BillingApi.md#billing_get_credit_line) | **GET** /billing/{orgKey}/credits/line | Get credit line information
*BillingApi* | [**billing_get_credits_history**](docs/BillingApi.md#billing_get_credits_history) | **GET** /billing/{orgKey}/credits/history | Get Credits History
*BillingApi* | [**billing_get_credits_usage**](docs/BillingApi.md#billing_get_credits_usage) | **GET** /billing/{orgKey}/credits/usage | Get Credits Usage
*BillingApi* | [**billing_get_feature_descriptions**](docs/BillingApi.md#billing_get_feature_descriptions) | **GET** /billing/{orgKey}/feature/descriptions | Get feature descriptions
*BillingApi* | [**billing_get_features**](docs/BillingApi.md#billing_get_features) | **GET** /billing/{orgKey}/features | Get Subscription Features
*BillingApi* | [**billing_get_invoice_pdf_link**](docs/BillingApi.md#billing_get_invoice_pdf_link) | **GET** /billing/{orgKey}/invoices/pdfLink/{id} | Get invoice PDF link
*BillingApi* | [**billing_get_invoices**](docs/BillingApi.md#billing_get_invoices) | **GET** /billing/{orgKey}/invoices | Get Invoices
*BillingApi* | [**billing_get_monthly_balance**](docs/BillingApi.md#billing_get_monthly_balance) | **GET** /billing/{orgKey}/credits/monthly/{month}/{year} | Get Monthly Credit Usage
*BillingApi* | [**billing_get_monthly_overview**](docs/BillingApi.md#billing_get_monthly_overview) | **GET** /billing/{orgKey}/usage/monthly/{year}/{month} | Get Monthly Overview
*BillingApi* | [**billing_get_past_subscriptions**](docs/BillingApi.md#billing_get_past_subscriptions) | **GET** /billing/{orgKey}/subscriptions/past | Get Past Subscriptions
*BillingApi* | [**billing_get_payment**](docs/BillingApi.md#billing_get_payment) | **GET** /billing/{orgKey}/payments | List payment methods
*BillingApi* | [**billing_get_payment_link**](docs/BillingApi.md#billing_get_payment_link) | **GET** /billing/{orgKey}/invoices/payment/{id}/{tab} | Get payment link
*BillingApi* | [**billing_get_recent_activity**](docs/BillingApi.md#billing_get_recent_activity) | **GET** /billing/{orgKey}/usage/recent | Get Recent Activity
*BillingApi* | [**billing_get_version**](docs/BillingApi.md#billing_get_version) | **GET** /billing/version | Get service version
*BillingApi* | [**billing_pay**](docs/BillingApi.md#billing_pay) | **POST** /billing/{orgKey}/invoices/{invoiceId}/{paymentId} | Process payment
*BillingApi* | [**billing_update_billing_address**](docs/BillingApi.md#billing_update_billing_address) | **POST** /billing/{orgKey}/address | Update billing address
*BillingApi* | [**billing_update_payment**](docs/BillingApi.md#billing_update_payment) | **POST** /billing/{orgKey}/payments | Update payment details
*BillingApi* | [**billing_update_subscription**](docs/BillingApi.md#billing_update_subscription) | **POST** /billing/{orgKey}/subscriptions | Updates Subscription
*DataPlatformApi* | [**data_platform_add_column**](docs/DataPlatformApi.md#data_platform_add_column) | **POST** /data-platform/{orgKey}/{entity}/meta/columns | Add column to an entity (physical or computed)
*DataPlatformApi* | [**data_platform_batch_changes**](docs/DataPlatformApi.md#data_platform_batch_changes) | **POST** /data-platform/{orgKey}/{entity}/batch/changes | Batch changes (multi-op) for an entity
*DataPlatformApi* | [**data_platform_batch_create**](docs/DataPlatformApi.md#data_platform_batch_create) | **POST** /data-platform/{orgKey}/{entity}/batch/create | Batch create entities
*DataPlatformApi* | [**data_platform_batch_delete**](docs/DataPlatformApi.md#data_platform_batch_delete) | **POST** /data-platform/{orgKey}/{entity}/batch/delete | Batch delete entities by ids
*DataPlatformApi* | [**data_platform_batch_truncate**](docs/DataPlatformApi.md#data_platform_batch_truncate) | **POST** /data-platform/{orgKey}/{entity}/batch/truncate | Truncate an entity (admin)
*DataPlatformApi* | [**data_platform_batch_update**](docs/DataPlatformApi.md#data_platform_batch_update) | **PATCH** /data-platform/{orgKey}/{entity}/batch/update | Batch update entities by ids
*DataPlatformApi* | [**data_platform_create_one**](docs/DataPlatformApi.md#data_platform_create_one) | **POST** /data-platform/{orgKey}/{entity} | Create one entity
*DataPlatformApi* | [**data_platform_delete_attribute**](docs/DataPlatformApi.md#data_platform_delete_attribute) | **DELETE** /data-platform/{orgKey}/meta/attributes/{id} | Delete a canonical attribute definition
*DataPlatformApi* | [**data_platform_delete_column**](docs/DataPlatformApi.md#data_platform_delete_column) | **DELETE** /data-platform/{orgKey}/{entity}/meta/columns/{name} | Soft-delete column for an entity
*DataPlatformApi* | [**data_platform_delete_one**](docs/DataPlatformApi.md#data_platform_delete_one) | **DELETE** /data-platform/{orgKey}/{entity}/{id} | Soft-delete one entity by id
*DataPlatformApi* | [**data_platform_get_one**](docs/DataPlatformApi.md#data_platform_get_one) | **GET** /data-platform/{orgKey}/{entity}/{id} | Get one entity by id
*DataPlatformApi* | [**data_platform_health**](docs/DataPlatformApi.md#data_platform_health) | **GET** /data-platform/health | 
*DataPlatformApi* | [**data_platform_list_columns**](docs/DataPlatformApi.md#data_platform_list_columns) | **GET** /data-platform/{orgKey}/{entity}/meta/columns | List columns for an entity
*DataPlatformApi* | [**data_platform_org_health**](docs/DataPlatformApi.md#data_platform_org_health) | **GET** /data-platform/{orgKey}/health | 
*DataPlatformApi* | [**data_platform_patch_attribute**](docs/DataPlatformApi.md#data_platform_patch_attribute) | **PATCH** /data-platform/{orgKey}/meta/attributes/{id} | Patch a canonical attribute definition by id
*DataPlatformApi* | [**data_platform_patch_column_http**](docs/DataPlatformApi.md#data_platform_patch_column_http) | **PATCH** /data-platform/{orgKey}/{entity}/meta/columns/{name} | Patch column metadata or computed definition
*DataPlatformApi* | [**data_platform_search**](docs/DataPlatformApi.md#data_platform_search) | **POST** /data-platform/{orgKey}/{entity}/search | Search an entity
*DataPlatformApi* | [**data_platform_search_attributes**](docs/DataPlatformApi.md#data_platform_search_attributes) | **POST** /data-platform/{orgKey}/meta/attributes/search | Search/browse the attribute catalog
*DataPlatformApi* | [**data_platform_update_one**](docs/DataPlatformApi.md#data_platform_update_one) | **PATCH** /data-platform/{orgKey}/{entity}/{id} | Update one entity by id (immutable versioning)
*DataPlatformApi* | [**data_platform_upsert_attribute**](docs/DataPlatformApi.md#data_platform_upsert_attribute) | **POST** /data-platform/{orgKey}/meta/attributes | Upsert a canonical attribute definition
*EntitiesApi* | [**entities_accept_organization_invite**](docs/EntitiesApi.md#entities_accept_organization_invite) | **GET** /entities/protected/organizations/invites/{code}:accept | Accept an organization invite
*EntitiesApi* | [**entities_check**](docs/EntitiesApi.md#entities_check) | **GET** /entities/health | Check overall service health
*EntitiesApi* | [**entities_contact_us**](docs/EntitiesApi.md#entities_contact_us) | **POST** /entities/{orgKey}/organizations/contact/us | Submit a contact request
*EntitiesApi* | [**entities_create_account**](docs/EntitiesApi.md#entities_create_account) | **POST** /entities/public/accounts | Create Account
*EntitiesApi* | [**entities_create_organization**](docs/EntitiesApi.md#entities_create_organization) | **POST** /entities/protected/organizations | Create a new organization
*EntitiesApi* | [**entities_create_signup_code**](docs/EntitiesApi.md#entities_create_signup_code) | **POST** /entities/public/accounts/verify | Create Signup Code
*EntitiesApi* | [**entities_create_token**](docs/EntitiesApi.md#entities_create_token) | **POST** /entities/protected/accounts/user/tokens | Create long-lived personal access token for user.
*EntitiesApi* | [**entities_delete_organization**](docs/EntitiesApi.md#entities_delete_organization) | **DELETE** /entities/{orgKey}/organizations | 
*EntitiesApi* | [**entities_delete_organization_invite**](docs/EntitiesApi.md#entities_delete_organization_invite) | **DELETE** /entities/{orgKey}/organizations/invites/{email} | 
*EntitiesApi* | [**entities_delete_organization_member**](docs/EntitiesApi.md#entities_delete_organization_member) | **DELETE** /entities/{orgKey}/organizations/users/{userId} | Delete an organization member
*EntitiesApi* | [**entities_generate_referral_code**](docs/EntitiesApi.md#entities_generate_referral_code) | **POST** /entities/protected/users/referral | Generate a referral code
*EntitiesApi* | [**entities_get_account**](docs/EntitiesApi.md#entities_get_account) | **GET** /entities/protected/account | Get user account
*EntitiesApi* | [**entities_get_flags**](docs/EntitiesApi.md#entities_get_flags) | **GET** /entities/protected/account/users/flags | Get user flags
*EntitiesApi* | [**entities_get_keycloak_token**](docs/EntitiesApi.md#entities_get_keycloak_token) | **GET** /entities/{orgKey}/token/{serviceName}:create | Get Keycloak Token
*EntitiesApi* | [**entities_get_notifications**](docs/EntitiesApi.md#entities_get_notifications) | **GET** /entities/{orgKey}/users/notifications/{notificationId} | 
*EntitiesApi* | [**entities_get_organization**](docs/EntitiesApi.md#entities_get_organization) | **GET** /entities/{orgKey} | 
*EntitiesApi* | [**entities_get_organization_invite**](docs/EntitiesApi.md#entities_get_organization_invite) | **GET** /entities/{orgKey}/organizations/invites/{code} | 
*EntitiesApi* | [**entities_get_organization_settings**](docs/EntitiesApi.md#entities_get_organization_settings) | **GET** /entities/{orgKey}/settings | 
*EntitiesApi* | [**entities_get_organization_threshold**](docs/EntitiesApi.md#entities_get_organization_threshold) | **GET** /entities/{orgKey}/approvalThreshold | 
*EntitiesApi* | [**entities_get_organization_user**](docs/EntitiesApi.md#entities_get_organization_user) | **GET** /entities/{orgKey}/organizations/users/{userId} | Get organization user details
*EntitiesApi* | [**entities_get_organization_users**](docs/EntitiesApi.md#entities_get_organization_users) | **GET** /entities/{orgKey}/organizations/users | List organization users
*EntitiesApi* | [**entities_get_organizations**](docs/EntitiesApi.md#entities_get_organizations) | **GET** /entities/admin/organizations | List Organizations
*EntitiesApi* | [**entities_get_role_by_email**](docs/EntitiesApi.md#entities_get_role_by_email) | **GET** /entities/protected/{orgKey}/roles | 
*EntitiesApi* | [**entities_get_scopes**](docs/EntitiesApi.md#entities_get_scopes) | **GET** /entities/protected/accounts/user/tokens/scopes | List all available scopes.
*EntitiesApi* | [**entities_get_signup_code**](docs/EntitiesApi.md#entities_get_signup_code) | **GET** /entities/public/accounts/verify/{code} | Get Signup Code
*EntitiesApi* | [**entities_get_tokens**](docs/EntitiesApi.md#entities_get_tokens) | **GET** /entities/protected/accounts/user/tokens | List of users personal access token.
*EntitiesApi* | [**entities_get_unique_organization_id**](docs/EntitiesApi.md#entities_get_unique_organization_id) | **GET** /entities/protected/organizations/unique/id/{companyName} | Generate a unique organization friendly ID
*EntitiesApi* | [**entities_get_version**](docs/EntitiesApi.md#entities_get_version) | **GET** /entities/version | Get service version
*EntitiesApi* | [**entities_invite_organization_member**](docs/EntitiesApi.md#entities_invite_organization_member) | **POST** /entities/{orgKey}/organizations/invite | 
*EntitiesApi* | [**entities_list_notifications**](docs/EntitiesApi.md#entities_list_notifications) | **GET** /entities/{orgKey}/users/notifications | Get billing notifications
*EntitiesApi* | [**entities_list_organizations**](docs/EntitiesApi.md#entities_list_organizations) | **GET** /entities/protected/organizations | 
*EntitiesApi* | [**entities_read_notification**](docs/EntitiesApi.md#entities_read_notification) | **POST** /entities/{orgKey}/users/notifications/{notificationId}/read | Mark a notification as read
*EntitiesApi* | [**entities_revoke_token**](docs/EntitiesApi.md#entities_revoke_token) | **DELETE** /entities/protected/accounts/user/tokens/{tokenId} | Revoke user token.
*EntitiesApi* | [**entities_send_all_notifications**](docs/EntitiesApi.md#entities_send_all_notifications) | **DELETE** /entities/admin/users/{email} | Delete a user
*EntitiesApi* | [**entities_send_notification_all_users**](docs/EntitiesApi.md#entities_send_notification_all_users) | **POST** /entities/admin/users/notifications/all | 
*EntitiesApi* | [**entities_send_notification_to_user**](docs/EntitiesApi.md#entities_send_notification_to_user) | **POST** /entities/{orgKey}/users/{userId}/notifications | 
*EntitiesApi* | [**entities_send_notification_user**](docs/EntitiesApi.md#entities_send_notification_user) | **POST** /entities/admin/users/notifications/user/{userId} | 
*EntitiesApi* | [**entities_update_account**](docs/EntitiesApi.md#entities_update_account) | **PATCH** /entities/protected/account | Update user account
*EntitiesApi* | [**entities_update_organization**](docs/EntitiesApi.md#entities_update_organization) | **PATCH** /entities/{orgKey} | 
*EntitiesApi* | [**entities_update_organization_invite_role**](docs/EntitiesApi.md#entities_update_organization_invite_role) | **PATCH** /entities/{orgKey}/organizations/invites/{email} | 
*EntitiesApi* | [**entities_update_organization_member_role**](docs/EntitiesApi.md#entities_update_organization_member_role) | **PATCH** /entities/{orgKey}/organizations/users/{userId} | 
*EntitiesApi* | [**entities_update_organization_status**](docs/EntitiesApi.md#entities_update_organization_status) | **PATCH** /entities/{orgKey}/organizations/status | 
*FileApi* | [**files_check**](docs/FileApi.md#files_check) | **GET** /files/health | 
*FileApi* | [**files_delete_object**](docs/FileApi.md#files_delete_object) | **DELETE** /files/{orgKey}/{filePath} | 
*FileApi* | [**files_get_object**](docs/FileApi.md#files_get_object) | **GET** /files/{orgKey}/{filePath} | 
*FileApi* | [**files_get_object_directory**](docs/FileApi.md#files_get_object_directory) | **GET** /files/{orgKey}/directory/{filePath} | 
*FileApi* | [**files_get_signed_url**](docs/FileApi.md#files_get_signed_url) | **GET** /files/{orgKey}/signedUrl/{filePath} | 
*FileApi* | [**files_get_version**](docs/FileApi.md#files_get_version) | **GET** /files/version | Get service version
*FileApi* | [**files_head_object**](docs/FileApi.md#files_head_object) | **HEAD** /files/{orgKey}/{filePath} | 
*FileApi* | [**files_post_url_file**](docs/FileApi.md#files_post_url_file) | **POST** /files/{orgKey}/{filePath} | Upload a file from a URL
*FileApi* | [**files_put_object**](docs/FileApi.md#files_put_object) | **PUT** /files/{orgKey}/{filePath} | 
*ToolsApi* | [**tools_action_tool_execution**](docs/ToolsApi.md#tools_action_tool_execution) | **PATCH** /tools/{orgKey}/tools/executions/{executionId}:{action} | Updates a Tool
*ToolsApi* | [**tools_capture_event**](docs/ToolsApi.md#tools_capture_event) | **POST** /tools/protected/ulog | Capture a custom analytics event
*ToolsApi* | [**tools_check**](docs/ToolsApi.md#tools_check) | **GET** /tools/health | 
*ToolsApi* | [**tools_create_function**](docs/ToolsApi.md#tools_create_function) | **POST** /tools/admin/functions/definitions | Creates a function
*ToolsApi* | [**tools_create_tool**](docs/ToolsApi.md#tools_create_tool) | **POST** /tools/admin/tools/definitions | Creates a new tool definition
*ToolsApi* | [**tools_delete_function**](docs/ToolsApi.md#tools_delete_function) | **DELETE** /tools/tools/admin/functions/{key}/{version}/definitions | Deletes a specific version of a function definition
*ToolsApi* | [**tools_delete_tool**](docs/ToolsApi.md#tools_delete_tool) | **DELETE** /tools/admin/tools/{toolKey}/{toolVersion}/definitions | Deletes a specific version of a tool definition
*ToolsApi* | [**tools_enable_disable_function**](docs/ToolsApi.md#tools_enable_disable_function) | **PUT** /tools/tools/admin/functions/{key}/{version}/definitions | Enable or disable a specific version of a function
*ToolsApi* | [**tools_execute_tool**](docs/ToolsApi.md#tools_execute_tool) | **POST** /tools/{orgKey}/tools/{toolKey}/executions | Executes a Tool
*ToolsApi* | [**tools_execute_tool_with_version**](docs/ToolsApi.md#tools_execute_tool_with_version) | **POST** /tools/{orgKey}/tools/{toolKey}/{toolVersion}/executions | Executes a Tool with a version
*ToolsApi* | [**tools_get_admin_tool_executions**](docs/ToolsApi.md#tools_get_admin_tool_executions) | **GET** /tools/admin/tools/executions | List admin tool executions
*ToolsApi* | [**tools_get_all_tools**](docs/ToolsApi.md#tools_get_all_tools) | **GET** /tools/protected/tools/definitions | Get all tools definition
*ToolsApi* | [**tools_get_connection**](docs/ToolsApi.md#tools_get_connection) | **GET** /tools/message-communication | Check connection status
*ToolsApi* | [**tools_get_function**](docs/ToolsApi.md#tools_get_function) | **GET** /tools/protected/functions/{key}/{version} | Gets a function by key and version
*ToolsApi* | [**tools_get_functions**](docs/ToolsApi.md#tools_get_functions) | **GET** /tools/protected/functions/definitions | Gets all functions
*ToolsApi* | [**tools_get_functions_bykey**](docs/ToolsApi.md#tools_get_functions_bykey) | **GET** /tools/protected/functions/{key}/definitions | Gets all versions of function key
*ToolsApi* | [**tools_get_tool**](docs/ToolsApi.md#tools_get_tool) | **GET** /tools/protected/tools/{toolKey}/definitions | Get all versions of a tool definition
*ToolsApi* | [**tools_get_tool_execution**](docs/ToolsApi.md#tools_get_tool_execution) | **GET** /tools/{orgKey}/tools/executions/{executionId} | Gets a Tool
*ToolsApi* | [**tools_get_tool_executions**](docs/ToolsApi.md#tools_get_tool_executions) | **GET** /tools/{orgKey}/tools/executions | Gets Paginated Tools Executions
*ToolsApi* | [**tools_get_version**](docs/ToolsApi.md#tools_get_version) | **GET** /tools/version | Get service version
*ToolsApi* | [**tools_get_versioned_tool**](docs/ToolsApi.md#tools_get_versioned_tool) | **GET** /tools/protected/tools/{toolKey}/{toolVersion}/definitions | Get a specific version of a tool definition
*ToolsApi* | [**tools_list_clusters**](docs/ToolsApi.md#tools_list_clusters) | **GET** /tools/{orgKey}/clusters | List Clusters by Org ID
*ToolsApi* | [**tools_run_function**](docs/ToolsApi.md#tools_run_function) | **POST** /tools/{orgKey}/functions/{key}/{version} | Runs a function (specific version)
*ToolsApi* | [**tools_run_function_latest**](docs/ToolsApi.md#tools_run_function_latest) | **POST** /tools/{orgKey}/functions/{key} | Runs a function (latest version)
*ToolsApi* | [**tools_update_execution**](docs/ToolsApi.md#tools_update_execution) | **PATCH** /tools/{orgKey}/tools/executions/{resourceId} | Updates a Tool
*ToolsApi* | [**tools_update_function**](docs/ToolsApi.md#tools_update_function) | **PUT** /tools/admin/functions/{key}/{version} | Updates a specific version of a function
*ToolsApi* | [**tools_update_tool**](docs/ToolsApi.md#tools_update_tool) | **PUT** /tools/admin/tools/{toolKey}/{toolVersion}/definitions | Updates a specific version of a tool definition


## Documentation For Models

 - [AddColumn](docs/AddColumn.md)
 - [AddColumnBoolean](docs/AddColumnBoolean.md)
 - [AddColumnDate](docs/AddColumnDate.md)
 - [AddColumnEditor](docs/AddColumnEditor.md)
 - [AddColumnExpression](docs/AddColumnExpression.md)
 - [AddColumnFile](docs/AddColumnFile.md)
 - [AddColumnFloat](docs/AddColumnFloat.md)
 - [AddColumnInteger](docs/AddColumnInteger.md)
 - [AddColumnLookup](docs/AddColumnLookup.md)
 - [AddColumnReference](docs/AddColumnReference.md)
 - [AddColumnSelect](docs/AddColumnSelect.md)
 - [AddColumnText](docs/AddColumnText.md)
 - [AddColumnUrl](docs/AddColumnUrl.md)
 - [AddColumnUser](docs/AddColumnUser.md)
 - [AddCreditsRequestSchemaDto](docs/AddCreditsRequestSchemaDto.md)
 - [AdminOrganizationSchemaDto](docs/AdminOrganizationSchemaDto.md)
 - [BillingAddressSchemaDto](docs/BillingAddressSchemaDto.md)
 - [BillingCheck200Response](docs/BillingCheck200Response.md)
 - [CaptureEventSchemaDto](docs/CaptureEventSchemaDto.md)
 - [CaptureEventSchemaDtoEventName](docs/CaptureEventSchemaDtoEventName.md)
 - [ChatThread](docs/ChatThread.md)
 - [ClusterSchemaDto](docs/ClusterSchemaDto.md)
 - [CodeExeuction](docs/CodeExeuction.md)
 - [Column](docs/Column.md)
 - [ColumnBooleanBase](docs/ColumnBooleanBase.md)
 - [ColumnDateBase](docs/ColumnDateBase.md)
 - [ColumnEditorBase](docs/ColumnEditorBase.md)
 - [ColumnExpressionBase](docs/ColumnExpressionBase.md)
 - [ColumnFileBase](docs/ColumnFileBase.md)
 - [ColumnFileBaseConfigFile](docs/ColumnFileBaseConfigFile.md)
 - [ColumnFloatBase](docs/ColumnFloatBase.md)
 - [ColumnFloatBaseConfigNumeric](docs/ColumnFloatBaseConfigNumeric.md)
 - [ColumnIntegerBase](docs/ColumnIntegerBase.md)
 - [ColumnLookupBase](docs/ColumnLookupBase.md)
 - [ColumnPrimitive](docs/ColumnPrimitive.md)
 - [ColumnReferenceBase](docs/ColumnReferenceBase.md)
 - [ColumnSelectBase](docs/ColumnSelectBase.md)
 - [ColumnSelectBaseConfigSelect](docs/ColumnSelectBaseConfigSelect.md)
 - [ColumnSelection](docs/ColumnSelection.md)
 - [ColumnTextBase](docs/ColumnTextBase.md)
 - [ColumnTypeBase](docs/ColumnTypeBase.md)
 - [ColumnUrlBase](docs/ColumnUrlBase.md)
 - [ColumnUserBase](docs/ColumnUserBase.md)
 - [ContactUsInputSchemaDto](docs/ContactUsInputSchemaDto.md)
 - [CountrySchemaDto](docs/CountrySchemaDto.md)
 - [CreateAccountInputV2SchemaDto](docs/CreateAccountInputV2SchemaDto.md)
 - [CreateNotificationInputSchemaDto](docs/CreateNotificationInputSchemaDto.md)
 - [CreateOrganizationInputSchemaDto](docs/CreateOrganizationInputSchemaDto.md)
 - [CreatePATInputSchemaDto](docs/CreatePATInputSchemaDto.md)
 - [CreatePATOutputSchemaDto](docs/CreatePATOutputSchemaDto.md)
 - [CreditAccountBalanceSchemaDto](docs/CreditAccountBalanceSchemaDto.md)
 - [CreditHistorySchemaDto](docs/CreditHistorySchemaDto.md)
 - [CreditLineSchemaDto](docs/CreditLineSchemaDto.md)
 - [CreditUsageSchemaDto](docs/CreditUsageSchemaDto.md)
 - [DataPlatformBatchChangesRequest](docs/DataPlatformBatchChangesRequest.md)
 - [DataPlatformBatchCreateRequest](docs/DataPlatformBatchCreateRequest.md)
 - [DataPlatformBatchDeleteRequest](docs/DataPlatformBatchDeleteRequest.md)
 - [DataPlatformBatchTruncateRequest](docs/DataPlatformBatchTruncateRequest.md)
 - [DataPlatformBatchUpdateRequest](docs/DataPlatformBatchUpdateRequest.md)
 - [DataPlatformBatchUpdateRequestUpdatesInner](docs/DataPlatformBatchUpdateRequestUpdatesInner.md)
 - [DataPlatformCreateOneRequest](docs/DataPlatformCreateOneRequest.md)
 - [DataPlatformSearchRequest](docs/DataPlatformSearchRequest.md)
 - [DataPlatformUpdateOneRequest](docs/DataPlatformUpdateOneRequest.md)
 - [Database](docs/Database.md)
 - [DatabaseRow](docs/DatabaseRow.md)
 - [DatabaseView](docs/DatabaseView.md)
 - [DatabaseViewCreate](docs/DatabaseViewCreate.md)
 - [DatabaseViewUpdate](docs/DatabaseViewUpdate.md)
 - [DescribeDatabaseRequest](docs/DescribeDatabaseRequest.md)
 - [DescribeDatabaseResponse](docs/DescribeDatabaseResponse.md)
 - [DescribeDatabaseRowRequest](docs/DescribeDatabaseRowRequest.md)
 - [DescribeDatabaseRowResponse](docs/DescribeDatabaseRowResponse.md)
 - [DescribeHierarchyRequest](docs/DescribeHierarchyRequest.md)
 - [DescribeHierarchyResponse](docs/DescribeHierarchyResponse.md)
 - [DescribeHierarchyResponseDataInner](docs/DescribeHierarchyResponseDataInner.md)
 - [DescribeRowRequest](docs/DescribeRowRequest.md)
 - [DescribeRowResponse](docs/DescribeRowResponse.md)
 - [DescribeWorkspaceRequest](docs/DescribeWorkspaceRequest.md)
 - [DescribeWorkspaceResponse](docs/DescribeWorkspaceResponse.md)
 - [EntitiesCheck200Response](docs/EntitiesCheck200Response.md)
 - [EntitiesCheck200ResponseErrorValue](docs/EntitiesCheck200ResponseErrorValue.md)
 - [EntitiesCheck200ResponseInfoValue](docs/EntitiesCheck200ResponseInfoValue.md)
 - [EntitiesCheck503Response](docs/EntitiesCheck503Response.md)
 - [EntitiesCreateSignupCode200Response](docs/EntitiesCreateSignupCode200Response.md)
 - [EntitiesGetVersion200Response](docs/EntitiesGetVersion200Response.md)
 - [EntitiesSendNotificationAllUsers200Response](docs/EntitiesSendNotificationAllUsers200Response.md)
 - [Error](docs/Error.md)
 - [ErrorDTo](docs/ErrorDTo.md)
 - [ExecuteToolSchemaDto](docs/ExecuteToolSchemaDto.md)
 - [FeatureDescriptionsResponseSchemaDto](docs/FeatureDescriptionsResponseSchemaDto.md)
 - [FeatureDescriptionsResponseSchemaDtoFeaturesInner](docs/FeatureDescriptionsResponseSchemaDtoFeaturesInner.md)
 - [FieldBase](docs/FieldBase.md)
 - [FieldBoolean](docs/FieldBoolean.md)
 - [FieldDate](docs/FieldDate.md)
 - [FieldEditor](docs/FieldEditor.md)
 - [FieldEditorValue](docs/FieldEditorValue.md)
 - [FieldExpression](docs/FieldExpression.md)
 - [FieldExpressionValue](docs/FieldExpressionValue.md)
 - [FieldExpressionValueResult](docs/FieldExpressionValueResult.md)
 - [FieldFile](docs/FieldFile.md)
 - [FieldFileValue](docs/FieldFileValue.md)
 - [FieldFloat](docs/FieldFloat.md)
 - [FieldInteger](docs/FieldInteger.md)
 - [FieldLookup](docs/FieldLookup.md)
 - [FieldLookupValue](docs/FieldLookupValue.md)
 - [FieldReference](docs/FieldReference.md)
 - [FieldReferenceValue](docs/FieldReferenceValue.md)
 - [FieldSelect](docs/FieldSelect.md)
 - [FieldSelectValue](docs/FieldSelectValue.md)
 - [FieldText](docs/FieldText.md)
 - [FieldUrl](docs/FieldUrl.md)
 - [FieldUrlValue](docs/FieldUrlValue.md)
 - [FieldUrlValueUrlsInner](docs/FieldUrlValueUrlsInner.md)
 - [FieldUser](docs/FieldUser.md)
 - [FieldUserValue](docs/FieldUserValue.md)
 - [File](docs/File.md)
 - [FilesGetObjectDirectory200Response](docs/FilesGetObjectDirectory200Response.md)
 - [FilesGetSignedUrl200Response](docs/FilesGetSignedUrl200Response.md)
 - [FilesPostUrlFile200Response](docs/FilesPostUrlFile200Response.md)
 - [FilesPostUrlFileRequest](docs/FilesPostUrlFileRequest.md)
 - [FilesPutObject200Response](docs/FilesPutObject200Response.md)
 - [FilesPutObject200ResponseS3](docs/FilesPutObject200ResponseS3.md)
 - [FunctionCreationResponseSchemaDto](docs/FunctionCreationResponseSchemaDto.md)
 - [FunctionCreationResponseSchemaDtoDeploymentStatusesInner](docs/FunctionCreationResponseSchemaDtoDeploymentStatusesInner.md)
 - [FunctionCreationResponseSchemaDtoFunction](docs/FunctionCreationResponseSchemaDtoFunction.md)
 - [FunctionCreationResponseSchemaDtoFunctionManifestBody](docs/FunctionCreationResponseSchemaDtoFunctionManifestBody.md)
 - [FunctionExecutionParamsSchemaDto](docs/FunctionExecutionParamsSchemaDto.md)
 - [FunctionManifestSchemaDto](docs/FunctionManifestSchemaDto.md)
 - [FunctionVersionInterfaceSchemaDto](docs/FunctionVersionInterfaceSchemaDto.md)
 - [GetSubscriptionsResultsSchemaDto](docs/GetSubscriptionsResultsSchemaDto.md)
 - [GetSubscriptionsResultsSchemaDtoSubscriptionsInner](docs/GetSubscriptionsResultsSchemaDtoSubscriptionsInner.md)
 - [GetSubscriptionsResultsSchemaDtoSubscriptionsInnerPlansInner](docs/GetSubscriptionsResultsSchemaDtoSubscriptionsInnerPlansInner.md)
 - [GetSubscriptionsResultsSchemaDtoSubscriptionsInnerPlansInnerMeta](docs/GetSubscriptionsResultsSchemaDtoSubscriptionsInnerPlansInnerMeta.md)
 - [HTTPErrorObjectDto](docs/HTTPErrorObjectDto.md)
 - [HTTPSourceObjectDto](docs/HTTPSourceObjectDto.md)
 - [HttpLinksDto](docs/HttpLinksDto.md)
 - [HttpListResponseBaseDto](docs/HttpListResponseBaseDto.md)
 - [HttpResponseBaseDto](docs/HttpResponseBaseDto.md)
 - [HttpResponseDataBase](docs/HttpResponseDataBase.md)
 - [InvalidData](docs/InvalidData.md)
 - [InviteUserToOrgInputSchemaDto](docs/InviteUserToOrgInputSchemaDto.md)
 - [InvoiceResultSchemaDto](docs/InvoiceResultSchemaDto.md)
 - [LinkResponseSchemaDto](docs/LinkResponseSchemaDto.md)
 - [MetaAttributesPatchDto](docs/MetaAttributesPatchDto.md)
 - [MetaAttributesUpsertDto](docs/MetaAttributesUpsertDto.md)
 - [MetaColumnsAddDto](docs/MetaColumnsAddDto.md)
 - [MetaColumnsDeleteDto](docs/MetaColumnsDeleteDto.md)
 - [MetaColumnsPatchDto](docs/MetaColumnsPatchDto.md)
 - [ModelField](docs/ModelField.md)
 - [MonthlyCreditUsageSchemaDto](docs/MonthlyCreditUsageSchemaDto.md)
 - [MonthlyCreditUsageSchemaDtoItemsInner](docs/MonthlyCreditUsageSchemaDtoItemsInner.md)
 - [MonthlyOverviewItemSchemaDto](docs/MonthlyOverviewItemSchemaDto.md)
 - [NotificationSchemaDto](docs/NotificationSchemaDto.md)
 - [NumberFormat](docs/NumberFormat.md)
 - [OrganizationInviteSchemaDto](docs/OrganizationInviteSchemaDto.md)
 - [OrganizationSchemaDto](docs/OrganizationSchemaDto.md)
 - [OrganizationSettingResponseSchemaDto](docs/OrganizationSettingResponseSchemaDto.md)
 - [OrganizationThresholdResponseSchemaDto](docs/OrganizationThresholdResponseSchemaDto.md)
 - [PatMetadataSchemaDto](docs/PatMetadataSchemaDto.md)
 - [PaymentMethodSchemaDto](docs/PaymentMethodSchemaDto.md)
 - [RecentActivityItemSchemaDto](docs/RecentActivityItemSchemaDto.md)
 - [ResolvedDatabaseId](docs/ResolvedDatabaseId.md)
 - [ResolvedRowId](docs/ResolvedRowId.md)
 - [ResolvedWorkspaceId](docs/ResolvedWorkspaceId.md)
 - [Row](docs/Row.md)
 - [RowFilter](docs/RowFilter.md)
 - [RowFilterAnyOf](docs/RowFilterAnyOf.md)
 - [RowFilterBoolean](docs/RowFilterBoolean.md)
 - [RowFilterJoin](docs/RowFilterJoin.md)
 - [RowFilterJoinConditionsInner](docs/RowFilterJoinConditionsInner.md)
 - [RowFilterNullity](docs/RowFilterNullity.md)
 - [RowFilterNumber](docs/RowFilterNumber.md)
 - [RowFilterSet](docs/RowFilterSet.md)
 - [RowFilterSetOperator](docs/RowFilterSetOperator.md)
 - [RowFilterSubstructure](docs/RowFilterSubstructure.md)
 - [RowFilterText](docs/RowFilterText.md)
 - [RowSortInner](docs/RowSortInner.md)
 - [SeqAnnotation](docs/SeqAnnotation.md)
 - [SeqData](docs/SeqData.md)
 - [SubscriptionsPlansSchemaDto](docs/SubscriptionsPlansSchemaDto.md)
 - [SuccessResultsSchemaDto](docs/SuccessResultsSchemaDto.md)
 - [SuccessSchemaDto](docs/SuccessSchemaDto.md)
 - [ToolDefinitionInputSchemaDto](docs/ToolDefinitionInputSchemaDto.md)
 - [ToolDefinitionSchemaDto](docs/ToolDefinitionSchemaDto.md)
 - [ToolDefinitionSchemaDtoBillingParser](docs/ToolDefinitionSchemaDtoBillingParser.md)
 - [ToolDefinitionSchemaDtoBillingParserExecutor](docs/ToolDefinitionSchemaDtoBillingParserExecutor.md)
 - [ToolDefinitionSchemaDtoBillingParserExecutorResourceRequirements](docs/ToolDefinitionSchemaDtoBillingParserExecutorResourceRequirements.md)
 - [ToolDefinitionSchemaDtoChanges](docs/ToolDefinitionSchemaDtoChanges.md)
 - [ToolDefinitionSchemaDtoChangesChangesInner](docs/ToolDefinitionSchemaDtoChangesChangesInner.md)
 - [ToolDefinitionSchemaDtoExamplesValue](docs/ToolDefinitionSchemaDtoExamplesValue.md)
 - [ToolDefinitionSchemaDtoExecutorsInner](docs/ToolDefinitionSchemaDtoExecutorsInner.md)
 - [ToolDefinitionSchemaDtoExecutorsInnerEnvironmentInner](docs/ToolDefinitionSchemaDtoExecutorsInnerEnvironmentInner.md)
 - [ToolDefinitionSchemaDtoExecutorsInnerPortsInner](docs/ToolDefinitionSchemaDtoExecutorsInnerPortsInner.md)
 - [ToolDefinitionSchemaDtoExecutorsInnerResourceRequirements](docs/ToolDefinitionSchemaDtoExecutorsInnerResourceRequirements.md)
 - [ToolDefinitionSchemaDtoExecutorsInnerStorageRequirementsInner](docs/ToolDefinitionSchemaDtoExecutorsInnerStorageRequirementsInner.md)
 - [ToolDefinitionSchemaDtoExecutorsInnerStorageRequirementsInnerOneOf](docs/ToolDefinitionSchemaDtoExecutorsInnerStorageRequirementsInnerOneOf.md)
 - [ToolDefinitionSchemaDtoExecutorsInnerStorageRequirementsInnerOneOf1](docs/ToolDefinitionSchemaDtoExecutorsInnerStorageRequirementsInnerOneOf1.md)
 - [ToolDefinitionSchemaDtoInputs](docs/ToolDefinitionSchemaDtoInputs.md)
 - [ToolDefinitionSchemaDtoInputsConst](docs/ToolDefinitionSchemaDtoInputsConst.md)
 - [ToolDefinitionSchemaDtoInputsConstOneOf](docs/ToolDefinitionSchemaDtoInputsConstOneOf.md)
 - [ToolDefinitionSchemaDtoInputsDefault](docs/ToolDefinitionSchemaDtoInputsDefault.md)
 - [ToolDefinitionSchemaDtoInputsErrorMessageValue](docs/ToolDefinitionSchemaDtoInputsErrorMessageValue.md)
 - [ToolDefinitionSchemaDtoInputsExclusiveMinimum](docs/ToolDefinitionSchemaDtoInputsExclusiveMinimum.md)
 - [ToolDefinitionSchemaDtoInputsRequired](docs/ToolDefinitionSchemaDtoInputsRequired.md)
 - [ToolDefinitionSchemaDtoInputsType](docs/ToolDefinitionSchemaDtoInputsType.md)
 - [ToolExecutionInterfaceSchemaDto](docs/ToolExecutionInterfaceSchemaDto.md)
 - [ToolExecutionInterfaceSchemaDtoTool](docs/ToolExecutionInterfaceSchemaDtoTool.md)
 - [ToolsGetToolExecutions200Response](docs/ToolsGetToolExecutions200Response.md)
 - [ToolsGetToolExecutions200ResponseDataInner](docs/ToolsGetToolExecutions200ResponseDataInner.md)
 - [UpdateBillingAddressSchemaDto](docs/UpdateBillingAddressSchemaDto.md)
 - [UpdateColumn](docs/UpdateColumn.md)
 - [UpdateExecutionInputSchemaDto](docs/UpdateExecutionInputSchemaDto.md)
 - [UpdateExecutionInputSchemaDtoResourcesUsed](docs/UpdateExecutionInputSchemaDtoResourcesUsed.md)
 - [UpdateFunctionSchemaDto](docs/UpdateFunctionSchemaDto.md)
 - [UpdateMeInputSchemaDto](docs/UpdateMeInputSchemaDto.md)
 - [UpdateOrganizationInputSchemaDto](docs/UpdateOrganizationInputSchemaDto.md)
 - [UpdateOrganizationInviteInputSchemaDto](docs/UpdateOrganizationInviteInputSchemaDto.md)
 - [UpdateOrganizationStatusInputSchemaDto](docs/UpdateOrganizationStatusInputSchemaDto.md)
 - [UpdatePaymentInputSchemaDto](docs/UpdatePaymentInputSchemaDto.md)
 - [UpdateSubscriptionSchemaDto](docs/UpdateSubscriptionSchemaDto.md)
 - [UpdateToolSchemaDto](docs/UpdateToolSchemaDto.md)
 - [UserSchemaDto](docs/UserSchemaDto.md)
 - [UserSignupDtoSchemaDto](docs/UserSignupDtoSchemaDto.md)
 - [Workspace](docs/Workspace.md)


<a id="documentation-for-authorization"></a>
## Documentation For Authorization


Authentication schemes defined for the API:
<a id="bearer"></a>
### bearer

- **Type**: Bearer authentication (JWT)

<a id="api-key"></a>
### api-key

- **Type**: API key
- **API key parameter name**: Authorization
- **Location**: HTTP header

<a id="keycloak"></a>
### keycloak

- **Type**: Bearer authentication (JWT)

<a id="bearerAuth"></a>
### bearerAuth

- **Type**: Bearer authentication (JWT)

<a id="basic"></a>
### basic

- **Type**: HTTP basic authentication


## Author




