# pnap-audit-api
The Audit Logs API lets you read audit log entries and track API calls or activities in the Bare Metal Cloud Portal.<br>
<br>
<span class='pnap-api-knowledge-base-link'>
Knowledge base articles to help you can be found
<a href='https://phoenixnap.com/kb/bmc-server-management-via-api#audit-log-api' target='_blank'>here</a>
</span><br>
<br>
<b>All URLs are relative to (https://api.phoenixnap.com/audit/v1/)</b>


This Python package is automatically generated by the [OpenAPI Generator](https://openapi-generator.tech) project:

- API version: 1.0
For more information, please visit [https://phoenixnap.com/](https://phoenixnap.com/)

## Requirements.

Python >=3.6

## Installation & Usage
### pip install

You can install this package directly from the [Python Package Index](https://pypi.org/) using:

```sh
$ pip install pnap_audit_api
```

Then import the package:
```python
import pnap_audit_api
```

### Setuptools

Install via [Setuptools](http://pypi.python.org/pypi/setuptools).

```sh
python setup.py install --user
```
(or `sudo python setup.py install` to install the package for all users)

Then import the package:
```python
import pnap_audit_api
```

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```python

import time
import pnap_audit_api
from pprint import pprint
from pnap_audit_api.api import events_api
from pnap_audit_api.model.error import Error
from pnap_audit_api.model.event import Event
# Defining the host is optional and defaults to https://api.phoenixnap.com/audit/v1
# See configuration.py for a list of all supported configuration parameters.
configuration = pnap_audit_api.Configuration(
    host = "https://api.phoenixnap.com/audit/v1"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure OAuth2 access token for authorization: OAuth2
configuration = pnap_audit_api.Configuration(
    host = "https://api.phoenixnap.com/audit/v1"
)
configuration.access_token = 'YOUR_ACCESS_TOKEN'


# Enter a context with an instance of the API client
with pnap_audit_api.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = events_api.EventsApi(api_client)
    _from = dateutil_parser('2021-04-27T16:24:57.123Z') # datetime | From the date and time (inclusive) to filter event log records by. (optional)
    to = dateutil_parser('2021-04-29T16:24:57.123Z') # datetime | To the date and time (inclusive) to filter event log records by. (optional)
    limit = 10 # int | Limit the number of records returned. (optional)
    order = "ASC" # str | Ordering of the event's time. SortBy can be introduced later on. (optional) (default to "ASC")
    username = "johnd@phoenixnap.com" # str | The username that did the actions. (optional)
    verb = "POST" # str | The HTTP verb corresponding to the action. (optional)
    uri = "/ams/v1/clients/12345" # str | The request uri. (optional)

    try:
        # List event logs.
        api_response = api_instance.events_get(_from=_from, to=to, limit=limit, order=order, username=username, verb=verb, uri=uri)
        pprint(api_response)
    except pnap_audit_api.ApiException as e:
        print("Exception when calling EventsApi->events_get: %s\n" % e)
```

To generate a token using the [python-keycloak](https://pypi.org/project/python-keycloak/) library:
```python
from keycloak import KeycloakOpenID

clientId = "YOUR_CLIENT_ID"
clientSecret = "YOUR_CLIENT_SECRET"
serverUrl = "https://auth.phoenixnap.com/auth/"
realmName = "BMC"
grantType = "client_credentials"

keycloakOpenId =  KeycloakOpenID(server_url=serverUrl,
                        realm_name=realmName,
                        client_id=clientId,
                        client_secret_key=clientSecret)

ACCESS_TOKEN = keycloakOpenId.token(grant_type=grantType)['access_token']
```

## Documentation for API Endpoints

All URIs are relative to *https://api.phoenixnap.com/audit/v1*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*EventsApi* | [**events_get**](docs/EventsApi.md#events_get) | **GET** /events | List event logs.


## Documentation For Models

 - [Error](docs/Error.md)
 - [Event](docs/Event.md)
 - [UserInfo](docs/UserInfo.md)


## Documentation For Authorization


## OAuth2

- **Type**: OAuth
- **Flow**: application
- **Authorization URL**: 
- **Scopes**: 
 - **audit.read**: Grants read only access to audit-log-api.


## Author

support@phoenixnap.com


## Notes for Large OpenAPI documents
If the OpenAPI document is large, imports in pnap_audit_api.apis and pnap_audit_api.models may fail with a
RecursionError indicating the maximum recursion limit has been exceeded. In that case, there are a couple of solutions:

Solution 1:
Use specific imports for apis and models like:
- `from pnap_audit_api.api.default_api import DefaultApi`
- `from pnap_audit_api.model.pet import Pet`

Solution 2:
Before importing the package, adjust the maximum recursion limit as shown below:
```
import sys
sys.setrecursionlimit(1500)
import pnap_audit_api
from pnap_audit_api.apis import *
from pnap_audit_api.models import *
```

