"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.LambdaDeploymentConfig = void 0;
const jsiiDeprecationWarnings = require("../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const utils_1 = require("../utils");
/**
 * A custom Deployment Configuration for a Lambda Deployment Group.
 *
 * Note: This class currently stands as namespaced container of the default configurations
 * until CloudFormation supports custom Lambda Deployment Configs. Until then it is closed
 * (private constructor) and does not extend {@link cdk.Construct}
 *
 * @resource AWS::CodeDeploy::DeploymentConfig
 */
class LambdaDeploymentConfig {
    constructor() {
    }
    /**
     * Import a custom Deployment Configuration for a Lambda Deployment Group defined outside the CDK.
     *
     * @param _scope the parent Construct for this new Construct
     * @param _id the logical ID of this new Construct
     * @param props the properties of the referenced custom Deployment Configuration
     * @returns a Construct representing a reference to an existing custom Deployment Configuration
     */
    static import(_scope, _id, props) {
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_codedeploy_LambdaDeploymentConfigImportProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.import);
            }
            throw error;
        }
        return deploymentConfig(props.deploymentConfigName);
    }
}
exports.LambdaDeploymentConfig = LambdaDeploymentConfig;
_a = JSII_RTTI_SYMBOL_1;
LambdaDeploymentConfig[_a] = { fqn: "@aws-cdk/aws-codedeploy.LambdaDeploymentConfig", version: "1.163.0" };
LambdaDeploymentConfig.ALL_AT_ONCE = deploymentConfig('CodeDeployDefault.LambdaAllAtOnce');
LambdaDeploymentConfig.CANARY_10PERCENT_30MINUTES = deploymentConfig('CodeDeployDefault.LambdaCanary10Percent30Minutes');
LambdaDeploymentConfig.CANARY_10PERCENT_5MINUTES = deploymentConfig('CodeDeployDefault.LambdaCanary10Percent5Minutes');
LambdaDeploymentConfig.CANARY_10PERCENT_10MINUTES = deploymentConfig('CodeDeployDefault.LambdaCanary10Percent10Minutes');
LambdaDeploymentConfig.CANARY_10PERCENT_15MINUTES = deploymentConfig('CodeDeployDefault.LambdaCanary10Percent15Minutes');
LambdaDeploymentConfig.LINEAR_10PERCENT_EVERY_10MINUTES = deploymentConfig('CodeDeployDefault.LambdaLinear10PercentEvery10Minutes');
LambdaDeploymentConfig.LINEAR_10PERCENT_EVERY_1MINUTE = deploymentConfig('CodeDeployDefault.LambdaLinear10PercentEvery1Minute');
LambdaDeploymentConfig.LINEAR_10PERCENT_EVERY_2MINUTES = deploymentConfig('CodeDeployDefault.LambdaLinear10PercentEvery2Minutes');
LambdaDeploymentConfig.LINEAR_10PERCENT_EVERY_3MINUTES = deploymentConfig('CodeDeployDefault.LambdaLinear10PercentEvery3Minutes');
function deploymentConfig(name) {
    return {
        deploymentConfigName: name,
        deploymentConfigArn: utils_1.arnForDeploymentConfig(name),
    };
}
//# sourceMappingURL=data:application/json;base64,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