from typing import IO, Any, Optional
from xml.sax.handler import ContentHandler
from xml.sax.xmlreader import XMLReader

START_ELEMENT: str
END_ELEMENT: str
COMMENT: str
START_DOCUMENT: str
END_DOCUMENT: str
PROCESSING_INSTRUCTION: str
IGNORABLE_WHITESPACE: str
CHARACTERS: str

class PullDOM(ContentHandler):
    document: Optional[Any]
    documentFactory: Any
    firstEvent: Any
    lastEvent: Any
    elementStack: Any
    push: Any
    pending_events: Any
    def __init__(self, documentFactory: Optional[Any] = ...) -> None: ...
    def pop(self): ...
    def setDocumentLocator(self, locator) -> None: ...
    def startPrefixMapping(self, prefix, uri) -> None: ...
    def endPrefixMapping(self, prefix) -> None: ...
    def startElementNS(self, name, tagName, attrs) -> None: ...
    def endElementNS(self, name, tagName) -> None: ...
    def startElement(self, name, attrs) -> None: ...
    def endElement(self, name) -> None: ...
    def comment(self, s) -> None: ...
    def processingInstruction(self, target, data) -> None: ...
    def ignorableWhitespace(self, chars) -> None: ...
    def characters(self, chars) -> None: ...
    def startDocument(self) -> None: ...
    def buildDocument(self, uri, tagname): ...
    def endDocument(self) -> None: ...
    def clear(self) -> None: ...

class ErrorHandler:
    def warning(self, exception) -> None: ...
    def error(self, exception) -> None: ...
    def fatalError(self, exception) -> None: ...

class DOMEventStream:
    stream: IO[bytes]
    parser: XMLReader
    bufsize: int
    def __init__(self, stream: IO[bytes], parser: XMLReader, bufsize: int) -> None: ...
    pulldom: Any
    def reset(self) -> None: ...
    def __getitem__(self, pos): ...
    def __next__(self): ...
    def __iter__(self): ...
    def expandNode(self, node) -> None: ...
    def getEvent(self): ...
    def clear(self) -> None: ...

class SAX2DOM(PullDOM):
    def startElementNS(self, name, tagName, attrs) -> None: ...
    def startElement(self, name, attrs) -> None: ...
    def processingInstruction(self, target, data) -> None: ...
    def ignorableWhitespace(self, chars) -> None: ...
    def characters(self, chars) -> None: ...

default_bufsize: int

def parse(
    stream_or_string: str | IO[bytes], parser: Optional[XMLReader] = ..., bufsize: Optional[int] = ...
) -> DOMEventStream: ...
def parseString(string: str, parser: Optional[XMLReader] = ...) -> DOMEventStream: ...
