from _typeshed import Self, SupportsRead, SupportsReadline
from socket import socket
from ssl import SSLContext
from types import TracebackType
from typing import Any, Callable, Dict, Iterable, Iterator, List, Optional, TextIO, Tuple, Type, Union
from typing_extensions import Literal

MSG_OOB: int
FTP_PORT: int
MAXLINE: int
CRLF: str
B_CRLF: bytes

class Error(Exception): ...
class error_reply(Error): ...
class error_temp(Error): ...
class error_perm(Error): ...
class error_proto(Error): ...

all_errors: Tuple[Type[Exception], ...]

class FTP:
    debugging: int
    host: str
    port: int
    maxline: int
    sock: Optional[socket]
    welcome: Optional[str]
    passiveserver: int
    timeout: int
    af: int
    lastresp: str
    file: Optional[TextIO]
    encoding: str
    def __enter__(self: Self) -> Self: ...
    def __exit__(
        self, exc_type: Optional[Type[BaseException]], exc_val: Optional[BaseException], exc_tb: Optional[TracebackType]
    ) -> None: ...
    source_address: Optional[Tuple[str, int]]
    def __init__(
        self,
        host: str = ...,
        user: str = ...,
        passwd: str = ...,
        acct: str = ...,
        timeout: float = ...,
        source_address: Optional[Tuple[str, int]] = ...,
    ) -> None: ...
    def connect(
        self, host: str = ..., port: int = ..., timeout: float = ..., source_address: Optional[Tuple[str, int]] = ...
    ) -> str: ...
    def getwelcome(self) -> str: ...
    def set_debuglevel(self, level: int) -> None: ...
    def debug(self, level: int) -> None: ...
    def set_pasv(self, val: Union[bool, int]) -> None: ...
    def sanitize(self, s: str) -> str: ...
    def putline(self, line: str) -> None: ...
    def putcmd(self, line: str) -> None: ...
    def getline(self) -> str: ...
    def getmultiline(self) -> str: ...
    def getresp(self) -> str: ...
    def voidresp(self) -> str: ...
    def abort(self) -> str: ...
    def sendcmd(self, cmd: str) -> str: ...
    def voidcmd(self, cmd: str) -> str: ...
    def sendport(self, host: str, port: int) -> str: ...
    def sendeprt(self, host: str, port: int) -> str: ...
    def makeport(self) -> socket: ...
    def makepasv(self) -> Tuple[str, int]: ...
    def login(self, user: str = ..., passwd: str = ..., acct: str = ...) -> str: ...
    # In practice, `rest` rest can actually be anything whose str() is an integer sequence, so to make it simple we allow integers.
    def ntransfercmd(self, cmd: str, rest: Optional[Union[int, str]] = ...) -> Tuple[socket, int]: ...
    def transfercmd(self, cmd: str, rest: Optional[Union[int, str]] = ...) -> socket: ...
    def retrbinary(
        self, cmd: str, callback: Callable[[bytes], Any], blocksize: int = ..., rest: Optional[Union[int, str]] = ...
    ) -> str: ...
    def storbinary(
        self,
        cmd: str,
        fp: SupportsRead[bytes],
        blocksize: int = ...,
        callback: Optional[Callable[[bytes], Any]] = ...,
        rest: Optional[Union[int, str]] = ...,
    ) -> str: ...
    def retrlines(self, cmd: str, callback: Optional[Callable[[str], Any]] = ...) -> str: ...
    def storlines(self, cmd: str, fp: SupportsReadline[bytes], callback: Optional[Callable[[bytes], Any]] = ...) -> str: ...
    def acct(self, password: str) -> str: ...
    def nlst(self, *args: str) -> List[str]: ...
    # Technically only the last arg can be a Callable but ...
    def dir(self, *args: Union[str, Callable[[str], None]]) -> None: ...
    def mlsd(self, path: str = ..., facts: Iterable[str] = ...) -> Iterator[Tuple[str, Dict[str, str]]]: ...
    def rename(self, fromname: str, toname: str) -> str: ...
    def delete(self, filename: str) -> str: ...
    def cwd(self, dirname: str) -> str: ...
    def size(self, filename: str) -> Optional[int]: ...
    def mkd(self, dirname: str) -> str: ...
    def rmd(self, dirname: str) -> str: ...
    def pwd(self) -> str: ...
    def quit(self) -> str: ...
    def close(self) -> None: ...

class FTP_TLS(FTP):
    def __init__(
        self,
        host: str = ...,
        user: str = ...,
        passwd: str = ...,
        acct: str = ...,
        keyfile: Optional[str] = ...,
        certfile: Optional[str] = ...,
        context: Optional[SSLContext] = ...,
        timeout: float = ...,
        source_address: Optional[Tuple[str, int]] = ...,
    ) -> None: ...
    ssl_version: int
    keyfile: Optional[str]
    certfile: Optional[str]
    context: SSLContext
    def login(self, user: str = ..., passwd: str = ..., acct: str = ..., secure: bool = ...) -> str: ...
    def auth(self) -> str: ...
    def prot_p(self) -> str: ...
    def prot_c(self) -> str: ...
    def ccc(self) -> str: ...

def parse150(resp: str) -> Optional[int]: ...  # undocumented
def parse227(resp: str) -> Tuple[str, int]: ...  # undocumented
def parse229(resp: str, peer: Any) -> Tuple[str, int]: ...  # undocumented
def parse257(resp: str) -> str: ...  # undocumented
def ftpcp(
    source: FTP, sourcename: str, target: FTP, targetname: str = ..., type: Literal["A", "I"] = ...
) -> None: ...  # undocumented
